/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils.copy;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.copy.CopyMethod;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import javax.annotation.Nullable;

public class RetriableCopyMethod
implements CopyMethod {
    private final int maxRetry;
    private final CopyMethod copyMethod;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.transactions.copy");

    public RetriableCopyMethod(CopyMethod copyMethod, int maxRetry) {
        this.copyMethod = copyMethod;
        this.maxRetry = maxRetry;
    }

    @Override
    public void copyFile(ReadOnlyFS srcFS, RelFile srcFile, @Nullable RelFileAttribute srcAttr, ReadWriteFS dstFS, RelFile dstFile, @Nullable RelFileAttribute dstAttr) throws IOException {
        if (this.maxRetry <= 0) {
            this.copyMethod.copyFile(srcFS, srcFile, srcAttr, dstFS, dstFile, dstAttr);
            return;
        }
        for (int retryCount = 0; retryCount <= this.maxRetry; ++retryCount) {
            try {
                this.copyMethod.copyFile(srcFS, srcFile, srcAttr, dstFS, dstFile, dstAttr);
                return;
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("Interrupted while retrying file copy", e);
                }
                if (retryCount >= this.maxRetry) {
                    throw new IOException("Copy attempt %s of %s failed, max retry reached", e);
                }
                logger.warnV("Copy attempt %s of %s failed with error: %s", new Object[]{retryCount + 1, this.maxRetry + 1, e.getMessage()});
                continue;
            }
        }
    }

    @Override
    public FSUtils.CopyStats getStats() {
        return this.copyMethod.getStats();
    }

    @Override
    public void close() throws IOException {
        this.copyMethod.close();
    }
}

