/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;

public class CachedJSONFile<T> {
    private File path;
    private T lastObject;
    private long lastTS;
    private long lastLength;
    private Class<T> clazz;

    public CachedJSONFile(File path, Class<T> clazz) {
        this.path = path;
        this.clazz = clazz;
    }

    private void update() throws IOException {
        long ts = this.path.lastModified();
        long length = this.path.length();
        if (this.lastTS == 0L || ts != this.lastTS || this.lastLength == 0L || length != this.lastLength) {
            this.lastObject = JSON.parseFile((File)this.path, this.clazz);
            this.lastTS = ts;
            this.lastLength = length;
        }
    }

    public synchronized void clear() throws IOException {
        this.lastTS = 0L;
        this.lastObject = null;
    }

    public synchronized void write(T newObj) throws IOException {
        this.clear();
        JSON.prettyToFile(newObj, (File)this.path);
    }

    public synchronized T get() throws IOException {
        if (!this.path.isFile()) {
            return null;
        }
        this.update();
        Object t = JSON.parse((String)JSON.json(this.lastObject), this.clazz);
        return (T)t;
    }

    public synchronized T getUnsafe() throws IOException {
        if (!this.path.isFile()) {
            return null;
        }
        this.update();
        return this.lastObject;
    }
}

