/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ValueObject;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.joda.time.Instant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jfr.Configuration;
import jdk.jfr.Recording;

public class DKUProfiler {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(\\d{8}-\\d{6}).*\\.jfr");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd-HHmmss");
    private ProfilerConfiguration currentConfiguration = new ProfilerConfiguration();
    private Recording recording;
    private File currentProfileFile;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.profiler");

    public synchronized File getProfileFile(String profileId) {
        if (this.currentConfiguration.directory == null) {
            throw new IllegalStateException("Profiler directory is not set");
        }
        return DKUFileUtils.getWithin((File)this.currentConfiguration.directory, (String[])new String[]{profileId});
    }

    public synchronized File getProfilesDirectory() {
        return this.currentConfiguration.directory;
    }

    public synchronized void deleteProfile(String profileId) throws IOException {
        logger.info((Object)("Deleting profile " + profileId));
        File profilesDirectory = this.currentConfiguration.directory;
        if (profilesDirectory != null) {
            File profileFile = DKUFileUtils.getWithin((File)profilesDirectory, (String[])new String[]{profileId});
            profileFile.delete();
        }
    }

    public synchronized List<PerformanceProfile> listProfiles() {
        File[] profileFiles;
        File directory = this.currentConfiguration.directory;
        ArrayList<PerformanceProfile> profiles = new ArrayList<PerformanceProfile>();
        if (directory != null && directory.isDirectory() && (profileFiles = directory.listFiles()) != null) {
            for (File file : profileFiles) {
                Matcher matcher;
                if (!file.isFile() || !file.getName().endsWith(".jfr") || !(matcher = FILE_NAME_PATTERN.matcher(file.getName())).matches()) continue;
                PerformanceProfile profile = new PerformanceProfile();
                profile.id = file.getName();
                profile.size = file.length();
                profile.date = file.lastModified();
                profile.active = Objects.equals(file, this.currentProfileFile);
                profiles.add(profile);
            }
        }
        profiles.sort(Comparator.comparingLong(p -> -p.date));
        return profiles;
    }

    private static void increaseJFRStackDepth() throws IOException, InterruptedException {
        long pid = ProcessHandle.current().pid();
        File javaHome = new File(System.getProperty("java.home"));
        String jcmdPath = new File(new File(javaHome, "bin"), "jcmd").getAbsolutePath();
        CharSequence[] configJFRCmd = new String[]{jcmdPath, "" + pid, "JFR.configure", "stackdepth=384"};
        logger.info((Object)("Configuring JFR stackdepth: " + String.join((CharSequence)" ", configJFRCmd)));
        DKUtils.execAndLogThrows((String[])configJFRCmd, new HashMap(), (DKUtils.SmartLogTailBuilder)new DKUtils.SmartLogTailBuilder());
    }

    public synchronized void setEnabled(boolean enable) {
        if (enable && this.recording == null) {
            try {
                logger.info((Object)"Starting profiler...");
                DKUProfiler.increaseJFRStackDepth();
                long pid = ProcessHandle.current().pid();
                String now = Instant.now().toString(DATE_TIME_FORMATTER);
                String processType = DKUApp.getProcessType().toString().toLowerCase();
                String filename = now + "-" + pid + "-" + processType + ".jfr";
                File destinationFile = new File(this.currentConfiguration.directory, filename).getAbsoluteFile();
                FileUtils.forceMkdir((File)this.currentConfiguration.directory);
                JFRConfigName jfrConfig = this.currentConfiguration.jfrConfigName == null ? JFRConfigName.DEFAULT : this.currentConfiguration.jfrConfigName;
                this.recording = new Recording(Configuration.getConfiguration(jfrConfig.name().toLowerCase()));
                this.recording.setDestination(destinationFile.toPath());
                this.recording.setMaxSize((long)this.currentConfiguration.maxSizeMB * 1024L * 1024L);
                this.recording.setName(filename);
                this.recording.setDumpOnExit(true);
                this.recording.setToDisk(true);
                this.recording.start();
                this.currentProfileFile = destinationFile;
                logger.info((Object)("Started profiling into " + String.valueOf(destinationFile)));
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to start profiler", e);
                if (this.recording != null) {
                    IOUtils.closeQuietly((Closeable)this.recording);
                }
                this.recording = null;
                this.currentProfileFile = null;
            }
        } else if (!enable && this.recording != null) {
            try {
                logger.info((Object)"Stopping profiler...");
                this.currentProfileFile = null;
                this.recording.stop();
                this.recording.close();
                this.recording = null;
                logger.info((Object)"Stopped recording");
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to stop profiler", e);
                if (this.recording != null) {
                    IOUtils.closeQuietly((Closeable)this.recording);
                }
                this.recording = null;
            }
        }
    }

    public synchronized void setConfiguration(ProfilerConfiguration configuration) throws IOException {
        if (this.recording != null && !Objects.equals((Object)this.currentConfiguration, (Object)configuration)) {
            this.setEnabled(false);
            this.currentConfiguration = configuration;
            this.setEnabled(true);
        } else {
            this.currentConfiguration = configuration;
        }
    }

    public static class ProfilerConfiguration
    extends ValueObject {
        public File directory;
        public int maxSizeMB;
        public JFRConfigName jfrConfigName;
    }

    @UIModel
    public static class PerformanceProfile {
        public String id;
        public long size;
        public long date;
        public boolean active;
    }

    @UIModel
    public static enum JFRConfigName {
        PROFILE,
        DEFAULT;

    }
}

