/*
 * Decompiled with CFR 0.152.
 */
package com.lastpass.saml;

import com.lastpass.saml.SAMLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.XMLSignatureBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPConfig {
    private String entityId;
    private String acs;
    private PrivateKey privateKey;
    private java.security.cert.X509Certificate certificate;

    public SPConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPConfig(File metadataFile) throws SAMLException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(metadataFile);
        }
        catch (IOException e) {
            throw new SAMLException(e);
        }
        try {
            this.init(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SPConfig(InputStream inputStream) throws SAMLException {
        this.init(inputStream);
    }

    private void init(InputStream inputStream) throws SAMLException {
        EntityDescriptor edesc;
        BasicParserPool parsers = new BasicParserPool();
        parsers.setNamespaceAware(true);
        try {
            Document doc = parsers.parse(inputStream);
            Element root = doc.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            edesc = (EntityDescriptor)unmarshallerFactory.getUnmarshaller(root).unmarshall(root);
        }
        catch (XMLParserException e) {
            throw new RuntimeException(e);
        }
        catch (UnmarshallingException e) {
            throw new RuntimeException(e);
        }
        SPSSODescriptor spDesc = edesc.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (spDesc == null) {
            throw new SAMLException("No SP SSO descriptor found");
        }
        String acsUrl = null;
        for (AssertionConsumerService svc : spDesc.getAssertionConsumerServices()) {
            if (!svc.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !svc.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
            acsUrl = svc.getLocation();
            break;
        }
        if (acsUrl == null) {
            throw new SAMLException("No acceptable Assertion Consumer Service found");
        }
        this.setEntityId(edesc.getEntityID());
        this.setAcs(acsUrl);
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setAcs(String acs) {
        this.acs = acs;
    }

    public String getAcs() {
        return this.acs;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setCertificate(java.security.cert.X509Certificate certificate) {
        this.certificate = certificate;
    }

    public java.security.cert.X509Certificate getCertificate() {
        return this.certificate;
    }

    public String spMetadata(boolean signedAuthnRequests) throws SAMLException {
        try {
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            AssertionConsumerService assertionConsumerService = (AssertionConsumerService)((SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME)).buildObject();
            assertionConsumerService.setIndex(Integer.valueOf(0));
            assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            assertionConsumerService.setLocation(this.acs);
            SPSSODescriptor ssoDescriptor = (SPSSODescriptor)((SAMLObjectBuilder)builderFactory.getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME)).buildObject();
            ssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            ssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
            if (signedAuthnRequests) {
                if (this.certificate == null) {
                    throw new SAMLException("Cannot generate SP metadata with signed requests: no certificate available");
                }
                X509Certificate x509Certificate = KeyInfoSupport.buildX509Certificate((java.security.cert.X509Certificate)this.certificate);
                X509Data x509Data = (X509Data)((XMLSignatureBuilder)builderFactory.getBuilder(X509Data.DEFAULT_ELEMENT_NAME)).buildObject();
                x509Data.getX509Certificates().add(x509Certificate);
                KeyInfo keyInfo = (KeyInfo)((XMLSignatureBuilder)builderFactory.getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME)).buildObject();
                keyInfo.getX509Datas().add(x509Data);
                KeyDescriptor keyDescriptor = (KeyDescriptor)((SAMLObjectBuilder)builderFactory.getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME)).buildObject();
                keyDescriptor.setUse(UsageType.SIGNING);
                keyDescriptor.setKeyInfo(keyInfo);
                ssoDescriptor.getKeyDescriptors().add(keyDescriptor);
                ssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
            }
            EntityDescriptor entityDescriptor = (EntityDescriptor)((SAMLObjectBuilder)builderFactory.getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME)).buildObject();
            entityDescriptor.setEntityID(this.entityId);
            entityDescriptor.setValidUntil(Instant.now().plus(2L, ChronoUnit.DAYS));
            entityDescriptor.getRoleDescriptors().add(ssoDescriptor);
            Element elem = marshallerFactory.getMarshaller((XMLObject)entityDescriptor).marshall((XMLObject)entityDescriptor);
            return SerializeSupport.prettyPrintXML((Node)elem);
        }
        catch (CertificateEncodingException e) {
            throw new SAMLException("Error generating SP metadata", e);
        }
        catch (MarshallingException e) {
            throw new SAMLException("Error generating SP metadata", e);
        }
    }
}

