/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.ImmutableHTTPRequest;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.auth.OAuth2Manager;
import org.apache.log4j.Logger;

public class UnshadedIcebergDSSAuthManager
implements AuthManager {
    private final String name;
    private final OAuth2Manager delegate;
    private static Logger logger = Logger.getLogger((String)"dip.iceberg.unshaded.auth_manager");

    public UnshadedIcebergDSSAuthManager(String name) {
        this.name = name;
        logger.info((Object)("instantiate " + name));
        this.delegate = "gcs-credentials-refresh".equals(name) ? null : ("adls-credentials-refresh".equals(name) ? null : new OAuth2Manager("sub-" + name));
    }

    public AuthSession initSession(RESTClient initClient, Map<String, String> properties) {
        if (this.delegate == null) {
            return super.initSession(initClient, properties);
        }
        return this.delegate.initSession(initClient, properties);
    }

    public AuthSession catalogSession(RESTClient restClient, Map<String, String> properties) {
        if (this.delegate == null) {
            String fetchInfoStr;
            if (properties.containsKey("gcs.oauth2.refresh-credentials-fetch-info")) {
                fetchInfoStr = properties.get("gcs.oauth2.refresh-credentials-fetch-info");
            } else if (properties.containsKey("adls.refresh-credentials-fetch-info")) {
                fetchInfoStr = properties.get("adls.refresh-credentials-fetch-info");
            } else {
                throw new IllegalArgumentException("No fetch info passed");
            }
            String azureContainer = properties.getOrDefault("adls.refresh-credentials-container", null);
            Gson gson = new Gson();
            final JsonObject fetchInfo = (JsonObject)gson.fromJson(fetchInfoStr, JsonObject.class);
            return new AuthSession(){

                public HTTPRequest authenticate(HTTPRequest request) {
                    HashMap<String, String> additionalHeaders = new HashMap<String, String>();
                    if (fetchInfo.has("sharedSecret")) {
                        additionalHeaders.putIfAbsent("X-DKU-IPythonSharedSecret", fetchInfo.get("sharedSecret").getAsString());
                    }
                    if (fetchInfo.has("apiTicket")) {
                        additionalHeaders.putIfAbsent("X-DKU-APITicket", fetchInfo.get("apiTicket").getAsString());
                    }
                    if (fetchInfo.has("apiExecutionSecret")) {
                        additionalHeaders.putIfAbsent("X-DKU-ExecutionSecretId", fetchInfo.get("apiExecutionSecret").getAsString());
                    }
                    if (fetchInfo.has("extraHeaders")) {
                        JsonObject extraHeaders = fetchInfo.get("extraHeaders").getAsJsonObject();
                        for (String k : extraHeaders.keySet()) {
                            additionalHeaders.put(k, extraHeaders.get("k").getAsString());
                        }
                    }
                    additionalHeaders.put("X-DKU-CallOrigin", "UNKNOWN");
                    if (additionalHeaders.isEmpty()) {
                        return request;
                    }
                    HTTPHeaders newHeaders = request.headers().putIfAbsent(HTTPHeaders.of(additionalHeaders));
                    return ImmutableHTTPRequest.builder().from(request).headers(newHeaders).build();
                }

                public void close() {
                }
            };
        }
        return this.delegate.catalogSession(restClient, properties);
    }

    public AuthSession tableSession(RESTClient sharedClient, Map<String, String> properties) {
        if (this.delegate == null) {
            return super.tableSession(sharedClient, properties);
        }
        return this.delegate.tableSession(sharedClient, properties);
    }

    public AuthSession contextualSession(SessionCatalog.SessionContext context, AuthSession parent) {
        if (this.delegate == null) {
            return super.contextualSession(context, parent);
        }
        return this.delegate.contextualSession(context, parent);
    }

    public AuthSession tableSession(TableIdentifier table, Map<String, String> properties, AuthSession parent) {
        if (this.delegate == null) {
            return super.tableSession(table, properties, parent);
        }
        return this.delegate.tableSession(table, properties, parent);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

