/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.BaseJsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.SnowflakePushdownUnsupportedException;
import net.snowflake.spark.snowflake.SnowflakeTelemetryMessageSender;
import net.snowflake.spark.snowflake.SparkConnectorContext$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.TelemetryConstValues$;
import net.snowflake.spark.snowflake.TelemetryFieldNames$;
import net.snowflake.spark.snowflake.TelemetryMessageSender;
import net.snowflake.spark.snowflake.TelemetryOOBFields$;
import net.snowflake.spark.snowflake.TelemetryOOBTags$;
import net.snowflake.spark.snowflake.TelemetryPushdownFailFields$;
import net.snowflake.spark.snowflake.TelemetryQueryStatusFields$;
import net.snowflake.spark.snowflake.TelemetryTaskInfoFields$;
import net.snowflake.spark.snowflake.TelemetryTypes$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SnowflakeTelemetry$ {
    public static SnowflakeTelemetry$ MODULE$;
    private boolean telemetryClientNullWarningSent;
    private final String TELEMETRY_TYPE_FIELD_NAME;
    private final String TELEMETRY_SOURCE_FIELD_NAME;
    private final String TELEMETRY_DATA_FIELD_NAME;
    private final String TELEMETRY_SOURCE;
    private final String TELEMETRY_OOB_NAME_PREFIX;
    private List<Tuple2<ObjectNode, Object>> logs;
    private final Logger logger;
    private final ObjectMapper mapper;
    private final int MB;
    private ObjectNode output;
    private TelemetryMessageSender telemetryMessageSender;
    private Option<String> cachedSparkApplicationId;
    private final int MAX_CACHED_SPARK_PLAN_STATISTIC_COUNT;
    private final Set<String> sparkOptions;
    private volatile boolean bitmap$0;

    static {
        new SnowflakeTelemetry$();
    }

    private String TELEMETRY_TYPE_FIELD_NAME() {
        return this.TELEMETRY_TYPE_FIELD_NAME;
    }

    private String TELEMETRY_SOURCE_FIELD_NAME() {
        return this.TELEMETRY_SOURCE_FIELD_NAME;
    }

    private String TELEMETRY_DATA_FIELD_NAME() {
        return this.TELEMETRY_DATA_FIELD_NAME;
    }

    private String TELEMETRY_SOURCE() {
        return this.TELEMETRY_SOURCE;
    }

    private String TELEMETRY_OOB_NAME_PREFIX() {
        return this.TELEMETRY_OOB_NAME_PREFIX;
    }

    private List<Tuple2<ObjectNode, Object>> logs() {
        return this.logs;
    }

    private void logs_$eq(List<Tuple2<ObjectNode, Object>> x$1) {
        this.logs = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public int MB() {
        return this.MB;
    }

    public ObjectNode output() {
        return this.output;
    }

    public void output_$eq(ObjectNode x$1) {
        this.output = x$1;
    }

    private TelemetryMessageSender telemetryMessageSender() {
        return this.telemetryMessageSender;
    }

    private void telemetryMessageSender_$eq(TelemetryMessageSender x$1) {
        this.telemetryMessageSender = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public TelemetryMessageSender setTelemetryMessageSenderForTest(TelemetryMessageSender sender) {
        void var2_2;
        TelemetryMessageSender oldSender = this.telemetryMessageSender();
        this.telemetryMessageSender_$eq(sender);
        return var2_2;
    }

    private Option<String> cachedSparkApplicationId() {
        return this.cachedSparkApplicationId;
    }

    private void cachedSparkApplicationId_$eq(Option<String> x$1) {
        this.cachedSparkApplicationId = x$1;
    }

    private String getSparkApplicationId() {
        String string;
        if (this.cachedSparkApplicationId().isEmpty()) {
            if (SparkEnv$.MODULE$.get() != null && SparkEnv$.MODULE$.get().conf() != null && SparkEnv$.MODULE$.get().conf().contains("spark.app.id")) {
                this.cachedSparkApplicationId_$eq((Option<String>)new Some((Object)SparkEnv$.MODULE$.get().conf().get("spark.app.id")));
                string = (String)this.cachedSparkApplicationId().get();
            } else {
                string = new StringBuilder(22).append("spark.app.id not set ").append(System.currentTimeMillis()).append("}").toString();
            }
        } else {
            string = (String)this.cachedSparkApplicationId().get();
        }
        return string;
    }

    public Seq<String> getSparkLibraries() {
        Seq seq;
        try {
            String[] classNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).reverse())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getClassName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.replaceAll("\\$", ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String userApplicationPackage = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNames)).head()).contains(".") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNames)).head()).split("\\."))).dropRight(1))).mkString("", ".", ".") : (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNames)).head();
            Seq knownLibraries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.", "jdk.internal.", "scala.", "net.snowflake.spark.snowflake.", "org.apache.spark.sql.", userApplicationPackage}));
            seq = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNames)).filterNot((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)knownLibraries.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)name.startsWith(x$1))))))).map((Function1 & Serializable & scala.Serializable)name -> name.contains(".") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])name.split("\\."))).dropRight(1))).mkString(".") : name, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct());
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(42).append("Fail to retrieve spark libraries. reason: ").append(th.getMessage()).toString());
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Seq<String> getSparkDependencies() {
        return (Seq)SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.sparkContext()).map((Function1 & Serializable & scala.Serializable)context -> (Seq)((SeqLike)context.files().$plus$plus((GenTraversableOnce)context.archives(), Seq$.MODULE$.canBuildFrom())).distinct()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Object addSparkClusterStatistics(ObjectNode metric) {
        BoxedUnit boxedUnit;
        try {
            metric.put(TelemetryFieldNames$.MODULE$.CLUSTER_NODE_COUNT(), SparkEnv$.MODULE$.get().blockManager().master().getStorageStatus().length);
            boxedUnit = SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.sparkContext()).map((Function1 & Serializable & scala.Serializable)sc -> {
                metric.put(TelemetryFieldNames$.MODULE$.SPARK_DEFAULT_PARALLELISM(), sc.defaultParallelism());
                return metric.put(TelemetryFieldNames$.MODULE$.DEPLOY_MODE(), sc.deployMode());
            });
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(39).append("Fail to get cluster statistic. reason: ").append(th.getMessage()).toString());
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private int MAX_CACHED_SPARK_PLAN_STATISTIC_COUNT() {
        return this.MAX_CACHED_SPARK_PLAN_STATISTIC_COUNT;
    }

    public void addSparkPlanStatistic(Set<String> statistic) {
        block5: {
            block4: {
                if (!statistic.nonEmpty()) break block5;
                SnowflakeTelemetry$ snowflakeTelemetry$ = this;
                synchronized (snowflakeTelemetry$) {
                    block3: {
                        if (this.logs().length() >= this.MAX_CACHED_SPARK_PLAN_STATISTIC_COUNT()) break block3;
                        break block4;
                    }
                    return;
                }
            }
            ObjectNode metric = this.mapper().createObjectNode();
            ArrayNode arrayNode = metric.putArray(TelemetryFieldNames$.MODULE$.STATISTIC_INFO());
            statistic.foreach((Function1 & Serializable & scala.Serializable)x$1 -> arrayNode.add(x$1));
            this.addCommonFields(metric);
            this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_PLAN_STATISTIC(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private TelemetryService getOobTelemetryService() {
        void var1_1;
        TelemetryService service = TelemetryService.getInstance();
        service.setDeployment(TelemetryService.TELEMETRY_SERVER_DEPLOYMENT.PROD);
        return var1_1;
    }

    public void sendClientInfoTelemetry(Map<String, String> extraValues, ServerConnection conn) {
        SparkConnectorContext$.MODULE$.recordConfig();
        ObjectNode metric = Utils$.MODULE$.getClientInfoJson();
        extraValues.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SnowflakeTelemetry$.$anonfun$sendClientInfoTelemetry$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            ObjectNode objectNode = metric.put(key, value);
            return objectNode;
        });
        this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_CLIENT_INFO(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        this.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
    }

    public void addLog(Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object> log) {
        this.logger().debug(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n        |Telemetry Output\n        |Type: ").append(((Tuple2)log._1())._1()).append("\n        |Data: ").append(((BaseJsonNode)((Tuple2)log._1())._2()).toString()).append("\n      ").toString())).stripMargin());
        SnowflakeTelemetry$ snowflakeTelemetry$ = this;
        synchronized (snowflakeTelemetry$) {
            this.output_$eq(this.mapper().createObjectNode());
            this.output().put(this.TELEMETRY_TYPE_FIELD_NAME(), ((Tuple2)log._1())._1().toString());
            this.output().put(this.TELEMETRY_SOURCE_FIELD_NAME(), this.TELEMETRY_SOURCE());
            this.output().set(this.TELEMETRY_DATA_FIELD_NAME(), (JsonNode)((Tuple2)log._1())._2());
            Tuple2 tuple2 = new Tuple2((Object)this.output(), (Object)BoxesRunTime.boxToLong((long)log._2$mcJ$sp()));
            this.logs_$eq((List<Tuple2<ObjectNode, Object>>)this.logs().$colon$colon((Object)tuple2));
        }
    }

    public void sendTelemetryOOB(String sfurl, String senderClass, String operation, int retryCount, int maxRetryCount, boolean success, boolean useProxy, Option<String> queryID, Option<Throwable> throwable) {
        try {
            BoxedUnit boxedUnit;
            ObjectNode metric = this.mapper().createObjectNode();
            metric.put(TelemetryOOBFields$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION());
            metric.put(TelemetryOOBFields$.MODULE$.SFURL(), sfurl);
            metric.put(TelemetryOOBFields$.MODULE$.SENDER_CLASS(), senderClass);
            metric.put(TelemetryOOBFields$.MODULE$.OPERATION(), operation);
            metric.put(TelemetryOOBFields$.MODULE$.RETRY_COUNT(), retryCount);
            metric.put(TelemetryOOBFields$.MODULE$.MAX_RETRY_COUNT(), maxRetryCount);
            metric.put(TelemetryOOBFields$.MODULE$.SUCCESS(), success);
            metric.put(TelemetryOOBFields$.MODULE$.USE_PROXY(), useProxy);
            metric.put(TelemetryOOBFields$.MODULE$.QUERY_ID(), (String)queryID.getOrElse((Function0 & Serializable & scala.Serializable)() -> "NA"));
            this.addCommonFields(metric);
            if (throwable.isDefined()) {
                this.addThrowable(metric, (Throwable)throwable.get());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                metric.put(TelemetryOOBFields$.MODULE$.EXCEPTION_CLASS_NAME(), "NA");
                metric.put(TelemetryOOBFields$.MODULE$.EXCEPTION_MESSAGE(), "NA");
                boxedUnit = metric.put(TelemetryOOBFields$.MODULE$.STACKTRACE(), "NA");
            }
            TelemetryService oobTelemetryService = this.getOobTelemetryService();
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(new StringBuilder(2).append(this.TELEMETRY_OOB_NAME_PREFIX()).append("_").append(operation).append("_").append(senderClass).toString())).withValue(metric.toString()).withTag(TelemetryOOBTags$.MODULE$.CONNECTION_STRING(), new StringBuilder(12).append("https://").append(sfurl).append(":443").toString())).withTag(TelemetryOOBTags$.MODULE$.CTX_ACCOUNT(), sfurl.substring(0, sfurl.indexOf(".")))).withTag(TelemetryOOBTags$.MODULE$.CTX_HOST(), sfurl.substring(sfurl.indexOf(".") + 1))).withTag(TelemetryOOBTags$.MODULE$.CTX_PORT(), "443")).withTag(TelemetryOOBTags$.MODULE$.CTX_PROTOCAL(), "https")).withTag(TelemetryOOBTags$.MODULE$.CTX_USER(), "fake_spark_user")).withTag(TelemetryOOBTags$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION())).withTag(TelemetryOOBTags$.MODULE$.SENDER_CLASS_NAME(), senderClass)).withTag(TelemetryOOBTags$.MODULE$.OPERATION(), operation)).build();
            this.logger().info(new StringBuilder(29).append("Send OOB Telemetry message: ").append(senderClass).append(" ").append(operation).toString());
            oobTelemetryService.report(log);
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(36).append("Fail to send OOB Telemetry message: ").append(th.getMessage()).toString());
        }
    }

    private boolean telemetryClientNullWarningSent$lzycompute() {
        SnowflakeTelemetry$ snowflakeTelemetry$ = this;
        synchronized (snowflakeTelemetry$) {
            if (!this.bitmap$0) {
                this.logger().warn("Telemetry message not sent because Telemetry client is null");
                this.telemetryClientNullWarningSent = true;
                this.bitmap$0 = true;
            }
        }
        return this.telemetryClientNullWarningSent;
    }

    private boolean telemetryClientNullWarningSent() {
        return !this.bitmap$0 ? this.telemetryClientNullWarningSent$lzycompute() : this.telemetryClientNullWarningSent;
    }

    public void send(Telemetry telemetry) {
        if (telemetry != null) {
            List<Tuple2<ObjectNode, Object>> curLogs = Nil$.MODULE$;
            SnowflakeTelemetry$ snowflakeTelemetry$ = this;
            synchronized (snowflakeTelemetry$) {
                curLogs = this.logs();
                this.logs_$eq((List<Tuple2<ObjectNode, Object>>)Nil$.MODULE$);
            }
            this.telemetryMessageSender().send(telemetry, curLogs);
        } else {
            this.telemetryClientNullWarningSent();
        }
    }

    public void addPushdownFailMessage(LogicalPlan plan, SnowflakePushdownUnsupportedException exception) {
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("Pushdown fails because of operation: ").append(exception.unsupportedOperation()).append("\n         | message: ").append(exception.getMessage()).append("\n         | isKnown: ").append(exception.isKnownUnsupportedOperation()).append("\n           ").toString())).stripMargin());
        if (exception.isKnownUnsupportedOperation()) {
            return;
        }
        ObjectNode metric = this.mapper().createObjectNode();
        metric.put(TelemetryPushdownFailFields$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION());
        metric.put(TelemetryPushdownFailFields$.MODULE$.UNSUPPORTED_OPERATION(), exception.unsupportedOperation());
        metric.put(TelemetryPushdownFailFields$.MODULE$.EXCEPTION_MESSAGE(), exception.getMessage());
        metric.put(TelemetryPushdownFailFields$.MODULE$.EXCEPTION_DETAILS(), exception.details());
        this.addCommonFields(metric);
        this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_PUSHDOWN_FAIL(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
    }

    public void addThrowable(ObjectNode metric, Throwable th) {
        metric.put(TelemetryFieldNames$.MODULE$.EXCEPTION_CLASS_NAME(), th.getClass().toString());
        if (th instanceof SnowflakeSQLException) {
            SnowflakeSQLException e = (SnowflakeSQLException)th;
            String proposedMessage = new StringBuilder(52).append("SnowflakeSQLException: ErrorCode=").append(e.getErrorCode()).append(" SQLState=").append(e.getSQLState()).append(" QueryId=").append(e.getQueryId()).toString();
            metric.put(TelemetryFieldNames$.MODULE$.EXCEPTION_MESSAGE(), proposedMessage);
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            String stacktraceString = stringWriter.toString().replaceAll(Pattern.quote(e.getMessage()), proposedMessage);
            metric.put(TelemetryFieldNames$.MODULE$.STACKTRACE(), stacktraceString);
        } else {
            metric.put(TelemetryFieldNames$.MODULE$.EXCEPTION_MESSAGE(), th.getMessage());
            StringWriter stringWriter = new StringWriter();
            th.printStackTrace(new PrintWriter(stringWriter));
            metric.put(TelemetryFieldNames$.MODULE$.STACKTRACE(), stringWriter.toString());
        }
    }

    public void sendQueryStatus(ServerConnection conn, String operation, String queryId, String queryStatus, long elapse, Option<Throwable> throwable, String details) {
        try {
            ObjectNode metric = this.mapper().createObjectNode();
            metric.put(TelemetryQueryStatusFields$.MODULE$.SPARK_CONNECTOR_VERSION(), Utils$.MODULE$.VERSION());
            metric.put(TelemetryQueryStatusFields$.MODULE$.OPERATION(), operation);
            metric.put(TelemetryQueryStatusFields$.MODULE$.QUERY_ID(), queryId);
            metric.put(TelemetryQueryStatusFields$.MODULE$.QUERY_STATUS(), queryStatus);
            metric.put(TelemetryQueryStatusFields$.MODULE$.ELAPSED_TIME(), elapse);
            if (throwable.isDefined()) {
                this.addThrowable(metric, (Throwable)throwable.get());
            }
            metric.put(TelemetryQueryStatusFields$.MODULE$.DETAILS(), details);
            this.addCommonFields(metric);
            this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_QUERY_STATUS(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            this.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(41).append("Fail to send spark_query_status. reason: ").append(th.getMessage()).toString());
        }
    }

    public void sendIngressMessage(ServerConnection conn, String queryId, long rowCount, long bytes) {
        try {
            ObjectNode metric = this.mapper().createObjectNode();
            metric.put(TelemetryFieldNames$.MODULE$.QUERY_ID(), queryId);
            metric.put(TelemetryFieldNames$.MODULE$.INPUT_BYTES(), bytes);
            metric.put(TelemetryFieldNames$.MODULE$.ROW_COUNT(), rowCount);
            this.addCommonFields(metric);
            this.addLog((Tuple2<Tuple2<Enumeration.Value, ObjectNode>, Object>)new Tuple2((Object)new Tuple2((Object)TelemetryTypes$.MODULE$.SPARK_INGRESS(), (Object)metric), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            this.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(36).append("Fail to send spark_ingress. reason: ").append(th.getMessage()).toString());
        }
    }

    public ObjectNode getClientConfig() {
        ObjectNode objectNode;
        ObjectNode metric = this.mapper().createObjectNode();
        try {
            Utils$.MODULE$.addVersionInfo(metric);
            metric.put(TelemetryClientInfoFields$.MODULE$.OS_NAME(), System.getProperty(TelemetryConstValues$.MODULE$.JVM_PROPERTY_NAME_OS_NAME()));
            Runtime rt = Runtime.getRuntime();
            metric.put(TelemetryClientInfoFields$.MODULE$.MAX_MEMORY_IN_MB(), rt.maxMemory() / (long)this.MB());
            metric.put(TelemetryClientInfoFields$.MODULE$.TOTAL_MEMORY_IN_MB(), rt.totalMemory() / (long)this.MB());
            metric.put(TelemetryClientInfoFields$.MODULE$.FREE_MEMORY_IN_MB(), rt.freeMemory() / (long)this.MB());
            metric.put(TelemetryClientInfoFields$.MODULE$.CPU_CORES(), rt.availableProcessors());
            SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
            this.addCommonFields(metric);
            metric.put(TelemetryFieldNames$.MODULE$.SPARK_LANGUAGE(), this.detectSparkLanguage(sparkConf));
            metric.put(TelemetryClientInfoFields$.MODULE$.IS_PYSPARK(), sparkConf.contains("spark.pyspark.python"));
            ObjectNode sparkMetric = this.mapper().createObjectNode();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                ObjectNode objectNode = MODULE$.sparkOptions().contains((Object)key) ? sparkMetric.put(key, value) : sparkMetric.put(key, "N/A");
                return objectNode;
            });
            Object object = !sparkMetric.isEmpty() ? metric.set(TelemetryClientInfoFields$.MODULE$.SPARK_CONFIG(), (JsonNode)sparkMetric) : BoxedUnit.UNIT;
            ArrayNode sparkLibrariesArray = metric.putArray(TelemetryFieldNames$.MODULE$.LIBRARIES());
            this.getSparkLibraries().foreach((Function1 & Serializable & scala.Serializable)x$1 -> sparkLibrariesArray.add(x$1));
            ArrayNode sparkDependenciesArray = metric.putArray(TelemetryFieldNames$.MODULE$.DEPENDENCIES());
            this.getSparkDependencies().foreach((Function1 & Serializable & scala.Serializable)x$1 -> sparkDependenciesArray.add(x$1));
            this.addSparkClusterStatistics(metric);
            objectNode = this.addTaskInfo(metric);
        }
        catch (Throwable throwable) {
            objectNode = metric;
        }
        return objectNode;
    }

    private Set<String> sparkOptions() {
        return this.sparkOptions;
    }

    public ObjectNode getTaskInfo() {
        ObjectNode objectNode;
        ObjectNode metric = this.mapper().createObjectNode();
        try {
            objectNode = this.addTaskInfo(metric);
        }
        catch (Throwable throwable) {
            objectNode = metric;
        }
        return objectNode;
    }

    private ObjectNode addTaskInfo(ObjectNode metric) {
        BoxedUnit boxedUnit;
        TaskContext task = TaskContext$.MODULE$.get();
        if (task != null) {
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_PARTITION_ID(), task.partitionId());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_ATTEMPT_ID(), task.taskAttemptId());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_ATTEMPT_NUMBER(), task.attemptNumber());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_STAGE_ATTEMPT_NUMBER(), task.stageAttemptNumber());
            metric.put(TelemetryTaskInfoFields$.MODULE$.TASK_STAGE_ID(), task.stageId());
            boxedUnit = metric.put(TelemetryTaskInfoFields$.MODULE$.THREAD_ID(), Thread.currentThread().getId());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return metric;
    }

    public String detectSparkLanguage(SparkConf sparkConf) {
        return sparkConf.contains("spark.r.command") || sparkConf.contains("spark.r.driver.command") || sparkConf.contains("spark.r.shell.command") ? "R" : (sparkConf.contains("spark.pyspark.python") ? "Python" : "Scala");
    }

    public ObjectNode addCommonFields(ObjectNode metric) {
        return metric.put(TelemetryFieldNames$.MODULE$.SPARK_APPLICATION_ID(), this.getSparkApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$sendClientInfoTelemetry$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private SnowflakeTelemetry$() {
        MODULE$ = this;
        this.TELEMETRY_TYPE_FIELD_NAME = "type";
        this.TELEMETRY_SOURCE_FIELD_NAME = "source";
        this.TELEMETRY_DATA_FIELD_NAME = "data";
        this.TELEMETRY_SOURCE = "spark_connector";
        this.TELEMETRY_OOB_NAME_PREFIX = "spark";
        this.logs = Nil$.MODULE$;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.mapper = new ObjectMapper();
        this.MB = 0x100000;
        this.telemetryMessageSender = new SnowflakeTelemetryMessageSender();
        this.cachedSparkApplicationId = None$.MODULE$;
        this.MAX_CACHED_SPARK_PLAN_STATISTIC_COUNT = 1000;
        TelemetryService.enable();
        this.sparkOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.app.name", "spark.app.id", "spark.submit.deployMode", "spark.jars", "spark.master", "spark.repl.local.jars", "spark.driver.host", "spark.driver.extraJavaOptions", "spark.driver.cores", "spark.executor.cores", "spark.executor.instances", "spark.executor.extraJavaOptions", "spark.executor.id", "spark.driver.memory", "spark.driver.memoryOverhead", "spark.executor.memory", "spark.executor.memoryOverhead", "spark.executor.pyspark.memory", "spark.python.worker.memory", "spark.memory.fraction", "spark.memory.storageFraction", "spark.memory.offHeap.enabled", "spark.memory.offHeap.size", "spark.default.parallelism", "spark.dynamicAllocation.enabled", "spark.dynamicAllocation.initialExecutors", "spark.dynamicAllocation.maxExecutors", "spark.dynamicAllocation.minExecutors", "spark.sql.ansi.enabled", "spark.pyspark.driver.python", "spark.pyspark.python", "spark.sql.session.timeZone", "spark.sql.execution.arrow.enabled", "spark.sql.execution.arrow.pyspark.enabled", "spark.sql.execution.arrow.sparkr.enabled"}));
    }
}

