/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.Serializable;
import java.sql.Connection;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.IngestStatus;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.streaming.IngestContextManager$;
import net.snowflake.spark.snowflake.streaming.IngestedFileList;
import net.snowflake.spark.snowflake.streaming.SnowflakeIngestConnector$;
import scala.Function0;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u000f\u001e\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDaa\u001a\u0001!\u0002\u0013!\u0007b\u00025\u0001\u0005\u0004%\ta\u0019\u0005\u0007S\u0002\u0001\u000b\u0011\u00023\t\u000f)\u0004!\u0019!C\u0001W\"1q\u000e\u0001Q\u0001\n1D\u0001\u0002\u001d\u0001\t\u0006\u0004%\u0019!\u001d\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0011\u001di\b\u00011A\u0005\nyDq!!\u0003\u0001A\u0003&!\u0010C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u0018\u0001A)\u0019!C\u0005\u00033A\u0001\"!\u0012\u0001\u0001\u0004%I!\u001f\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0005\u0003\u0013Bq!!\u0014\u0001A\u0003&!\u0010C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R!A\u0011q\f\u0001!\u0002\u0013\t\u0019\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011q\u000e\u0001\u0005\u0002\u00055\u0004bBA9\u0001\u0011%\u00111\u000f\u0002\u0017':|wO\u001a7bW\u0016LenZ3tiN+'O^5dK*\u0011adH\u0001\ngR\u0014X-Y7j]\u001eT!\u0001I\u0011\u0002\u0013Mtwn\u001e4mC.,'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001CEC\u0001&\u0003\rqW\r^\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0006a\u0006\u0014\u0018-\u001c\t\u0003ayr!!\r\u001f\u000f\u0005IZdBA\u001a;\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u00028M\u00051AH]8pizJ\u0011!J\u0005\u0003A\u0011J!AI\u0012\n\u0005\u0001\n\u0013BA\u001f \u0003)\u0001\u0016M]1nKR,'o]\u0005\u0003\u007f\u0001\u0013\u0001#T3sO\u0016$\u0007+\u0019:b[\u0016$XM]:\u000b\u0005uz\u0012\u0001\u00039ja\u0016t\u0015-\\3\u0011\u0005\r;eB\u0001#F!\t)$&\u0003\u0002GU\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%&A\u0004ti>\u0014\u0018mZ3\u0011\u00051{U\"A'\u000b\u00059{\u0012AA5p\u0013\t\u0001VJ\u0001\u0007DY>,Hm\u0015;pe\u0006<W-\u0001\u0003d_:t\u0007CA*Y\u001b\u0005!&BA+W\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0006D_:tWm\u0019;j_:\fa\u0001P5oSRtD#\u0002/_?\u0002\f\u0007CA/\u0001\u001b\u0005i\u0002\"\u0002\u0018\u0006\u0001\u0004y\u0003\"B!\u0006\u0001\u0004\u0011\u0005\"\u0002&\u0006\u0001\u0004Y\u0005\"B)\u0006\u0001\u0004\u0011\u0016AC*M\u000b\u0016\u0003v\fV%N\u000bV\tA\r\u0005\u0002*K&\u0011aM\u000b\u0002\u0005\u0019>tw-A\u0006T\u0019\u0016+\u0005k\u0018+J\u001b\u0016\u0003\u0013A\u0005%J'R{%+W0D\u0011\u0016\u001b5j\u0018+J\u001b\u0016\u000b1\u0003S%T)>\u0013\u0016lX\"I\u000b\u000e[u\fV%N\u000b\u0002\n1dV!J)&sui\u0018+J\u001b\u0016{vJT0U\u000bJk\u0015JT!U\u0013>sU#\u00017\u0011\u0005%j\u0017B\u00018+\u0005\rIe\u000e^\u0001\u001d/\u0006KE+\u0013(H?RKU*R0P\u001d~#VIU'J\u001d\u0006#\u0016j\u0014(!\u00035IgnZ3ti6\u000bg.Y4feV\t!\u000f\u0005\u0002tm6\tAO\u0003\u0002vG\u00051\u0011N\\4fgRL!a\u001e;\u0003'MKW\u000e\u001d7f\u0013:<Wm\u001d;NC:\fw-\u001a:\u0002\u00139|Go\u00117pg\u0016$W#\u0001>\u0011\u0005%Z\u0018B\u0001?+\u0005\u001d\u0011un\u001c7fC:\fQB\\8u\u00072|7/\u001a3`I\u0015\fHcA@\u0002\u0006A\u0019\u0011&!\u0001\n\u0007\u0005\r!F\u0001\u0003V]&$\b\u0002CA\u0004\u001d\u0005\u0005\t\u0019\u0001>\u0002\u0007a$\u0013'\u0001\u0006o_R\u001cEn\\:fI\u0002\n\u0001#\u001b8hKN$X\r\u001a$jY\u0016d\u0015n\u001d;\u0016\u0005\u0005=\u0001cA/\u0002\u0012%\u0019\u00111C\u000f\u0003!%sw-Z:uK\u00124\u0015\u000e\\3MSN$\u0018!E5oO\u0016\u001cH/\u001a3GS2,G*[:uA\u000591\r[3dW\u0016\u0014XCAA\u000e!\u0015I\u0013QDA\u0011\u0013\r\tyB\u000b\u0002\n\rVt7\r^5p]B\u0002b!a\t\u0002.\u0005Mb\u0002BA\u0013\u0003Sq1!NA\u0014\u0013\u0005Y\u0013bAA\u0016U\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u0011A\u0001T5ti*\u0019\u00111\u0006\u0016\u0011\r%\n)DQA\u001d\u0013\r\t9D\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010u\u0003)\u0019wN\u001c8fGRLwN\\\u0005\u0005\u0003\u0007\niD\u0001\u0007J]\u001e,7\u000f^*uCR,8/A\u0006qSB,GI]8qa\u0016$\u0017a\u00049ja\u0016$%o\u001c9qK\u0012|F%Z9\u0015\u0007}\fY\u0005\u0003\u0005\u0002\bQ\t\t\u00111\u0001{\u00031\u0001\u0018\u000e]3Ee>\u0004\b/\u001a3!\u0003\u001d\u0001(o\\2fgN,\"!a\u0015\u0011\u000b\u0005U\u00131L@\u000e\u0005\u0005]#bAA-U\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005u\u0013q\u000b\u0002\u0007\rV$XO]3\u0002\u0011A\u0014xnY3tg\u0002\n1\"\u001b8hKN$h)\u001b7fgR\u0019q0!\u001a\t\u000f\u0005\u001d\u0004\u00041\u0001\u0002j\u0005!A.[:u!\u0015\t\u0019#!\fC\u0003!\u0019G.Z1o\u00032dG#A@\u0002\u000b\rdwn]3\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u0003\u001f\u0001")
public class SnowflakeIngestService {
    private SimpleIngestManager ingestManager;
    private Function0<List<Tuple2<String, IngestStatus>>> checker;
    private Parameters.MergedParameters param;
    private final String pipeName;
    private final CloudStorage storage;
    private final Connection conn;
    private final long SLEEP_TIME;
    private final long HISTORY_CHECK_TIME;
    private final int WAITING_TIME_ON_TERMINATION;
    private boolean notClosed;
    private final IngestedFileList ingestedFileList;
    private boolean pipeDropped;
    private final Future<BoxedUnit> process;
    private volatile byte bitmap$0;

    public long SLEEP_TIME() {
        return this.SLEEP_TIME;
    }

    public long HISTORY_CHECK_TIME() {
        return this.HISTORY_CHECK_TIME;
    }

    public int WAITING_TIME_ON_TERMINATION() {
        return this.WAITING_TIME_ON_TERMINATION;
    }

    private SimpleIngestManager ingestManager$lzycompute() {
        SnowflakeIngestService snowflakeIngestService = this;
        synchronized (snowflakeIngestService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ingestManager = SnowflakeIngestConnector$.MODULE$.createIngestManager(this.param, this.pipeName);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.param = null;
        return this.ingestManager;
    }

    public SimpleIngestManager ingestManager() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ingestManager$lzycompute() : this.ingestManager;
    }

    private boolean notClosed() {
        return this.notClosed;
    }

    private void notClosed_$eq(boolean x$1) {
        this.notClosed = x$1;
    }

    private IngestedFileList ingestedFileList() {
        return this.ingestedFileList;
    }

    private Function0<List<Tuple2<String, IngestStatus>>> checker$lzycompute() {
        SnowflakeIngestService snowflakeIngestService = this;
        synchronized (snowflakeIngestService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.checker = SnowflakeIngestConnector$.MODULE$.createHistoryChecker(this.ingestManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.checker;
    }

    private Function0<List<Tuple2<String, IngestStatus>>> checker() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.checker$lzycompute() : this.checker;
    }

    private boolean pipeDropped() {
        return this.pipeDropped;
    }

    private void pipeDropped_$eq(boolean x$1) {
        this.pipeDropped = x$1;
    }

    private Future<BoxedUnit> process() {
        return this.process;
    }

    public void ingestFiles(List<String> list) {
        SnowflakeIngestConnector$.MODULE$.ingestFiles(list, this.ingestManager());
        this.ingestedFileList().addFiles(list);
    }

    public void cleanAll() {
        while (this.ingestedFileList().nonEmpty()) {
            Thread.sleep(this.SLEEP_TIME());
            long time = System.currentTimeMillis();
            if (time - BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()) > 600000L) {
                this.ingestedFileList().checkResponseList(SnowflakeIngestConnector$.MODULE$.checkHistoryByRange(this.ingestManager(), BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()), time));
                continue;
            }
            this.ingestedFileList().checkResponseList((List<Tuple2<String, IngestStatus>>)((List)this.checker().apply()));
        }
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(this.conn);
        String x$1 = this.pipeName;
        boolean x$2 = qual$1.dropPipe$default$2();
        qual$1.dropPipe(x$1, x$2);
        this.ingestedFileList().remove();
        this.pipeDropped_$eq(true);
    }

    public void close() {
        long ct = System.currentTimeMillis();
        IngestContextManager$.MODULE$.logger().debug((Object)"closing ingest service");
        this.notClosed_$eq(false);
        Await$.MODULE$.result(this.process(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(this.WAITING_TIME_ON_TERMINATION())).minutes());
        if (!this.pipeDropped()) {
            IngestContextManager$.MODULE$.logger().error((Object)new StringBuilder(60).append("closing ingest service time out, please drop pipe: ").append(this.pipeName).append(" manually").toString());
        }
        IngestContextManager$.MODULE$.logger().debug((Object)new StringBuilder(23).append("ingest service closed: ").append((double)(System.currentTimeMillis() - ct) / 1000.0).toString());
    }

    private IngestedFileList init() {
        return IngestContextManager$.MODULE$.readIngestList(this.storage, this.conn);
    }

    public SnowflakeIngestService(Parameters.MergedParameters param, String pipeName, CloudStorage storage, Connection conn) {
        this.param = param;
        this.pipeName = pipeName;
        this.storage = storage;
        this.conn = conn;
        this.SLEEP_TIME = 60000L;
        this.HISTORY_CHECK_TIME = 3600000L;
        this.WAITING_TIME_ON_TERMINATION = 10;
        this.notClosed = true;
        this.ingestedFileList = this.init();
        this.pipeDropped = false;
        this.process = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (this.notClosed()) {
                Thread.sleep(this.SLEEP_TIME());
                long time = System.currentTimeMillis();
                this.ingestedFileList().checkResponseList((List<Tuple2<String, IngestStatus>>)((List)this.checker().apply()));
                if (!this.ingestedFileList().getFirstTimeStamp().isDefined() || time - BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()) <= this.HISTORY_CHECK_TIME()) continue;
                this.ingestedFileList().checkResponseList(SnowflakeIngestConnector$.MODULE$.checkHistoryByRange(this.ingestManager(), BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()), time));
            }
            this.cleanAll();
        }, ExecutionContext.Implicits$.MODULE$.global());
    }
}

