/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.twitter4j;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.twitter.hbc.core.Client;
import com.twitter.hbc.twitter4j.BaseTwitter4jClient;
import com.twitter.hbc.twitter4j.handler.SitestreamHandler;
import com.twitter.hbc.twitter4j.message.DisconnectMessage;
import com.twitter.hbc.twitter4j.message.StallWarningMessage;
import com.twitter.hbc.twitter4j.parser.JSONObjectParser;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import twitter4j.DirectMessage;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.SiteStreamsListener;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;

public class Twitter4jSitestreamClient
extends BaseTwitter4jClient {
    private final List<SiteStreamsListener> sitestreamListeners;
    private final AtomicReference<String> streamId;

    public Twitter4jSitestreamClient(Client client, BlockingQueue<String> blockingQueue, List<SiteStreamsListener> listeners, ExecutorService executorService) {
        super(client, blockingQueue, executorService);
        Preconditions.checkNotNull(listeners);
        this.sitestreamListeners = ImmutableList.copyOf(listeners);
        this.streamId = new AtomicReference();
    }

    @Override
    protected long getSitestreamUser(JSONObject json) throws JSONException {
        try {
            return JSONObjectParser.getSitestreamUser(json);
        }
        catch (JSONException e) {
            this.onException((Exception)((Object)e));
            throw e;
        }
    }

    @Override
    protected JSONObject preprocessMessage(JSONObject json) throws JSONException {
        if (JSONObjectParser.isControlStreamMessage(json)) {
            return json;
        }
        try {
            return JSONObjectParser.getSitestreamMessage(json);
        }
        catch (JSONException e) {
            this.onException((Exception)((Object)e));
            throw e;
        }
    }

    @Override
    protected void onStatus(long sitestreamUser, Status status) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onStatus(sitestreamUser, status);
        }
    }

    @Override
    protected void onDelete(long sitestreamUser, StatusDeletionNotice delete) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onDeletionNotice(sitestreamUser, delete);
        }
    }

    @Override
    protected void onDeleteDirectMessage(long sitestreamUser, long directMessageId, long userId) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onDeletionNotice(sitestreamUser, directMessageId, userId);
        }
    }

    @Override
    protected void onDirectMessage(long sitestreamUser, DirectMessage directMessage) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onDirectMessage(sitestreamUser, directMessage);
        }
    }

    @Override
    protected void onFriends(long sitestreamUser, long[] friendIds) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onFriendList(sitestreamUser, friendIds);
        }
    }

    @Override
    protected void onFavorite(long sitestreamUser, User source, User target, Status faved) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onFavorite(sitestreamUser, source, target, faved);
        }
    }

    @Override
    protected void onUnfavorite(long sitestreamUser, User source, User target, Status unfaved) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUnfavorite(sitestreamUser, source, target, unfaved);
        }
    }

    @Override
    protected void onFollow(long sitestreamUser, User source, User target) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onFollow(sitestreamUser, source, target);
        }
    }

    @Override
    protected void onUnfollow(long sitestreamUser, User source, User target) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUnfollow(sitestreamUser, source, target);
        }
    }

    @Override
    protected void onBlock(long sitestreamUser, User source, User blockedUser) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onBlock(sitestreamUser, source, blockedUser);
        }
    }

    @Override
    protected void onUnblock(long sitestreamUser, User source, User unblockedUser) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUnblock(sitestreamUser, source, unblockedUser);
        }
    }

    @Override
    protected void onUserListCreation(long sitestreamUser, User user, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListCreation(sitestreamUser, user, userList);
        }
    }

    @Override
    protected void onUserListUpdate(long sitestreamUser, User user, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListUpdate(sitestreamUser, user, userList);
        }
    }

    @Override
    protected void onUserListDeletion(long sitestreamUser, User user, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListDeletion(sitestreamUser, user, userList);
        }
    }

    @Override
    protected void onUserListMemberAddition(long sitestreamUser, User addedUser, User user, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListMemberAddition(sitestreamUser, addedUser, user, userList);
        }
    }

    @Override
    protected void onUserListMemberDeletion(long sitestreamUser, User deletedUser, User user, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListMemberDeletion(sitestreamUser, deletedUser, user, userList);
        }
    }

    @Override
    protected void onUserListSubscription(long sitestreamUser, User subscriber, User listOwner, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListSubscription(sitestreamUser, subscriber, listOwner, userList);
        }
    }

    @Override
    protected void onUserListUnsubscription(long sitestreamUser, User subscriber, User listOwner, UserList userList) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserListUnsubscription(sitestreamUser, subscriber, listOwner, userList);
        }
    }

    @Override
    protected void onUserProfileUpdate(long sitestreamUser, User user) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onUserProfileUpdate(sitestreamUser, user);
        }
    }

    @Override
    protected void onControlStreamMessage(String streamId) {
        this.streamId.set(streamId);
    }

    @Override
    protected void onDisconnectMessage(DisconnectMessage disconnect) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            if (!(listener instanceof SitestreamHandler)) continue;
            ((SitestreamHandler)listener).onDisconnectMessage(disconnect);
        }
    }

    @Override
    protected void onStallWarning(StallWarningMessage stallWarning) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            if (!(listener instanceof SitestreamHandler)) continue;
            ((SitestreamHandler)listener).onStallWarningMessage(stallWarning);
        }
    }

    @Override
    protected void onUnknownMessageType(String msg) {
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            if (listener instanceof SitestreamHandler) {
                ((SitestreamHandler)listener).onUnknownMessageType(msg);
                continue;
            }
            super.onUnknownMessageType(msg);
        }
    }

    @Override
    protected void onException(Exception e) {
        super.onException(e);
        for (SiteStreamsListener listener : this.sitestreamListeners) {
            listener.onException(e);
        }
    }

    @Nullable
    public String getStreamId() {
        return this.streamId.get();
    }
}

