/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.MalformedRequest;
import com.twitter.joauth.Normalizer;
import com.twitter.joauth.OAuthParams;
import com.twitter.joauth.Request;
import com.twitter.joauth.UnpackedRequest;
import com.twitter.joauth.UnpackerException;
import com.twitter.joauth.UrlCodec;
import com.twitter.joauth.keyvalue.KeyValueHandler;
import com.twitter.joauth.keyvalue.KeyValueParser;
import com.twitter.joauth.keyvalue.Transformer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface Unpacker {
    public UnpackedRequest unpack(Request var1) throws UnpackerException;

    public UnpackedRequest unpack(Request var1, KeyValueHandler var2) throws UnpackerException;

    public UnpackedRequest unpack(Request var1, List<KeyValueHandler> var2) throws UnpackerException;

    public static class StandardUnpacker
    extends CustomizableUnpacker {
        static final KeyValueCallback callback = new KeyValueCallback(){

            @Override
            public KeyValueHandler invoke(KeyValueHandler kvHandler) {
                return new KeyValueHandler.UrlEncodingNormalizingKeyValueHandler(kvHandler);
            }
        };
        static final OAuth2Checker checker = new OAuth2Checker(){

            @Override
            public boolean shouldAllowOAuth2(Request request, Request.ParsedRequest parsedRequest) {
                return "HTTPS".equalsIgnoreCase(request.scheme());
            }
        };

        public StandardUnpacker(OAuthParams.OAuthParamsHelper helper, Normalizer normalizer, KeyValueParser queryParser, KeyValueParser headerParser) {
            super(helper, normalizer, queryParser, headerParser, callback, callback, callback, checker);
        }
    }

    public static class StandardUnpackerFactory {
        public static StandardUnpacker newUnpacker() {
            return new StandardUnpacker(OAuthParams.STANDARD_OAUTH_PARAMS_HELPER, Normalizer.getStandardNormalizer(), KeyValueParser.QueryKeyValueParser, KeyValueParser.HeaderKeyValueParser);
        }

        public static StandardUnpacker newUnpacker(OAuthParams.OAuthParamsHelper helper) {
            return new StandardUnpacker(helper, Normalizer.getStandardNormalizer(), KeyValueParser.QueryKeyValueParser, KeyValueParser.HeaderKeyValueParser);
        }
    }

    public static class CustomizableUnpacker
    implements Unpacker {
        public static final String WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String HTTPS = "HTTPS";
        private static final Logger log = Logger.getLogger("CustomizableUnpacker");
        private final OAuthParams.OAuthParamsHelper helper;
        private final Normalizer normalizer;
        private final KeyValueParser queryParser;
        private final KeyValueParser headerParser;
        private final KeyValueCallback queryParamTransformer;
        private final KeyValueCallback bodyParamTransformer;
        private final KeyValueCallback headerTransformer;
        private final OAuth2Checker shouldAllowOAuth2;

        public CustomizableUnpacker(OAuthParams.OAuthParamsHelper helper, Normalizer normalizer, KeyValueParser queryParser, KeyValueParser headerParser, KeyValueCallback queryParamTransformer, KeyValueCallback bodyParamTransformer, KeyValueCallback headerTransformer, OAuth2Checker shouldAllowOAuth2) {
            this.helper = helper;
            this.normalizer = normalizer;
            this.queryParser = queryParser;
            this.headerParser = headerParser;
            this.queryParamTransformer = queryParamTransformer;
            this.bodyParamTransformer = bodyParamTransformer;
            this.headerTransformer = headerTransformer;
            this.shouldAllowOAuth2 = shouldAllowOAuth2;
        }

        private KeyValueHandler createKeyValueHandler(KeyValueHandler kvHandler, KeyValueCallback transformer) {
            Transformer processKey = new Transformer(){

                @Override
                public String transform(String input) {
                    return CustomizableUnpacker.this.helper.processKey(input);
                }
            };
            return new KeyValueHandler.KeyTransformingKeyValueHandler(new KeyValueHandler.TrimmingKeyValueHandler(transformer.invoke(kvHandler)), processKey);
        }

        public KeyValueHandler queryParamKeyValueHandler(KeyValueHandler kvHandler) {
            return this.createKeyValueHandler(kvHandler, this.queryParamTransformer);
        }

        public KeyValueHandler bodyParamKeyValueHandler(KeyValueHandler kvHandler) {
            return this.createKeyValueHandler(kvHandler, this.bodyParamTransformer);
        }

        public KeyValueHandler headerParamKeyValueHandler(KeyValueHandler kvHandler) {
            return this.createKeyValueHandler(kvHandler, this.headerTransformer);
        }

        public void parseHeader(String header, KeyValueHandler nonTransformingHandler) {
            int spaceIndex;
            KeyValueHandler handler = this.headerParamKeyValueHandler(nonTransformingHandler);
            if (header != null && (spaceIndex = header.indexOf(32)) != -1 && spaceIndex != 0 && spaceIndex + 1 < header.length()) {
                String authType = header.substring(0, spaceIndex);
                String authString = header.substring(spaceIndex + 1, header.length());
                boolean shouldParse = false;
                boolean oauth2 = false;
                if (authType.equalsIgnoreCase("bearer")) {
                    shouldParse = false;
                    oauth2 = true;
                } else if (authType.equalsIgnoreCase("oauth")) {
                    shouldParse = true;
                    oauth2 = false;
                }
                if (shouldParse) {
                    KeyValueHandler.MaybeQuotedValueKeyValueHandler quotedHandler = new KeyValueHandler.MaybeQuotedValueKeyValueHandler(handler);
                    List<KeyValueHandler> handlers = Collections.singletonList(quotedHandler);
                    this.headerParser.parse(authString, handlers);
                } else if (oauth2) {
                    nonTransformingHandler.handle("Bearer", authString);
                }
            }
        }

        public OAuthParams.OAuthParamsBuilder parseRequest(Request request, List<KeyValueHandler> kvHandlers) {
            OAuthParams.OAuthParamsBuilder oAuthParamsBuilder = new OAuthParams.OAuthParamsBuilder(this.helper);
            this.parseHeader(request.authHeader(), oAuthParamsBuilder.headerHandler);
            if (!oAuthParamsBuilder.isOAuth2()) {
                ArrayList<KeyValueHandler> queryHandlers = new ArrayList<KeyValueHandler>(kvHandlers.size() + 1);
                queryHandlers.add(this.queryParamKeyValueHandler(oAuthParamsBuilder.queryHandler));
                queryHandlers.addAll(kvHandlers);
                ArrayList<KeyValueHandler> bodyParamHandlers = new ArrayList<KeyValueHandler>(kvHandlers.size() + 1);
                bodyParamHandlers.add(this.bodyParamKeyValueHandler(oAuthParamsBuilder.queryHandler));
                bodyParamHandlers.addAll(kvHandlers);
                this.queryParser.parse(request.queryString(), queryHandlers);
                if (request.contentType() != null && request.contentType().startsWith(WWW_FORM_URLENCODED)) {
                    this.queryParser.parse(request.body(), bodyParamHandlers);
                }
            }
            return oAuthParamsBuilder;
        }

        @Override
        public UnpackedRequest unpack(Request request, List<KeyValueHandler> kvHandlers) throws UnpackerException {
            try {
                OAuthParams.OAuthParamsBuilder oAuthParamsBuilder = this.parseRequest(request, kvHandlers);
                Request.ParsedRequest parsedRequest = Request.factory.parsedRequest(request, oAuthParamsBuilder.otherParams());
                if (oAuthParamsBuilder.isOAuth2()) {
                    return this.getOAuth2Request(request, parsedRequest, oAuthParamsBuilder.oAuth2Token());
                }
                if (oAuthParamsBuilder.isOAuth1()) {
                    return this.getOAuth1Request(parsedRequest, oAuthParamsBuilder.oAuth1Params());
                }
                if (oAuthParamsBuilder.isOAuth1TwoLegged()) {
                    return this.getOAuth1TwoLeggedRequest(parsedRequest, oAuthParamsBuilder.oAuth1Params());
                }
                return new UnpackedRequest.UnknownRequest(parsedRequest);
            }
            catch (UnpackerException u) {
                throw u;
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "could not unpack request", t);
                throw new UnpackerException("could not unpack request: " + t, t);
            }
        }

        @Override
        public UnpackedRequest unpack(Request request) throws UnpackerException {
            List<KeyValueHandler> emptyList = Collections.emptyList();
            return this.unpack(request, emptyList);
        }

        @Override
        public UnpackedRequest unpack(Request request, KeyValueHandler kvHandler) throws UnpackerException {
            List<KeyValueHandler> handlers = Collections.singletonList(kvHandler);
            return this.unpack(request, handlers);
        }

        public UnpackedRequest.OAuth1Request getOAuth1Request(Request.ParsedRequest parsedRequest, OAuthParams.OAuth1Params oAuth1Params) throws MalformedRequest, UnsupportedEncodingException {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("building oauth1 request -> path = %s, host = %s, token = %s, consumer key = %s, signature = %s, method = %s", parsedRequest.path(), parsedRequest.host(), oAuth1Params.token(), oAuth1Params.consumerKey(), oAuth1Params.signature(), oAuth1Params.signatureMethod()));
            }
            return UnpackedRequest.O_AUTH_1_REQUEST_HELPER.buildOAuth1Request(parsedRequest, oAuth1Params, this.normalizer);
        }

        public UnpackedRequest.OAuth1TwoLeggedRequest getOAuth1TwoLeggedRequest(Request.ParsedRequest parsedRequest, OAuthParams.OAuth1Params oAuth1Params) throws MalformedRequest, UnsupportedEncodingException {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("building oauth1 two-legged request -> path = %s, host = %s, consumer key = %s, signature = %s, method = %s", parsedRequest.path(), parsedRequest.host(), oAuth1Params.consumerKey(), oAuth1Params.signature(), oAuth1Params.signatureMethod()));
            }
            return UnpackedRequest.O_AUTH_1_REQUEST_HELPER.buildOAuth1TwoLeggedRequest(parsedRequest, oAuth1Params, this.normalizer);
        }

        public UnpackedRequest.OAuth2Request getOAuth2Request(Request request, Request.ParsedRequest parsedRequest, String token) throws UnsupportedEncodingException, MalformedRequest {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("building oauth2 request -> path = %s, host = %s, token = %s", parsedRequest.path(), parsedRequest.host(), token));
            }
            if (this.shouldAllowOAuth2.shouldAllowOAuth2(request, parsedRequest)) {
                return new UnpackedRequest.OAuth2Request(UrlCodec.decode(token), parsedRequest, "");
            }
            throw new MalformedRequest("OAuth 2.0 requests not allowed");
        }
    }

    public static interface OAuth2Checker {
        public boolean shouldAllowOAuth2(Request var1, Request.ParsedRequest var2);
    }

    public static interface KeyValueCallback {
        public KeyValueHandler invoke(KeyValueHandler var1);
    }
}

