/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.metrics.Model;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.RecordsProbeType;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.metrics.DataStoreMetricsStatusService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.LazyHashMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionDataReportingService {
    private final TransactionService transactionService;
    private final ProjectsService projectsService;
    private final DatasetsDAO datasetsDAO;
    private final ManagedFolderDAO managedFolderDAO;
    private final DatasetAccessService datasetAccessService;
    private final DatasetMetricsStatusService datasetMetricsStatusService;
    private final DataStoreMetricsStatusService dataStoreMetricsStatusService;
    private static final String SIZE_METRIC_ID = new BasicProbeType.BasicMetric(BasicProbeType.BasicMetrics.SIZE).getId();
    private static final String FILE_COUNT_METRIC_ID = new BasicProbeType.BasicMetric(BasicProbeType.BasicMetrics.COUNT_FILES).getId();
    private static final String RECORD_COUNT_METRIC_ID = new RecordsProbeType.RecordsMetric(RecordsProbeType.RecordsMetrics.COUNT_RECORDS).getId();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku");

    @Autowired
    public ConnectionDataReportingService(TransactionService transactionService, ProjectsService projectsService, DatasetsDAO datasetsDAO, ManagedFolderDAO managedFolderDAO, DatasetAccessService datasetAccessService, DatasetMetricsStatusService datasetMetricsStatusService, DataStoreMetricsStatusService dataStoreMetricsStatusService) {
        this.transactionService = transactionService;
        this.projectsService = projectsService;
        this.datasetsDAO = datasetsDAO;
        this.managedFolderDAO = managedFolderDAO;
        this.datasetAccessService = datasetAccessService;
        this.datasetMetricsStatusService = datasetMetricsStatusService;
        this.dataStoreMetricsStatusService = dataStoreMetricsStatusService;
    }

    public ConnectionData getConnectionData_NT(String connectionId) throws Exception {
        ConnectionData cd = new ConnectionData();
        List<Dataset> datasets = this.listDatasetOfConnection_NT(connectionId);
        logger.infoV("Connection %s is used by %d datasets", new Object[]{connectionId, datasets.size()});
        List<ManagedFolder> managedFolders = this.listManagedFoldersOfConnection_NT(connectionId);
        logger.infoV("Connection %s is used by %d manage folders", new Object[]{connectionId, managedFolders.size()});
        List<DataPoint> dataSetDataPoints = this.computeDataPoints(datasets, SIZE_METRIC_ID, RECORD_COUNT_METRIC_ID);
        List<DataPoint> managedFolderDataPoints = this.computeDataPoints(managedFolders, SIZE_METRIC_ID, FILE_COUNT_METRIC_ID);
        cd.byProject = this.aggregateByProject(dataSetDataPoints, managedFolderDataPoints);
        cd.global = this.aggregateGlobally(dataSetDataPoints, managedFolderDataPoints);
        return cd;
    }

    public ProjectData getConnectionProjectData_NT(String connectionId, String projectKey) throws Exception {
        ProjectData pd = new ProjectData();
        pd.projectKey = projectKey;
        List<Dataset> datasets = this.listDatasetOfConnectionAndProject_NT(connectionId, projectKey);
        List<ManagedFolder> managedFolders = this.listManagedFoldersOfConnectionAndProject_NT(connectionId, projectKey);
        logger.infoV("Connection %s is used by %d datasets in %s", new Object[]{connectionId, datasets.size(), projectKey});
        pd.datasetDataPoints = this.computeDataPoints(datasets, SIZE_METRIC_ID, RECORD_COUNT_METRIC_ID);
        pd.managedFolderDataPoints = this.computeDataPoints(managedFolders, SIZE_METRIC_ID, FILE_COUNT_METRIC_ID);
        return pd;
    }

    public FutureResponse<?> updateForProject(AuthCtx user, String connectionId, String projectKey, boolean computeRecords, boolean forceRecompute) throws Exception {
        List dataStores = Stream.concat(this.listDatasetOfConnectionAndProject_NT(connectionId, projectKey).stream(), this.listManagedFoldersOfConnectionAndProject_NT(connectionId, projectKey).stream()).toList();
        return this.updateStatusForDataStores(user, dataStores, computeRecords, forceRecompute);
    }

    public FutureResponse<?> updateForDataset(AuthCtx user, String projectKey, String datasetName, boolean computeRecords, boolean forceRecompute) throws Exception {
        List<Dataset> datasets;
        try (Transaction t = this.transactionService.beginRead();){
            datasets = List.of(this.datasetAccessService.getMandatoryUnsafe(projectKey, datasetName));
        }
        return this.updateStatusForDataStores(user, datasets, computeRecords, forceRecompute);
    }

    public FutureResponse<?> updateForManagedFolder(AuthCtx user, String projectKey, String managedFolderName, boolean forceRecompute) throws Exception {
        List<ManagedFolder> managedFolders;
        try (Transaction t = this.transactionService.beginRead();){
            managedFolders = List.of((ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(projectKey, managedFolderName));
        }
        return this.updateStatusForDataStores(user, managedFolders, false, forceRecompute);
    }

    private void computeRatios(List<StorageUsageOverview> ret) {
        long totalRecordCount = 0L;
        long totalDatasetsSize = 0L;
        long totalFileCount = 0L;
        long totalManagedFoldersSize = 0L;
        long totalSize = 0L;
        for (StorageUsageOverview adp : ret) {
            if (adp.records.totalValue > 0L) {
                totalRecordCount += adp.records.totalValue;
            }
            if (adp.datasetsSize.totalValue > 0L) {
                totalDatasetsSize += adp.datasetsSize.totalValue;
            }
            if (adp.fileCount.totalValue > 0L) {
                totalFileCount += adp.fileCount.totalValue;
            }
            if (adp.managedFoldersSize.totalValue > 0L) {
                totalManagedFoldersSize += adp.managedFoldersSize.totalValue;
            }
            if (adp.totalSize.totalValue <= 0L) continue;
            totalSize += adp.totalSize.totalValue;
        }
        for (StorageUsageOverview adp : ret) {
            if (totalRecordCount > 0L && adp.records.totalValue > 0L) {
                adp.records.ratioOfTotal = (double)adp.records.totalValue / (double)totalRecordCount;
            }
            if (totalDatasetsSize > 0L && adp.datasetsSize.totalValue > 0L) {
                adp.datasetsSize.ratioOfTotal = (double)adp.datasetsSize.totalValue / (double)totalDatasetsSize;
            }
            if (totalFileCount > 0L && adp.fileCount.totalValue > 0L) {
                adp.fileCount.ratioOfTotal = (double)adp.fileCount.totalValue / (double)totalFileCount;
            }
            if (totalManagedFoldersSize > 0L && adp.managedFoldersSize.totalValue > 0L) {
                adp.managedFoldersSize.ratioOfTotal = (double)adp.managedFoldersSize.totalValue / (double)totalManagedFoldersSize;
            }
            if (totalSize <= 0L || adp.totalSize.totalValue <= 0L) continue;
            adp.totalSize.ratioOfTotal = (double)adp.totalSize.totalValue / (double)totalSize;
        }
    }

    private List<StorageUsageOverview> aggregateByProject(List<DataPoint> datasetDataPoints, List<DataPoint> managedFolderDataPoints) {
        StorageUsageOverview adp;
        LazyHashMap lm = new LazyHashMap(StorageUsageOverview.class);
        for (DataPoint dp : datasetDataPoints) {
            adp = (StorageUsageOverview)lm.getOrCreate((Object)dp.projectKey);
            ++adp.nbDatasets;
            adp.key = dp.projectKey;
            adp.datasetsSize.merge(dp.size);
            adp.totalSize.merge(dp.size);
            adp.records.merge(dp.itemCount);
        }
        for (DataPoint dp : managedFolderDataPoints) {
            adp = (StorageUsageOverview)lm.getOrCreate((Object)dp.projectKey);
            ++adp.nbManagedFolders;
            adp.key = dp.projectKey;
            adp.managedFoldersSize.merge(dp.size);
            adp.totalSize.merge(dp.size);
            adp.fileCount.merge(dp.itemCount);
        }
        ArrayList ret = Lists.newArrayList((Iterable)lm.values());
        this.computeRatios(ret);
        return ret;
    }

    private StorageUsageOverview aggregateGlobally(List<DataPoint> datasetDataPoints, List<DataPoint> managedFolderDataPoints) {
        StorageUsageOverview adp = new StorageUsageOverview();
        for (DataPoint dp : datasetDataPoints) {
            ++adp.nbDatasets;
            adp.datasetsSize.merge(dp.size);
            adp.records.merge(dp.itemCount);
        }
        for (DataPoint dp : managedFolderDataPoints) {
            ++adp.nbManagedFolders;
            adp.managedFoldersSize.merge(dp.size);
            adp.fileCount.merge(dp.itemCount);
        }
        return adp;
    }

    private List<DataPoint> computeDataPoints(List<? extends Partitionable> dataStores, String sizeMetricId, String itemCountMetricId) throws Exception {
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        for (Partitionable partitionable : dataStores) {
            DataPoint dataPoint = new DataPoint();
            dataPoint.projectKey = partitionable.getProjectKey();
            dataPoint.dataStoreId = partitionable.getName();
            dataPoint.dataStoreName = this.getDataStoreName(partitionable);
            DataStoreMetricsStatusService.DataStoreSummaryStatus summaryStatus = this.dataStoreMetricsStatusService.getCachedSummaryStatus(partitionable, Set.of(sizeMetricId, itemCountMetricId));
            dataPoint.itemCount = new Model.AggregatedDatasetsMetricValue();
            dataPoint.itemCount.merge(summaryStatus.metricIdToValueMap().get(itemCountMetricId));
            dataPoint.size = new Model.AggregatedDatasetsMetricValue();
            dataPoint.size.merge(summaryStatus.metricIdToValueMap().get(sizeMetricId));
            dataPoints.add(dataPoint);
            long totalRecords = 0L;
            long totalSize = 0L;
            for (DataPoint dp : dataPoints) {
                if (dp.itemCount.totalValue > 0L) {
                    totalRecords += dp.itemCount.totalValue;
                }
                if (dp.size.totalValue <= 0L) continue;
                totalSize += dp.size.totalValue;
            }
            for (DataPoint dp : dataPoints) {
                if (totalRecords > 0L && dp.itemCount.totalValue > 0L) {
                    dp.itemCount.ratioOfTotal = (double)dp.itemCount.totalValue / (double)totalRecords;
                }
                if (totalSize <= 0L || dp.size.totalValue <= 0L) continue;
                dp.size.ratioOfTotal = (double)dp.size.totalValue / (double)totalSize;
            }
        }
        return dataPoints;
    }

    private String getDataStoreName(Partitionable dataStore) {
        if (dataStore instanceof TaggableObjectsService.TaggableObject) {
            TaggableObjectsService.TaggableObject taggableObject = (TaggableObjectsService.TaggableObject)((Object)dataStore);
            return taggableObject.getDisplayName();
        }
        return dataStore.getName();
    }

    private List<Dataset> listDatasetOfConnection_NT(String connectionId) throws IOException {
        return this.listDatasetOfConnection_NT(connectionId, List.of());
    }

    private List<Dataset> listDatasetOfConnectionAndProject_NT(String connectionId, String projectKey) throws IOException {
        return this.listDatasetOfConnection_NT(connectionId, List.of(projectKey));
    }

    private List<Dataset> listDatasetOfConnection_NT(String connectionId, List<String> optionalProjectKeyList) throws IOException {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        logger.infoV("Getting connection usage for %s", new Object[]{connectionId});
        try (Transaction t = this.transactionService.beginRead();){
            List<String> effectiveProjectList = !optionalProjectKeyList.isEmpty() ? optionalProjectKeyList : this.projectsService.listKeys();
            for (String spProjectKey : effectiveProjectList) {
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(spProjectKey)) {
                    if (sd.getParams() == null || !StringUtils.equals((String)connectionId, (String)sd.getParams().getConnection())) continue;
                    datasets.add(Dataset.fromSerializedUnsafe(sd));
                }
            }
        }
        return datasets;
    }

    private List<ManagedFolder> listManagedFoldersOfConnection_NT(String connectionId) throws IOException {
        return this.listManagedFoldersOfConnection_NT(connectionId, List.of());
    }

    private List<ManagedFolder> listManagedFoldersOfConnectionAndProject_NT(String connectionId, String projectKey) throws IOException {
        return this.listManagedFoldersOfConnection_NT(connectionId, List.of(projectKey));
    }

    private List<ManagedFolder> listManagedFoldersOfConnection_NT(String connectionId, List<String> optionalProjectKeyList) throws IOException {
        ArrayList<ManagedFolder> managedFolderList = new ArrayList<ManagedFolder>();
        logger.infoV("Getting connection usage for %s", new Object[]{connectionId});
        try (Transaction t = this.transactionService.beginRead();){
            List<String> effectiveProjectList = !optionalProjectKeyList.isEmpty() ? optionalProjectKeyList : this.projectsService.listKeys();
            for (String spProjectKey : effectiveProjectList) {
                for (ManagedFolder managedFolder : this.managedFolderDAO.listUnsafe(spProjectKey)) {
                    if (managedFolder.getParams() == null || !StringUtils.equals((String)connectionId, (String)managedFolder.getParams().getConnection())) continue;
                    managedFolderList.add(managedFolder);
                }
            }
        }
        return managedFolderList;
    }

    private FutureResponse<?> updateStatusForDataStores(AuthCtx user, List<? extends Partitionable> dataStores, boolean computeRecords, boolean forceRecompute) throws Exception {
        return this.datasetMetricsStatusService.refreshMultiSummaries_F(user, dataStores, computeRecords, forceRecompute);
    }

    public static class ConnectionData {
        StorageUsageOverview global;
        public List<StorageUsageOverview> byProject = new ArrayList<StorageUsageOverview>();
    }

    public static class StorageUsageOverview {
        public String key;
        public Model.AggregatedDatasetsMetricValue totalSize = new Model.AggregatedDatasetsMetricValue();
        public int nbDatasets;
        public Model.AggregatedDatasetsMetricValue datasetsSize = new Model.AggregatedDatasetsMetricValue();
        public Model.AggregatedDatasetsMetricValue records = new Model.AggregatedDatasetsMetricValue();
        public int nbManagedFolders;
        public Model.AggregatedDatasetsMetricValue managedFoldersSize = new Model.AggregatedDatasetsMetricValue();
        public Model.AggregatedDatasetsMetricValue fileCount = new Model.AggregatedDatasetsMetricValue();
    }

    public static class ProjectData {
        public String projectKey;
        public List<DataPoint> datasetDataPoints = new ArrayList<DataPoint>();
        public List<DataPoint> managedFolderDataPoints = new ArrayList<DataPoint>();
    }

    public static class DataPoint {
        public String projectKey;
        public String dataStoreName;
        public String dataStoreId;
        public Model.AggregatedDatasetsMetricValue size;
        public Model.AggregatedDatasetsMetricValue itemCount;
    }
}

