/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.activity.UsageSummaryBuilderUtils;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.jobrunner.JobRuntimeSummary;
import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JobsSummaryReportBuilder {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    private UsageSummaryBuilderUtils usbu = new UsageSummaryBuilderUtils();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    public JobsSummaryReportBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private ProjectJobsRunSummaryReport buildForProject(String projectKey) throws Exception {
        ProjectJobsRunSummaryReport ret = new ProjectJobsRunSummaryReport();
        ret.projectId = DigestUtils.md5Hex((String)projectKey);
        logger.info((Object)("Building jobs report for project " + projectKey));
        long from = System.currentTimeMillis() - 604800000L;
        long to = System.currentTimeMillis();
        ret.from = from;
        ret.to = to;
        File jobsFolder = ApplicationConfigurator.getFile((String[])new String[]{"jobs", projectKey});
        if (jobsFolder.isDirectory()) {
            int count = 0;
            for (File jobFolder : jobsFolder.listFiles()) {
                File summaryFile;
                long lastModified = jobFolder.lastModified();
                if (lastModified < from || lastModified > to || !(summaryFile = new File(jobFolder, "run-summary.json")).isFile()) continue;
                this.mergeJobSummary(ret, summaryFile);
                ++count;
            }
            if (count > 0) {
                logger.infoV("Merging %s job summaries for project %s", new Object[]{count, projectKey});
            }
        }
        if (ret.activitiesPerType.size() == 0) {
            ret.activitiesPerType = null;
        }
        if (ret.activitiesPerEngine.size() == 0) {
            ret.activitiesPerEngine = null;
        }
        if (ret.activitiesPerTypeAndEngine.size() == 0) {
            ret.activitiesPerTypeAndEngine = null;
        }
        if (ret.activitiesPerTypeAndContainer.size() == 0) {
            ret.activitiesPerTypeAndContainer = null;
        }
        if (ret.activitiesPerState.size() == 0) {
            ret.activitiesPerState = null;
        }
        if (ret.activitiesPerFailureCode.size() == 0) {
            ret.activitiesPerFailureCode = null;
        }
        if (ret.activitiesPerTypeAndState.size() == 0) {
            ret.activitiesPerTypeAndState = null;
        }
        if (ret.activitiesPerTypeAndFailureCode.size() == 0) {
            ret.activitiesPerTypeAndFailureCode = null;
        }
        if (ret.activitiesPerRequiredReasonType.size() == 0) {
            ret.activitiesPerRequiredReasonType = null;
        }
        return ret;
    }

    private void mergeJobSummary(ProjectJobsRunSummaryReport summ, File summaryFile) {
        try {
            ++summ.nbJobs;
            JobRuntimeSummary jrs = (JobRuntimeSummary)JSON.parseFile((File)summaryFile, JobRuntimeSummary.class);
            for (JobActivity.ActivityRunSummary ars : jrs.activities) {
                ++summ.nbActivities;
                UsageSummaryBuilderUtils.inc(summ.activitiesPerType, ars.activityType);
                UsageSummaryBuilderUtils.inc(summ.activitiesPerEngine, ars.engineType);
                String arsActivityTypeNN = StringUtils.defaultIfEmpty((String)ars.activityType, (String)"null");
                String arsEngineTypeNN = StringUtils.defaultIfEmpty((String)ars.engineType, (String)"null");
                UsageSummaryBuilderUtils.inc(summ.activitiesPerTypeAndEngine, arsActivityTypeNN + "__" + ars.engineType);
                if (ars.containerConfType != null) {
                    UsageSummaryBuilderUtils.inc(summ.activitiesPerTypeAndContainer, arsActivityTypeNN + "__" + ars.containerConfType);
                    UsageSummaryBuilderUtils.inc(summ.activitiesPerEngineAndContainer, arsEngineTypeNN + "__" + ars.containerConfType);
                }
                UsageSummaryBuilderUtils.inc(summ.activitiesPerState, ars.state);
                UsageSummaryBuilderUtils.inc(summ.activitiesPerTypeAndState, arsActivityTypeNN + "__" + ars.state);
                if (!"DONE".equals(ars.state)) {
                    UsageSummaryBuilderUtils.inc(summ.activitiesPerFailureCode, ars.failureCode);
                    UsageSummaryBuilderUtils.inc(summ.activitiesPerTypeAndFailureCode, arsActivityTypeNN + "__" + ars.failureCode);
                }
                UsageSummaryBuilderUtils.inc(summ.activitiesPerRequiredReasonType, ars.requiredReasonType);
                if (ars.totalTime != null) {
                    summ.totalTime += ars.totalTime.longValue();
                }
                if (ars.preparingTime != null) {
                    summ.preparingTime += ars.preparingTime.longValue();
                }
                if (ars.waitingTime != null) {
                    summ.waitingTime += ars.waitingTime.longValue();
                }
                if (ars.runningTime == null) continue;
                summ.runningTime += ars.runningTime.longValue();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to handle job summary file: " + String.valueOf(summaryFile) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private JobsRunSummaryReport build() throws Exception {
        JobsRunSummaryReport ret = new JobsRunSummaryReport();
        List<String> projectKeys = null;
        try (Transaction t = this.transactionService.beginRead();){
            projectKeys = this.projectsService.listProjectKeys();
        }
        for (String projectKey : projectKeys) {
            try {
                ret.projects.add(this.buildForProject(projectKey));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to build jobs report for project " + projectKey), (Throwable)e);
            }
        }
        return ret;
    }

    public ReportsManagementService.ReadyReport buildReport() throws Exception {
        return new ReportsManagementService.ReadyReport("jobs-run-summary", JSON.toJsonObject((Object)this.build(), (String[])new String[0]));
    }

    public static class ProjectJobsRunSummaryReport {
        public String projectId;
        public int nbJobs;
        public long nbActivities;
        public long from;
        public long to;
        public long totalTime = 0L;
        public long preparingTime = 0L;
        public long waitingTime = 0L;
        public long runningTime = 0L;
        private Map<String, Integer> activitiesPerType = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerEngine = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerTypeAndEngine = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerTypeAndContainer = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerEngineAndContainer = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerState = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerFailureCode = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerTypeAndState = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerTypeAndFailureCode = new HashMap<String, Integer>();
        private Map<String, Integer> activitiesPerRequiredReasonType = new HashMap<String, Integer>();
    }

    public static class JobsRunSummaryReport {
        public List<ProjectJobsRunSummaryReport> projects = new ArrayList<ProjectJobsRunSummaryReport>();
    }
}

