/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewInternalDB;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.agentreview.AgentReviewsDAO;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentReviewCRUDService {
    @Autowired
    private AgentReviewsDAO agentReviewsDAO;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private AgentReviewInternalDB agentReviewInternalDB;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.agentReviewCRUD");

    public AgentReview getMandatory(String projectKey, String id) throws IOException, CodedException {
        return (AgentReview)this.agentReviewsDAO.getMandatory(projectKey, id);
    }

    public List<AgentReview> list(String projectKey) throws IOException {
        return this.agentReviewsDAO.list(projectKey);
    }

    public List<AgentReview> listUnsafe(String projectKey) throws IOException {
        return this.agentReviewsDAO.listUnsafe(projectKey);
    }

    public void delete(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws IOException, CodedException, SQLException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AgentReview agentReview = (AgentReview)this.agentReviewsDAO.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, agentReview);
        JsonObject details = new JsonObject();
        if (agentReview != null) {
            details.addProperty("objectDisplayName", agentReview.name);
        }
        this.agentReviewsDAO.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.AGENT_REVIEW, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.AGENT_REVIEW_DELETE).withDetails(details));
    }

    public void clearAgentReviewForDeletion(String projectKey, String agentReviewId) throws SQLException {
        this.agentReviewInternalDB.clearAgentReviewData(projectKey, agentReviewId);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws IOException {
        return new TaggableObjectsDeletionService.DeletionImpact();
    }

    public AgentReview upsertAgentReview(AuthCtx user, AgentReview agentReview, boolean withDefaultTraitsAtCreation) throws IOException, CodedException, LicenseRestrictionException, DKUSecurityException {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)agentReview.projectKey);
        Preconditions.checkNotNull((Object)agentReview.name);
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = this.licenseEnforcementService.getFeaturesStatus();
        if (!featuresStatus.advancedLLMMeshAllowed) {
            throw new LicenseRestrictionException("Agent review requires Advanced LLM Mesh, which is not enabled in your license.");
        }
        AgentReview agentReviewToSave = (AgentReview)JSON.deepCopy((Object)agentReview);
        AgentReview preExisting = null;
        if (agentReview.id != null) {
            preExisting = (AgentReview)this.agentReviewsDAO.getMandatory(agentReview.projectKey, agentReview.id);
        }
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(agentReviewToSave, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", agentReviewToSave.name);
        for (AgentReviewTrait trait : agentReviewToSave.traits) {
            if (trait.id != null) continue;
            trait.id = SecretKeyGenerator.generate((int)10);
        }
        if (preExisting == null) {
            agentReviewToSave.creationTag = new VersionTag(t.getUser().getIdentifier());
            agentReviewToSave.id = SecretKeyGenerator.generate((int)10);
            agentReviewToSave.owner = t.getUser().getIdentifier();
            agentReviewToSave.creationTimestamp = System.currentTimeMillis();
            if (withDefaultTraitsAtCreation) {
                agentReviewToSave.traits.add(AgentReviewTrait.reference(null));
                agentReviewToSave.traits.add(AgentReviewTrait.expectations(null));
            }
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(agentReviewToSave);
            action = TaggableObjectChangedEvent.ActionType.AGENT_REVIEW_CREATE;
        } else if (!agentReviewToSave.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.AGENT_REVIEW_RENAME;
            details.addProperty("newName", agentReviewToSave.name);
            details.addProperty("oldName", preExisting.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.AGENT_REVIEW_EDIT;
            diff = this.colaborativeMetadataDiffService.diff(preExisting, agentReviewToSave, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), preExisting, agentReviewToSave);
        if (action.equals((Object)TaggableObjectChangedEvent.ActionType.AGENT_REVIEW_CREATE)) {
            logger.infoV("Saving new agent review %s", new Object[]{agentReviewToSave.id});
        } else {
            logger.infoV("Updating agent review %s", new Object[]{agentReviewToSave.id});
        }
        this.agentReviewsDAO.save(agentReviewToSave);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        } else {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.AGENT_REVIEW, agentReviewToSave.projectKey, agentReviewToSave.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(agentReviewToSave.projectKey, agentReviewToSave.tags);
        return agentReviewToSave;
    }
}

