/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewExecutionResult;
import com.dataiku.dip.agentreview.AgentReviewHumanReview;
import com.dataiku.dip.agentreview.AgentReviewRawExecutionResult;
import com.dataiku.dip.agentreview.AgentReviewResult;
import com.dataiku.dip.agentreview.AgentReviewRun;
import com.dataiku.dip.agentreview.AgentReviewRunState;
import com.dataiku.dip.agentreview.AgentReviewService;
import com.dataiku.dip.agentreview.AgentReviewTest;
import com.dataiku.dip.agentreview.AgentReviewTestOverview;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.agentreview.AgentReviewTraitOutcome;
import com.dataiku.dip.agentreview.AgentReviewTraitOverride;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.AddColumnQueryBuilder;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AgentReviewInternalDB
extends AbstractDSSDBService {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private static final int SCHEMA_VERSION = 2;
    private static final String DB_NAME = "agent-review";
    public static final String MAX_BATCH_COUNT_KEY = "dku.agentreview.batching.maxCount";
    public static final int MAX_BATCH_COUNT_DEFAULT = 100;
    public static final String MAX_BATCH_SIZE_KEY = "dku.agentreview.batching.maxSize";
    public static final long MAX_BATCH_SIZE_DEFAULT = 10000000L;
    public static final String MAX_HISTORY_COUNT_KEY = "dku.agentreview.historydetails.maxCount";
    public static final int MAX_HISTORY_COUNT_DEFAULT = 500;
    public static final String MAX_HISTORY_SIZE_KEY = "dku.agentreview.historydetails.maxSize";
    public static final long MAX_HISTORY_SIZE_DEFAULT = 0x6400000L;
    public static final List<String> TABLES = ImmutableList.of((Object)"AGENT_REVIEW_TEST", (Object)"AGENT_REVIEW_RUN", (Object)"AGENT_REVIEW_RESULT", (Object)"AGENT_REVIEW_HUMAN_REVIEW", (Object)"AGENT_REVIEW_EXECUTION_RESULT", (Object)"AGENT_REVIEW_TRAIT_OVERRIDE", (Object)"AGENT_REVIEW_TRAIT_DEFINITION", (Object)"AGENT_REVIEW_TRAIT_OUTCOME");
    private final String listTests = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TEST") + " WHERE " + this.quote("TEST__PROJECT_KEY") + "=? AND " + this.quote("TEST__AGENT_REVIEW_ID") + "=? ORDER BY " + this.quote("TEST__CREATION_TIMESTAMP") + " DESC";
    private final String listSelectedTests = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TEST") + " WHERE " + this.quote("TEST__PROJECT_KEY") + "=? AND " + this.quote("TEST__AGENT_REVIEW_ID") + "=? AND " + this.quote("TEST__ID") + " IN(:testIds:) ORDER BY " + this.quote("TEST__CREATION_TIMESTAMP") + " DESC";
    private final String countTests = "SELECT COUNT(*) FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TEST") + " WHERE " + this.quote("TEST__PROJECT_KEY") + "=? AND " + this.quote("TEST__AGENT_REVIEW_ID") + "=?";
    private final String listTestIds = "SELECT " + this.quote("TEST__ID") + " FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TEST") + " WHERE " + this.quote("TEST__PROJECT_KEY") + "=? AND " + this.quote("TEST__AGENT_REVIEW_ID") + "=?";
    private final String getTest = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TEST") + " WHERE " + this.quote("TEST__PROJECT_KEY") + "=? AND " + this.quote("TEST__ID") + "=?";
    private final String insertTest = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_TEST")).addColumns(TestTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String updateTest = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TEST") + " SET " + this.quote("TEST__QUERY") + "=? ," + this.quote("TEST__REFERENCE_ANSWER") + "=? ," + this.quote("TEST__EXPECTATIONS") + "=? ," + this.quote("TEST__LAST_MODIFIED_BY") + "=? ," + this.quote("TEST__LAST_MODIFIED_TIMESTAMP") + "=? WHERE " + this.quote("TEST__ID") + "=? AND " + this.quote("TEST__PROJECT_KEY") + "=?";
    private final String deleteTestsForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TEST")).withParameterizedEqualWheres("TEST__PROJECT_KEY").withParameterizedEqualWheres("TEST__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String deleteTest = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TEST")).withParameterizedEqualWheres("TEST__PROJECT_KEY").withParameterizedEqualWheres("TEST__ID").toSql(this.getDialect());
    private final String listRuns = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=? ORDER BY " + this.quote("RUN__START_TIMESTAMP") + " DESC";
    private final String getMaxRunId = "SELECT COALESCE(MAX(CAST(" + this.quote("RUN__ID") + " AS INTEGER)), 0) FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=?";
    private final String countRuns = "SELECT COUNT(*) FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=?";
    private final String countDanglingRuns = "SELECT COUNT(*) FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__STATUS") + "=?";
    private final String getRun = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=? AND " + this.quote("RUN__ID") + "=?";
    private final String getPreviousFinishedRunBefore = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=? AND " + this.quote("RUN__STATUS") + "=? AND " + this.quote("RUN__START_TIMESTAMP") + " < ? ORDER BY " + this.quote("RUN__START_TIMESTAMP") + " DESC";
    private final String insertRun = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_RUN")).addColumns(RunTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String finishRun = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " SET " + this.quote("RUN__END_TIMESTAMP") + "=? ," + this.quote("RUN__STATUS") + "=? WHERE " + this.quote("RUN__ID") + "=? AND " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=?";
    private final String updateRunState = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " SET " + this.quote("RUN__STATUS") + "=? ," + this.quote("RUN__ERROR_MESSAGE") + "=? ," + this.quote("RUN__END_TIMESTAMP") + "=? WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=? AND " + this.quote("RUN__ID") + "=?";
    private final String updateRunName = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " SET " + this.quote("RUN__NAME") + "=? WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=? AND " + this.quote("RUN__ID") + "=?";
    private final String getTestIdsForRun = "SELECT " + this.quote("RUN__TEST_IDS") + " FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " WHERE " + this.quote("RUN__PROJECT_KEY") + "=? AND " + this.quote("RUN__AGENT_REVIEW_ID") + "=? AND " + this.quote("RUN__ID") + "=?";
    private final String finishDanglingJobs = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " SET " + this.quote("RUN__STATUS") + "=? ," + this.quote("RUN__ERROR_MESSAGE") + "=? ," + this.quote("RUN__END_TIMESTAMP") + "=? WHERE " + this.quote("RUN__STATUS") + "=?";
    private final String deleteRunsForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_RUN")).withParameterizedEqualWheres("RUN__PROJECT_KEY").withParameterizedEqualWheres("RUN__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String deleteRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_RUN")).withParameterizedEqualWheres("RUN__PROJECT_KEY").withParameterizedEqualWheres("RUN__AGENT_REVIEW_ID").withParameterizedEqualWheres("RUN__ID").toSql(this.getDialect());
    private final String getResult = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RESULT") + " WHERE " + this.quote("RESULT__PROJECT_KEY") + "=? AND " + this.quote("RESULT__ID") + "=?";
    private final String insertResult = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_RESULT")).addColumns(ResultTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String deleteResultsForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_RESULT")).withParameterizedEqualWheres("RESULT__PROJECT_KEY").withParameterizedEqualWheres("RESULT__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String deleteResultForRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_RESULT")).withParameterizedEqualWheres("RESULT__PROJECT_KEY").withParameterizedEqualWheres("RESULT__AGENT_REVIEW_ID").withParameterizedEqualWheres("RESULT__RUN_ID").toSql(this.getDialect());
    private final String listHumanReviews = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_HUMAN_REVIEW") + " WHERE " + this.quote("HUMAN_REVIEW__PROJECT_KEY") + "=? AND " + this.quote("HUMAN_REVIEW__RESULT_ID") + "=? ORDER BY " + this.quote("HUMAN_REVIEW__LAST_MODIFIED_TIMESTAMP") + " DESC";
    private final String insertHumanReview = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW")).addColumns(HumanReviewTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String getHumanReview = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_HUMAN_REVIEW") + " WHERE " + this.quote("HUMAN_REVIEW__PROJECT_KEY") + "=? AND " + this.quote("HUMAN_REVIEW__ID") + "=?";
    private final String updateHumanReview = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_HUMAN_REVIEW") + " SET " + this.quote("HUMAN_REVIEW__LIKE") + "=? ," + this.quote("HUMAN_REVIEW__COMMENT") + "=? ," + this.quote("HUMAN_REVIEW__LAST_MODIFIED_TIMESTAMP") + "=? WHERE " + this.quote("HUMAN_REVIEW__PROJECT_KEY") + "=? AND " + this.quote("HUMAN_REVIEW__ID") + "=?";
    private final String deleteHumanReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW")).withParameterizedEqualWheres("HUMAN_REVIEW__PROJECT_KEY").withParameterizedEqualWheres("HUMAN_REVIEW__ID").toSql(this.getDialect());
    private final String deleteHumanReviewsForRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW")).withParameterizedEqualWheres("HUMAN_REVIEW__PROJECT_KEY").withParameterizedEqualWheres("HUMAN_REVIEW__AGENT_REVIEW_ID").withParameterizedEqualWheres("HUMAN_REVIEW__RUN_ID").toSql(this.getDialect());
    private final String getExecutionResult = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_EXECUTION_RESULT") + " WHERE " + this.quote("EXECUTION_RESULT__PROJECT_KEY") + "=? AND " + this.quote("EXECUTION_RESULT__ID") + "=?";
    private final String insertExecutionResult = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT")).addColumns(ExecutionResultTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String deleteExecutionResultsForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT")).withParameterizedEqualWheres("EXECUTION_RESULT__PROJECT_KEY").withParameterizedEqualWheres("EXECUTION_RESULT__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String deleteExecutionResultForRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT")).withParameterizedEqualWheres("EXECUTION_RESULT__PROJECT_KEY").withParameterizedEqualWheres("EXECUTION_RESULT__AGENT_REVIEW_ID").withParameterizedEqualWheres("EXECUTION_RESULT__RUN_ID").toSql(this.getDialect());
    private final String listTraitOverrides = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_OVERRIDE") + " WHERE " + this.quote("TRAIT_OVERRIDE__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_OVERRIDE__RESULT_ID") + "=? ORDER BY " + this.quote("TRAIT_OVERRIDE__CREATION_TIMESTAMP") + " DESC";
    private final String getTraitOverride = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_OVERRIDE") + " WHERE " + this.quote("TRAIT_OVERRIDE__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_OVERRIDE__ID") + "=?";
    private final String insertTraitOverride = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE")).addColumns(TraitOverrideTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String updateTraitOverride = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_OVERRIDE") + " SET " + this.quote("TRAIT_OVERRIDE__LIKE") + "=? ," + this.quote("TRAIT_OVERRIDE__LAST_MODIFIED_BY") + "=? ," + this.quote("TRAIT_OVERRIDE__LAST_MODIFIED_TIMESTAMP") + "=? WHERE " + this.quote("TRAIT_OVERRIDE__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_OVERRIDE__ID") + "=?";
    private final String deleteTraitOverridesForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE")).withParameterizedEqualWheres("TRAIT_OVERRIDE__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_OVERRIDE__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String deleteTraitOverridesForRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE")).withParameterizedEqualWheres("TRAIT_OVERRIDE__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_OVERRIDE__AGENT_REVIEW_ID").withParameterizedEqualWheres("TRAIT_OVERRIDE__RUN_ID").toSql(this.getDialect());
    private final String deleteTraitOverride = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE")).withParameterizedEqualWheres("TRAIT_OVERRIDE__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_OVERRIDE__ID").toSql(this.getDialect());
    private final String insertTraitDefinition = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_TRAIT_DEFINITION")).addColumns(TraitDefinitionTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String getTraitDefinition = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_DEFINITION") + " WHERE " + this.quote("TRAIT_DEFINITION__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_DEFINITION__AGENT_REVIEW_ID") + "=? AND " + this.quote("TRAIT_DEFINITION__RUN_ID") + "=? AND " + this.quote("TRAIT_DEFINITION__TRAIT_ID") + "=?";
    private final String listTraitDefinitionsForRun = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_DEFINITION") + " WHERE " + this.quote("TRAIT_DEFINITION__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_DEFINITION__AGENT_REVIEW_ID") + "=? AND " + this.quote("TRAIT_DEFINITION__RUN_ID") + "=?";
    private final String listTraitDefinitionsForAgentReview = "SELECT * FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_DEFINITION") + " WHERE " + this.quote("TRAIT_DEFINITION__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_DEFINITION__AGENT_REVIEW_ID") + "=?";
    private final String deleteTraitDefinitionsForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_DEFINITION")).withParameterizedEqualWheres("TRAIT_DEFINITION__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_DEFINITION__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String deleteTraitDefinitionForRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_DEFINITION")).withParameterizedEqualWheres("TRAIT_DEFINITION__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_DEFINITION__AGENT_REVIEW_ID").withParameterizedEqualWheres("TRAIT_DEFINITION__RUN_ID").toSql(this.getDialect());
    private final String insertTraitOutcome = InsertQueryBuilder.insertInto(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME")).addColumns(TraitOutcomeTable.TABLE_COLUMNS).toSQL(this.getDialect());
    private final String deleteTraitOutcomesForRun = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME")).withParameterizedEqualWheres("TRAIT_OUTCOME__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_OUTCOME__AGENT_REVIEW_ID").withParameterizedEqualWheres("TRAIT_OUTCOME__RUN_ID").toSql(this.getDialect());
    private final String deleteTraitOutcomesForReview = DeleteQueryBuilder.deleteFrom(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME")).withParameterizedEqualWheres("TRAIT_OUTCOME__PROJECT_KEY").withParameterizedEqualWheres("TRAIT_OUTCOME__AGENT_REVIEW_ID").toSql(this.getDialect());
    private final String countDistinctContributors = "SELECT COUNT(DISTINCT contributors) FROM (SELECT " + this.quote("HUMAN_REVIEW__CREATED_BY") + " AS contributors FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_HUMAN_REVIEW") + " WHERE " + this.quote("HUMAN_REVIEW__PROJECT_KEY") + "=? AND " + this.quote("HUMAN_REVIEW__AGENT_REVIEW_ID") + "=? UNION ALL SELECT " + this.quote("TRAIT_OVERRIDE__CREATED_BY") + " AS contributors FROM " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_TRAIT_OVERRIDE") + " WHERE " + this.quote("TRAIT_OVERRIDE__PROJECT_KEY") + "=? AND " + this.quote("TRAIT_OVERRIDE__AGENT_REVIEW_ID") + "=?) AS combined_results";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agentreview.db");

    private static long estimatePayloadSize(@Nullable String query, @Nullable String referenceAnswer, @Nullable String expectations) {
        long size = 0L;
        size += AgentReviewInternalDB.estimateStringSize(query);
        size += AgentReviewInternalDB.estimateStringSize(referenceAnswer);
        return size += AgentReviewInternalDB.estimateStringSize(expectations);
    }

    private static long estimateStringSize(@Nullable String s) {
        if (s == null) {
            return 0L;
        }
        return s.getBytes(StandardCharsets.UTF_8).length;
    }

    private static long estimateResultSize(AgentReviewResult result) {
        long size = AgentReviewInternalDB.estimatePayloadSize(result.query, result.referenceAnswer, result.expectations);
        size += AgentReviewInternalDB.estimateStringSize(result.rawQuery);
        if (result.executionResults != null) {
            for (AgentReviewExecutionResult exec : result.executionResults) {
                size += AgentReviewInternalDB.estimateStringSize(exec.answer);
                size += AgentReviewInternalDB.estimateStringSize(exec.rawResponse);
                size += AgentReviewInternalDB.estimateStringSize(exec.trajectory);
                if (exec.traitOutcomePerTraitId == null) continue;
                for (AgentReviewTraitOutcome outcome : exec.traitOutcomePerTraitId.values()) {
                    size += AgentReviewInternalDB.estimateStringSize(outcome.justification());
                }
            }
        }
        if (result.humanReviews != null) {
            for (AgentReviewHumanReview review : result.humanReviews) {
                size += AgentReviewInternalDB.estimateStringSize(review.comment);
            }
        }
        return size;
    }

    private String getTestIdsAsINString(@Nonnull List<String> testIds) {
        return StringUtils.join(testIds.stream().map(x$0 -> this.quoteString((String)x$0)).toList(), (String)",");
    }

    public Flux<AgentReviewTest> streamTests(String projectKey, String agentReviewId, @Nullable List<String> testIds) {
        return Flux.using(() -> {
            PreparedStatement ps2;
            DSSDBConnection conn = this.acquireConnection();
            if (CollectionUtils.isEmpty((Collection)testIds)) {
                ps2 = this.getPreparedStatement(conn, this.listTests);
                ps2.setString(1, projectKey);
                ps2.setString(2, agentReviewId);
            } else {
                ps2 = this.getPreparedStatement(conn, this.listSelectedTests.replace(":testIds:", this.getTestIdsAsINString(testIds)));
                ps2.setString(1, projectKey);
                ps2.setString(2, agentReviewId);
            }
            ResultSet rs2 = ps2.executeQuery();
            return new AgentReviewDBResourceBundle(conn, rs2);
        }, resource -> this.generateFlux(resource.resultSet, this::readTest), AgentReviewDBResourceBundle::closeResources);
    }

    public int countTests(String projectKey, String agentReviewId) throws SQLException {
        int nbRuns = 0;
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.countTests);
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            try (ResultSet rs2 = ps2.executeQuery();){
                if (rs2.next()) {
                    nbRuns = rs2.getInt(1);
                }
            }
        }
        return nbRuns;
    }

    public Flux<AgentReviewTestOverview> streamTestOverviews(String projectKey, String agentReviewId) throws SQLException {
        ResultSet rs2;
        Map<String, List<AgentReviewTrait>> traitsPerRun;
        SelectQueryBuilder lastRunQb = new SelectQueryBuilder();
        lastRunQb.from(this.resolveTable("AGENT_REVIEW_RESULT"), "AGENT_REVIEW_RESULT");
        lastRunQb.select("RESULT__TEST_ID", "filter_test_id");
        lastRunQb.select("RESULT__PROJECT_KEY", "filter_project_key");
        lastRunQb.select(EBF.col("RESULT__CREATION_TIMESTAMP").max(), "max_ts");
        lastRunQb.group("RESULT__TEST_ID");
        lastRunQb.group("RESULT__PROJECT_KEY");
        SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
        queryBuilder.select("*");
        queryBuilder.from(this.resolveTable("AGENT_REVIEW_TEST"), "AGENT_REVIEW_TEST");
        String filterAlias = "latest_run_filter";
        queryBuilder.join(lastRunQb, QueryAst.JoinType.LEFT, filterAlias).on(EBF.col("TEST__ID").eq(EBF.col(filterAlias, "filter_test_id"))).on(EBF.col("TEST__PROJECT_KEY").eq(EBF.col(filterAlias, "filter_project_key")));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_RESULT"), QueryAst.JoinType.LEFT).on(EBF.col("TEST__ID").eq(EBF.col("RESULT__TEST_ID")).and(EBF.col("TEST__PROJECT_KEY").eq(EBF.col("RESULT__PROJECT_KEY"))).and(EBF.col("RESULT__CREATION_TIMESTAMP").eq(EBF.col(filterAlias, "max_ts"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_RUN"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__RUN_ID").eq(EBF.col("RUN__ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("RUN__PROJECT_KEY"))).and(EBF.col("RESULT__AGENT_REVIEW_ID").eq(EBF.col("RUN__AGENT_REVIEW_ID"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("EXECUTION_RESULT__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("EXECUTION_RESULT__PROJECT_KEY"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME"), QueryAst.JoinType.LEFT).on(EBF.col("EXECUTION_RESULT__ID").eq(EBF.col("TRAIT_OUTCOME__EXECUTION_RESULT_ID")).and(EBF.col("EXECUTION_RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OUTCOME__PROJECT_KEY"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("TRAIT_OVERRIDE__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OVERRIDE__PROJECT_KEY"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW"), QueryAst.JoinType.LEFT).on(EBF.col("HUMAN_REVIEW__RESULT_ID").eq(EBF.col("RESULT__ID")).and(EBF.col("HUMAN_REVIEW__PROJECT_KEY").eq(EBF.col("RESULT__PROJECT_KEY"))));
        queryBuilder.where(EBF.parameterizedColumnOperation("TEST__PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        queryBuilder.where(EBF.parameterizedColumnOperation("TEST__AGENT_REVIEW_ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        queryBuilder.order("TEST__CREATION_TIMESTAMP", QueryAst.OrderType.ASC);
        queryBuilder.order("TEST__ID", QueryAst.OrderType.ASC);
        DSSDBConnection conn = this.acquireConnection();
        try {
            traitsPerRun = this.listTraitDefinitionPerRun(conn, projectKey, agentReviewId);
            PreparedStatement ps2 = this.getPreparedStatement(conn, queryBuilder.toSQL(this.getDialect()));
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            rs2 = ps2.executeQuery();
        }
        catch (SQLException e) {
            logger.errorV("Encountered SQL exception: %s", new Object[]{ExceptionUtils.getMessageWithSQLNest((SQLException)e)});
            conn.close();
            throw e;
        }
        catch (Throwable t) {
            logger.errorV(t, "Could not retrieve test overviews for agent review %s in project %s", new Object[]{agentReviewId, projectKey});
            conn.close();
            throw t;
        }
        return Flux.using(() -> new AgentReviewDBResourceBundle(conn, rs2), resource -> this.generateFlux(resource.resultSet, this::readTestResultRow), AgentReviewDBResourceBundle::closeResources).bufferUntilChanged(row -> row.test.id).map(rows -> this.consolidateTestOverviews((List<TestResultRow>)rows, traitsPerRun));
    }

    private TestResultRow readTestResultRow(ResultSet rs2) throws SQLException {
        AgentReviewTest test = this.readTest(rs2);
        String resultId = rs2.getString("RESULT__ID");
        ResultRow resultRow = null;
        if (resultId != null) {
            resultRow = this.readFullResult(rs2);
        }
        return new TestResultRow(test, resultRow);
    }

    private AgentReviewTestOverview consolidateTestOverviews(List<TestResultRow> rows, Map<String, List<AgentReviewTrait>> traitsPerRun) {
        if (rows.isEmpty()) {
            return null;
        }
        AgentReviewTestOverview overview = new AgentReviewTestOverview();
        overview.test = rows.get((int)0).test;
        List<ResultRow> resultRows = rows.stream().map(TestResultRow::resultComponents).filter(Objects::nonNull).toList();
        if (!resultRows.isEmpty()) {
            List<AgentReviewTrait> traits = traitsPerRun.getOrDefault(resultRows.get((int)0).baseResult.runId, Collections.emptyList());
            overview.lastRunResult = this.consolidateFullResults(resultRows, traits);
        }
        return overview;
    }

    public List<String> listTestIds(String projectKey, String agentReviewId) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listTestIds);
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ret.add(rs2.getString("TEST__ID"));
                }
            }
        }
        return ret;
    }

    public List<String> getExistingTestIds(String projectKey, List<String> testIdsToCheck) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (DSSDBConnection conn = this.acquireConnection();){
            for (String testId : testIdsToCheck) {
                AgentReviewTest test = this.getTest(conn, projectKey, testId);
                if (test == null) continue;
                ret.add(test.id);
            }
        }
        return ret;
    }

    public AgentReviewTest createTest(String userLogin, String projectKey, String agentReviewId, @Nullable String query, @Nullable String referenceAnswer, @Nullable String expectations) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            long timeMillis = System.currentTimeMillis();
            String testId = AgentReviewInternalDB.generateId();
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertTest);
            AgentReviewInternalDB.fillInsertTestQuery(ps2, testId, projectKey, agentReviewId, query, referenceAnswer, expectations, timeMillis, userLogin);
            ps2.execute();
            conn.commit();
            AgentReviewTest agentReviewTest = this.getTest(conn, projectKey, testId);
            return agentReviewTest;
        }
    }

    public List<AgentReviewTest> createTests(String userLogin, List<AgentReviewTest> tests) throws SQLException {
        ArrayList<AgentReviewTest> createdTests = new ArrayList<AgentReviewTest>();
        try (DSSDBConnection conn = this.acquireConnection();){
            for (AgentReviewTest test : tests) {
                long timeMillis = System.currentTimeMillis();
                String testId = AgentReviewInternalDB.generateId();
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertTest);
                AgentReviewInternalDB.fillInsertTestQuery(ps2, testId, test.projectKey, test.agentReviewId, test.query, test.referenceAnswer, test.expectations, timeMillis, userLogin);
                ps2.execute();
                createdTests.add(this.getTest(conn, test.projectKey, testId));
            }
            conn.commit();
        }
        return createdTests;
    }

    public void createOrUpdateTestsFromJson(String user, String projectKey, Iterator<AgentReviewTest> testsIterator) {
        final int maxBatchCount = DKUApp.getParams().getIntParam(MAX_BATCH_COUNT_KEY, Integer.valueOf(100));
        final long maxBatchSize = DKUApp.getParams().getLongParam(MAX_BATCH_SIZE_KEY, 10000000L);
        Flux.fromIterable(() -> testsIterator).map(test -> {
            test.projectKey = projectKey;
            return test;
        }).bufferUntil((Predicate)new Predicate<AgentReviewTest>(){
            long currentSize = 0L;
            int currentCount = 0;

            @Override
            public boolean test(AgentReviewTest test) {
                long size = AgentReviewInternalDB.estimatePayloadSize(test.query, test.referenceAnswer, test.expectations);
                if (this.currentCount >= maxBatchCount || this.currentSize + size > maxBatchSize && this.currentCount > 0) {
                    this.currentSize = size;
                    this.currentCount = 1;
                    return true;
                }
                this.currentSize += size;
                ++this.currentCount;
                return false;
            }
        }, true).doOnNext(batch -> {
            try {
                this.saveBatchOfTests(user, projectKey, (List<AgentReviewTest>)batch);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).blockLast();
    }

    private void saveBatchOfTests(String user, String projectKey, List<AgentReviewTest> batch) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            for (AgentReviewTest test : batch) {
                logger.trace(() -> "Processing test %s".formatted(test.id));
                AgentReviewTest existingTest = this.getTest(conn, projectKey, test.id);
                if (existingTest == null) {
                    this.createTestWithFixedId(conn, user, test);
                    continue;
                }
                this.updateTest(conn, user, test);
            }
            conn.commit();
        }
    }

    private void createTestWithFixedId(DSSDBConnection conn, String userLogin, AgentReviewTest test) throws SQLException {
        long timeMillis = System.currentTimeMillis();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertTest);
        AgentReviewInternalDB.fillInsertTestQuery(ps2, test.id, test.projectKey, test.agentReviewId, test.query, test.referenceAnswer, test.expectations, timeMillis, userLogin);
        ps2.execute();
    }

    private static void fillInsertTestQuery(PreparedStatement ps2, String testId, String projectKey, String agentReviewId, String query, String referenceAnswer, String expectations, long timeMillis, String userLogin) throws SQLException {
        int i = 0;
        ps2.setString(++i, testId);
        ps2.setString(++i, projectKey);
        ps2.setString(++i, agentReviewId);
        ps2.setString(++i, query);
        ps2.setString(++i, referenceAnswer);
        ps2.setString(++i, expectations);
        ps2.setLong(++i, timeMillis);
        ps2.setString(++i, userLogin);
        ps2.setNull(++i, -5);
        ps2.setNull(++i, 12);
    }

    public AgentReviewCreateTestsFromDatasetResult createTestsFromDataset(AuthCtx user, Dataset dataset, String projectKey, String agentReviewId, String userLogin, AgentReviewCreateTestsFromDatasetRequest request) throws Exception {
        AgentReviewCreateTestsFromDatasetResult result = new AgentReviewCreateTestsFromDatasetResult();
        CreateTestProcessorOutput processorOutput = null;
        try (DSSDBConnection conn = this.acquireConnection();){
            processorOutput = new CreateTestProcessorOutput(conn, request.queryColumn, request.referenceAnswerColumn, request.expectationsColumn, projectKey, agentReviewId, userLogin);
            StreamColumnFactory cf = new StreamColumnFactory();
            processorOutput.init((ColumnFactory)cf);
            UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(user, dataset, (ProcessorOutput)processorOutput, (ColumnFactory)cf, (RowFactory)new StreamRowFactory());
            StreamableDatasetSelection selection = new StreamableDatasetSelection();
            selection.samplingMethod = request.samplingMethod;
            selection.maxRecords = request.maxRecords == null ? -1L : request.maxRecords.longValue();
            selection.partitionSelectionMethod = request.partitionSelectionMethod;
            selection.selectedPartitions = request.selectedPartitions;
            selection.latestPartitionsN = request.latestPartitionsN == null ? 0 : request.latestPartitionsN;
            pusher.setDatasetSelection(selection);
            pusher.push();
            processorOutput.lastRowEmitted();
            result.createdTestIds = processorOutput.getCreatedTestIds();
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to create tests from dataset in Agent Review database", e);
            if (processorOutput != null) {
                processorOutput.cancel();
            }
            result.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return result;
    }

    public AgentReviewTest getTest(String projectKey, String testId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project Key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)testId), (Object)"Test ID can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewTest agentReviewTest = this.getTest(conn, projectKey, testId);
            return agentReviewTest;
        }
    }

    public void deleteTest(String projectKey, String testId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project Key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)testId), (Object)"Test ID can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getMandatoryTest(conn, projectKey, testId);
            PreparedStatement psReview = this.getPreparedStatement(conn, this.deleteTest);
            psReview.setString(1, projectKey);
            psReview.setString(2, testId);
            psReview.execute();
            conn.commit();
        }
    }

    public void deleteTests(String projectKey, List<String> testIds) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project Key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            for (String testId : testIds) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)testId), (Object)"Test ID can not be empty");
                this.getMandatoryTest(conn, projectKey, testId);
                PreparedStatement psReview = this.getPreparedStatement(conn, this.deleteTest);
                psReview.setString(1, projectKey);
                psReview.setString(2, testId);
                psReview.execute();
            }
            conn.commit();
        }
    }

    public AgentReviewTest updateTest(String userLogin, AgentReviewTest testToUpdate) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getMandatoryTest(conn, testToUpdate.projectKey, testToUpdate.id);
            this.updateTest(conn, userLogin, testToUpdate);
            conn.commit();
            AgentReviewTest agentReviewTest = this.getTest(conn, testToUpdate.projectKey, testToUpdate.id);
            return agentReviewTest;
        }
    }

    private void updateTest(DSSDBConnection conn, String userLogin, AgentReviewTest testToUpdate) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateTest);
        int i = 0;
        ps2.setString(++i, testToUpdate.query);
        ps2.setString(++i, testToUpdate.referenceAnswer);
        ps2.setString(++i, testToUpdate.expectations);
        ps2.setString(++i, userLogin);
        ps2.setLong(++i, System.currentTimeMillis());
        ps2.setString(++i, testToUpdate.id);
        ps2.setString(++i, testToUpdate.projectKey);
        ps2.execute();
    }

    private AgentReviewTest getTest(DSSDBConnection conn, String projectKey, String testId) throws SQLException {
        AgentReviewTest test;
        block7: {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getTest);
            ps2.setString(1, projectKey);
            ps2.setString(2, testId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    test = this.readTest(rs2);
                    break block7;
                }
                AgentReviewTest agentReviewTest = null;
                return agentReviewTest;
            }
        }
        return test;
    }

    @Nonnull
    private AgentReviewTest getMandatoryTest(DSSDBConnection conn, String projectKey, String testId) throws SQLException {
        AgentReviewTest test = this.getTest(conn, projectKey, testId);
        if (test == null) {
            throw new InvalidParameterException("Test with id %s does not exist in project %s".formatted(testId, projectKey));
        }
        return test;
    }

    private AgentReviewTest readTest(ResultSet rs2) throws SQLException {
        AgentReviewTest test = new AgentReviewTest();
        test.id = rs2.getString("TEST__ID");
        test.projectKey = rs2.getString("TEST__PROJECT_KEY");
        test.agentReviewId = rs2.getString("TEST__AGENT_REVIEW_ID");
        test.query = rs2.getString("TEST__QUERY");
        test.referenceAnswer = rs2.getString("TEST__REFERENCE_ANSWER");
        test.expectations = rs2.getString("TEST__EXPECTATIONS");
        test.creationTimestamp = rs2.getLong("TEST__CREATION_TIMESTAMP");
        test.createdBy = rs2.getString("TEST__CREATED_BY");
        test.lastModifiedTimestamp = rs2.getLong("TEST__LAST_MODIFIED_TIMESTAMP");
        test.lastModifiedBy = rs2.getString("TEST__LAST_MODIFIED_BY");
        return test;
    }

    public List<AgentReviewRun> listRuns(String projectKey, String agentReviewId) throws SQLException {
        ArrayList<AgentReviewRun> ret = new ArrayList<AgentReviewRun>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listRuns);
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    AgentReviewRun run = this.readRun(rs2);
                    ret.add(run);
                }
            }
        }
        return ret;
    }

    public AgentReviewRun createRun(String userLogin, String projectKey, AgentReview agentReview, String agentVersion, String agentProjectLastCommitId, String reviewProjectProjectLastCommitId, List<String> testIds, @Nullable String runName) throws SQLException {
        int maxRetries = 5;
        int attempt = 0;
        String testIdsAsString = String.join((CharSequence)",", testIds);
        while (true) {
            AgentReviewRun agentReviewRun;
            block15: {
                DSSDBConnection conn = this.acquireConnection();
                try {
                    String runId = this.getNextRunIdForReview(conn, projectKey, agentReview.id);
                    PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertRun);
                    int i = 0;
                    ps2.setString(++i, runId);
                    ps2.setString(++i, projectKey);
                    ps2.setString(++i, reviewProjectProjectLastCommitId);
                    ps2.setString(++i, agentReview.id);
                    ps2.setString(++i, userLogin);
                    ps2.setString(++i, agentReview.agentSmartId);
                    ps2.setString(++i, agentVersion);
                    ps2.setString(++i, agentProjectLastCommitId);
                    ps2.setLong(++i, System.currentTimeMillis());
                    ps2.setLong(++i, 0L);
                    ps2.setInt(++i, agentReview.nbExecutions);
                    ps2.setString(++i, AgentReviewRunState.RUNNING.name());
                    ps2.setNull(++i, 12);
                    if (StringUtils.isBlank((String)runName)) {
                        ps2.setString(++i, "Run #" + runId);
                    } else {
                        ps2.setString(++i, runName);
                    }
                    ps2.setString(++i, testIdsAsString);
                    ps2.execute();
                    conn.commit();
                    agentReviewRun = this.getRun(conn, projectKey, agentReview.id, runId);
                    if (conn == null) break block15;
                }
                catch (Throwable runId) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable) {
                                runId.addSuppressed(throwable);
                            }
                        }
                        throw runId;
                    }
                    catch (SQLException e) {
                        if (this.isConstraintViolation(e)) {
                            if (attempt < maxRetries - 1) {
                                logger.debug((Object)("Concurrent run creation detected for review " + agentReview.id + ", retrying (attempt " + (attempt + 1) + ")"));
                                try {
                                    Thread.sleep(10L + (long)(Math.random() * 50.0));
                                }
                                catch (InterruptedException ex) {
                                    Thread.currentThread().interrupt();
                                    throw new SQLException("Interrupted during retry", ex);
                                }
                                ++attempt;
                                continue;
                            }
                            throw new SQLException("Failed to create run after " + maxRetries + " attempts", e);
                        }
                        throw e;
                    }
                }
                conn.close();
            }
            return agentReviewRun;
            break;
        }
    }

    private boolean isConstraintViolation(SQLException e) {
        return "23505".equals(e.getSQLState());
    }

    public AgentReviewRun getRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewRun agentReviewRun = this.getRun(conn, projectKey, agentReviewId, runId);
            return agentReviewRun;
        }
    }

    public AgentReviewRun finishRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
            long timeMillis = System.currentTimeMillis();
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.finishRun);
            ps2.setLong(1, timeMillis);
            ps2.setString(2, AgentReviewRunState.FINISHED.name());
            ps2.setString(3, runId);
            ps2.setString(4, projectKey);
            ps2.setString(5, agentReviewId);
            ps2.execute();
            conn.commit();
            AgentReviewRun agentReviewRun = this.getRun(conn, projectKey, agentReviewId, runId);
            return agentReviewRun;
        }
    }

    public AgentReviewRun failRun(String projectKey, String agentReviewId, String runId, String throwException) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
            this.updateRunState(conn, projectKey, agentReviewId, runId, AgentReviewRunState.FINISHED, throwException);
            conn.commit();
            AgentReviewRun agentReviewRun = this.getRun(conn, projectKey, agentReviewId, runId);
            return agentReviewRun;
        }
    }

    public AgentReviewRun abortRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewRun run = this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
            if (run.status != AgentReviewRunState.RUNNING) {
                logger.info((Object)("Run with id " + runId + " is not in RUNNING status, it is already finished. Returning the run as is."));
                AgentReviewRun agentReviewRun = run;
                return agentReviewRun;
            }
            this.updateRunState(conn, projectKey, agentReviewId, runId, AgentReviewRunState.ABORTED, null);
            conn.commit();
            AgentReviewRun agentReviewRun = this.getRun(conn, projectKey, agentReviewId, runId);
            return agentReviewRun;
        }
    }

    public List<AgentReviewRun> deleteRuns(String projectKey, String agentReviewId, List<String> runIds) throws SQLException {
        ArrayList<AgentReviewRun> deletedRuns = new ArrayList<AgentReviewRun>();
        try (DSSDBConnection conn = this.acquireConnection();){
            for (String runId : runIds) {
                AgentReviewRun run = this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
                if (AgentReviewRunState.RUNNING.equals((Object)run.status)) {
                    throw new IllegalStateException("Run %s of agent review %s in project %s is still running. Wait for it to finish or abort it, before deleting it.".formatted(runId, agentReviewId, projectKey));
                }
                PreparedStatement psTraitOverrides = this.getPreparedStatement(conn, this.deleteTraitOverridesForRun);
                psTraitOverrides.setString(1, projectKey);
                psTraitOverrides.setString(2, agentReviewId);
                psTraitOverrides.setString(3, runId);
                psTraitOverrides.execute();
                PreparedStatement psHumanReviews = this.getPreparedStatement(conn, this.deleteHumanReviewsForRun);
                psHumanReviews.setString(1, projectKey);
                psHumanReviews.setString(2, agentReviewId);
                psHumanReviews.setString(3, runId);
                psHumanReviews.execute();
                PreparedStatement psExecutionResults = this.getPreparedStatement(conn, this.deleteExecutionResultForRun);
                psExecutionResults.setString(1, projectKey);
                psExecutionResults.setString(2, agentReviewId);
                psExecutionResults.setString(3, runId);
                psExecutionResults.execute();
                PreparedStatement psResult = this.getPreparedStatement(conn, this.deleteResultForRun);
                psResult.setString(1, projectKey);
                psResult.setString(2, agentReviewId);
                psResult.setString(3, runId);
                psResult.execute();
                PreparedStatement psTraitOutcome = this.getPreparedStatement(conn, this.deleteTraitOutcomesForRun);
                psTraitOutcome.setString(1, projectKey);
                psTraitOutcome.setString(2, agentReviewId);
                psTraitOutcome.setString(3, runId);
                psTraitOutcome.execute();
                PreparedStatement psTraitDefinition = this.getPreparedStatement(conn, this.deleteTraitDefinitionForRun);
                psTraitDefinition.setString(1, projectKey);
                psTraitDefinition.setString(2, agentReviewId);
                psTraitDefinition.setString(3, runId);
                psTraitDefinition.execute();
                PreparedStatement psRuns = this.getPreparedStatement(conn, this.deleteRun);
                psRuns.setString(1, projectKey);
                psRuns.setString(2, agentReviewId);
                psRuns.setString(3, runId);
                psRuns.execute();
                deletedRuns.add(run);
            }
            conn.commit();
        }
        return deletedRuns;
    }

    @Nullable
    public AgentReviewRun getPreviousFinishedRunBefore(String projectKey, String agentReviewId, String runId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewRun agentReviewRun;
            block16: {
                ResultSet rs2;
                block14: {
                    AgentReviewRun agentReviewRun2;
                    block15: {
                        AgentReviewRun currentRun = this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
                        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getPreviousFinishedRunBefore);
                        ps2.setString(1, projectKey);
                        ps2.setString(2, agentReviewId);
                        ps2.setString(3, AgentReviewRunState.FINISHED.name());
                        ps2.setLong(4, currentRun.startTimestamp);
                        ps2.execute();
                        rs2 = ps2.getResultSet();
                        try {
                            if (!rs2.next()) break block14;
                            agentReviewRun2 = this.readRun(rs2);
                            if (rs2 == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return agentReviewRun2;
                }
                agentReviewRun = null;
                if (rs2 == null) break block16;
                rs2.close();
            }
            return agentReviewRun;
        }
    }

    private String getNextRunIdForReview(DSSDBConnection conn, String projectKey, String agentReviewId) throws SQLException {
        PreparedStatement maxRunIdPs = this.getPreparedStatement(conn, this.getMaxRunId);
        maxRunIdPs.setString(1, projectKey);
        maxRunIdPs.setString(2, agentReviewId);
        try (ResultSet rs2 = maxRunIdPs.executeQuery();){
            rs2.next();
            int maxId = rs2.getInt(1);
            String string = String.valueOf(maxId + 1);
            return string;
        }
    }

    private AgentReviewRun getRun(DSSDBConnection conn, String projectKey, String agentReviewId, String runId) throws SQLException {
        AgentReviewRun run;
        block7: {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRun);
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            ps2.setString(3, runId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    run = this.readRun(rs2);
                    break block7;
                }
                AgentReviewRun agentReviewRun = null;
                return agentReviewRun;
            }
        }
        return run;
    }

    @Nonnull
    private AgentReviewRun getMandatoryRun(DSSDBConnection conn, String projectKey, String agentReviewId, String runId) throws SQLException {
        AgentReviewRun run = this.getRun(conn, projectKey, agentReviewId, runId);
        if (run == null) {
            throw new InvalidParameterException("Run with id %s does not exist in agent review %s of project %s".formatted(runId, agentReviewId, projectKey));
        }
        return run;
    }

    private void updateRunState(DSSDBConnection conn, String projectKey, String agentReviewId, String runId, @Nonnull AgentReviewRunState status, @Nullable String errorMessage) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateRunState);
        ps2.setString(1, status.name());
        ps2.setString(2, errorMessage);
        ps2.setLong(3, System.currentTimeMillis());
        ps2.setString(4, projectKey);
        ps2.setString(5, agentReviewId);
        ps2.setString(6, runId);
        ps2.execute();
    }

    public void updateRunName(String projectKey, String agentReviewId, String runId, @Nullable String newName) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateRunName);
            ps2.setString(1, newName);
            ps2.setString(2, projectKey);
            ps2.setString(3, agentReviewId);
            ps2.setString(4, runId);
            ps2.execute();
            conn.commit();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getTestIdsForRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getTestIdsForRun);
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            ps2.setString(3, runId);
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            if (!rs2.next()) throw new InvalidParameterException("Run with id %s does not exist in agent review %s of project %s".formatted(runId, agentReviewId, projectKey));
            String testIdsAsString = rs2.getString(1);
            if (StringUtils.isBlank((String)testIdsAsString)) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = Arrays.asList(testIdsAsString.split(","));
            return list;
            finally {
                if (rs2 != null) {
                    rs2.close();
                }
            }
        }
    }

    private AgentReviewRun readRun(ResultSet rs2) throws SQLException {
        AgentReviewRun run = new AgentReviewRun();
        run.id = rs2.getString("RUN__ID");
        run.projectKey = rs2.getString("RUN__PROJECT_KEY");
        run.reviewProjectLastCommitId = rs2.getString("RUN__REVIEW_PROJECT_LAST_COMMIT_ID");
        run.agentReviewId = rs2.getString("RUN__AGENT_REVIEW_ID");
        run.createdBy = rs2.getString("RUN__CREATED_BY");
        run.agentSmartId = rs2.getString("RUN__AGENT_SMART_ID");
        run.agentVersion = rs2.getString("RUN__AGENT_VERSION");
        run.agentProjectLastCommitId = rs2.getString("RUN__AGENT_PROJECT_LAST_COMMIT_ID");
        run.startTimestamp = rs2.getLong("RUN__START_TIMESTAMP");
        run.endTimestamp = rs2.getLong("RUN__END_TIMESTAMP");
        run.nbExecutions = rs2.getInt("RUN__NB_EXECUTIONS");
        run.status = AgentReviewRunState.valueOf(rs2.getString("RUN__STATUS"));
        run.errorMessage = rs2.getString("RUN__ERROR_MESSAGE");
        run.name = rs2.getString("RUN__NAME");
        return run;
    }

    public Flux<AgentReviewResult> streamRunResultsFullInfo(String projectKey, String agentReviewId, String runId) throws SQLException {
        ResultSet rs2;
        List<AgentReviewTrait> traits;
        DSSDBConnection conn = this.acquireConnection();
        try {
            this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
            traits = this.listTraitDefinitions(conn, projectKey, agentReviewId, runId);
            SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
            queryBuilder.select("*");
            queryBuilder.from(this.resolveTable("AGENT_REVIEW_RESULT"), "AGENT_REVIEW_RESULT");
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_RUN"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__RUN_ID").eq(EBF.col("RUN__ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("RUN__PROJECT_KEY"))).and(EBF.col("RESULT__AGENT_REVIEW_ID").eq(EBF.col("RUN__AGENT_REVIEW_ID"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("EXECUTION_RESULT__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("EXECUTION_RESULT__PROJECT_KEY"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME"), QueryAst.JoinType.LEFT).on(EBF.col("EXECUTION_RESULT__ID").eq(EBF.col("TRAIT_OUTCOME__EXECUTION_RESULT_ID")).and(EBF.col("EXECUTION_RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OUTCOME__PROJECT_KEY"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("TRAIT_OVERRIDE__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OVERRIDE__PROJECT_KEY"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW"), QueryAst.JoinType.LEFT).on(EBF.col("HUMAN_REVIEW__RESULT_ID").eq(EBF.col("RESULT__ID")).and(EBF.col("HUMAN_REVIEW__PROJECT_KEY").eq(EBF.col("RESULT__PROJECT_KEY"))));
            queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__AGENT_REVIEW_ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__RUN_ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            queryBuilder.order("RESULT__CREATION_TIMESTAMP", QueryAst.OrderType.ASC);
            queryBuilder.order("RESULT__ID", QueryAst.OrderType.DESC);
            PreparedStatement ps2 = this.getPreparedStatement(conn, queryBuilder.toSQL(this.getDialect()));
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            ps2.setString(3, runId);
            rs2 = ps2.executeQuery();
        }
        catch (SQLException e) {
            logger.errorV("Encountered SQL exception: %s", new Object[]{ExceptionUtils.getMessageWithSQLNest((SQLException)e)});
            conn.close();
            throw e;
        }
        catch (Throwable t) {
            logger.errorV(t, "Could not retrieve results full info for run %s of agent review %s in project %s", new Object[]{runId, agentReviewId, projectKey});
            conn.close();
            throw t;
        }
        return Flux.using(() -> new AgentReviewDBResourceBundle(conn, rs2), resource -> this.generateFlux(resource.resultSet, this::readFullResult), AgentReviewDBResourceBundle::closeResources).bufferUntilChanged(ResultRow::resultId).map(rows -> this.consolidateFullResults((List<ResultRow>)rows, traits));
    }

    private AgentReviewResult consolidateFullResults(List<ResultRow> rowsForResult, List<AgentReviewTrait> traits) {
        if (rowsForResult.isEmpty()) {
            return null;
        }
        AgentReviewResult result = rowsForResult.get((int)0).baseResult;
        LinkedHashMap<String, AgentReviewExecutionResult> executionMap = new LinkedHashMap<String, AgentReviewExecutionResult>();
        LinkedHashMap<String, AgentReviewTraitOverride> overrideMap = new LinkedHashMap<String, AgentReviewTraitOverride>();
        LinkedHashMap<String, AgentReviewHumanReview> humanReviewMap = new LinkedHashMap<String, AgentReviewHumanReview>();
        for (ResultRow row : rowsForResult) {
            if (row.execution != null) {
                AgentReviewExecutionResult exec = executionMap.computeIfAbsent(row.execution.id, k -> row.execution);
                if (row.traitOutcome != null) {
                    exec.traitOutcomePerTraitId.put(row.traitOutcome.traitId(), row.traitOutcome);
                }
            }
            if (row.traitOverride != null && !overrideMap.containsKey(row.traitOverride.id)) {
                result.traitOverridesPerTraitId.computeIfAbsent(row.traitOverride.traitId, k -> new ArrayList()).add(row.traitOverride);
                overrideMap.put(row.traitOverride.id, row.traitOverride);
            }
            if (row.humanReview == null || humanReviewMap.containsKey(row.humanReview.id)) continue;
            result.humanReviews.add(row.humanReview);
            humanReviewMap.put(row.humanReview.id, row.humanReview);
        }
        result.executionResults.addAll(executionMap.values());
        result.computeStatuses(traits);
        return result;
    }

    private ResultRow readFullResult(ResultSet rs2) throws SQLException {
        String resultId = rs2.getString("RESULT__ID");
        AgentReviewResult baseResult = this.readResult(rs2);
        baseResult.agentSmartId = rs2.getString("RUN__AGENT_SMART_ID");
        baseResult.agentVersion = rs2.getString("RUN__AGENT_VERSION");
        baseResult.createdBy = rs2.getString("RUN__CREATED_BY");
        AgentReviewExecutionResult execution = this.readIfPresent(rs2, "EXECUTION_RESULT__ID", this::readExecutionResult);
        AgentReviewTraitOutcome outcome = this.readIfPresent(rs2, "TRAIT_OUTCOME__ID", this::readTraitOutcome);
        AgentReviewTraitOverride override = this.readIfPresent(rs2, "TRAIT_OVERRIDE__ID", this::readTraitOverride);
        AgentReviewHumanReview humanReview = this.readIfPresent(rs2, "HUMAN_REVIEW__ID", this::readHumanReview);
        return new ResultRow(resultId, baseResult, execution, outcome, override, humanReview);
    }

    public List<AgentReviewResult> listTestResultsHistory(String projectKey, String testId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project Key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)testId), (Object)"Test ID can not be empty");
        int maxCount = DKUApp.getParams().getIntParam(MAX_HISTORY_COUNT_KEY, Integer.valueOf(500));
        long maxSize = DKUApp.getParams().getLongParam(MAX_HISTORY_SIZE_KEY, 0x6400000L);
        ArrayList<AgentReviewResult> results = new ArrayList<AgentReviewResult>();
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewTest test = this.getMandatoryTest(conn, projectKey, testId);
            SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
            queryBuilder.select("*");
            queryBuilder.from(this.resolveTable("AGENT_REVIEW_RESULT"), "AGENT_REVIEW_RESULT");
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_RUN"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__RUN_ID").eq(EBF.col("RUN__ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("RUN__PROJECT_KEY"))).and(EBF.col("RESULT__AGENT_REVIEW_ID").eq(EBF.col("RUN__AGENT_REVIEW_ID"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("EXECUTION_RESULT__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("EXECUTION_RESULT__PROJECT_KEY"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME"), QueryAst.JoinType.LEFT).on(EBF.col("EXECUTION_RESULT__ID").eq(EBF.col("TRAIT_OUTCOME__EXECUTION_RESULT_ID")).and(EBF.col("EXECUTION_RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OUTCOME__PROJECT_KEY"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("TRAIT_OVERRIDE__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OVERRIDE__PROJECT_KEY"))));
            queryBuilder.join(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW"), QueryAst.JoinType.LEFT).on(EBF.col("HUMAN_REVIEW__RESULT_ID").eq(EBF.col("RESULT__ID")).and(EBF.col("HUMAN_REVIEW__PROJECT_KEY").eq(EBF.col("RESULT__PROJECT_KEY"))));
            queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__TEST_ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            queryBuilder.order("RESULT__CREATION_TIMESTAMP", QueryAst.OrderType.DESC);
            queryBuilder.order("RESULT__ID", QueryAst.OrderType.DESC);
            PreparedStatement ps2 = this.getPreparedStatement(conn, queryBuilder.toSQL(this.getDialect()));
            ps2.setString(1, projectKey);
            ps2.setString(2, testId);
            ps2.execute();
            long currentSize = 0L;
            try (ResultSet rs2 = ps2.getResultSet();){
                HashMap<String, List<AgentReviewTrait>> traitsByRun = new HashMap<String, List<AgentReviewTrait>>();
                ArrayList<ResultRow> currentResultRows = new ArrayList<ResultRow>();
                String currentResultId = null;
                while (rs2.next()) {
                    ResultRow row = this.readFullResult(rs2);
                    String rowResultId = row.resultId();
                    if (currentResultId != null && !currentResultId.equals(rowResultId)) {
                        AgentReviewResult result = this.computeAgentReviewResult(projectKey, currentResultRows, traitsByRun, conn, test);
                        if (result != null) {
                            if (results.size() >= maxCount || (currentSize += AgentReviewInternalDB.estimateResultSize(result)) > maxSize) {
                                logger.warn((Object)("Truncating test results history for test " + testId + " in project " + projectKey + ". Reached limit: count=" + results.size() + "/" + maxCount + ", size=" + currentSize + "/" + maxSize));
                                ArrayList<AgentReviewResult> arrayList = results;
                                return arrayList;
                            }
                            results.add(result);
                        }
                        currentResultRows.clear();
                    }
                    currentResultId = rowResultId;
                    currentResultRows.add(row);
                }
                if (!currentResultRows.isEmpty()) {
                    AgentReviewResult result = this.computeAgentReviewResult(projectKey, currentResultRows, traitsByRun, conn, test);
                    assert (result != null);
                    if (results.size() >= maxCount || (currentSize += AgentReviewInternalDB.estimateResultSize(result)) > maxSize) {
                        logger.warn((Object)("Truncating test results history for test " + testId + " in project " + projectKey + ". Reached limit: count=" + results.size() + "/" + maxCount + ", size=" + currentSize + "/" + maxSize));
                    }
                    results.add(result);
                }
            }
        }
        return results;
    }

    @Nullable
    private AgentReviewResult computeAgentReviewResult(String projectKey, List<ResultRow> currentResultRows, Map<String, List<AgentReviewTrait>> traitsByRun, DSSDBConnection conn, AgentReviewTest test) throws SQLException {
        List<AgentReviewTrait> traits;
        String runId = currentResultRows.get((int)0).baseResult().runId;
        if (traitsByRun.containsKey(runId)) {
            traits = traitsByRun.get(runId);
        } else {
            traits = this.listTraitDefinitions(conn, projectKey, test.agentReviewId, runId);
            traitsByRun.put(runId, traits);
        }
        return this.consolidateFullResults(currentResultRows, traits);
    }

    @Nullable
    public AgentReviewResult getFullResult(String projectKey, String resultId) throws SQLException {
        SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
        queryBuilder.select("*");
        queryBuilder.from(this.resolveTable("AGENT_REVIEW_RESULT"), "AGENT_REVIEW_RESULT");
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_RUN"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__RUN_ID").eq(EBF.col("RUN__ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("RUN__PROJECT_KEY"))).and(EBF.col("RESULT__AGENT_REVIEW_ID").eq(EBF.col("RUN__AGENT_REVIEW_ID"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_EXECUTION_RESULT"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("EXECUTION_RESULT__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("EXECUTION_RESULT__PROJECT_KEY"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OUTCOME"), QueryAst.JoinType.LEFT).on(EBF.col("EXECUTION_RESULT__ID").eq(EBF.col("TRAIT_OUTCOME__EXECUTION_RESULT_ID")).and(EBF.col("EXECUTION_RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OUTCOME__PROJECT_KEY"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_TRAIT_OVERRIDE"), QueryAst.JoinType.LEFT).on(EBF.col("RESULT__ID").eq(EBF.col("TRAIT_OVERRIDE__RESULT_ID")).and(EBF.col("RESULT__PROJECT_KEY").eq(EBF.col("TRAIT_OVERRIDE__PROJECT_KEY"))));
        queryBuilder.join(this.resolveTable("AGENT_REVIEW_HUMAN_REVIEW"), QueryAst.JoinType.LEFT).on(EBF.col("HUMAN_REVIEW__RESULT_ID").eq(EBF.col("RESULT__ID")).and(EBF.col("HUMAN_REVIEW__PROJECT_KEY").eq(EBF.col("RESULT__PROJECT_KEY"))));
        queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        queryBuilder.where(EBF.parameterizedColumnOperation("RESULT__ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewResult agentReviewResult;
            block17: {
                ArrayList<ResultRow> rows;
                ResultSet rs2;
                block15: {
                    AgentReviewResult agentReviewResult2;
                    block16: {
                        PreparedStatement ps2 = this.getPreparedStatement(conn, queryBuilder.toSQL(this.getDialect()));
                        ps2.setString(1, projectKey);
                        ps2.setString(2, resultId);
                        ps2.execute();
                        rs2 = ps2.executeQuery();
                        try {
                            rows = new ArrayList<ResultRow>();
                            while (rs2.next()) {
                                rows.add(this.readFullResult(rs2));
                            }
                            if (!rows.isEmpty()) break block15;
                            agentReviewResult2 = null;
                            if (rs2 == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return agentReviewResult2;
                }
                String agentReviewId = ((ResultRow)rows.get((int)0)).baseResult().agentReviewId;
                String runId = ((ResultRow)rows.get((int)0)).baseResult().runId;
                List<AgentReviewTrait> traits = this.listTraitDefinitions(conn, projectKey, agentReviewId, runId);
                agentReviewResult = this.consolidateFullResults(rows, traits);
                if (rs2 == null) break block17;
                rs2.close();
            }
            return agentReviewResult;
        }
    }

    private AgentReviewResult createResult(DSSDBConnection conn, String projectKey, String agentReviewId, String runId, AgentReviewTest test, long timeMillis) throws SQLException {
        this.getMandatoryRun(conn, projectKey, agentReviewId, runId);
        this.getMandatoryTest(conn, projectKey, test.id);
        String resultId = AgentReviewInternalDB.generateId();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertResult);
        int i = 0;
        ps2.setString(++i, resultId);
        ps2.setString(++i, projectKey);
        ps2.setString(++i, agentReviewId);
        ps2.setString(++i, runId);
        ps2.setString(++i, test.id);
        ps2.setString(++i, test.query);
        ps2.setString(++i, test.referenceAnswer);
        ps2.setString(++i, test.expectations);
        ps2.setNull(++i, 12);
        ps2.setLong(++i, timeMillis);
        ps2.execute();
        return this.getResult(conn, projectKey, resultId);
    }

    public void createResult(String projectKey, AgentReview agentReview, String runId, AgentReviewTest test, List<AgentReviewRawExecutionResult> executionResults) throws SQLException {
        long timeMillis = System.currentTimeMillis();
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewResult result = this.createResult(conn, projectKey, agentReview.id, runId, test, timeMillis);
            for (AgentReviewRawExecutionResult executionRawResult : executionResults) {
                AgentReviewExecutionResult executionResult = this.createExecutionResult(conn, projectKey, agentReview.id, runId, test.id, result.id, executionRawResult, timeMillis);
                for (String traitId : executionRawResult.traitOutcomeByTraitId.keySet()) {
                    this.createTraitOutcome(conn, traitId, executionRawResult.traitOutcomeByTraitId.get(traitId), executionResult);
                }
            }
            conn.commit();
        }
    }

    private AgentReviewResult getResult(DSSDBConnection conn, String projectKey, String resultId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getResult);
        ps2.setString(1, projectKey);
        ps2.setString(2, resultId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                AgentReviewResult agentReviewResult = this.readResult(rs2);
                return agentReviewResult;
            }
            AgentReviewResult agentReviewResult = null;
            return agentReviewResult;
        }
    }

    @Nonnull
    private AgentReviewResult getMandatoryResult(DSSDBConnection conn, String projectKey, String resultId) throws SQLException {
        AgentReviewResult result = this.getResult(conn, projectKey, resultId);
        if (result == null) {
            throw new IllegalArgumentException("Result with id %s does not exist in project %s".formatted(resultId, projectKey));
        }
        return result;
    }

    private AgentReviewResult readResult(ResultSet rs2) throws SQLException {
        AgentReviewResult result = new AgentReviewResult();
        result.projectKey = rs2.getString("RESULT__PROJECT_KEY");
        result.id = rs2.getString("RESULT__ID");
        result.agentReviewId = rs2.getString("RESULT__AGENT_REVIEW_ID");
        result.runId = rs2.getString("RESULT__RUN_ID");
        result.testId = rs2.getString("RESULT__TEST_ID");
        result.creationTimestamp = rs2.getLong("RESULT__CREATION_TIMESTAMP");
        result.query = rs2.getString("RESULT__QUERY");
        result.rawQuery = rs2.getString("RESULT__RAW_QUERY");
        result.referenceAnswer = rs2.getString("RESULT__REFERENCE_ANSWER");
        result.expectations = rs2.getString("RESULT__EXPECTATIONS");
        return result;
    }

    public void createHumanReview(String userLogin, AgentReviewHumanReview humanReview) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            String humanReviewId;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertHumanReview);
            AgentReviewResult result = this.getMandatoryResult(conn, humanReview.projectKey, humanReview.resultId);
            long timeMillis = System.currentTimeMillis();
            humanReview.id = humanReviewId = AgentReviewInternalDB.generateId();
            humanReview.agentReviewId = result.agentReviewId;
            humanReview.runId = result.runId;
            humanReview.testId = result.testId;
            humanReview.createdBy = userLogin;
            humanReview.lastModifiedTimestamp = timeMillis;
            int i = 0;
            ps2.setString(++i, humanReviewId);
            ps2.setString(++i, humanReview.projectKey);
            ps2.setString(++i, result.agentReviewId);
            ps2.setString(++i, result.runId);
            ps2.setString(++i, result.testId);
            ps2.setString(++i, result.id);
            ps2.setString(++i, humanReview.comment);
            ps2.setObject(++i, (Object)humanReview.like, 16);
            ps2.setString(++i, userLogin);
            ps2.setLong(++i, timeMillis);
            ps2.execute();
            conn.commit();
        }
    }

    public List<AgentReviewHumanReview> listHumanReviews(String projectKey, String resultId) throws SQLException {
        ArrayList<AgentReviewHumanReview> ret = new ArrayList<AgentReviewHumanReview>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listHumanReviews);
            ps2.setString(1, projectKey);
            ps2.setString(2, resultId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ret.add(this.readHumanReview(rs2));
                }
            }
        }
        return ret;
    }

    public AgentReviewHumanReview getHumanReview(String projectKey, String humanReviewId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)humanReviewId), (Object)"HumanReview ID can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewHumanReview agentReviewHumanReview = this.getHumanReview(conn, projectKey, humanReviewId);
            return agentReviewHumanReview;
        }
    }

    public AgentReviewHumanReview updateHumanReview(String userLogin, AgentReviewHumanReview humanReviewToUpdate) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)humanReviewToUpdate.projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)humanReviewToUpdate.id), (Object)"HumanReview id can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewHumanReview existing = this.getMandatoryHumanReview(conn, humanReviewToUpdate.projectKey, humanReviewToUpdate.id);
            if (existing.createdBy == null || !existing.createdBy.equals(userLogin)) {
                throw new IllegalArgumentException("Only the author of the review can update it");
            }
            long timeMillis = System.currentTimeMillis();
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateHumanReview);
            int i = 0;
            ps2.setObject(++i, (Object)humanReviewToUpdate.like, 16);
            ps2.setString(++i, humanReviewToUpdate.comment);
            ps2.setLong(++i, timeMillis);
            ps2.setString(++i, humanReviewToUpdate.projectKey);
            ps2.setString(++i, humanReviewToUpdate.id);
            ps2.execute();
            existing.like = humanReviewToUpdate.like;
            existing.comment = humanReviewToUpdate.comment;
            existing.lastModifiedTimestamp = timeMillis;
            conn.commit();
            AgentReviewHumanReview agentReviewHumanReview = existing;
            return agentReviewHumanReview;
        }
    }

    public AgentReviewHumanReview deleteHumanReview(String userLogin, String projectKey, String humanReviewId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewHumanReview humanReview = this.getMandatoryHumanReview(conn, projectKey, humanReviewId);
            if (humanReview.createdBy == null || !humanReview.createdBy.equals(userLogin)) {
                throw new IllegalArgumentException("Only the author of the review can delete it");
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteHumanReview);
            ps2.setString(1, projectKey);
            ps2.setString(2, humanReviewId);
            ps2.execute();
            conn.commit();
            AgentReviewHumanReview agentReviewHumanReview = humanReview;
            return agentReviewHumanReview;
        }
    }

    private AgentReviewHumanReview getHumanReview(DSSDBConnection conn, String projectKey, String humanReviewId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getHumanReview);
        ps2.setString(1, projectKey);
        ps2.setString(2, humanReviewId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                AgentReviewHumanReview agentReviewHumanReview = this.readHumanReview(rs2);
                return agentReviewHumanReview;
            }
            AgentReviewHumanReview agentReviewHumanReview = null;
            return agentReviewHumanReview;
        }
    }

    @Nonnull
    private AgentReviewHumanReview getMandatoryHumanReview(DSSDBConnection conn, String projectKey, String humanReviewId) throws SQLException {
        AgentReviewHumanReview humanReview = this.getHumanReview(conn, projectKey, humanReviewId);
        if (humanReview == null) {
            throw new IllegalArgumentException("Cannot find human review %s of project %s".formatted(humanReviewId, projectKey));
        }
        return humanReview;
    }

    private AgentReviewHumanReview readHumanReview(ResultSet rs2) throws SQLException {
        AgentReviewHumanReview humanReview = new AgentReviewHumanReview();
        humanReview.id = rs2.getString("HUMAN_REVIEW__ID");
        humanReview.projectKey = rs2.getString("HUMAN_REVIEW__PROJECT_KEY");
        humanReview.agentReviewId = rs2.getString("HUMAN_REVIEW__AGENT_REVIEW_ID");
        humanReview.runId = rs2.getString("HUMAN_REVIEW__RUN_ID");
        humanReview.testId = rs2.getString("HUMAN_REVIEW__TEST_ID");
        humanReview.resultId = rs2.getString("HUMAN_REVIEW__RESULT_ID");
        humanReview.comment = rs2.getObject("HUMAN_REVIEW__COMMENT", String.class);
        humanReview.like = rs2.getObject("HUMAN_REVIEW__LIKE", Boolean.class);
        humanReview.createdBy = rs2.getString("HUMAN_REVIEW__CREATED_BY");
        humanReview.lastModifiedTimestamp = rs2.getLong("HUMAN_REVIEW__LAST_MODIFIED_TIMESTAMP");
        return humanReview;
    }

    private AgentReviewExecutionResult readExecutionResult(ResultSet rs2) throws SQLException {
        AgentReviewExecutionResult executionResult = new AgentReviewExecutionResult();
        executionResult.id = rs2.getString("EXECUTION_RESULT__ID");
        executionResult.projectKey = rs2.getString("EXECUTION_RESULT__PROJECT_KEY");
        executionResult.agentReviewId = rs2.getString("EXECUTION_RESULT__AGENT_REVIEW_ID");
        executionResult.runId = rs2.getString("EXECUTION_RESULT__RUN_ID");
        executionResult.testId = rs2.getString("EXECUTION_RESULT__TEST_ID");
        executionResult.resultId = rs2.getString("EXECUTION_RESULT__RESULT_ID");
        executionResult.answer = rs2.getString("EXECUTION_RESULT__ANSWER");
        executionResult.rawResponse = rs2.getString("EXECUTION_RESULT__RAW_RESPONSE");
        executionResult.trajectory = rs2.getString("EXECUTION_RESULT__TRAJECTORY");
        executionResult.creationTimestamp = rs2.getLong("EXECUTION_RESULT__CREATION_TIMESTAMP");
        return executionResult;
    }

    private AgentReviewExecutionResult getExecutionResult(DSSDBConnection conn, String projectKey, String executionResultId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getExecutionResult);
        ps2.setString(1, projectKey);
        ps2.setString(2, executionResultId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                AgentReviewExecutionResult agentReviewExecutionResult = this.readExecutionResult(rs2);
                return agentReviewExecutionResult;
            }
            AgentReviewExecutionResult agentReviewExecutionResult = null;
            return agentReviewExecutionResult;
        }
    }

    private AgentReviewExecutionResult createExecutionResult(DSSDBConnection conn, String projectKey, String agentReviewId, String runId, String testId, String resultId, AgentReviewRawExecutionResult executionResult, long timeMillis) throws SQLException {
        String executionResultId = AgentReviewInternalDB.generateId();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertExecutionResult);
        int i = 0;
        ps2.setString(++i, executionResultId);
        ps2.setString(++i, projectKey);
        ps2.setString(++i, agentReviewId);
        ps2.setString(++i, runId);
        ps2.setString(++i, testId);
        ps2.setString(++i, resultId);
        ps2.setString(++i, executionResult.answer);
        ps2.setNull(++i, 12);
        ps2.setString(++i, executionResult.trajectory);
        ps2.setLong(++i, timeMillis);
        ps2.execute();
        return this.getExecutionResult(conn, projectKey, executionResultId);
    }

    public List<AgentReviewTraitOverride> listTraitOverrides(String projectKey, String resultId) throws SQLException {
        ArrayList<AgentReviewTraitOverride> ret = new ArrayList<AgentReviewTraitOverride>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listTraitOverrides);
            ps2.setString(1, projectKey);
            ps2.setString(2, resultId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    AgentReviewTraitOverride traitOverride = this.readTraitOverride(rs2);
                    ret.add(traitOverride);
                }
            }
        }
        return ret;
    }

    public void createTraitOverride(String userLogin, AgentReviewTraitOverride traitOverride) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            String traitOverrideId;
            AgentReviewResult result = this.getMandatoryResult(conn, traitOverride.projectKey, traitOverride.resultId);
            long timeMillis = System.currentTimeMillis();
            traitOverride.id = traitOverrideId = AgentReviewInternalDB.generateId();
            traitOverride.agentReviewId = result.agentReviewId;
            traitOverride.runId = result.runId;
            traitOverride.createdBy = userLogin;
            traitOverride.creationTimestamp = timeMillis;
            traitOverride.lastModifiedBy = userLogin;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertTraitOverride);
            int i = 0;
            ps2.setString(++i, traitOverrideId);
            ps2.setString(++i, traitOverride.projectKey);
            ps2.setString(++i, result.agentReviewId);
            ps2.setString(++i, result.runId);
            ps2.setString(++i, result.id);
            ps2.setString(++i, traitOverride.traitId);
            ps2.setString(++i, userLogin);
            ps2.setBoolean(++i, traitOverride.like);
            ps2.setLong(++i, timeMillis);
            ps2.setString(++i, userLogin);
            ps2.setNull(++i, -5);
            ps2.execute();
            conn.commit();
        }
    }

    public AgentReviewTraitOverride updateTraitOverride(String userLogin, AgentReviewTraitOverride traitOverrideToUpdate) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)traitOverrideToUpdate.projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)traitOverrideToUpdate.id), (Object)"Run id can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewTraitOverride traitOverride = this.getMandatoryTraitOverride(conn, traitOverrideToUpdate);
            if (traitOverride.createdBy == null || !traitOverride.createdBy.equals(userLogin)) {
                throw new IllegalArgumentException("Only the author of the traitOverride can update it");
            }
            long timeMillis = System.currentTimeMillis();
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateTraitOverride);
            int i = 0;
            ps2.setObject(++i, (Object)traitOverrideToUpdate.like, 16);
            ps2.setString(++i, userLogin);
            ps2.setLong(++i, timeMillis);
            ps2.setString(++i, traitOverrideToUpdate.projectKey);
            ps2.setString(++i, traitOverrideToUpdate.id);
            ps2.execute();
            traitOverride.like = traitOverrideToUpdate.like;
            traitOverride.lastModifiedBy = userLogin;
            traitOverride.lastModifiedTimestamp = timeMillis;
            conn.commit();
            AgentReviewTraitOverride agentReviewTraitOverride = traitOverride;
            return agentReviewTraitOverride;
        }
    }

    public AgentReviewTraitOverride getTraitOverride(String projectKey, String traitOverrideId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)traitOverrideId), (Object)"TraitOverride ID can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewTraitOverride agentReviewTraitOverride = this.getTraitOverride(conn, projectKey, traitOverrideId);
            return agentReviewTraitOverride;
        }
    }

    @Nonnull
    private AgentReviewTraitOverride getMandatoryTraitOverride(DSSDBConnection conn, AgentReviewTraitOverride traitOverrideToUpdate) throws SQLException {
        AgentReviewTraitOverride traitOverride = this.getTraitOverride(conn, traitOverrideToUpdate.projectKey, traitOverrideToUpdate.id);
        if (traitOverride == null) {
            throw new InvalidParameterException("TraitOverride %s of project %s does not exist".formatted(traitOverrideToUpdate.id, traitOverrideToUpdate.projectKey));
        }
        return traitOverride;
    }

    public AgentReviewTraitOverride deleteTraitOverride(String userLogin, String projectKey, String traitOverrideId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            AgentReviewTraitOverride traitOverride = this.getMandatoryTraitOverride(conn, projectKey, traitOverrideId);
            if (traitOverride.createdBy == null || !traitOverride.createdBy.equals(userLogin)) {
                throw new IllegalArgumentException("Only the author of the traitOverride can delete it");
            }
            PreparedStatement psTraitOverrides = this.getPreparedStatement(conn, this.deleteTraitOverride);
            psTraitOverrides.setString(1, projectKey);
            psTraitOverrides.setString(2, traitOverrideId);
            psTraitOverrides.execute();
            conn.commit();
            AgentReviewTraitOverride agentReviewTraitOverride = traitOverride;
            return agentReviewTraitOverride;
        }
    }

    private AgentReviewTraitOverride getTraitOverride(DSSDBConnection conn, String projectKey, String traitOverrideId) throws SQLException {
        AgentReviewTraitOverride traitOverride;
        block7: {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getTraitOverride);
            ps2.setString(1, projectKey);
            ps2.setString(2, traitOverrideId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    traitOverride = this.readTraitOverride(rs2);
                    break block7;
                }
                AgentReviewTraitOverride agentReviewTraitOverride = null;
                return agentReviewTraitOverride;
            }
        }
        return traitOverride;
    }

    @Nonnull
    private AgentReviewTraitOverride getMandatoryTraitOverride(DSSDBConnection conn, String projectKey, String traitOverrideId) throws SQLException {
        AgentReviewTraitOverride traitOverride = this.getTraitOverride(conn, projectKey, traitOverrideId);
        if (traitOverride == null) {
            throw new InvalidParameterException("Trait override %s of project %s does not exist".formatted(traitOverrideId, projectKey));
        }
        return traitOverride;
    }

    private AgentReviewTraitOverride readTraitOverride(ResultSet rs2) throws SQLException {
        AgentReviewTraitOverride traitOverride = new AgentReviewTraitOverride();
        traitOverride.id = rs2.getString("TRAIT_OVERRIDE__ID");
        traitOverride.projectKey = rs2.getString("TRAIT_OVERRIDE__PROJECT_KEY");
        traitOverride.agentReviewId = rs2.getString("TRAIT_OVERRIDE__AGENT_REVIEW_ID");
        traitOverride.resultId = rs2.getString("TRAIT_OVERRIDE__RESULT_ID");
        traitOverride.traitId = rs2.getString("TRAIT_OVERRIDE__TRAIT_ID");
        traitOverride.runId = rs2.getString("TRAIT_OVERRIDE__RUN_ID");
        traitOverride.createdBy = rs2.getString("TRAIT_OVERRIDE__CREATED_BY");
        traitOverride.like = rs2.getObject("TRAIT_OVERRIDE__LIKE", Boolean.class);
        traitOverride.creationTimestamp = rs2.getLong("TRAIT_OVERRIDE__CREATION_TIMESTAMP");
        traitOverride.lastModifiedBy = rs2.getString("TRAIT_OVERRIDE__LAST_MODIFIED_BY");
        traitOverride.lastModifiedTimestamp = rs2.getLong("TRAIT_OVERRIDE__LAST_MODIFIED_TIMESTAMP");
        return traitOverride;
    }

    public void createTraitDefinitions(String projectKey, String agentReviewId, String runId, List<AgentReviewTrait> traitDefinitions) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            for (AgentReviewTrait traitDefinition : traitDefinitions) {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertTraitDefinition);
                int i = 0;
                ps2.setString(++i, projectKey);
                ps2.setString(++i, agentReviewId);
                ps2.setString(++i, runId);
                ps2.setString(++i, traitDefinition.id);
                ps2.setString(++i, traitDefinition.name);
                ps2.setString(++i, traitDefinition.description);
                ps2.setString(++i, traitDefinition.criteria);
                ps2.setString(++i, traitDefinition.llmId);
                ps2.setBoolean(++i, traitDefinition.needsReference);
                ps2.setBoolean(++i, traitDefinition.needsExpectations);
                ps2.execute();
            }
            conn.commit();
        }
    }

    public AgentReviewTrait getTraitDefinition(DSSDBConnection conn, String projectKey, String agentReviewId, String runId, String traitId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getTraitDefinition);
        ps2.setString(1, projectKey);
        ps2.setString(2, agentReviewId);
        ps2.setString(3, runId);
        ps2.setString(4, traitId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                AgentReviewTrait agentReviewTrait = this.readTraitDefinition(rs2);
                return agentReviewTrait;
            }
            AgentReviewTrait agentReviewTrait = null;
            return agentReviewTrait;
        }
    }

    private void getMandatoryTraitDefinition(DSSDBConnection conn, String traitId, AgentReviewExecutionResult executionResult) throws SQLException {
        AgentReviewTrait trait = this.getTraitDefinition(conn, executionResult.projectKey, executionResult.agentReviewId, executionResult.runId, traitId);
        if (trait == null) {
            throw new InvalidParameterException("Trait with id %s does not exist for run %s in agent review %s of project %s".formatted(traitId, executionResult.runId, executionResult.agentReviewId, executionResult.projectKey));
        }
    }

    public Map<String, List<AgentReviewTrait>> listTraitDefinitionPerRun(DSSDBConnection conn, String projectKey, String agentReviewId) throws SQLException {
        HashMap<String, List<AgentReviewTrait>> ret = new HashMap<String, List<AgentReviewTrait>>();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.listTraitDefinitionsForAgentReview);
        ps2.setString(1, projectKey);
        ps2.setString(2, agentReviewId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                String runId = rs2.getString("TRAIT_DEFINITION__RUN_ID");
                ret.computeIfAbsent(runId, k -> new ArrayList()).add(this.readTraitDefinition(rs2));
            }
        }
        return ret;
    }

    public List<AgentReviewTrait> listTraitDefinitions(String projectKey, String agentReviewId, String runId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            List<AgentReviewTrait> list = this.listTraitDefinitions(conn, projectKey, agentReviewId, runId);
            return list;
        }
    }

    public List<AgentReviewTrait> listTraitDefinitions(DSSDBConnection conn, String projectKey, String agentReviewId, String runId) throws SQLException {
        ArrayList<AgentReviewTrait> ret = new ArrayList<AgentReviewTrait>();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.listTraitDefinitionsForRun);
        ps2.setString(1, projectKey);
        ps2.setString(2, agentReviewId);
        ps2.setString(3, runId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                ret.add(this.readTraitDefinition(rs2));
            }
        }
        return ret;
    }

    private AgentReviewTrait readTraitDefinition(ResultSet rs2) throws SQLException {
        AgentReviewTrait trait = new AgentReviewTrait();
        trait.id = rs2.getString("TRAIT_DEFINITION__TRAIT_ID");
        trait.name = rs2.getString("TRAIT_DEFINITION__TRAIT_NAME");
        trait.description = rs2.getString("TRAIT_DEFINITION__TRAIT_DESCRIPTION");
        trait.llmId = rs2.getString("TRAIT_DEFINITION__TRAIT_LLM_ID");
        trait.criteria = rs2.getString("TRAIT_DEFINITION__TRAIT_CRITERIA");
        trait.needsReference = rs2.getBoolean("TRAIT_DEFINITION__NEEDS_REFERENCE");
        trait.needsExpectations = rs2.getBoolean("TRAIT_DEFINITION__NEEDS_EXPECTATIONS");
        return trait;
    }

    private void createTraitOutcome(DSSDBConnection conn, String traitId, AgentReviewService.TraitOutcome traitOutcome, AgentReviewExecutionResult executionResult) throws SQLException {
        this.getMandatoryTraitDefinition(conn, traitId, executionResult);
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertTraitOutcome);
        String traitOutcomeId = AgentReviewInternalDB.generateId();
        int i = 0;
        ps2.setString(++i, traitOutcomeId);
        ps2.setString(++i, executionResult.projectKey);
        ps2.setString(++i, executionResult.agentReviewId);
        ps2.setString(++i, executionResult.runId);
        ps2.setString(++i, executionResult.resultId);
        ps2.setString(++i, executionResult.id);
        ps2.setString(++i, traitId);
        ps2.setString(++i, traitOutcome.llmId);
        ps2.setObject(++i, (Object)traitOutcome.outcome, 16);
        ps2.setString(++i, traitOutcome.justification);
        ps2.execute();
    }

    public AgentReviewTraitOutcome readTraitOutcome(ResultSet rs2) throws SQLException {
        return new AgentReviewTraitOutcome(rs2.getString("TRAIT_OUTCOME__ID"), rs2.getString("TRAIT_OUTCOME__PROJECT_KEY"), rs2.getString("TRAIT_OUTCOME__AGENT_REVIEW_ID"), rs2.getString("TRAIT_OUTCOME__RUN_ID"), rs2.getString("TRAIT_OUTCOME__RESULT_ID"), rs2.getString("TRAIT_OUTCOME__TRAIT_ID"), rs2.getBoolean("TRAIT_OUTCOME__OUTCOME"), rs2.getString("TRAIT_OUTCOME__JUSTIFICATION"));
    }

    public AgentReviewInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 2, true);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
        this.cleanupDanglingRuns();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        Statement st2;
        if (currentSchemaVersion == 0) {
            st2 = conn.createStatement();
            try {
                this.createTable("AGENT_REVIEW_TEST", TestTable.TABLE_COLUMNS, TestTable.PRIMARY_KEY_COLUMNS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_TEST", TestTable.TEST_INDEX_KEYS, st2);
                this.createTable("AGENT_REVIEW_RUN", RunTable.TABLE_COLUMNS, RunTable.PRIMARY_KEY_COLUMNS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_RUN", RunTable.RUN_INDEX_KEYS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_RUN", RunTable.STATUS_INDEX_KEYS, st2);
                this.createTable("AGENT_REVIEW_RESULT", ResultTable.TABLE_COLUMNS, ResultTable.PRIMARY_KEY_COLUMNS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_RESULT", ResultTable.RUN_INDEX_KEYS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_RESULT", ResultTable.LIST_ALL_RESULTS_INDEX_KEYS, st2);
                this.createTable("AGENT_REVIEW_HUMAN_REVIEW", HumanReviewTable.TABLE_COLUMNS, HumanReviewTable.PRIMARY_KEY_COLUMNS, st2);
                this.createTable("AGENT_REVIEW_EXECUTION_RESULT", ExecutionResultTable.TABLE_COLUMNS, ExecutionResultTable.PRIMARY_KEY_COLUMNS, st2);
                this.createTable("AGENT_REVIEW_TRAIT_OVERRIDE", TraitOverrideTable.TABLE_COLUMNS, TraitOverrideTable.PRIMARY_KEY_COLUMNS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_TRAIT_OVERRIDE", TraitOverrideTable.RESULT_INDEX_KEYS, st2);
                this.createTable("AGENT_REVIEW_TRAIT_DEFINITION", TraitDefinitionTable.TABLE_COLUMNS, null, st2);
                this.createAnonymousIndex("AGENT_REVIEW_TRAIT_DEFINITION", TraitDefinitionTable.RUN_INDEX_KEYS, st2);
                this.createTable("AGENT_REVIEW_TRAIT_OUTCOME", TraitOutcomeTable.TABLE_COLUMNS, TraitOutcomeTable.PRIMARY_KEY_COLUMNS, st2);
                this.createAnonymousIndex("AGENT_REVIEW_TRAIT_OUTCOME", TraitOutcomeTable.RESULT_INDEX_KEYS, st2);
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
        if (currentSchemaVersion == 1) {
            st2 = conn.createStatement();
            try {
                String previousRunMessageColumnName = "RUN__MESSAGE";
                String renameMessageColumn = "ALTER TABLE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " RENAME COLUMN " + this.quote(previousRunMessageColumnName) + " TO " + this.quote("RUN__ERROR_MESSAGE");
                this.getPreparedStatement(conn, renameMessageColumn).execute();
                AddColumnQueryBuilder.addColumnTo(this.resolveTable("AGENT_REVIEW_RUN")).addColumns(new SchemaColumn("RUN__NAME", Type.STRING)).execute(st2, this.getDialect());
                String defaultRunName = "UPDATE " + this.getQuotedFullResolvedTableName("AGENT_REVIEW_RUN") + " SET " + this.quote("RUN__NAME") + "= 'Run #' ||" + this.quote("RUN__ID");
                PreparedStatement ps2 = this.getPreparedStatement(conn, defaultRunName);
                ps2.execute();
                AddColumnQueryBuilder.addColumnTo(this.resolveTable("AGENT_REVIEW_RUN")).addColumns(new SchemaColumn("RUN__TEST_IDS", Type.STRING)).execute(st2, this.getDialect());
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
    }

    public int countRuns(String projectKey, String agentReviewId) throws SQLException {
        int nbRuns = 0;
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.countRuns);
            ps2.setString(1, projectKey);
            ps2.setString(2, agentReviewId);
            try (ResultSet rs2 = ps2.executeQuery();){
                if (rs2.next()) {
                    nbRuns = rs2.getInt(1);
                }
            }
        }
        return nbRuns;
    }

    public void cleanupDanglingRuns() {
        try {
            int nbDanglingRuns = 0;
            try (DSSDBConnection conn = this.acquireConnection();){
                PreparedStatement psCount = this.getPreparedStatement(conn, this.countDanglingRuns);
                psCount.setString(1, AgentReviewRunState.RUNNING.name());
                try (ResultSet rs2 = psCount.executeQuery();){
                    if (rs2.next()) {
                        nbDanglingRuns = rs2.getInt(1);
                    }
                }
                logger.info((Object)("Collected " + nbDanglingRuns + " runs to cleanup"));
                if (nbDanglingRuns > 0) {
                    PreparedStatement psFinish = this.getPreparedStatement(conn, this.finishDanglingJobs);
                    psFinish.setString(1, AgentReviewRunState.FINISHED.name());
                    psFinish.setString(2, "Unterminated run, aborted when starting DSS");
                    psFinish.setLong(3, System.currentTimeMillis());
                    psFinish.setString(4, AgentReviewRunState.RUNNING.name());
                    psFinish.execute();
                    conn.commit();
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error while cleaning up dangling runs.", (Throwable)e);
        }
    }

    public int countDistinctContributors(String projectKey, String agentReviewId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int n;
            block16: {
                ResultSet rs2;
                block14: {
                    int n2;
                    block15: {
                        PreparedStatement ps2 = this.getPreparedStatement(conn, this.countDistinctContributors);
                        ps2.setString(1, projectKey);
                        ps2.setString(2, agentReviewId);
                        ps2.setString(3, projectKey);
                        ps2.setString(4, agentReviewId);
                        rs2 = ps2.executeQuery();
                        try {
                            if (!rs2.next()) break block14;
                            n2 = rs2.getInt(1);
                            if (rs2 == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return n2;
                }
                n = 0;
                if (rs2 == null) break block16;
                rs2.close();
            }
            return n;
        }
    }

    static String generateId() {
        return AgentReviewInternalDB.generateId(0);
    }

    static String generateId(int index) {
        return String.format("%d-%d-%s", System.currentTimeMillis(), index, SecretKeyGenerator.generate((int)6));
    }

    public void clearAgentReviewData(String projectKey, String agentReviewId) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement testSt = this.getPreparedStatement(conn, this.deleteTestsForReview);
            testSt.setString(1, projectKey);
            testSt.setString(2, agentReviewId);
            testSt.execute();
            conn.commit();
            PreparedStatement runSt = this.getPreparedStatement(conn, this.deleteRunsForReview);
            runSt.setString(1, projectKey);
            runSt.setString(2, agentReviewId);
            runSt.execute();
            PreparedStatement resultSt = this.getPreparedStatement(conn, this.deleteResultsForReview);
            resultSt.setString(1, projectKey);
            resultSt.setString(2, agentReviewId);
            resultSt.execute();
            PreparedStatement traitOverrideSt = this.getPreparedStatement(conn, this.deleteTraitOverridesForReview);
            traitOverrideSt.setString(1, projectKey);
            traitOverrideSt.setString(2, agentReviewId);
            traitOverrideSt.execute();
            PreparedStatement traitDefinitionSt = this.getPreparedStatement(conn, this.deleteTraitDefinitionsForReview);
            traitDefinitionSt.setString(1, projectKey);
            traitDefinitionSt.setString(2, agentReviewId);
            traitDefinitionSt.execute();
            PreparedStatement traitOutcomeSt = this.getPreparedStatement(conn, this.deleteTraitOutcomesForReview);
            traitOutcomeSt.setString(1, projectKey);
            traitOutcomeSt.setString(2, agentReviewId);
            traitOutcomeSt.execute();
            PreparedStatement executionResultSt = this.getPreparedStatement(conn, this.deleteExecutionResultsForReview);
            executionResultSt.setString(1, projectKey);
            executionResultSt.setString(2, agentReviewId);
            executionResultSt.execute();
            conn.commit();
        }
    }

    private <T> T readIfPresent(ResultSet rs2, String idColumn, ResultSetMapper<T> mapper) throws SQLException {
        return rs2.getString(idColumn) != null ? (T)mapper.map(rs2) : null;
    }

    private <T> Flux<T> generateFlux(ResultSet resultSet, ResultSetMapper<T> mapper) {
        return Flux.generate(sink -> {
            try {
                if (resultSet.next()) {
                    sink.next(mapper.map(resultSet));
                } else {
                    sink.complete();
                }
            }
            catch (SQLException e) {
                sink.error((Throwable)e);
            }
        });
    }

    private static class ResultTable {
        static final String NAME = "AGENT_REVIEW_RESULT";
        static final String ID = "RESULT__ID";
        static final String PROJECT_KEY = "RESULT__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "RESULT__AGENT_REVIEW_ID";
        static final String RUN_ID = "RESULT__RUN_ID";
        static final String TEST_ID = "RESULT__TEST_ID";
        static final String QUERY = "RESULT__QUERY";
        static final String REFERENCE_ANSWER = "RESULT__REFERENCE_ANSWER";
        static final String EXPECTATIONS = "RESULT__EXPECTATIONS";
        static final String RAW_QUERY = "RESULT__RAW_QUERY";
        static final String CREATION_TIMESTAMP = "RESULT__CREATION_TIMESTAMP";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("RESULT__ID", Type.STRING), new SchemaColumn("RESULT__PROJECT_KEY", Type.STRING), new SchemaColumn("RESULT__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("RESULT__RUN_ID", Type.STRING), new SchemaColumn("RESULT__TEST_ID", Type.STRING), new SchemaColumn("RESULT__QUERY", Type.STRING), new SchemaColumn("RESULT__REFERENCE_ANSWER", Type.STRING), new SchemaColumn("RESULT__EXPECTATIONS", Type.STRING), new SchemaColumn("RESULT__RAW_QUERY", Type.STRING), new SchemaColumn("RESULT__CREATION_TIMESTAMP", Type.BIGINT)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"RESULT__ID", "RESULT__PROJECT_KEY"};
        static final String[] LIST_ALL_RESULTS_INDEX_KEYS = new String[]{"RESULT__ID", "RESULT__PROJECT_KEY", "RESULT__CREATION_TIMESTAMP", "RESULT__ID"};
        static final String[] RUN_INDEX_KEYS = new String[]{"RESULT__RUN_ID", "RESULT__AGENT_REVIEW_ID", "RESULT__PROJECT_KEY", "RESULT__CREATION_TIMESTAMP"};

        private ResultTable() {
        }
    }

    private static class TestTable {
        static final String NAME = "AGENT_REVIEW_TEST";
        static final String ID = "TEST__ID";
        static final String PROJECT_KEY = "TEST__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "TEST__AGENT_REVIEW_ID";
        static final String QUERY = "TEST__QUERY";
        static final String REFERENCE_ANSWER = "TEST__REFERENCE_ANSWER";
        static final String EXPECTATIONS = "TEST__EXPECTATIONS";
        static final String CREATION_TIMESTAMP = "TEST__CREATION_TIMESTAMP";
        static final String CREATED_BY = "TEST__CREATED_BY";
        static final String LAST_MODIFIED_TIMESTAMP = "TEST__LAST_MODIFIED_TIMESTAMP";
        static final String LAST_MODIFIED_BY = "TEST__LAST_MODIFIED_BY";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("TEST__ID", Type.STRING), new SchemaColumn("TEST__PROJECT_KEY", Type.STRING), new SchemaColumn("TEST__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("TEST__QUERY", Type.STRING), new SchemaColumn("TEST__REFERENCE_ANSWER", Type.STRING), new SchemaColumn("TEST__EXPECTATIONS", Type.STRING), new SchemaColumn("TEST__CREATION_TIMESTAMP", Type.BIGINT), new SchemaColumn("TEST__CREATED_BY", Type.STRING), new SchemaColumn("TEST__LAST_MODIFIED_TIMESTAMP", Type.BIGINT), new SchemaColumn("TEST__LAST_MODIFIED_BY", Type.STRING)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"TEST__ID", "TEST__PROJECT_KEY"};
        static final String[] TEST_INDEX_KEYS = new String[]{"TEST__AGENT_REVIEW_ID", "TEST__PROJECT_KEY", "TEST__CREATION_TIMESTAMP"};

        private TestTable() {
        }
    }

    private static class RunTable {
        static final String NAME = "AGENT_REVIEW_RUN";
        static final String ID = "RUN__ID";
        static final String PROJECT_KEY = "RUN__PROJECT_KEY";
        static final String REVIEW_PROJECT_LAST_COMMIT_ID = "RUN__REVIEW_PROJECT_LAST_COMMIT_ID";
        static final String AGENT_REVIEW_ID = "RUN__AGENT_REVIEW_ID";
        static final String CREATED_BY = "RUN__CREATED_BY";
        static final String AGENT_SMART_ID = "RUN__AGENT_SMART_ID";
        static final String AGENT_VERSION = "RUN__AGENT_VERSION";
        static final String AGENT_PROJECT_LAST_COMMIT_ID = "RUN__AGENT_PROJECT_LAST_COMMIT_ID";
        static final String START_TIMESTAMP = "RUN__START_TIMESTAMP";
        static final String END_TIMESTAMP = "RUN__END_TIMESTAMP";
        static final String NB_EXECUTIONS = "RUN__NB_EXECUTIONS";
        static final String STATUS = "RUN__STATUS";
        static final String ERROR_MESSAGE = "RUN__ERROR_MESSAGE";
        static final String RUN_NAME = "RUN__NAME";
        static final String TEST_IDS = "RUN__TEST_IDS";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("RUN__ID", Type.STRING), new SchemaColumn("RUN__PROJECT_KEY", Type.STRING), new SchemaColumn("RUN__REVIEW_PROJECT_LAST_COMMIT_ID", Type.STRING), new SchemaColumn("RUN__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("RUN__CREATED_BY", Type.STRING), new SchemaColumn("RUN__AGENT_SMART_ID", Type.STRING), new SchemaColumn("RUN__AGENT_VERSION", Type.STRING), new SchemaColumn("RUN__AGENT_PROJECT_LAST_COMMIT_ID", Type.STRING), new SchemaColumn("RUN__START_TIMESTAMP", Type.BIGINT), new SchemaColumn("RUN__END_TIMESTAMP", Type.BIGINT), new SchemaColumn("RUN__NB_EXECUTIONS", Type.BIGINT), new SchemaColumn("RUN__STATUS", Type.STRING), new SchemaColumn("RUN__ERROR_MESSAGE", Type.STRING), new SchemaColumn("RUN__NAME", Type.STRING), new SchemaColumn("RUN__TEST_IDS", Type.STRING)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"RUN__ID", "RUN__PROJECT_KEY", "RUN__AGENT_REVIEW_ID"};
        static final String[] RUN_INDEX_KEYS = new String[]{"RUN__AGENT_REVIEW_ID", "RUN__PROJECT_KEY", "RUN__START_TIMESTAMP"};
        static final String[] STATUS_INDEX_KEYS = new String[]{"RUN__STATUS"};

        private RunTable() {
        }
    }

    private static class ExecutionResultTable {
        static final String NAME = "AGENT_REVIEW_EXECUTION_RESULT";
        static final String ID = "EXECUTION_RESULT__ID";
        static final String PROJECT_KEY = "EXECUTION_RESULT__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "EXECUTION_RESULT__AGENT_REVIEW_ID";
        static final String RUN_ID = "EXECUTION_RESULT__RUN_ID";
        static final String TEST_ID = "EXECUTION_RESULT__TEST_ID";
        static final String RESULT_ID = "EXECUTION_RESULT__RESULT_ID";
        static final String ANSWER = "EXECUTION_RESULT__ANSWER";
        static final String RAW_RESPONSE = "EXECUTION_RESULT__RAW_RESPONSE";
        static final String TRAJECTORY = "EXECUTION_RESULT__TRAJECTORY";
        static final String CREATION_TIMESTAMP = "EXECUTION_RESULT__CREATION_TIMESTAMP";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("EXECUTION_RESULT__ID", Type.STRING), new SchemaColumn("EXECUTION_RESULT__PROJECT_KEY", Type.STRING), new SchemaColumn("EXECUTION_RESULT__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("EXECUTION_RESULT__RUN_ID", Type.STRING), new SchemaColumn("EXECUTION_RESULT__TEST_ID", Type.STRING), new SchemaColumn("EXECUTION_RESULT__RESULT_ID", Type.STRING), new SchemaColumn("EXECUTION_RESULT__ANSWER", Type.STRING), new SchemaColumn("EXECUTION_RESULT__RAW_RESPONSE", Type.STRING), new SchemaColumn("EXECUTION_RESULT__TRAJECTORY", Type.STRING), new SchemaColumn("EXECUTION_RESULT__CREATION_TIMESTAMP", Type.BIGINT)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"EXECUTION_RESULT__ID", "EXECUTION_RESULT__PROJECT_KEY"};

        private ExecutionResultTable() {
        }
    }

    private static class TraitOutcomeTable {
        static final String NAME = "AGENT_REVIEW_TRAIT_OUTCOME";
        static final String ID = "TRAIT_OUTCOME__ID";
        static final String PROJECT_KEY = "TRAIT_OUTCOME__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "TRAIT_OUTCOME__AGENT_REVIEW_ID";
        static final String RUN_ID = "TRAIT_OUTCOME__RUN_ID";
        static final String RESULT_ID = "TRAIT_OUTCOME__RESULT_ID";
        static final String EXECUTION_RESULT_ID = "TRAIT_OUTCOME__EXECUTION_RESULT_ID";
        static final String TRAIT_ID = "TRAIT_OUTCOME__TRAIT_ID";
        static final String TRAIT_LLM_ID = "TRAIT_OUTCOME__TRAIT_LLM_ID";
        static final String OUTCOME = "TRAIT_OUTCOME__OUTCOME";
        static final String JUSTIFICATION = "TRAIT_OUTCOME__JUSTIFICATION";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("TRAIT_OUTCOME__ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__PROJECT_KEY", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__RUN_ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__RESULT_ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__EXECUTION_RESULT_ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__TRAIT_ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__TRAIT_LLM_ID", Type.STRING), new SchemaColumn("TRAIT_OUTCOME__OUTCOME", Type.BOOLEAN), new SchemaColumn("TRAIT_OUTCOME__JUSTIFICATION", Type.STRING)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"TRAIT_OUTCOME__ID", "TRAIT_OUTCOME__PROJECT_KEY"};
        static final String[] RESULT_INDEX_KEYS = new String[]{"TRAIT_OUTCOME__EXECUTION_RESULT_ID", "TRAIT_OUTCOME__PROJECT_KEY"};

        private TraitOutcomeTable() {
        }
    }

    private static class TraitOverrideTable {
        static final String NAME = "AGENT_REVIEW_TRAIT_OVERRIDE";
        static final String ID = "TRAIT_OVERRIDE__ID";
        static final String PROJECT_KEY = "TRAIT_OVERRIDE__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "TRAIT_OVERRIDE__AGENT_REVIEW_ID";
        static final String RUN_ID = "TRAIT_OVERRIDE__RUN_ID";
        static final String RESULT_ID = "TRAIT_OVERRIDE__RESULT_ID";
        static final String TRAIT_ID = "TRAIT_OVERRIDE__TRAIT_ID";
        static final String CREATED_BY = "TRAIT_OVERRIDE__CREATED_BY";
        static final String LIKE = "TRAIT_OVERRIDE__LIKE";
        static final String CREATION_TIMESTAMP = "TRAIT_OVERRIDE__CREATION_TIMESTAMP";
        static final String LAST_MODIFIED_BY = "TRAIT_OVERRIDE__LAST_MODIFIED_BY";
        static final String LAST_MODIFIED_TIMESTAMP = "TRAIT_OVERRIDE__LAST_MODIFIED_TIMESTAMP";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("TRAIT_OVERRIDE__ID", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__PROJECT_KEY", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__RUN_ID", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__RESULT_ID", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__TRAIT_ID", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__CREATED_BY", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__LIKE", Type.BOOLEAN), new SchemaColumn("TRAIT_OVERRIDE__CREATION_TIMESTAMP", Type.BIGINT), new SchemaColumn("TRAIT_OVERRIDE__LAST_MODIFIED_BY", Type.STRING), new SchemaColumn("TRAIT_OVERRIDE__LAST_MODIFIED_TIMESTAMP", Type.BIGINT)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"TRAIT_OVERRIDE__ID", "TRAIT_OVERRIDE__PROJECT_KEY"};
        static final String[] RESULT_INDEX_KEYS = new String[]{"TRAIT_OVERRIDE__RESULT_ID", "TRAIT_OVERRIDE__PROJECT_KEY"};

        private TraitOverrideTable() {
        }
    }

    private static class HumanReviewTable {
        static final String NAME = "AGENT_REVIEW_HUMAN_REVIEW";
        static final String ID = "HUMAN_REVIEW__ID";
        static final String PROJECT_KEY = "HUMAN_REVIEW__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "HUMAN_REVIEW__AGENT_REVIEW_ID";
        static final String RUN_ID = "HUMAN_REVIEW__RUN_ID";
        static final String TEST_ID = "HUMAN_REVIEW__TEST_ID";
        static final String RESULT_ID = "HUMAN_REVIEW__RESULT_ID";
        static final String COMMENT = "HUMAN_REVIEW__COMMENT";
        static final String LIKE = "HUMAN_REVIEW__LIKE";
        static final String CREATED_BY = "HUMAN_REVIEW__CREATED_BY";
        static final String LAST_MODIFIED_TIMESTAMP = "HUMAN_REVIEW__LAST_MODIFIED_TIMESTAMP";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("HUMAN_REVIEW__ID", Type.STRING), new SchemaColumn("HUMAN_REVIEW__PROJECT_KEY", Type.STRING), new SchemaColumn("HUMAN_REVIEW__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("HUMAN_REVIEW__RUN_ID", Type.STRING), new SchemaColumn("HUMAN_REVIEW__TEST_ID", Type.STRING), new SchemaColumn("HUMAN_REVIEW__RESULT_ID", Type.STRING), new SchemaColumn("HUMAN_REVIEW__COMMENT", Type.STRING), new SchemaColumn("HUMAN_REVIEW__LIKE", Type.BOOLEAN), new SchemaColumn("HUMAN_REVIEW__CREATED_BY", Type.STRING), new SchemaColumn("HUMAN_REVIEW__LAST_MODIFIED_TIMESTAMP", Type.BIGINT)};
        static final String[] PRIMARY_KEY_COLUMNS = new String[]{"HUMAN_REVIEW__ID", "HUMAN_REVIEW__PROJECT_KEY"};

        private HumanReviewTable() {
        }
    }

    private record ResultRow(String resultId, @Nonnull AgentReviewResult baseResult, AgentReviewExecutionResult execution, AgentReviewTraitOutcome traitOutcome, AgentReviewTraitOverride traitOverride, AgentReviewHumanReview humanReview) {
    }

    private record TestResultRow(AgentReviewTest test, ResultRow resultComponents) {
    }

    public class CreateTestProcessorOutput
    extends OutputWriter {
        private DSSDBConnection connection;
        private final String queryColumnName;
        private final String referenceAnswerColumnName;
        private final String expectationsColumnName;
        private final String projectKey;
        private final String agentReviewId;
        private final String userLogin;
        private final int maxBatchCount;
        private final long maxBatchSize;
        private Column queryColumn;
        private Column referenceAnswerColumn;
        private Column expectationsColumn;
        private boolean supportBatchUpdates;
        private PreparedStatement ps;
        private ComputeResourceUsage cru;
        private int rowsInBatch = 0;
        private long currentBatchSize = 0L;
        private int importedRows = 0;
        private int skippedRows = 0;
        private final List<String> createdTestIds = new ArrayList<String>();

        public CreateTestProcessorOutput(DSSDBConnection connection, String queryColumn, String referenceAnswerColumn, String expectationsColumn, String projectKey, String agentReviewId, String userLogin) {
            this.connection = connection;
            this.queryColumnName = queryColumn;
            this.referenceAnswerColumnName = referenceAnswerColumn;
            this.expectationsColumnName = expectationsColumn;
            this.projectKey = projectKey;
            this.agentReviewId = agentReviewId;
            this.userLogin = userLogin;
            this.maxBatchCount = DKUApp.getParams().getIntParam(AgentReviewInternalDB.MAX_BATCH_COUNT_KEY, Integer.valueOf(100));
            this.maxBatchSize = DKUApp.getParams().getLongParam(AgentReviewInternalDB.MAX_BATCH_SIZE_KEY, 10000000L);
        }

        public List<String> getCreatedTestIds() {
            return this.createdTestIds;
        }

        public void init(ColumnFactory cf) throws Exception {
            SQLConnectionProvider.SQLConnectionWrapper connectionWrapper;
            SQLConnectionProvider.SQLConnectionData connectionData;
            SQLDialect dialect;
            this.queryColumn = cf.column(this.queryColumnName);
            if (StringUtils.isNotBlank((String)this.referenceAnswerColumnName)) {
                this.referenceAnswerColumn = cf.column(this.referenceAnswerColumnName);
            }
            if (StringUtils.isNotBlank((String)this.expectationsColumnName)) {
                this.expectationsColumn = cf.column(this.expectationsColumnName);
            }
            this.supportBatchUpdates = (dialect = (connectionData = (connectionWrapper = this.connection.getConn()).getConnectionData()).getDialect()).supportsBatchUpdates(connectionData) && connectionWrapper.getMetaData().supportsBatchUpdates();
            this.ps = AgentReviewInternalDB.this.getPreparedStatement(this.connection, AgentReviewInternalDB.this.insertTest);
            this.cru = SQLComputeResourceUsage.startSQLQuery(connectionWrapper, AgentReviewInternalDB.this.insertTest, true);
        }

        public void emitRow(Row row) throws Exception {
            this.cru.setUpdateCheckingIfMissing(SQLComputeResourceUsage.getUpdateChecking());
            String query = row.get(this.queryColumn);
            if (StringUtils.isBlank((String)query)) {
                logger.debug((Object)"Row has an empty query statement, skipping it");
                ++this.skippedRows;
                return;
            }
            String referenceAnswer = this.referenceAnswerColumn != null ? row.get(this.referenceAnswerColumn) : null;
            String expectations = this.expectationsColumn != null ? row.get(this.expectationsColumn) : null;
            long timeMillis = System.currentTimeMillis();
            String testId = AgentReviewInternalDB.generateId(this.importedRows);
            long rowSize = AgentReviewInternalDB.estimatePayloadSize(query, referenceAnswer, expectations);
            try {
                if (this.rowsInBatch >= this.maxBatchCount || this.currentBatchSize + rowSize > this.maxBatchSize && this.rowsInBatch > 0) {
                    if (this.supportBatchUpdates) {
                        logger.trace((Object)"Executing SQL insert batch ...");
                        this.ps.executeBatch();
                        this.ps.clearBatch();
                        this.cru.updateInsertedRowCountAndCheck((long)this.importedRows);
                        logger.trace((Object)"SQL insert batch done");
                        logger.trace((Object)("imported " + this.importedRows + " rows, skippedRows=" + this.skippedRows));
                    }
                    this.connection.commit();
                    this.rowsInBatch = 0;
                    this.currentBatchSize = 0L;
                }
                AgentReviewInternalDB.fillInsertTestQuery(this.ps, testId, this.projectKey, this.agentReviewId, query, referenceAnswer, expectations, timeMillis, this.userLogin);
                if (this.supportBatchUpdates) {
                    this.ps.addBatch();
                } else {
                    this.ps.execute();
                    this.ps.clearParameters();
                }
                this.currentBatchSize += rowSize;
                ++this.rowsInBatch;
                ++this.importedRows;
            }
            catch (SQLException e) {
                logger.errorV("Encountered SQL exception: %s", new Object[]{ExceptionUtils.getMessageWithSQLNest((SQLException)e)});
                throw e;
            }
            this.createdTestIds.add(testId);
        }

        public void lastRowEmitted() throws Exception {
            logger.info((Object)("committing, imported " + this.importedRows + " skippedRows=" + this.skippedRows));
            if (this.skippedRows > 0) {
                logger.warn((Object)("Encountered " + this.skippedRows + " rows with empty query that were skipped"));
            }
            try {
                if (this.rowsInBatch > 0) {
                    try {
                        logger.info((Object)"Executing final batch");
                        this.ps.executeBatch();
                        logger.info((Object)"Executed final batch");
                    }
                    catch (SQLException e) {
                        logger.errorV("Failed to execute final batch: %s", new Object[]{ExceptionUtils.getMessageWithSQLNest((SQLException)e)});
                        throw e;
                    }
                }
                if (this.connection != null) {
                    this.connection.commit();
                    this.connection = null;
                }
            }
            finally {
                this.cru.reportCompleteWithRowCount((long)this.importedRows);
            }
            logger.info((Object)"Transaction done");
        }

        public void cancel() throws Exception {
            if (this.cru != null) {
                this.cru.reportCompleteNoFail();
            }
            logger.info((Object)"Aborting transaction");
            if (this.connection != null) {
                if (!this.connection.getConn().getAutoCommit()) {
                    logger.info((Object)"Executing rollback");
                    this.connection.rollback();
                }
                this.connection = null;
            }
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }
    }

    @FunctionalInterface
    private static interface ResultSetMapper<T> {
        public T map(ResultSet var1) throws SQLException;
    }

    private static class TraitDefinitionTable {
        static final String NAME = "AGENT_REVIEW_TRAIT_DEFINITION";
        static final String PROJECT_KEY = "TRAIT_DEFINITION__PROJECT_KEY";
        static final String AGENT_REVIEW_ID = "TRAIT_DEFINITION__AGENT_REVIEW_ID";
        static final String RUN_ID = "TRAIT_DEFINITION__RUN_ID";
        static final String TRAIT_ID = "TRAIT_DEFINITION__TRAIT_ID";
        static final String TRAIT_NAME = "TRAIT_DEFINITION__TRAIT_NAME";
        static final String TRAIT_DESCRIPTION = "TRAIT_DEFINITION__TRAIT_DESCRIPTION";
        static final String TRAIT_CRITERIA = "TRAIT_DEFINITION__TRAIT_CRITERIA";
        static final String TRAIT_LLM_ID = "TRAIT_DEFINITION__TRAIT_LLM_ID";
        static final String NEEDS_REFERENCE = "TRAIT_DEFINITION__NEEDS_REFERENCE";
        static final String NEEDS_EXPECTATIONS = "TRAIT_DEFINITION__NEEDS_EXPECTATIONS";
        static final SchemaColumn[] TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("TRAIT_DEFINITION__PROJECT_KEY", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__AGENT_REVIEW_ID", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__RUN_ID", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__TRAIT_ID", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__TRAIT_NAME", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__TRAIT_DESCRIPTION", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__TRAIT_CRITERIA", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__TRAIT_LLM_ID", Type.STRING), new SchemaColumn("TRAIT_DEFINITION__NEEDS_REFERENCE", Type.BOOLEAN), new SchemaColumn("TRAIT_DEFINITION__NEEDS_EXPECTATIONS", Type.BOOLEAN)};
        static final String[] RUN_INDEX_KEYS = new String[]{"TRAIT_DEFINITION__RUN_ID", "TRAIT_DEFINITION__PROJECT_KEY"};

        private TraitDefinitionTable() {
        }
    }

    public static class AgentReviewDBResourceBundle {
        DSSDBConnection conn;
        ResultSet resultSet;

        public AgentReviewDBResourceBundle(DSSDBConnection conn, ResultSet resultSet) {
            this.conn = conn;
            this.resultSet = resultSet;
        }

        public void closeResources() {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while closing ResultSet in Agent Review database", (Throwable)e);
            }
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while closing Connection in Agent Review database", (Throwable)e);
            }
        }
    }
}

