/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewExportTestsToDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewExportTestsToDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewHumanReview;
import com.dataiku.dip.agentreview.AgentReviewInternalDB;
import com.dataiku.dip.agentreview.AgentReviewLLMClientManager;
import com.dataiku.dip.agentreview.AgentReviewRawExecutionResult;
import com.dataiku.dip.agentreview.AgentReviewResult;
import com.dataiku.dip.agentreview.AgentReviewResultOverview;
import com.dataiku.dip.agentreview.AgentReviewRun;
import com.dataiku.dip.agentreview.AgentReviewRunHistoryItem;
import com.dataiku.dip.agentreview.AgentReviewRunState;
import com.dataiku.dip.agentreview.AgentReviewTest;
import com.dataiku.dip.agentreview.AgentReviewTestOverview;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.agentreview.AgentReviewTraitOverride;
import com.dataiku.dip.agentreview.AgentReviewsDAO;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.streaming.DatasetWriter;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureHistoryService;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.LLMMeshClientFactory;
import com.dataiku.dip.logging.AutoClosableAppenderWrapper;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.threads.BaseProgressingWorkThread;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import com.dataiku.j2py.annotations.PyModel;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AgentReviewService {
    public static final String TESTS_CREATE_FROM_DATASET_MAX_ROWS = "dku.agentReview.tests.createFromDataset.maxRows";
    public static final int DEFAULT_TESTS_CREATE_FROM_DATASET_MAX_ROWS = 5000;
    public static final String RUN_HISTORY_CACHE_EXPIRATION_MINUTES = "dku.agentReview.runHistory.cache.expirationMinutes";
    public static final int DEFAULT_RUN_HISTORY_CACHE_EXPIRATION_MINUTES = 60;
    private static final int RUN_HISTORY_CACHE_MAX_SIZE = 10000;
    private final AgentReviewInternalDB agentReviewInternalDB;
    private final SavedModelsCRUDService savedModelsCRUDService;
    private final TransactionService transactionService;
    private final AgentReviewsDAO agentReviewsDAO;
    private final FutureService futureService;
    private final UsersService usersService;
    private final DatasetAccessService datasetAccessService;
    private final ProjectsService projectsService;
    private final PermissionsService permissionsService;
    private final DatasetSaveService datasetSaveService;
    private final ConnectionsDAO connectionsDAO;
    private final ManagedDatasetsCreationService managedDatasetsCreationService;
    private final DatasetDeletionService datasetDeletionService;
    private final FutureHistoryService futureHistoryService;
    private final ProjectsJGitService projectsJGitService;
    private final LicenseEnforcementService licenseEnforcementService;
    private final Cache<AgentReviewRunIdentifier, AgentReviewRunHistoryItem> runHistoryCache;
    static final String QUERY_COL_NAME = "query";
    static final String REFERENCE_ANSWER_COL_NAME = "reference_answer";
    static final String EXPECTATIONS_COL_NAME = "expectations";
    static final SchemaColumn[] EXPORTED_DATASET_COLUMNS = new SchemaColumn[]{new SchemaColumn("query", Type.STRING), new SchemaColumn("reference_answer", Type.STRING), new SchemaColumn("expectations", Type.STRING)};
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agentreview.service");

    public AgentReviewService(AgentReviewInternalDB agentReviewInternalDB, SavedModelsCRUDService savedModelsCRUDService, TransactionService transactionService, AgentReviewsDAO agentReviewsDAO, FutureService futureService, UsersService usersService, DatasetAccessService datasetAccessService, ProjectsService projectsService, PermissionsService permissionsService, DatasetSaveService datasetSaveService, ConnectionsDAO connectionsDAO, ManagedDatasetsCreationService managedDatasetsCreationService, DatasetDeletionService datasetDeletionService, FutureHistoryService futureHistoryService, LicenseEnforcementService licenseEnforcementService, ProjectsJGitService projectsJGitService) {
        this.agentReviewInternalDB = agentReviewInternalDB;
        this.savedModelsCRUDService = savedModelsCRUDService;
        this.transactionService = transactionService;
        this.agentReviewsDAO = agentReviewsDAO;
        this.futureService = futureService;
        this.usersService = usersService;
        this.datasetAccessService = datasetAccessService;
        this.projectsService = projectsService;
        this.permissionsService = permissionsService;
        this.datasetSaveService = datasetSaveService;
        this.connectionsDAO = connectionsDAO;
        this.managedDatasetsCreationService = managedDatasetsCreationService;
        this.datasetDeletionService = datasetDeletionService;
        this.futureHistoryService = futureHistoryService;
        this.licenseEnforcementService = licenseEnforcementService;
        this.projectsJGitService = projectsJGitService;
        int runHistoryCacheExpirationInMinutes = DKUApp.getParams().getIntParam(RUN_HISTORY_CACHE_EXPIRATION_MINUTES, Integer.valueOf(60));
        this.runHistoryCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofMinutes(runHistoryCacheExpirationInMinutes)).build();
    }

    public int countTests(String projectKey, String agentReviewId) throws SQLException {
        return this.agentReviewInternalDB.countTests(projectKey, agentReviewId);
    }

    public Flux<AgentReviewTest> streamTests(String projectKey, String agentReviewId, @Nullable List<String> testIds) {
        return this.agentReviewInternalDB.streamTests(projectKey, agentReviewId, testIds);
    }

    public Flux<AgentReviewTestOverview> streamTestOverviews(String projectKey, String agentReviewId) throws SQLException {
        return this.agentReviewInternalDB.streamTestOverviews(projectKey, agentReviewId);
    }

    public AgentReviewTest getTest(String projectKey, String testId) throws SQLException {
        return this.agentReviewInternalDB.getTest(projectKey, testId);
    }

    public AgentReviewTest createTest(AuthCtx user, AgentReviewTest test) throws SQLException {
        return this.agentReviewInternalDB.createTest(this.retrieveAndCheckUserLogin(user), test.projectKey, test.agentReviewId, test.query, test.referenceAnswer, test.expectations);
    }

    public List<AgentReviewTest> createTests(AuthCtx user, List<AgentReviewTest> tests) throws SQLException {
        return this.agentReviewInternalDB.createTests(this.retrieveAndCheckUserLogin(user), tests);
    }

    public FutureResponse<AgentReviewCreateTestsFromDatasetResult> createTestsFromDataset(final AuthCtx user, final String projectKey, final String agentReviewId, final DatasetLocUtils.DatasetLoc datasetLoc, final AgentReviewCreateTestsFromDatasetRequest request) throws Exception {
        SimpleFutureThread<AgentReviewCreateTestsFromDatasetResult> futureThread = new SimpleFutureThread<AgentReviewCreateTestsFromDatasetResult>(user){

            public FuturePayload getPayload() {
                FuturePayload fp = FuturePayload.newSimple((String)"agent_review_create_from_dataset", (String)"Agent Review create tests from dataset");
                fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, agentReviewId, agentReviewId, ITaggingService.TaggableType.AGENT_REVIEW.name()));
                return fp;
            }

            @Override
            protected AgentReviewCreateTestsFromDatasetResult compute() throws Exception {
                Dataset dataset;
                logger.infoV("Loading tests from dataset %s into agent review %s.%s", new Object[]{datasetLoc.getFullName(), projectKey, agentReviewId});
                try (Transaction ignored = AgentReviewService.this.transactionService.beginRead();){
                    dataset = AgentReviewService.this.datasetAccessService.getMandatory(datasetLoc.getProjectKey(), datasetLoc.getName());
                }
                int maxRows = DKUApp.getParams().getIntParam(AgentReviewService.TESTS_CREATE_FROM_DATASET_MAX_ROWS, Integer.valueOf(5000));
                if (SamplingParam.SamplingMethod.HEAD_SEQUENTIAL.equals((Object)request.samplingMethod)) {
                    if (request.maxRecords > maxRows) {
                        logger.infoV("Sampling requested to load tests is HEAD_SEQUENTIAL with max records %d, which is above the limit of %d. Only the first %d will be imported", new Object[]{request.maxRecords, maxRows, maxRows});
                        request.maxRecords = maxRows;
                    } else if (request.maxRecords <= 0) {
                        logger.infoV("Sampling requested to load tests is HEAD_SEQUENTIAL with negative or zero max records %d, which would load the full dataset. Only the first %d will be imported", new Object[]{request.maxRecords, maxRows});
                        request.maxRecords = maxRows;
                    }
                } else if (SamplingParam.SamplingMethod.FULL.equals((Object)request.samplingMethod)) {
                    logger.infoV("Sampling requested to load tests is FULL, switching to HEAD_SEQUENTIAL with max records of %d to match the maximum permitted", new Object[]{maxRows});
                    request.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
                    request.maxRecords = maxRows;
                } else {
                    throw new IllegalArgumentException("Unsupported sampling method: " + String.valueOf(request.samplingMethod));
                }
                return AgentReviewService.this.agentReviewInternalDB.createTestsFromDataset(user, dataset, projectKey, agentReviewId, AgentReviewService.this.retrieveAndCheckUserLogin(user), request);
            }
        };
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AgentReviewCreateTestsFromDatasetResult>>(){});
    }

    public void importTestsFromJSON(AuthCtx user, File testFile, String projectKey) {
        String arId = FilenameUtils.getBaseName((String)testFile.getName());
        String userLogin = this.retrieveAndCheckUserLogin(user);
        logger.infoV("Reading tests of review %s", new Object[]{arId});
        final Gson gson = new Gson();
        try (final JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(testFile), StandardCharsets.UTF_8));){
            reader.beginArray();
            Iterator<AgentReviewTest> testIterator = new Iterator<AgentReviewTest>(){

                @Override
                public boolean hasNext() {
                    try {
                        return reader.hasNext();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error reading JSON stream", e);
                    }
                }

                @Override
                public AgentReviewTest next() {
                    return (AgentReviewTest)gson.fromJson(reader, AgentReviewTest.class);
                }
            };
            this.agentReviewInternalDB.createOrUpdateTestsFromJson(userLogin, projectKey, testIterator);
            reader.endArray();
        }
        catch (IOException | RuntimeException e) {
            logger.errorV((Throwable)e, "Error with file %s. Will not import all the tests of agent review %s", new Object[]{testFile.getName(), arId});
        }
    }

    @NotNull
    private static Schema getExportedDatasetSchema() {
        Schema schema = new Schema();
        schema.addColumns(List.of(EXPORTED_DATASET_COLUMNS));
        return schema;
    }

    private SerializedDataset initializeExportDestinationDataset(AuthCtx user, DatasetLocUtils.DatasetLoc datasetLoc, AgentReviewExportTestsToDatasetRequest params) throws Exception {
        SerializedDataset sds;
        Schema schema = AgentReviewService.getExportedDatasetSchema();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.permissionsService.checkProjectPrivileges(user, datasetLoc.getProjectKey(), true, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (params.overwriteDestinationDataset) {
                Dataset outputDataset = this.datasetAccessService.getMandatory(datasetLoc);
                if (outputDataset.getPartitioningSchema().isPartitioned()) {
                    throw new Exception("It is not possible to use a partitioned dataset \"" + datasetLoc.getFullName() + "\" as export output");
                }
                Dataset oldDataset = Dataset.fromSerialized(outputDataset.serialize());
                oldDataset.setSchema(schema);
                ManagedDatasetsHelper.copySchema(user, oldDataset.getSchema(), outputDataset);
                sds = outputDataset.serialize();
                this.datasetSaveService.save(datasetLoc, sds, user);
                t.commit("Update schema of " + outputDataset.getFullName() + " before filling it with export data");
            } else {
                if (this.datasetAccessService.getOrNull(datasetLoc) != null) {
                    throw new Exception("Dataset \"" + datasetLoc.getFullName() + "\" already exists");
                }
                DSSConnection connection = this.connectionsDAO.getMandatoryConnection(user, params.destinationDatasetConnection);
                String outputDatasetType = connection.getMainManagedDatasetType();
                Dataset outputDataset = new Dataset();
                outputDataset.setFullName(datasetLoc.getFullName());
                outputDataset.setType(outputDatasetType);
                ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings = new ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings();
                specificSettings.formatOptionId = this.managedDatasetsCreationService.getDefaultFormatOption(connection);
                DatasetHandlerFactory.getMeta(outputDataset).fillManagedDatasetParams(outputDataset, connection, specificSettings);
                outputDataset.fixupSchemaPerDatasetConstraint(user, schema);
                outputDataset.setSchema(schema);
                sds = outputDataset.serialize();
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
                this.datasetSaveService.create(datasetLoc.getProjectKey(), sds, dsCtx, user);
                t.commit("Created dataset " + outputDataset.getFullName() + " from export");
            }
        }
        return sds;
    }

    public FutureResponse<AgentReviewExportTestsToDatasetResult> exportTestsToDataset(final AuthCtx user, final String projectKey, final String agentReviewId, final DatasetLocUtils.DatasetLoc datasetLoc, final AgentReviewExportTestsToDatasetRequest request) throws Exception {
        final SerializedDataset targetDS = this.initializeExportDestinationDataset(user, datasetLoc, request);
        BaseProgressingWorkThread<AgentReviewExportTestsToDatasetResult> futureThread = new BaseProgressingWorkThread<AgentReviewExportTestsToDatasetResult>((DSSAuthCtx)user){
            AgentReviewExportTestsToDatasetResult result;

            public FuturePayload getPayload() {
                FuturePayload fp = FuturePayload.newSimple((String)"agent_review_export_to_dataset", (String)"Agent Review export tests to dataset");
                fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, agentReviewId, agentReviewId, ITaggingService.TaggableType.AGENT_REVIEW.name()));
                return fp;
            }

            public double getDangerosity() {
                return 0.0;
            }

            public AgentReviewExportTestsToDatasetResult getResult() {
                return this.result;
            }

            public void execute() throws Exception {
                Dataset dataset;
                logger.infoV("Exporting tests of agent review %s.%s to dataset %s", new Object[]{projectKey, agentReviewId, datasetLoc.getFullName()});
                this.result = new AgentReviewExportTestsToDatasetResult();
                int testsCount = CollectionUtils.isEmpty(request.testIds) ? AgentReviewService.this.agentReviewInternalDB.countTests(projectKey, agentReviewId) : request.testIds.size();
                try (Transaction ignored = AgentReviewService.this.transactionService.beginRead();){
                    dataset = AgentReviewService.this.datasetAccessService.getMandatory(datasetLoc.getProjectKey(), datasetLoc.getName());
                }
                StreamRowFactory rf = new StreamRowFactory();
                StreamColumnFactory cf = new StreamColumnFactory(AgentReviewService.getExportedDatasetSchema());
                try (DatasetWriter writingSession = DatasetWriter.build(user, dataset, "", Output.WriteMode.OVERWRITE, null, (ColumnFactory)cf);
                     Stream testsStream = AgentReviewService.this.streamTests(projectKey, agentReviewId, request.testIds).toStream();
                     FutureProgress.AutocloseableFutureProgressState exportState = FutureProgress.pushAutoCloseableState((String)"Exporting tests...", (double)testsCount, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    try {
                        Iterator it = testsStream.iterator();
                        while (it.hasNext()) {
                            Row row = rf.row();
                            AgentReviewTest test = (AgentReviewTest)it.next();
                            row.put((Column)cf.column(AgentReviewService.QUERY_COL_NAME), test.query);
                            row.put((Column)cf.column(AgentReviewService.REFERENCE_ANSWER_COL_NAME), test.referenceAnswer);
                            row.put((Column)cf.column(AgentReviewService.EXPECTATIONS_COL_NAME), test.expectations);
                            writingSession.appendRow(row);
                            FutureProgress.incrementState((double)1.0);
                            TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(targetDS);
                            ((NeverBuiltComputablesCacheService)SpringUtils.getBean(NeverBuiltComputablesCacheService.class)).remove(ref);
                        }
                        this.result.exportedTestCount = writingSession.getWrittenRows();
                    }
                    catch (Exception e) {
                        logger.errorV((Throwable)e, "Error exporting tests to dataset", new Object[0]);
                        try {
                            writingSession.cancel();
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to cancel export", (Throwable)e2);
                        }
                        TaggableObjectsDeletionService.DeletionOptions options = new TaggableObjectsDeletionService.DeletionOptions();
                        options.dropData = true;
                        options.dropMetastoreTable = false;
                        AgentReviewService.this.datasetDeletionService.clearDatasetForDeletion_NT(user, dataset, options);
                        try (RWTransaction t = AgentReviewService.this.transactionService.beginWriteAsLoggedInUser(user);){
                            AgentReviewService.this.datasetDeletionService.performDeletion(dataset, null, user, false);
                            t.commit("Deleted dataset " + dataset.getFullName() + " because export failed");
                        }
                        this.result.error = e.getLocalizedMessage();
                    }
                }
            }
        };
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AgentReviewExportTestsToDatasetResult>>(){});
    }

    public void deleteTest(String projectKey, String testId) throws SQLException {
        this.agentReviewInternalDB.deleteTest(projectKey, testId);
    }

    public void deleteTests(String projectKey, List<String> testIds) throws SQLException {
        this.agentReviewInternalDB.deleteTests(projectKey, testIds);
    }

    public AgentReviewTest updateTest(AuthCtx user, AgentReviewTest test) throws SQLException {
        return this.agentReviewInternalDB.updateTest(this.retrieveAndCheckUserLogin(user), test);
    }

    public List<AgentReviewResultOverview> listTestResultOverviewHistory_NT(AuthCtx authCtx, String projectKey, String testId) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        List<AgentReviewResult> agentReviewResults = this.agentReviewInternalDB.listTestResultsHistory(projectKey, testId);
        HashSet<String> userLogins = new HashSet<String>();
        HashSet<String> agentSmartIds = new HashSet<String>();
        for (AgentReviewResult result : agentReviewResults) {
            userLogins.add(result.createdBy);
            agentSmartIds.add(result.agentSmartId);
        }
        HashMap<String, PublicUser> publicUsersCache = new HashMap<String, PublicUser>();
        HashMap<String, String> agentNames = new HashMap<String, String>();
        for (String agentSmartId : agentSmartIds) {
            agentNames.computeIfAbsent(agentSmartId, id -> this.resolveAgentName(authCtx, projectKey, (String)id));
        }
        this.fillPublicUsersCache(userLogins, publicUsersCache);
        ArrayList<AgentReviewResultOverview> history = new ArrayList<AgentReviewResultOverview>();
        for (AgentReviewResult result : agentReviewResults) {
            PublicUser publicUser = (PublicUser)publicUsersCache.get(result.createdBy);
            String createdByDisplayName = publicUser == null ? null : publicUser.displayName;
            String agentDisplayName = (String)agentNames.get(result.agentSmartId);
            history.add(new AgentReviewResultOverview(result.id, result.runId, result.creationTimestamp, result.agentSmartId, result.agentVersion, result.createdBy, result.status, createdByDisplayName, agentDisplayName));
        }
        return history;
    }

    public List<AgentReviewResult> listTestFullResultHistory(String projectKey, String testId) throws SQLException {
        List<AgentReviewResult> results = this.agentReviewInternalDB.listTestResultsHistory(projectKey, testId);
        ConcurrentHashMap<String, String> userDisplayNameCache = new ConcurrentHashMap<String, String>();
        HashSet<String> usersToResolve = new HashSet<String>();
        for (AgentReviewResult result : results) {
            this.collectLogins(result, usersToResolve, userDisplayNameCache);
        }
        this.getUserDisplayNames(usersToResolve, userDisplayNameCache);
        for (AgentReviewResult result : results) {
            this.fillDisplayNames(result, userDisplayNameCache);
        }
        return results;
    }

    public int countRuns(String projectKey, String agentReviewId) throws SQLException {
        return this.agentReviewInternalDB.countRuns(projectKey, agentReviewId);
    }

    public List<AgentReviewRun> listRuns(String projectKey, String agentReviewId) throws SQLException {
        List<AgentReviewRun> runs = this.agentReviewInternalDB.listRuns(projectKey, agentReviewId);
        ConcurrentHashMap<String, String> userDisplayNameCache = new ConcurrentHashMap<String, String>();
        Set<String> allLogins = runs.stream().map(run -> run.createdBy).filter(Objects::nonNull).collect(Collectors.toSet());
        this.getUserDisplayNames(allLogins, userDisplayNameCache);
        runs.forEach(run -> {
            if (run.createdBy != null) {
                run.createdByDisplayName = (String)userDisplayNameCache.get(run.createdBy);
            }
        });
        return runs;
    }

    public AgentReviewRun getRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        return this.agentReviewInternalDB.getRun(projectKey, agentReviewId, runId);
    }

    @Nullable
    public AgentReviewRunHistoryItem getPreviousRunHistoryItem_NT(AuthCtx authCtx, String projectKey, String agentReviewId, String runId) throws SQLException, ExecutionException {
        TransactionContext.assertNoAttachedTransaction();
        AgentReviewRun previousFinishedRun = this.agentReviewInternalDB.getPreviousFinishedRunBefore(projectKey, agentReviewId, runId);
        if (previousFinishedRun == null) {
            return null;
        }
        return this.getRunHistoryItem_NT(authCtx, previousFinishedRun);
    }

    public List<AgentReviewRunHistoryItem> listRunHistory_NT(AuthCtx authCtx, String projectKey, String agentReviewId) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        HashSet<String> userLogins = new HashSet<String>();
        HashSet<String> agentSmartIds = new HashSet<String>();
        ArrayList<AgentReviewRunHistoryItem> history = new ArrayList<AgentReviewRunHistoryItem>();
        for (AgentReviewRun run : this.agentReviewInternalDB.listRuns(projectKey, agentReviewId)) {
            try {
                AgentReviewRunHistoryItem historyItem = this.getRunHistoryItemCopyWithoutUpdatableFields(run);
                history.add(historyItem);
                agentSmartIds.add(run.agentSmartId);
                userLogins.addAll(historyItem.reviewedByLogins);
                userLogins.add(run.createdBy);
            }
            catch (ExecutionException e) {
                logger.warn((Object)"Error computing run history item for run %s of project %s".formatted(run.id, run.projectKey), (Throwable)e);
            }
        }
        HashMap<String, PublicUser> publicUsersCache = new HashMap<String, PublicUser>();
        HashMap<String, String> agentNames = new HashMap<String, String>();
        for (String agentSmartId : agentSmartIds) {
            agentNames.computeIfAbsent(agentSmartId, id -> this.resolveAgentName(authCtx, projectKey, (String)id));
        }
        this.fillPublicUsersCache(userLogins, publicUsersCache);
        for (AgentReviewRunHistoryItem historyItem : history) {
            historyItem.agentName = (String)agentNames.get(historyItem.run.agentSmartId);
            historyItem.reviewedBy = historyItem.reviewedByLogins.stream().map(publicUsersCache::get).filter(Objects::nonNull).collect(Collectors.toSet());
            historyItem.runBy = (PublicUser)publicUsersCache.get(historyItem.run.createdBy);
        }
        return history;
    }

    public AgentReviewRunHistoryItem getRunHistoryItem_NT(AuthCtx authCtx, AgentReviewRun run) throws ExecutionException {
        TransactionContext.assertNoAttachedTransaction();
        AgentReviewRunHistoryItem historyItem = this.getRunHistoryItemCopyWithoutUpdatableFields(run);
        HashSet<String> userLogins = new HashSet<String>(historyItem.reviewedByLogins);
        userLogins.add(run.createdBy);
        HashMap<String, PublicUser> publicUsersCache = new HashMap<String, PublicUser>();
        try (Transaction ignored = this.transactionService.beginRead();){
            historyItem.agentName = this.resolveAgentName(authCtx, run.projectKey, run.agentSmartId);
            this.fillPublicUsersCache(userLogins, publicUsersCache);
        }
        historyItem.reviewedBy = historyItem.reviewedByLogins.stream().map(publicUsersCache::get).filter(Objects::nonNull).collect(Collectors.toSet());
        historyItem.runBy = (PublicUser)publicUsersCache.get(historyItem.run.createdBy);
        return historyItem;
    }

    private String resolveAgentName(AuthCtx authCtx, String projectKey, String agentSmartId) {
        String string;
        block9: {
            Transaction ignored = this.transactionService.retrieveOrBeginRead();
            try {
                AnyLoc loc = AnyLoc.resolveSmart(projectKey, agentSmartId).resolved();
                this.projectsService.failIfNoSavedModelReadUseAccess(authCtx, loc, projectKey);
                SavedModel sm = this.savedModelsCRUDService.getMandatory(loc.getProjectKey(), loc.getId());
                string = sm.name;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DKUSecurityException e) {
                    logger.trace((Object)("User does not have access to agent " + agentSmartId));
                    return agentSmartId;
                }
                catch (IOException e) {
                    logger.warn((Object)"Error retrieving the agent with id '%s'".formatted(agentSmartId), (Throwable)e);
                    return agentSmartId;
                }
            }
            ignored.close();
        }
        return string;
    }

    private void fillPublicUsersCache(Set<String> userLogins, Map<String, PublicUser> publicUsersCache) {
        if (userLogins.isEmpty()) {
            return;
        }
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            List<PublicUser> publicUsers = this.usersService.getPublicUsers(userLogins);
            for (PublicUser user : publicUsers) {
                if (user == null) continue;
                publicUsersCache.put(user.login, user);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error retrieving user profiles", (Throwable)e);
        }
    }

    private AgentReviewRunHistoryItem getRunHistoryItemCopyWithoutUpdatableFields(AgentReviewRun run) throws ExecutionException {
        return ((AgentReviewRunHistoryItem)this.runHistoryCache.get((Object)new AgentReviewRunIdentifier(run.projectKey, run.agentReviewId, run.id), () -> {
            logger.info((Object)"History item for run %s of agent review %s in project %s is not in cache. Computing it now".formatted(run.id, run.agentReviewId, run.projectKey));
            return this.computeRunHistoryItem(run);
        })).partialCopy();
    }

    private AgentReviewRunHistoryItem computeRunHistoryItem(AgentReviewRun run) throws SQLException {
        AgentReviewRunHistoryItem ret = new AgentReviewRunHistoryItem(run);
        if (!AgentReviewRunState.RUNNING.equals((Object)run.status)) {
            this.streamResults(run.projectKey, run.agentReviewId, run.id).doOnNext(result -> {
                Integer n = ret.nbTest;
                ret.nbTest = ret.nbTest + 1;
                switch (result.status) {
                    case PASS: {
                        n = ret.nbPass;
                        ret.nbPass = ret.nbPass + 1;
                        break;
                    }
                    case FAIL: {
                        n = ret.nbFail;
                        ret.nbFail = ret.nbFail + 1;
                        break;
                    }
                    case CONFLICT: {
                        n = ret.nbConflict;
                        ret.nbConflict = ret.nbConflict + 1;
                        break;
                    }
                    case SKIPPED: {
                        n = ret.nbSkipped;
                        ret.nbSkipped = ret.nbSkipped + 1;
                        break;
                    }
                    case EMPTY: {
                        n = ret.nbEmpty;
                        ret.nbEmpty = ret.nbEmpty + 1;
                    }
                }
                ret.reviewedByLogins.addAll(result.humanReviews.stream().map(humanReview -> humanReview.createdBy).collect(Collectors.toSet()));
                ret.reviewedByLogins.addAll(result.traitOverridesPerTraitId.values().stream().flatMap(Collection::stream).map(traitOverride -> traitOverride.createdBy).collect(Collectors.toSet()));
            }).blockLast();
        }
        return ret;
    }

    public AgentReviewRun rerun_NT(AuthCtx authCtx, String projectKey, String agentReviewId, boolean wait, boolean alwaysUseActiveVersionOfAgent, String runID, String newRunName) throws Exception {
        List<String> testIds = this.agentReviewInternalDB.getTestIdsForRun(projectKey, agentReviewId, runID);
        return this.performRun_NT(authCtx, projectKey, agentReviewId, testIds, wait, alwaysUseActiveVersionOfAgent, newRunName);
    }

    public FutureResponse<AgentReviewRawExecutionResult> performQuickRun_NT(final AuthCtx authCtx, String projectKey, final AgentReviewTest test) throws Exception {
        SavedModel agent;
        AgentReview agentReview;
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = this.licenseEnforcementService.getFeaturesStatus();
        if (!featuresStatus.advancedLLMMeshAllowed) {
            throw new LicenseRestrictionException("Agent review requires Advanced LLM Mesh, which is not enabled in your license.");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            try {
                agentReview = (AgentReview)this.agentReviewsDAO.getMandatory(projectKey, test.agentReviewId);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find agent review %s of project %s".formatted(test.agentReviewId, projectKey), e);
            }
            try {
                AnyLoc loc = AnyLoc.resolveSmart(agentReview.projectKey, agentReview.agentSmartId).resolved();
                this.projectsService.failIfNoSavedModelReadUseAccess(authCtx, loc, projectKey);
                agent = this.savedModelsCRUDService.getMandatory(loc.getProjectKey(), loc.getId());
            }
            catch (DKUSecurityException e) {
                throw new IllegalArgumentException("Error accessing agent %s reviewed by agent review %s of project %s".formatted(agentReview.agentSmartId, test.agentReviewId, projectKey), e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find agent review %s of project %s".formatted(test.agentReviewId, projectKey), e);
            }
        }
        return this.futureService.runFuture(new BaseProgressingWorkThread<AgentReviewRawExecutionResult>((DSSAuthCtx)authCtx){
            AgentReviewRawExecutionResult result;

            public FuturePayload getPayload() {
                FuturePayload fp = FuturePayload.newSimple((String)"agent-review-quick-run", (String)"Quick run");
                fp.targets.add(new FuturePayload.FuturePayloadTarget(agentReview.projectKey, agentReview.id, agentReview.name, ITaggingService.TaggableType.AGENT_REVIEW.name()));
                return fp;
            }

            public double getDangerosity() {
                return 0.0;
            }

            public AgentReviewRawExecutionResult getResult() {
                return this.result;
            }

            public void execute() throws Exception {
                try (FutureProgress.AutocloseableFutureProgressState quickRunState = FutureProgress.pushAutoCloseableState((String)"Query agent on test ...");){
                    String resolvedVersion = StringUtils.isBlank((String)agentReview.agentVersion) ? agent.getActiveVersion() : agentReview.agentVersion;
                    SavedModel.SavedModelInlineVersion agentInlineVersion = agent.getVersion(resolvedVersion).orElseThrow(() -> new IllegalArgumentException("Unknown agent version " + resolvedVersion + " for agent " + agentReview2.agentSmartId));
                    LLMClient.CompletionSettings agentCompletionSettings = agentInlineVersion.toolsUsingAgentSettings.completionSettings;
                    agentCompletionSettings.outputTrajectory = true;
                    EnrichedLLMStructuredRef agentRef = ((LLMRefEnricherService)SpringUtils.getBean(LLMRefEnricherService.class)).getEnrichedLLMRefFromAgentSMVersion(authCtx, agent, resolvedVersion, agentReview.projectKey);
                    GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, agentReview.projectKey, agentRef);
                    GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, agentInlineVersion.guardrailsPipelineSettings);
                    try (LLMMeshClient agentClient = LLMMeshClientFactory.get(authCtx, agentReview.projectKey, agentRef, guardrailsPipelineSettings, null, 1);){
                        JsonElement trajectoryJsonElement;
                        LLMClient.SingleCompletionQuery testQuery = new LLMClient.SingleCompletionQuery();
                        testQuery.messages.add(new LLMClient.ChatMessage("user", test.query));
                        LLMClient.SimpleCompletionResponseOrError agentResponse = agentClient.completeQueries(List.of(testQuery), agentCompletionSettings).get(0);
                        if (this.aborted) {
                            throw new InterruptedException("Agent review quick run has been aborted");
                        }
                        if (!agentResponse.ok) {
                            throw new RuntimeException("The Agent query failed on test '%s' : %s".formatted(test.id, agentResponse.errorMessage));
                        }
                        AgentReviewRawExecutionResult rawExecutionResult = new AgentReviewRawExecutionResult();
                        rawExecutionResult.answer = agentResponse.text;
                        String trajectory = null;
                        if (agentResponse.additionalInformation != null && (trajectoryJsonElement = agentResponse.additionalInformation.get("trajectory")) != null) {
                            trajectory = trajectoryJsonElement.toString();
                        }
                        rawExecutionResult.trajectory = trajectory;
                        this.result = rawExecutionResult;
                    }
                }
            }
        }, 10L, new TypeToken<FutureResponse<AgentReviewRawExecutionResult>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentReviewRun performRun_NT(AuthCtx authCtx, final String projectKey, final String agentReviewId, @Nullable List<String> testIds, boolean wait, boolean alwaysUseActiveVersionOfAgent, @Nullable String runName) throws Exception {
        Object agentProjectInfo;
        SavedModel agent;
        AgentReview agentReview;
        List<String> testIdsToReview;
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = this.licenseEnforcementService.getFeaturesStatus();
        if (!featuresStatus.advancedLLMMeshAllowed) {
            throw new LicenseRestrictionException("Agent review requires Advanced LLM Mesh, which is not enabled in your license.");
        }
        ArrayList<String> skippedIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty(testIds)) {
            logger.info((Object)"No test has been selected. Will run all tests of the agent review %s".formatted(agentReviewId));
            testIdsToReview = this.agentReviewInternalDB.listTestIds(projectKey, agentReviewId);
        } else {
            testIdsToReview = this.agentReviewInternalDB.getExistingTestIds(projectKey, testIds);
            skippedIds.addAll(testIds);
            skippedIds.removeAll(testIdsToReview);
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            try {
                agentReview = (AgentReview)this.agentReviewsDAO.getMandatory(projectKey, agentReviewId);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find agent review %s of project %s".formatted(agentReviewId, projectKey), e);
            }
            AnyLoc loc = AnyLoc.resolveSmart(agentReview.projectKey, agentReview.agentSmartId).resolved();
            this.projectsService.failIfNoSavedModelReadUseAccess(authCtx, loc, projectKey);
            agent = this.savedModelsCRUDService.getMandatory(loc.getProjectKey(), loc.getId());
        }
        String version = alwaysUseActiveVersionOfAgent || StringUtils.isBlank((String)agentReview.agentVersion) ? agent.getActiveVersion() : agentReview.agentVersion;
        SavedModel.SavedModelInlineVersion agentInlineVersion = agent.getVersion(version).orElseThrow(() -> new IllegalArgumentException("Unknown agent version " + version + " for agent " + agentReview.agentSmartId));
        boolean jobSubmittedSuccessfully = false;
        String agentProjectLastCommitId = "";
        try {
            agentProjectLastCommitId = this.getProjectLastCommitId(agent.projectKey);
        }
        catch (Throwable t) {
            logger.errorV(t, "Could not retrieve latest commit of agent's project %s.", new Object[]{agent.projectKey});
        }
        String reviewProjectLastCommitId = "";
        try {
            reviewProjectLastCommitId = this.getProjectLastCommitId(projectKey);
        }
        catch (Throwable t) {
            logger.errorV(t, "Could not retrieve latest commit of project %s.", new Object[]{projectKey});
        }
        final AgentReviewRun run = this.agentReviewInternalDB.createRun(this.retrieveAndCheckUserLogin(authCtx), projectKey, agentReview, agentInlineVersion.versionId, agentProjectLastCommitId, reviewProjectLastCommitId, testIdsToReview, runName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        AgentReviewLLMClientManager llmClientManager = null;
        try (AutoClosableAppenderWrapper ignored = this.appendCurrentThreadLogsToLogFile(run);){
            try {
                String startingRun = String.format("Preparing execution of run %s of agent review %s.%s", run.id, run.projectKey, run.agentReviewId);
                logger.info((Object)startingRun);
                logTailBuilder.appendLine(startingRun);
                String reviewProjectInfo = "Project '%s' last commit id : '%s'".formatted(projectKey, reviewProjectLastCommitId);
                logger.info((Object)reviewProjectInfo);
                logTailBuilder.appendLine(reviewProjectInfo);
                agentProjectInfo = "The review is performed with agent '%s' on version '%s'".formatted(agentReview.agentSmartId, version);
                logger.info(agentProjectInfo);
                logTailBuilder.appendLine((String)agentProjectInfo);
                if (!projectKey.equals(agent.projectKey)) {
                    String agentProjectLastCommitInfo = "Project '%s' last commit id : '%s'".formatted(agent.projectKey, agentProjectLastCommitId);
                    logger.info((Object)agentProjectLastCommitInfo);
                    logTailBuilder.appendLine(agentProjectLastCommitInfo);
                }
                if (!skippedIds.isEmpty()) {
                    String skippedTestsMsg = "The following test ids no longer exist in project %s and will be skipped: %s".formatted(projectKey, String.join((CharSequence)", ", skippedIds));
                    logger.warn((Object)skippedTestsMsg);
                    logTailBuilder.appendLine(skippedTestsMsg);
                }
                String initMsg = "Initializing LLM clients and verifying configuration...";
                logger.debug((Object)initMsg);
                logTailBuilder.appendLine(initMsg);
                llmClientManager = new AgentReviewLLMClientManager(authCtx, agentReview, testIdsToReview.size());
                String traitsMsg = "Initializing traits definition...";
                logger.debug((Object)traitsMsg);
                logTailBuilder.appendLine(traitsMsg);
                this.agentReviewInternalDB.createTraitDefinitions(projectKey, agentReviewId, run.id, agentReview.getEnabledTraits());
                String readyMsg = "Initialization complete. Starting tests execution.";
                logger.debug((Object)readyMsg);
                logTailBuilder.appendLine(readyMsg);
            }
            catch (Exception e) {
                String errorMsg = "Initialization error for agent '%s': %s".formatted(agentReview.agentSmartId, e.getMessage());
                logger.error((Object)errorMsg);
                logTailBuilder.appendLine(errorMsg);
                if (llmClientManager != null) {
                    llmClientManager.close();
                }
                this.agentReviewInternalDB.failRun(projectKey, agentReviewId, run.id, "Initialization error: " + e.getMessage());
                throw e;
            }
        }
        try {
            final AgentReviewLLMClientManager llmClientManagerInFuture = llmClientManager;
            FutureResponse<AgentReviewRun> fr = this.futureService.runFuture(new BaseProgressingWorkThread<AgentReviewRun>((DSSAuthCtx)authCtx){
                AgentReviewRun finishedRun;

                public FuturePayload getPayload() {
                    FuturePayload fp = FuturePayload.newSimple((String)"agent-review-run", (String)"Run agent review '%s'".formatted(agentReview.id));
                    fp.targets.add(new FuturePayload.FuturePayloadTarget(agentReview.projectKey, agentReview.id, agentReview.name, ITaggingService.TaggableType.AGENT_REVIEW.name()));
                    return fp;
                }

                public double getDangerosity() {
                    return 0.0;
                }

                public AgentReviewRun getResult() {
                    return this.finishedRun;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute() throws Exception {
                    int nbTests = testIdsToReview.size();
                    int stepsPerTest = 1 + agentReview.nbExecutions * (1 + agentReview.getEnabledTraits().size());
                    try (AutoClosableAppenderWrapper ignored = AgentReviewService.this.appendCurrentThreadLogsToLogFile(run);){
                        try (AgentReviewLLMClientManager agentReviewLLMClientManager = llmClientManagerInFuture;
                             FutureProgress.AutocloseableFutureProgressState allTestsState = FutureProgress.pushAutoCloseableState((String)"Computing", (double)nbTests, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                            String startMsg = "Starting run %s for agent review %s.%s, on %s tests".formatted(run.id, run.projectKey, run.agentReviewId, nbTests);
                            logger.info((Object)startMsg);
                            logTailBuilder.appendLine(startMsg);
                            for (int i = 0; i < testIdsToReview.size(); ++i) {
                                String testId = (String)testIdsToReview.get(i);
                                AgentReviewTest test = AgentReviewService.this.agentReviewInternalDB.getTest(projectKey, testId);
                                if (test == null) {
                                    logger.warnV("Test with id %s in project %s does not exist, skipping it", new Object[]{testId, projectKey});
                                    FutureProgress.incrementState((double)1.0);
                                    continue;
                                }
                                String query = test.query == null ? "" : test.query;
                                String testName = "\"%s\"   %d/%d".formatted(query.length() > 90 ? query.substring(0, 90) + "..." : query, i + 1, testIdsToReview.size());
                                String testStartMsg = "Performing test %d/%d: %s".formatted(i + 1, nbTests, test.query);
                                logger.debug((Object)testStartMsg);
                                logTailBuilder.appendLine(testStartMsg);
                                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement testState = FutureProgress.pushAutoCloseableState((String)testName, (double)stepsPerTest, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE, (double)1.0);){
                                    logger.trace(() -> "Performing agent review test query : %s".formatted(test.query));
                                    ArrayList<LLMClient.SingleCompletionQuery> completionQueries = new ArrayList<LLMClient.SingleCompletionQuery>();
                                    for (int nbExecution = 0; nbExecution < agentReview.nbExecutions; ++nbExecution) {
                                        LLMClient.SingleCompletionQuery testQuery = new LLMClient.SingleCompletionQuery();
                                        testQuery.messages.add(new LLMClient.ChatMessage("user", test.query));
                                        completionQueries.add(testQuery);
                                    }
                                    FutureProgress.incrementState((double)1.0);
                                    LLMClient.CompletionSettings completionSettings = llmClientManagerInFuture.agentCompletionSettings;
                                    completionSettings.outputTrajectory = true;
                                    List<LLMClient.SimpleCompletionResponseOrError> agentClientResponses = llmClientManagerInFuture.agentClient.completeQueries(completionQueries, completionSettings);
                                    if (this.aborted) {
                                        throw new InterruptedException("Agent review run has been aborted while performing query for test " + test.id);
                                    }
                                    List<AgentReviewRawExecutionResult> executionResults = new ArrayList<AgentReviewRawExecutionResult>();
                                    for (LLMClient.SimpleCompletionResponseOrError response : agentClientResponses) {
                                        JsonElement trajectoryObj;
                                        if (!response.ok) {
                                            logTailBuilder.appendLine("Agent query failed on test '%s': %s".formatted(test.id, response.errorMessage));
                                            logger.warn((Object)"The Agent query failed on test '%s' : %s".formatted(test.id, response.errorMessage));
                                            executionResults = Collections.emptyList();
                                            break;
                                        }
                                        AgentReviewRawExecutionResult agentReviewRawFullExecutionResult = new AgentReviewRawExecutionResult();
                                        agentReviewRawFullExecutionResult.answer = response.text;
                                        String trajectory = null;
                                        if (response.additionalInformation != null && (trajectoryObj = response.additionalInformation.get("trajectory")) != null) {
                                            trajectory = trajectoryObj.toString();
                                        }
                                        agentReviewRawFullExecutionResult.trajectory = trajectory;
                                        executionResults.add(agentReviewRawFullExecutionResult);
                                    }
                                    if (executionResults.isEmpty()) {
                                        String agentFailedMsg = "  - Agent failed to respond";
                                        logger.warn((Object)agentFailedMsg);
                                        logTailBuilder.appendLine(agentFailedMsg);
                                    } else {
                                        logger.trace(() -> "  - Agent responded to %d executions".formatted(agentReview2.nbExecutions));
                                    }
                                    LLMClient.CompletionSettings traitCompletionSettings = new LLMClient.CompletionSettings();
                                    traitCompletionSettings.responseFormat = AgentReviewService.this.traitResponseFormat();
                                    for (AgentReviewTrait trait : agentReview.getEnabledTraits()) {
                                        if (trait.needsReference && StringUtils.isBlank((String)test.referenceAnswer)) {
                                            String noReferenceMsg = "  - Test '%s' has no reference answer. Skipping trait '%s' '%s'".formatted(test.id, trait.name, trait.id);
                                            logger.debug((Object)noReferenceMsg);
                                            logTailBuilder.appendLine(noReferenceMsg);
                                            continue;
                                        }
                                        if (trait.needsExpectations && StringUtils.isBlank((String)test.expectations)) {
                                            String noExpectationsMsg = "  - Test '%s' has no expectations. Skipping trait '%s' ('%s')".formatted(test.id, trait.name, trait.id);
                                            logger.debug((Object)noExpectationsMsg);
                                            logTailBuilder.appendLine(noExpectationsMsg);
                                            continue;
                                        }
                                        String traitMsg = "  - Computing trait '%s' (%s)".formatted(trait.name, trait.id);
                                        logger.debug((Object)traitMsg);
                                        logTailBuilder.appendLine(traitMsg);
                                        LLMMeshClient llmClient = llmClientManagerInFuture.llmClientPerTraitId.get(trait.id);
                                        ArrayList<LLMClient.SingleCompletionQuery> traitCompletionQueries = new ArrayList<LLMClient.SingleCompletionQuery>();
                                        for (AgentReviewRawExecutionResult executionResult : executionResults) {
                                            LLMClient.SingleCompletionQuery traitCompletionQuery = new LLMClient.SingleCompletionQuery();
                                            traitCompletionQuery.messages.add(new LLMClient.ChatMessage("user", AgentReviewService.this.getTraitCompletionQuery(trait.criteria, test.query, executionResult.answer, test.referenceAnswer, test.expectations, executionResult.trajectory)));
                                            traitCompletionQueries.add(traitCompletionQuery);
                                        }
                                        try {
                                            List<LLMClient.SimpleCompletionResponseOrError> traitResponses = llmClient.completeQueries(traitCompletionQueries, traitCompletionSettings);
                                            if (this.aborted) {
                                                throw new InterruptedException("Agent review run has been aborted while computing trait " + trait.name + " for test " + test.id);
                                            }
                                            for (int j = 0; j < executionResults.size(); ++j) {
                                                AgentReviewRawExecutionResult executionResult = executionResults.get(j);
                                                LLMClient.SimpleCompletionResponseOrError traitResponse = traitResponses.get(j);
                                                if (traitResponse.ok) {
                                                    Gson gson = new Gson();
                                                    TraitOutcome traitOutcome = (TraitOutcome)gson.fromJson(traitResponse.text, TraitOutcome.class);
                                                    traitOutcome.llmId = llmClient.getEnrichedRef().id;
                                                    executionResult.traitOutcomeByTraitId.put(trait.id, traitOutcome);
                                                    continue;
                                                }
                                                logger.warn((Object)"The computation of trait %s failed for the execution %s of a test: %s".formatted(trait.name, j, traitResponse.errorMessage));
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            throw e;
                                        }
                                        catch (Exception e) {
                                            logTailBuilder.appendLine("Error computing trait '%s' (id: %s) for test '%s': %s".formatted(trait.name, trait.id, test.id, e.getMessage()));
                                            logger.warn((Object)"An error happened during the trait completion queries for test %s for trait %s".formatted(test.id, trait.id), (Throwable)e);
                                        }
                                    }
                                    AgentReviewService.this.agentReviewInternalDB.createResult(projectKey, agentReview, run.id, test, executionResults);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    String errMsg = "An error happened during the execution of test %s of agent review %s".formatted(testId, agentReviewId);
                                    logTailBuilder.appendLine(errMsg);
                                    logger.warn((Object)errMsg, (Throwable)e);
                                    AgentReviewService.this.agentReviewInternalDB.createResult(projectKey, agentReview, run.id, test, Collections.emptyList());
                                }
                            }
                            String finishMsg = "Run %s for agent review %s.%s completed.".formatted(run.id, run.projectKey, run.agentReviewId);
                            logger.info((Object)finishMsg);
                            logTailBuilder.appendLine(finishMsg);
                            this.finishedRun = AgentReviewService.this.agentReviewInternalDB.finishRun(agentReview.projectKey, agentReview.id, run.id);
                        }
                        catch (InterruptedException e) {
                            logTailBuilder.appendLine("Agent review run aborted.");
                            logger.warn((Object)"Agent review run aborted", (Throwable)e);
                            this.finishedRun = AgentReviewService.this.agentReviewInternalDB.abortRun(projectKey, agentReview.id, run.id);
                        }
                        catch (Exception e) {
                            logTailBuilder.appendLine("Critical error during agent review run: " + e.getMessage());
                            logger.warn((Object)"Error while running agent review", (Throwable)e);
                            this.finishedRun = AgentReviewService.this.agentReviewInternalDB.failRun(projectKey, agentReview.id, run.id, "Error while running agent review: " + e.getMessage());
                        }
                        finally {
                            AgentReviewService.this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(projectKey, agentReview.id, run.id));
                        }
                    }
                }

                public SmartLogTail getLog() {
                    return logTailBuilder.get();
                }
            }, 50L, new TypeToken<FutureResponse<AgentReviewRun>>(){});
            if (fr.jobId == null) {
                throw new RuntimeException("An error happened at startup of the run. Please check the logs");
            }
            this.futureHistoryService.register(run.getFutureHistoryKey(), fr, true, new String[0]);
            jobSubmittedSuccessfully = true;
            if (wait) {
                FutureResponse futureResponse = this.futureHistoryService.waitForFinalResponse(run.getFutureHistoryKey());
                agentProjectInfo = (AgentReviewRun)futureResponse.result;
                return agentProjectInfo;
            }
            AgentReviewRun agentReviewRun = run;
            return agentReviewRun;
        }
        finally {
            if (!jobSubmittedSuccessfully) {
                try {
                    llmClientManager.close();
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to close LLMClientManager after run submission failure", (Throwable)e);
                }
            }
        }
    }

    private LLMClient.ResponseFormatJson traitResponseFormat() {
        JsonObject properties = new JsonObject();
        JsonObject outcomeType = new JsonObject();
        outcomeType.addProperty("type", "boolean");
        properties.add("outcome", (JsonElement)outcomeType);
        JsonObject justificationType = new JsonObject();
        justificationType.addProperty("type", "string");
        properties.add("justification", (JsonElement)justificationType);
        JsonArray required = new JsonArray();
        required.add("outcome");
        required.add("justification");
        JsonObject jsonOutputSchema = new JsonObject();
        jsonOutputSchema.addProperty("type", "object");
        jsonOutputSchema.add("properties", (JsonElement)properties);
        jsonOutputSchema.add("required", (JsonElement)required);
        LLMClient.ResponseFormatJson jsonOutputFormat = new LLMClient.ResponseFormatJson();
        jsonOutputFormat.schema = jsonOutputSchema;
        return jsonOutputFormat;
    }

    private String getTraitCompletionQuery(String traitCriteria, @Nullable String query, @Nullable String answer, @Nullable String referenceAnswer, @Nullable String expectations, @Nullable String trajectory) {
        return "You are an automatic evaluator. Your task is to judge whether the **Agent's execution** satisfies a specific **Trait rule**.\n\nFollow these rules strictly:\n\n    1. Decision rule\n        - If the Agent's Answer or if the Agent's Trajectory clearly satisfies the Trait rule \u2192 set \"outcome\" to true.\n        - Otherwise (partially, ambiguously, or not at all) \u2192 set \"outcome\" to false.\n\n    2. How to use the Reference Answer\n        - The Reference Answer is an optional input that can be used to compute a trait.\n        - If NOT_PROVIDED, ignore this section completely\n\n    3. How to use the Expectations\n        - The Expectations is an optional input that can be used to compute a trait.\n        - If NOT_PROVIDED, ignore this section completely\n\n    4. How to use the Agent's Trajectory\n        - The Agent's Trajectory is an output of the agent that can be used to compute a trait.\n        - It contains the intermediate steps and tool calls made by the agent.\n        - It is provided in the <AGENT_TRAJECTORY> element.\n        - If NOT_PROVIDED, ignore this section completely\n\n    5. Scope of evaluation\n        - Judge only the Trait rule provided.\n        - Ignore aspects unrelated to this trait unless they directly impact whether the trait is satisfied.\n\n    6. Output format\n        - Always respond in valid JSON with exactly these two fields:\n            - \"outcome\": a boolean (true or false).\n            - \"justification\": a short explanation (1\u20133 sentences).\n\n        Example output:\n        {\n            \"outcome\": true,\n            \"justification\": \"The agent clearly satisfies the trait rule by providing all required steps with accurate reasoning, even though the wording and structure differ from the reference.\"\n        }\n\nNow perform the evaluation using ONLY the content inside the tags:\n\n<TRAIT_RULE>\n%s\n</TRAIT_RULE>\n\n<QUERY>\n%s\n</QUERY>\n\n<AGENT_ANSWER>\n%s\n</AGENT_ANSWER>\n\n<REFERENCE_ANSWER>\n%s\n</REFERENCE_ANSWER>\n\n<EXPECTATIONS>\n%s\n</EXPECTATIONS>\n\n<AGENT_TRAJECTORY>\n%s\n</AGENT_TRAJECTORY>\n".formatted(traitCriteria, query, answer, this.getTextOrNotProvided(referenceAnswer), this.getTextOrNotProvided(expectations), this.getTextOrNotProvided(trajectory));
    }

    @Nonnull
    private String getTextOrNotProvided(@Nullable String text) {
        return StringUtils.isBlank((String)text) ? "NOT_PROVIDED" : text;
    }

    private String getProjectLastCommitId(String projectKey) throws GitAPIException, IOException {
        TaggableObjectsService.TaggableObjectRef projectRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
        DSSGitModel.ObjectLog objectLog = this.projectsJGitService.getObjectLogSince(projectRef, null, null, 1);
        if (!CollectionUtils.isEmpty((Collection)objectLog.logEntries)) {
            GitModel.DKULogEntry dkuLogEntry = (GitModel.DKULogEntry)objectLog.logEntries.get(0);
            return dkuLogEntry.commitId;
        }
        throw new RuntimeException("There are no logs entries in project %s".formatted(projectKey));
    }

    public AgentReviewRun renameRun(String projectKey, String agentReviewId, String runId, String newName) throws SQLException {
        if (StringUtils.isBlank((String)newName)) {
            throw new IllegalArgumentException("Run name cannot be empty.");
        }
        this.agentReviewInternalDB.updateRunName(projectKey, agentReviewId, runId, newName);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(projectKey, agentReviewId, runId));
        return this.agentReviewInternalDB.getRun(projectKey, agentReviewId, runId);
    }

    public AgentReviewRun abortRun(AuthCtx user, String projectKey, String agentReviewId, String runId) throws SQLException {
        AgentReviewRun run = this.agentReviewInternalDB.getRun(projectKey, agentReviewId, runId);
        if (run != null) {
            FutureHistoryService.FutureHistoryItem item = this.futureHistoryService.getExactMatchOrNull(run.getFutureHistoryKey());
            if (item != null && !item.finished()) {
                this.futureService.abort(item.jobId, user);
            }
            return run;
        }
        throw new IllegalArgumentException(String.format("Cannot find run %s of agent review %s.%s ", runId, projectKey, agentReviewId));
    }

    public void deleteRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        this.deleteRuns(projectKey, agentReviewId, Collections.singletonList(runId));
    }

    public void deleteRuns(String projectKey, String agentReviewId, List<String> runIds) throws SQLException {
        if (CollectionUtils.isEmpty(runIds)) {
            return;
        }
        List<AgentReviewRun> deletedRuns = this.agentReviewInternalDB.deleteRuns(projectKey, agentReviewId, runIds);
        for (AgentReviewRun run : deletedRuns) {
            this.futureHistoryService.removeExactMatch(run.getFutureHistoryKey());
            this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(projectKey, agentReviewId, run.id));
            this.deleteLogsDir(projectKey, agentReviewId, run.id);
        }
    }

    public List<AgentReviewTraitOverride> listTraitOverrides(String projectKey, String resultId) throws SQLException {
        return this.agentReviewInternalDB.listTraitOverrides(projectKey, resultId);
    }

    public AgentReviewTraitOverride getTraitOverride(String projectKey, String traitOverrideId) throws SQLException {
        return this.agentReviewInternalDB.getTraitOverride(projectKey, traitOverrideId);
    }

    public AgentReviewTraitOverride createTraitOverride(AuthCtx user, AgentReviewTraitOverride traitOverride, boolean resolveDisplayNames) throws SQLException {
        this.agentReviewInternalDB.createTraitOverride(this.retrieveAndCheckUserLogin(user), traitOverride);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(traitOverride.projectKey, traitOverride.agentReviewId, traitOverride.runId));
        if (resolveDisplayNames) {
            traitOverride.createdByDisplayName = this.resolveDisplayName(traitOverride.createdBy);
        }
        return traitOverride;
    }

    public AgentReviewResult deleteTraitOverride(AuthCtx user, String projectKey, String traitOverrideId) throws SQLException {
        AgentReviewTraitOverride traitOverride = this.agentReviewInternalDB.deleteTraitOverride(this.retrieveAndCheckUserLogin(user), projectKey, traitOverrideId);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(traitOverride.projectKey, traitOverride.agentReviewId, traitOverride.runId));
        return this.getResult(projectKey, traitOverride.resultId);
    }

    public AgentReviewTraitOverride updateTraitOverride(AuthCtx user, AgentReviewTraitOverride traitOverride, boolean resolveDisplayNames) throws SQLException {
        AgentReviewTraitOverride updatedTraitOverride = this.agentReviewInternalDB.updateTraitOverride(this.retrieveAndCheckUserLogin(user), traitOverride);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(updatedTraitOverride.projectKey, updatedTraitOverride.agentReviewId, updatedTraitOverride.runId));
        if (resolveDisplayNames) {
            updatedTraitOverride.createdByDisplayName = this.resolveDisplayName(updatedTraitOverride.createdBy);
        }
        return updatedTraitOverride;
    }

    public List<AgentReviewHumanReview> listHumanReviews(String projectKey, String resultId) throws SQLException {
        return this.agentReviewInternalDB.listHumanReviews(projectKey, resultId);
    }

    public AgentReviewHumanReview getHumanReview(String projectKey, String humanReviewId) throws SQLException {
        return this.agentReviewInternalDB.getHumanReview(projectKey, humanReviewId);
    }

    public AgentReviewHumanReview createHumanReview(AuthCtx user, AgentReviewHumanReview humanReview, boolean resolveDisplayNames) throws SQLException {
        this.agentReviewInternalDB.createHumanReview(this.retrieveAndCheckUserLogin(user), humanReview);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(humanReview.projectKey, humanReview.agentReviewId, humanReview.runId));
        if (resolveDisplayNames) {
            humanReview.createdByDisplayName = this.resolveDisplayName(humanReview.createdBy);
        }
        return humanReview;
    }

    public AgentReviewResult deleteHumanReview(AuthCtx user, String projectKey, String humanReviewId) throws SQLException {
        AgentReviewHumanReview humanReview = this.agentReviewInternalDB.deleteHumanReview(this.retrieveAndCheckUserLogin(user), projectKey, humanReviewId);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(projectKey, humanReview.agentReviewId, humanReview.runId));
        return this.getResult(projectKey, humanReview.resultId);
    }

    public AgentReviewHumanReview updateHumanReview(AuthCtx user, AgentReviewHumanReview humanReview, boolean resolveDisplayNames) throws SQLException {
        AgentReviewHumanReview updatedReview = this.agentReviewInternalDB.updateHumanReview(this.retrieveAndCheckUserLogin(user), humanReview);
        this.runHistoryCache.invalidate((Object)new AgentReviewRunIdentifier(updatedReview.projectKey, updatedReview.agentReviewId, updatedReview.runId));
        if (resolveDisplayNames) {
            updatedReview.createdByDisplayName = this.resolveDisplayName(updatedReview.createdBy);
        }
        return updatedReview;
    }

    private String resolveDisplayName(String login) {
        String string;
        block9: {
            if (login == null) {
                return null;
            }
            Transaction ignored = this.transactionService.retrieveOrBeginRead();
            try {
                PublicUser publicUser = this.usersService.getPublicUser(login);
                String string2 = string = publicUser != null ? publicUser.displayName : null;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Error retrieving user profile for %s", new Object[]{login});
                    return null;
                }
            }
            ignored.close();
        }
        return string;
    }

    public Flux<AgentReviewResult> streamResults(String projectKey, String agentReviewId, String runId) throws SQLException {
        ConcurrentHashMap userDisplayNameCache = new ConcurrentHashMap();
        return this.agentReviewInternalDB.streamRunResultsFullInfo(projectKey, agentReviewId, runId).map(result -> {
            HashSet<String> usersToResolve = new HashSet<String>();
            this.collectLogins((AgentReviewResult)result, (Set<String>)usersToResolve, userDisplayNameCache);
            this.getUserDisplayNames(usersToResolve, userDisplayNameCache);
            this.fillDisplayNames((AgentReviewResult)result, userDisplayNameCache);
            return result;
        });
    }

    @Nonnull
    public AgentReviewResult getResult(String projectKey, String resultId) throws SQLException {
        AgentReviewResult result = this.agentReviewInternalDB.getFullResult(projectKey, resultId);
        if (result == null) {
            throw new IllegalArgumentException("Result with id %s does not exist in project %s".formatted(resultId, projectKey));
        }
        ConcurrentHashMap<String, String> userDisplayNameCache = new ConcurrentHashMap<String, String>();
        HashSet<String> usersToResolve = new HashSet<String>();
        this.collectLogins(result, usersToResolve, userDisplayNameCache);
        this.getUserDisplayNames(usersToResolve, userDisplayNameCache);
        this.fillDisplayNames(result, userDisplayNameCache);
        return result;
    }

    public List<AgentReviewTrait> listTraitsForRun(String projectKey, String agentReviewId, String runId) throws SQLException {
        return this.agentReviewInternalDB.listTraitDefinitions(projectKey, agentReviewId, runId);
    }

    public String extractExpectationsFromAnswerAndTrajectory(AuthCtx authCtx, String projectKey, String agentReviewId, String query, String answer, String trajectory) throws Exception {
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = this.licenseEnforcementService.getFeaturesStatus();
        if (!featuresStatus.advancedLLMMeshAllowed) {
            throw new LicenseRestrictionException("Agent review requires Advanced LLM Mesh, which is not enabled in your license.");
        }
        String llmId = null;
        try (Transaction t = this.transactionService.beginRead();){
            AgentReview agentReview = (AgentReview)this.agentReviewsDAO.getMandatory(projectKey, agentReviewId);
            llmId = agentReview.helperLLMId;
        }
        if (StringUtils.isBlank((String)llmId)) {
            llmId = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.defaultEvalLLMCompletionModelId;
        }
        if (StringUtils.isBlank((String)llmId)) {
            throw new IllegalArgumentException("No default evaluation LLM configured.");
        }
        EnrichedLLMStructuredRef enrichedRef = ((LLMRefEnricherService)SpringUtils.getBean(LLMRefEnricherService.class)).getEnrichedLLMRef(llmId, authCtx, projectKey);
        GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, projectKey, enrichedRef);
        try (LLMMeshClient llmClient = LLMMeshClientFactory.get(authCtx, projectKey, enrichedRef, guardrailsPipelineSettings, null, 1);){
            String prompt = "You are an expert at defining expectations for AI agent outputs.\nYour task is to extract a concise list of at most five expectations in total, including at least one expectation about the answer of the query and at least one expectation about the execution trajectory.\nThese expectations will be used to verify the reliability of future agent runs.\n\nThe expectations must satisfy the following criteria:\n- Divide your expectations in two sections and you must use the following labels: 'Answer Expectations' and 'Trajectory Expectations'.\n- Answer expectations : Each expected element must be present in the answer, either explicitly or through clear paraphrase. Do not judge factual correctness or answer quality beyond checking alignment with the Expectations. Stay concise.\n- Trajectory expectations: Formalize concisely the tool usage, sequence, or key parameters.\n- Trajectory Requirement: If the provided Trajectory is empty or null, you must include exactly one expectation under Trajectory Expectations stating that no \"tool calls\" should be made.\n- No expected element may be missing.\n\n\nQuery:\n%s\n\nAnswer:\n%s\n\nTrajectory:\n%s\n\nProvide the expectations as a bulleted list starting with a simple dash without any introduction or conclusion text.".formatted(query, answer, trajectory);
            LLMClient.SingleCompletionQuery llmQuery = new LLMClient.SingleCompletionQuery();
            llmQuery.messages.add(new LLMClient.ChatMessage("user", prompt));
            LLMClient.CompletionSettings settings = new LLMClient.CompletionSettings();
            LLMClient.SimpleCompletionResponseOrError response = llmClient.completeQueries(List.of(llmQuery), settings).get(0);
            if (!response.ok) {
                throw new Exception("LLM completion failed: " + response.errorMessage);
            }
            String string = response.text;
            return string;
        }
    }

    public int countDistinctContributors(String projectKey, String agentReviewId) throws SQLException {
        return this.agentReviewInternalDB.countDistinctContributors(projectKey, agentReviewId);
    }

    @Nonnull
    private String retrieveAndCheckUserLogin(AuthCtx authCtx) {
        String userLogin = authCtx.getDSSUserForImpersonation();
        if (StringUtils.isBlank((String)userLogin)) {
            throw new IllegalArgumentException("The provided API key does not impersonate a DSS user.");
        }
        return userLogin;
    }

    private AutoClosableAppenderWrapper appendCurrentThreadLogsToLogFile(@Nonnull AgentReviewRun run) {
        File logsDir = this.getLogsDir(run.projectKey, run.agentReviewId, run.id);
        try {
            DKUFileUtils.mkdirs((File)logsDir);
        }
        catch (IOException e) {
            logger.errorV("Error creating log directory %s for agent review %s in project %s", new Object[]{logsDir, run.agentReviewId, run.projectKey});
        }
        File logFile = this.getLogFile(run.projectKey, run.agentReviewId, run.id, "run.log");
        try {
            return DKUtils.appendCurrentThreadLogsToLogFile((File)logFile);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error setting saving of log of agent review run %s in file %s", new Object[]{run.id, logFile.getAbsolutePath()});
            return null;
        }
    }

    private File getLogsDir(@Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId) {
        return DKUFileUtils.getWithin((File)new File(System.getenv("DIP_HOME"), "run"), (String[])new String[]{"agent-review", projectKey, agentReviewId, runId});
    }

    private void deleteLogsDir(@Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId) {
        File logsDir = this.getLogsDir(projectKey, agentReviewId, runId);
        if (logsDir.isDirectory()) {
            try {
                DKUFileUtils.deleteDirectory((File)logsDir);
            }
            catch (IOException e) {
                logger.error((Object)String.format("Failed to delete run logs folder: %s", logsDir.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private File getLogFile(@Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId, @Nonnull String logFileName) {
        File logsDir = this.getLogsDir(projectKey, agentReviewId, runId);
        return DKUFileUtils.getWithin((File)logsDir, (String[])new String[]{logFileName});
    }

    public SmartLogTail getLog(@Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId, @Nonnull String logFileName) throws IOException {
        File logFile = this.getLogFile(projectKey, agentReviewId, runId, logFileName);
        if (logFile.exists() && logFile.isFile()) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        return new SmartLogTail();
    }

    public List<LogsService.LogDesc> listLogs(@Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId) throws IOException {
        ArrayList logs = Lists.newArrayList();
        File logsDir = this.getLogsDir(projectKey, agentReviewId, runId);
        if (logsDir.exists() && logsDir.isDirectory()) {
            for (File logFile : DKUFileUtils.recursiveListFiles((File)logsDir)) {
                logs.add(new LogsService.LogDesc(logFile, logsDir));
            }
        }
        return logs;
    }

    public void streamLog(OutputStream os, @Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId, @Nonnull String logName) throws Exception {
        block11: {
            File logFile = this.getLogFile(projectKey, agentReviewId, runId, logName);
            if (logFile.exists() && logFile.isFile()) {
                logger.debug((Object)("Start compressed stream for " + logFile.getAbsolutePath()));
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file " + logName + " doesn't exist");
        }
    }

    public void getAllLogsZip(OutputStream os, @Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId) throws Exception {
        File logsDir = this.getLogsDir(projectKey, agentReviewId, runId);
        ArrayList<Path> logFiles = new ArrayList<Path>();
        try {
            if (logsDir.exists() && logsDir.isDirectory()) {
                EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                Files.walkFileTree(logsDir.toPath(), opts, 5, new LogsService.LogFilesVisitor(logFiles));
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Listing log files failed", (Throwable)e);
        }
        logger.info((Object)("Start compressed stream of all logs for run " + runId + " of agent review " + agentReviewId + " in project " + projectKey));
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(os);){
            for (Path path : logFiles) {
                logger.info((Object)("Adding " + path.toString()));
                File file = path.toFile();
                LogsService.LogDesc desc = new LogsService.LogDesc(file, logsDir);
                ZipArchiveEntry ae = zos.createArchiveEntry(file, desc.name);
                zos.putArchiveEntry(ae);
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                }
                zos.closeArchiveEntry();
            }
        }
    }

    public void checkAgentReviewWritePermission(AuthCtx authCtx, String projectKey) throws DKUSecurityException {
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        this.licenseEnforcementService.checkAgentReviewAllowed(authCtx);
    }

    private void getUserDisplayNames(Collection<String> logins, Map<String, String> cache) {
        Set<String> usersToResolve = logins.stream().filter(login -> login != null && !cache.containsKey(login)).collect(Collectors.toSet());
        if (!usersToResolve.isEmpty()) {
            try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
                List<PublicUser> users = this.usersService.getPublicUsers(usersToResolve);
                for (PublicUser user : users) {
                    if (user == null || user.displayName == null) continue;
                    cache.put(user.login, user.displayName);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Error retrieving user profiles", (Throwable)e);
            }
        }
    }

    private void collectLogins(AgentReviewResult result, Set<String> usersToResolve, Map<String, String> cache) {
        if (result.createdBy != null && !cache.containsKey(result.createdBy)) {
            usersToResolve.add(result.createdBy);
        }
        if (result.traitOverridesPerTraitId != null) {
            result.traitOverridesPerTraitId.values().forEach(traitOverrides -> traitOverrides.forEach(override -> {
                if (override.createdBy != null && !cache.containsKey(override.createdBy)) {
                    usersToResolve.add(override.createdBy);
                }
            }));
        }
        if (result.humanReviews != null) {
            result.humanReviews.forEach(humanReview -> {
                if (humanReview.createdBy != null && !cache.containsKey(humanReview.createdBy)) {
                    usersToResolve.add(humanReview.createdBy);
                }
            });
        }
    }

    private void fillDisplayNames(AgentReviewResult result, Map<String, String> cache) {
        if (result.createdBy != null) {
            result.createdByDisplayName = cache.get(result.createdBy);
        }
        if (result.traitOverridesPerTraitId != null) {
            result.traitOverridesPerTraitId.values().forEach(traitOverrides -> traitOverrides.forEach(override -> {
                if (override.createdBy != null) {
                    override.createdByDisplayName = (String)cache.get(override.createdBy);
                }
            }));
        }
        if (result.humanReviews != null) {
            result.humanReviews.forEach(humanReview -> {
                if (humanReview.createdBy != null) {
                    humanReview.createdByDisplayName = (String)cache.get(humanReview.createdBy);
                }
            });
        }
    }

    public void enrichAgentReviewsWithAgentNames(String projectKey, List<AgentReview.AgentReviewListItem> items) {
        SavedModel sm;
        Set agentIds = items.stream().map(i -> i.agentId).collect(Collectors.toSet());
        HashMap<String, SavedModel> models = new HashMap<String, SavedModel>();
        try (Transaction t = this.transactionService.beginRead();){
            for (String agentId : agentIds) {
                try {
                    sm = this.savedModelsCRUDService.getOrNullUnsafe(projectKey, agentId);
                    if (sm == null) continue;
                    models.put(agentId, sm);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to retrieve agent name for id " + agentId), (Throwable)e);
                }
            }
        }
        HashMap<String, Integer> nameCounts = new HashMap<String, Integer>();
        for (SavedModel sm2 : models.values()) {
            nameCounts.merge(sm2.name, 1, Integer::sum);
        }
        for (AgentReview.AgentReviewListItem item : items) {
            sm = (SavedModel)models.get(item.agentId);
            if (sm != null) {
                if ((Integer)nameCounts.get(sm.name) > 1) {
                    item.agentDisplayName = sm.name + " (" + sm.id + ")";
                    continue;
                }
                item.agentDisplayName = sm.name;
                continue;
            }
            item.agentDisplayName = item.agentId + " (not found)";
        }
    }

    private record AgentReviewRunIdentifier(@Nonnull String projectKey, @Nonnull String agentReviewId, @Nonnull String runId) {
        public AgentReviewRunIdentifier {
            Objects.requireNonNull(projectKey, "projectKey");
            Objects.requireNonNull(agentReviewId, "agentReviewId");
            Objects.requireNonNull(runId, "runId");
        }
    }

    @PyModel
    public static class TraitOutcome {
        public Boolean outcome;
        public String justification;
        public String llmId;
    }
}

