/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class AgentTool
extends TaggableObjectsService.TaggableObject
implements ParamsWithSelectableCodeEnv,
ParamsWithContainerizable {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String name;
    public String type;
    public JsonObject params;
    public String quickTestQueryStr;
    public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    public boolean singleInstance;
    @Nullable
    public Integer minimumRetentionTimeSeconds;
    public boolean requireHumanApproval = false;
    public boolean allowEditingInputs = false;
    public String additionalDescriptionForLLM;

    public <T extends AgentToolParams> T getParamsCopyAs(Class<T> clazz) {
        return (T)((AgentToolParams)JSON.parse((JsonElement)this.params, clazz));
    }

    public void setParams(AgentToolParams params) {
        this.params = JSON.toJsonObject((Object)params, (String[])new String[0]);
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.AGENT_TOOL;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    private ParamsWithSelectableCodeEnv getParamsWithSelectableCodeEnv() {
        AgentToolMeta meta = AgentToolsRegistry.getMeta(this.type);
        if (meta == null) {
            throw new UnsupportedOperationException("Agent tool type " + this.type + " is unknown");
        }
        AgentToolParams params = this.getParamsCopyAs(meta.paramsClass());
        if (params instanceof ParamsWithSelectableCodeEnv) {
            ParamsWithSelectableCodeEnv paramsWithSelectableCodeEnv = (ParamsWithSelectableCodeEnv)((Object)params);
            return paramsWithSelectableCodeEnv;
        }
        return null;
    }

    private ParamsWithSelectableCodeEnv getMandatoryParamsWithSelectableCodeEnv() {
        ParamsWithSelectableCodeEnv params = this.getParamsWithSelectableCodeEnv();
        if (params == null) {
            throw new UnsupportedOperationException("Agent tool type " + this.type + " doesn't support selecting a code environment");
        }
        return params;
    }

    @Override
    public CodeEnvSelection getCodeEnvSelection() {
        ParamsWithSelectableCodeEnv params = this.getMandatoryParamsWithSelectableCodeEnv();
        return params.getCodeEnvSelection();
    }

    @Override
    public void setCodeEnvSelection(CodeEnvSelection envSelection) {
        ParamsWithSelectableCodeEnv params = this.getMandatoryParamsWithSelectableCodeEnv();
        params.setCodeEnvSelection(envSelection);
        this.setParams((AgentToolParams)((Object)params));
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
        ParamsWithSelectableCodeEnv params = this.getParamsWithSelectableCodeEnv();
        if (params == null) {
            return List.of();
        }
        return params.collectCodeEnvUsage(object);
    }

    private ParamsWithContainerizable getParamsWithContainerizable() {
        AgentToolMeta meta = AgentToolsRegistry.getMeta(this.type);
        if (meta == null) {
            throw new UnsupportedOperationException("Agent tool type " + this.type + " is unknown");
        }
        AgentToolParams params = this.getParamsCopyAs(meta.paramsClass());
        if (params instanceof ParamsWithContainerizable) {
            ParamsWithContainerizable paramsWithContainerizable = (ParamsWithContainerizable)((Object)params);
            return paramsWithContainerizable;
        }
        return null;
    }

    private ParamsWithContainerizable getMandatoryParamsWithContainerizable() {
        ParamsWithContainerizable params = this.getParamsWithContainerizable();
        if (params == null) {
            throw new UnsupportedOperationException("Agent tool type " + this.type + " doesn't support selecting a container execution context");
        }
        return params;
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        ParamsWithContainerizable params = this.getParamsWithContainerizable();
        if (params == null) {
            return null;
        }
        return params.getContainerSelection();
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        ParamsWithContainerizable params = this.getMandatoryParamsWithContainerizable();
        params.setContainerSelection(selection);
        this.setParams((AgentToolParams)((Object)params));
    }

    @UIModel
    public static class AgentToolListItem
    extends TaggableObjectsService.TaggableListItem {
        public String type;

        public AgentToolListItem(AgentTool agentTool) {
            super(agentTool);
            this.type = agentTool.type;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.AGENT_TOOL;
        }
    }
}

