/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.utils.JsonSchema;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.ForbiddenObjectException;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AgentToolMeta {
    public boolean supportsLoadSampleQuery;

    public AgentToolMeta(boolean supportsLoadSampleQuery) {
        this.supportsLoadSampleQuery = supportsLoadSampleQuery;
    }

    public abstract String getType();

    public abstract Class<? extends AgentToolParams> paramsClass();

    public abstract List<SavedModel.AgentDependency> getDependencies(AgentTool var1) throws IOException;

    public void checkAccessDependency(AuthCtx authCtx, AgentTool tool) throws IOException, ForbiddenObjectException {
    }

    public Set<String> listConnectionNames(AgentTool tool) {
        return new HashSet<String>();
    }

    public boolean remapConnections(AgentTool tool, Map<String, String> replacements) {
        return false;
    }

    public void encryptPasswords(AgentTool tool, PasswordEncryptionService passwordEncryptionService) {
        if (tool.dkuProperties != null) {
            for (AbstractSQLConnection.CustomDatabaseProperty cdp : tool.dkuProperties) {
                if (!cdp.secret || !StringUtils.isNotBlank((String)cdp.value)) continue;
                cdp.value = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(cdp.value);
            }
        }
    }

    public abstract ToolDescriptor getResultingDescriptor(AuthCtx var1, String var2, AgentTool var3) throws Exception;

    public ToolCallDescription getToolCallDescription_NT(AuthCtx authCtx, String projectKey, AgentTool tool, LLMClient.FunctionTool descriptor, AgentToolRunner.AgentToolInput input) throws Exception {
        return ToolCallDescription.empty();
    }

    public JsonObject loadSampleQuery(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
        throw new NotImplementedException(String.format("The %s tool does not have a custom sample query to load.", this.getType()));
    }

    public abstract AgentToolRunner buildRunner(AuthCtx var1, String var2, AgentTool var3, boolean var4) throws Exception;

    public final AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
        return this.buildRunner(authCtx, projectKey, tool, false);
    }

    public AgentToolParams newParams() {
        try {
            return this.paramsClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Required default constructor for param class: " + String.valueOf(this.paramsClass()), e);
        }
    }

    public static class ToolCallDescription {
        public String description;

        private ToolCallDescription() {
        }

        public static ToolCallDescription empty() {
            return new ToolCallDescription();
        }

        public ToolCallDescription(String description) {
            this.description = description;
        }
    }

    public static class SubtoolDescriptor {
        public String name;
        public String description;
        public JsonSchema inputSchema;
        public Boolean enabled;
    }

    @UIModel
    public static class ToolDescriptor {
        public Boolean multiple;
        public List<SubtoolDescriptor> subtools;
        public String name;
        public String description;
        public JsonSchema inputSchema;

        public ToolDescriptor(String name) {
            this.name = ToolDescriptor.sanitiseToolName(name);
        }

        public static String sanitiseToolName(String name) {
            Object sanitisedName = name.replaceAll("[^A-Za-z0-9_]", "_");
            if (!DKUApp.getParams().getBoolParam("dku.agents.visual.agenticLoopV2", true)) {
                sanitisedName = (String)sanitisedName + "_" + SecretKeyGenerator.generate((int)6);
            }
            return sanitisedName;
        }
    }
}

