/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.calculator;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.calculator.CalculatorTool;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import java.util.ArrayList;
import java.util.Arrays;

public class CalculatorToolRunner
implements AgentToolRunner {
    private final AuthCtx authCtx;
    private final CalculatorTool.Params params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.tools.calculator");

    public CalculatorToolRunner(DSSAuthCtx authCtx, AgentTool at) {
        this.authCtx = authCtx;
        this.params = at.getParamsCopyAs(CalculatorTool.Params.class);
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public AgentToolRunner.AgentToolOutput run(AgentToolRunner.AgentToolInput input) throws Exception {
        String formula = this.safeReadStringArgument(input, "formula");
        Object result = CalculatorToolRunner.evaluateWithMappedBooleans(formula);
        JF.ObjectBuilder response = JF.obj();
        AgentToolRunner.AgentToolOutput ret = new AgentToolRunner.AgentToolOutput();
        if (result instanceof ExpressionError) {
            ExpressionError e = (ExpressionError)result;
            throw new IllegalArgumentException(e.toString());
        }
        ret.output = result == null ? response.with("result", "").get() : response.with("result", result.toString()).get();
        return ret;
    }

    private static Object evaluateWithMappedBooleans(String formula) {
        Schema schema = new Schema();
        MemTable table = new MemTable();
        MemRow row = new MemRow(table);
        ArrayList<String> trueStrings = new ArrayList<String>(Arrays.asList("True", "true", "TRUE"));
        for (String string : trueStrings) {
            schema.addColumn(new SchemaColumn(string, Type.BOOLEAN));
            MemColumn col = table.column(string);
            row.put((Column)col, "True");
        }
        ArrayList<String> falseStrings = new ArrayList<String>(Arrays.asList("False", "false", "FALSE"));
        for (String falseString : falseStrings) {
            schema.addColumn(new SchemaColumn(falseString, Type.BOOLEAN));
            MemColumn col = table.column(falseString);
            row.put((Column)col, "False");
        }
        Expression expression = new Expression(formula, schema);
        expression.setColumnFactory(table);
        return expression.evaluate(row);
    }

    @Override
    public void close() throws Exception {
    }
}

