/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.custom;

import com.dataiku.dip.agents.tools.AbstractPythonAgentToolRunner;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.agents.tools.PythonAgentToolServerKernelDesc;
import com.dataiku.dip.agents.tools.PythonAgentToolServerPool;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolMeta;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.langchain.PluginAgentLLMClient;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class CustomAgentToolRunner
extends AbstractPythonAgentToolRunner {
    private final CustomAgentToolParams params;
    private final LoadedCustomAgentTool desc;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.tools");

    public CustomAgentToolRunner(DSSAuthCtx authCtx, AgentTool at, boolean devKernel, boolean devMode) throws Exception {
        super(authCtx, at);
        this.params = at.getParamsCopyAs(CustomAgentToolParams.class);
        this.devKernel = devKernel;
        this.devMode = devMode;
        CustomAgentToolMeta meta = (CustomAgentToolMeta)AgentToolsRegistry.getMeta(at.type);
        this.desc = meta.getLoadedDesc();
    }

    private String getLibFolder() {
        CustomAgentToolsService customAgentToolsService = (CustomAgentToolsService)SpringUtils.getBean(CustomAgentToolsService.class);
        return customAgentToolsService.getPythonLibFolder(this.desc.getType());
    }

    private String getCode() throws IOException {
        IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        File pluginFolder = pluginsService.getActualPluginFolder(this.desc.ownerPluginId);
        File codeFolder = new File(pluginFolder, this.desc.folderName);
        return DKUFileUtils.readFileToStringUTF8((File)new File(codeFolder, "tool.py"));
    }

    private PluginSettingsResolver.ResolvedSettings getExpandedPluginSettings() throws IOException, DKUSecurityException {
        IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        CustomAgentToolsService customAgentToolsService = (CustomAgentToolsService)SpringUtils.getBean(CustomAgentToolsService.class);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = customAgentToolsService.getExpandedPluginSettings(this.desc.getType(), this.authCtx, this.projectKey, this.params.config);
        PluginDesc pluginDesc = pluginsService.getDesc(this.desc.ownerPluginId);
        HashSet<String> passwordParams = new HashSet<String>();
        PluginAgentLLMClient.PluginPasswordFinder finder = new PluginAgentLLMClient.PluginPasswordFinder();
        passwordParams.addAll(finder.findPasswordParams(pluginDesc.params));
        passwordParams.addAll(finder.findPasswordParams(this.desc.getParams()));
        JsonArray jsonPasswordParams = new JsonArray();
        passwordParams.forEach(arg_0 -> ((JsonArray)jsonPasswordParams).add(arg_0));
        expandedPluginSettings.pluginConfig.add("dkuPasswordParams", (JsonElement)jsonPasswordParams);
        return expandedPluginSettings;
    }

    @Override
    public PythonAgentToolServerKernelDesc buildKernelDesc() throws Exception {
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.desc.ownerPluginId);
        String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.projectKey, this.params.containerExecSelection);
        String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.projectKey).getClusterId();
        String libFolder = this.getLibFolder();
        String code = this.getCode();
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.getExpandedPluginSettings();
        return PythonAgentToolServerPool.buildKernelDesc(this.authCtx, this.at, null, code, this.desc.getOwnerPluginId(), libFolder, false, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, envName, containerConfName, clusterId, this.devKernel);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        if (this.serverAPI == null) {
            try {
                this.initToolServer(this.buildKernelDesc());
            }
            catch (CustomPythonKernelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize Python Agent Tool", e);
            }
        }
    }

    public static class CustomAgentToolParams
    implements AgentToolParams,
    ParamsWithContainerizable {
        public JsonObject config = new JsonObject();
        public ContainerExecSelection containerExecSelection = new ContainerExecSelection();

        @Override
        public ContainerExecSelection getContainerSelection() {
            return this.containerExecSelection;
        }

        @Override
        public void setContainerSelection(ContainerExecSelection selection) {
            this.containerExecSelection = selection;
        }
    }
}

