/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.inlinepython;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.inlinepython.InlinePythonToolRunner;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InlinePythonTool {
    public static final AgentToolMeta META = new AgentToolMeta(false){

        @Override
        public String getType() {
            return "InlinePython";
        }

        @Override
        public Class<? extends AgentToolParams> paramsClass() {
            return Params.class;
        }

        @Override
        public List<SavedModel.AgentDependency> getDependencies(AgentTool tool) throws IOException {
            ArrayList dependencies = new ArrayList();
            Params params = tool.getParamsCopyAs(Params.class);
            if (params != null) {
                return params.dependencies;
            }
            return new ArrayList<SavedModel.AgentDependency>();
        }

        @Override
        public AgentToolMeta.ToolDescriptor getResultingDescriptor(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
            TransactionContext.assertNoAttachedTransaction();
            try (InlinePythonToolRunner runner = new InlinePythonToolRunner((DSSAuthCtx)authCtx, tool, false, false);){
                AgentToolMeta.ToolDescriptor toolDescriptor = runner.getResultingDescriptor(tool);
                return toolDescriptor;
            }
        }

        @Override
        public AgentToolMeta.ToolCallDescription getToolCallDescription_NT(AuthCtx authCtx, String projectKey, AgentTool tool, LLMClient.FunctionTool descriptor, AgentToolRunner.AgentToolInput input) throws Exception {
            TransactionContext.assertNoAttachedTransaction();
            try (InlinePythonToolRunner runner = new InlinePythonToolRunner((DSSAuthCtx)authCtx, tool, false, false);){
                AgentToolMeta.ToolCallDescription toolCallDescription = runner.getToolCallDescription(tool, descriptor, input);
                return toolCallDescription;
            }
        }

        @Override
        public AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool, boolean devKernel) throws Exception {
            com.dataiku.dip.utils.Params dkuParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(tool.dkuProperties);
            boolean devMode = dkuParams.getBoolParam("dku.agents.tool.python.devMode", false);
            return new InlinePythonToolRunner((DSSAuthCtx)authCtx, tool, devKernel, devMode);
        }
    };

    public static class Params
    implements AgentToolParams,
    ParamsWithSelectableCodeEnv,
    ParamsWithContainerizable {
        public String code;
        public ContainerExecSelection containerExecSelection = new ContainerExecSelection();
        public CodeEnvSelection codeEnvSelection = CodeEnvSelection.inherit();
        public List<SavedModel.AgentDependency> dependencies = new ArrayList<SavedModel.AgentDependency>();

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.codeEnvSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.codeEnvSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
            Params p = ((AgentTool)object).getParamsCopyAs(Params.class);
            if (p.codeEnvSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, p.codeEnvSelection.envName, CodeEnvModel.EnvUsage.AGENT_TOOL, object.getProjectKey(), object.getId()));
            }
            return usages;
        }

        @Override
        public ContainerExecSelection getContainerSelection() {
            return this.containerExecSelection;
        }

        @Override
        public void setContainerSelection(ContainerExecSelection selection) {
            this.containerExecSelection = selection;
        }
    }
}

