/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.aigenerations.AIGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.aigenerations.recipes.AIRecipeFactory;
import com.dataiku.dip.aigenerations.recipes.AISampling;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.notifications.InternalForwardNotificationsRouter;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIRecipeGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ShakerRecipeService shakerFlowService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AIGenerationService aiGenerationService;
    @Autowired
    private ConnectionsService connectionService;
    @Autowired
    private ManagedDatasetsCreationService managedDatasetsCreationService;
    public static final String VIRTUAL_INPUTS = "virtualInputs";
    public static final String CREATE_OUTPUT_DATASET = "createOutputDataset";
    public static final String CREATE_OUTPUT_STREAMING_ENDPOINT = "createOutputStreamingEndpoint";
    public static final String CONNECTION_ID = "connectionId";
    public static final String PARTITIONING_OPTION_ID = "partitioningOptionId";
    public static final String OUTPUT_DATASET_SETTINGS = "outputDatasetSettings";
    public static final String ZONE_ID = "zone";
    @Autowired
    private InternalForwardNotificationsRouter internalForwardNotificationsRouter;
    private static final DKULogger logger = DKULogger.getLogger(AIRecipeGenerationService.class);

    public FutureResponse<AIRecipeGenerationFrontendResponse> startGeneration(AuthCtx authCtx, String projectKey, List<Dataset> datasets, String query) throws Exception {
        AIRecipeGenerationFutureThread futureThread = new AIRecipeGenerationFutureThread(authCtx, projectKey, datasets, query, this.licenseStatusService.getLicensingStatus());
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIRecipeGenerationFrontendResponse>>(){});
    }

    public RecipeCreationResponse createRecipe(AuthCtx authCtx, RecipeCreationSettings recipeCreationSettings) throws Exception {
        RecipeMeta meta = RecipeRegistry.getMeta(recipeCreationSettings.recipe.type);
        RecipeCreator creator = meta.buildCreator(authCtx);
        assert (creator != null);
        for (String outputDataset : recipeCreationSettings.recipeOutputDatasetNames) {
            this.createOutputDataset_NT(authCtx, recipeCreationSettings.projectKey, recipeCreationSettings.outputDatasetCreationSettings, outputDataset);
        }
        RecipeParams paramsWithSampleSettings = recipeCreationSettings.recipe.params;
        RecipeCreator.CreationResult creationResult = creator.create_NT(recipeCreationSettings.recipe, recipeCreationSettings.recipeCreationData);
        this.updateRecipeWithPayload_NT(authCtx, recipeCreationSettings.projectKey, recipeCreationSettings.recipe, recipeCreationSettings.recipePayload, paramsWithSampleSettings);
        AIRecipe aiMeta = AIRecipeFactory.getMeta(recipeCreationSettings.recipe.type, new JsonObject());
        String error = aiMeta.postValidate(recipeCreationSettings.recipePayload);
        return new RecipeCreationResponse(creationResult.id, error);
    }

    private void createOutputDataset_NT(AuthCtx authCtx, String projectKey, JsonObject datasetCreationSettings, String outputDatasetName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            ManagedDatasetsCreationService.ManagedDatasetCreationSettings creationSettings = (ManagedDatasetsCreationService.ManagedDatasetCreationSettings)new Gson().fromJson((JsonElement)datasetCreationSettings, ManagedDatasetsCreationService.ManagedDatasetCreationSettings.class);
            Dataset outputDataset = this.mdcService.prepare(authCtx, projectKey, outputDatasetName, creationSettings);
            SerializedDataset sds = outputDataset.serialize();
            logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)sds)));
            DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
            dsCtx.setZoneId(creationSettings.zone);
            WithMessages<SerializedDataset> createdDataset = this.datasetSaveService.create(projectKey, sds, dsCtx, authCtx);
            outputDataset = Dataset.fromSerialized((SerializedDataset)createdDataset.value);
            t.commitV("Created dataset from AI recipe generation: %s", new Object[]{outputDataset.getName()});
        }
    }

    private void updateRecipeWithPayload_NT(AuthCtx authCtx, String projectKey, SerializedRecipe sr, String payload, RecipeParams recipeParams) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (sr.type.equals("sampling")) {
                sr.params = recipeParams;
            }
            SerializedRecipe savedRecipe = this.recipeSaveService.save(projectKey, sr, payload);
            if (sr.type.equals("shaker")) {
                savedRecipe = this.shakerFlowService.tryUpdateShakerRecipeDependencies(projectKey, sr.name);
            }
            savedRecipe.name = sr.name;
            t.commit("Saved recipe from AI generation: " + projectKey + "." + sr.name, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
        }
    }

    public RecipeGenerationConfiguration generateRecipeConfiguration(AuthCtx authCtx, String projectKey, JsonObject recipeJson, List<Dataset> datasets, Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap, String lang) throws Exception {
        String recipeType = recipeJson.get("type").getAsString();
        if (StringUtils.isBlank((String)recipeType)) {
            throw new IllegalArgumentException("AI recipe generation was not able to generate a valid recipe json");
        }
        if (recipeType.equals("shaker") && !recipeJson.get("params").getAsJsonObject().get("ok").getAsBoolean()) {
            throw new IllegalArgumentException("AI completion was not able to suggest actions");
        }
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((JsonElement)recipeJson, SerializedRecipe.class);
        String suggestedOutputConnection = null;
        if ("sync".equals(recipeType)) {
            String outputConnection = "default";
            if (recipeJson.getAsJsonObject("params").has("output_connection")) {
                outputConnection = recipeJson.getAsJsonObject("params").get("output_connection").getAsString();
            }
            DSSConnection dssConnection = this.connectionService.get(outputConnection);
            if (!"default".equalsIgnoreCase(outputConnection)) {
                if (dssConnection == null) {
                    AIRecipeGetOutputConnectionQuery outputConnectionQuery = this.createRecipeOutputConnectionQuery(authCtx, projectKey, outputConnection, sr, lang);
                    try (InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(authCtx, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN(), AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);){
                        AIRecipeGetOutputConnectionResponse aiConnectionResponse = (AIRecipeGetOutputConnectionResponse)apiClient.postObject("text2Connection", AIRecipeGetOutputConnectionResponse.class, (Object)outputConnectionQuery);
                        if (aiConnectionResponse.connection_name == null || "null".equals(aiConnectionResponse.connection_name)) {
                            throw new IllegalArgumentException(this.translationService.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SYNC.WRONG_OUTPUT_CONNECTION", "Could not find requested connection: " + outputConnection, "connectionName", outputConnection));
                        }
                        suggestedOutputConnection = aiConnectionResponse.connection_name;
                    }
                } else {
                    suggestedOutputConnection = outputConnection;
                }
            }
        }
        sr.projectKey = projectKey;
        RecipeMeta meta = RecipeRegistry.getMeta(sr.type);
        AIRecipe aiMeta = AIRecipeFactory.getMeta(sr.type, recipeJson);
        this.enrichSerializedRecipe(sr, aiMeta);
        AIMetaCreation creationInfo = aiMeta.generateRecipeMetaPayload(new RecipeGenerationContext(datasets, datasetNameToTWRMap, projectKey, lang));
        this.fixupDatasetNameIfAlreadyExisting_NT(creationInfo, projectKey);
        this.enrichSerializedRecipeWithDatasetsAndRecipeInformation(sr, creationInfo);
        RecipeCreation recipeCreation = new RecipeCreation();
        recipeCreation.payload = creationInfo.payload;
        recipeCreation.creationData = this.getCreationData(authCtx, sr, creationInfo.datasetInputNames, datasets, projectKey, suggestedOutputConnection);
        if ("sync".equals(recipeType) && recipeJson.getAsJsonObject("params").has("schema_mode")) {
            recipeCreation.creationData.addProperty("schemaMode", recipeJson.getAsJsonObject("params").get("schema_mode").getAsString());
        }
        RecipeCreator creator = meta.buildCreator(authCtx);
        assert (creator != null);
        RecipeGenerationConfiguration generationConfiguration = new RecipeGenerationConfiguration();
        generationConfiguration.creationMessages = creationInfo.messages;
        generationConfiguration.creationSettings = new RecipeCreationSettings(sr, recipeCreation, creationInfo, projectKey, recipeCreation.creationData, creationInfo.payload);
        return generationConfiguration;
    }

    private AIRecipeGetOutputConnectionQuery createRecipeOutputConnectionQuery(AuthCtx authCtx, String projectKey, String outputConnection, SerializedRecipe recipe, String lang) throws IOException {
        AIRecipeGetOutputConnectionQuery outputConnectionQuery = new AIRecipeGetOutputConnectionQuery();
        outputConnectionQuery.telemetryEnabled = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings.telemetryEnabled;
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        outputConnectionQuery.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
        recipe.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            outputConnectionQuery.connectionOptions = this.managedDatasetsCreationService.getOptionsForRecipe((SerializedRecipe)recipe, (String)"main", (AuthCtx)authCtx, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (String)lang).connections.stream().map(connection -> {
                AIConnectionOption connectionOption = new AIConnectionOption();
                connectionOption.type = connection.connectionType;
                connectionOption.name = connection.connectionName;
                connectionOption.description = connection.connectionDescription;
                return connectionOption;
            }).toList();
        }
        outputConnectionQuery.connectionName = outputConnection;
        return outputConnectionQuery;
    }

    private void fixupDatasetNameIfAlreadyExisting_NT(AIMetaCreation metaCreation, String projectKey) throws IOException {
        ProjectFlowGraph projectFlowGraph;
        try (Transaction t = this.transactionService.beginRead();){
            projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey, false);
        }
        ImmutableMap.Builder renamedOutputs = ImmutableMap.builder();
        ImmutableList.Builder newOutputNames = ImmutableList.builder();
        metaCreation.datasetOutputNames.forEach(name -> {
            Set datasetsLowerCaseNames = projectFlowGraph.datasets.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
            SerializedDataset sd = new SerializedDataset();
            sd.projectKey = projectKey;
            sd.name = name;
            int i = 0;
            while (datasetsLowerCaseNames.contains(sd.getFullName().toLowerCase())) {
                sd.name = name + "_ai_" + ++i;
            }
            newOutputNames.add((Object)sd.name);
            if (!sd.name.equals(name)) {
                renamedOutputs.put(name, (Object)sd.name);
            }
        });
        metaCreation.datasetOutputNames = newOutputNames.build();
        metaCreation.renamedOutputDatasets = renamedOutputs.build();
    }

    private JsonObject getCreationData(AuthCtx authCtx, SerializedRecipe sr, List<String> inputDatasets, List<Dataset> datasets, String projectKey, @Nullable String suggestedOutputConnection) throws IOException {
        JsonObject creationData = new JsonObject();
        JsonArray virtualInputs = new JsonArray();
        for (String inputDataset : inputDatasets) {
            virtualInputs.add(inputDataset);
        }
        creationData.add(VIRTUAL_INPUTS, (JsonElement)virtualInputs);
        creationData.addProperty(CREATE_OUTPUT_DATASET, Boolean.valueOf(false));
        creationData.addProperty(CREATE_OUTPUT_STREAMING_ENDPOINT, Boolean.valueOf(false));
        JsonObject outputDatasetSettings = new JsonObject();
        ManagedDatasetsCreationService.CreationOptions optionsForRecipes = new ManagedDatasetsCreationService.CreationOptions();
        try (Transaction t = this.transactionService.beginRead();){
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            optionsForRecipes = this.mdcService.getOptionsForRecipe(sr, "main", authCtx, true, false, false, false, lang);
        }
        if (optionsForRecipes.connections.isEmpty()) {
            throw new IllegalArgumentException("No writable connections available.");
        }
        String connectionId = optionsForRecipes.connections.get((int)0).id;
        if (suggestedOutputConnection != null) {
            Optional<ManagedDatasetsCreationService.ConnectionOption> connectionOption = optionsForRecipes.connections.stream().filter(connection -> Objects.equals(connection.connectionName, suggestedOutputConnection)).findFirst();
            if (connectionOption.isPresent()) {
                connectionId = connectionOption.get().id;
            } else {
                throw new IllegalArgumentException("Could not find requested connection: " + suggestedOutputConnection);
            }
        }
        String firstSelectedInputDataset = "";
        if (!datasets.isEmpty()) {
            firstSelectedInputDataset = datasets.get(0).getFullName();
        }
        outputDatasetSettings.addProperty(CONNECTION_ID, connectionId);
        outputDatasetSettings.addProperty(PARTITIONING_OPTION_ID, "copy:dataset:" + firstSelectedInputDataset);
        if (!datasets.isEmpty()) {
            String zoneId;
            Dataset firstSelectedDataset = datasets.get(0);
            try (Transaction t = this.transactionService.beginRead();){
                zoneId = this.flowZonesService.retrieveZone(projectKey, SmartObjectRef.fromSmartName(ITaggingService.TaggableType.DATASET, firstSelectedDataset.getSmartName(projectKey)));
            }
            if (StringUtils.isNotBlank((String)zoneId)) {
                outputDatasetSettings.addProperty(ZONE_ID, zoneId);
            }
        }
        creationData.add(OUTPUT_DATASET_SETTINGS, (JsonElement)outputDatasetSettings);
        return creationData;
    }

    private void enrichSerializedRecipe(SerializedRecipe sr, AIRecipe aiRecipe) {
        if (aiRecipe instanceof AISampling) {
            AISampling aiSampling = (AISampling)aiRecipe;
            aiSampling.enrichSerializedRecipeWithSampleSettings(sr);
        }
    }

    public void enrichSerializedRecipeWithDatasetsAndRecipeInformation(SerializedRecipe sr, AIMetaCreation mc) {
        String roleMain = "main";
        sr.name = "compute_" + mc.datasetOutputNames.get(0);
        for (String input : mc.datasetInputNames) {
            sr.addInput(roleMain, input);
        }
        for (String output : mc.datasetOutputNames) {
            sr.addOutput(roleMain, output, false);
        }
    }

    private class AIRecipeGenerationFutureThread
    extends SimpleFutureThread<AIRecipeGenerationFrontendResponse> {
        private final String projectKey;
        private final List<Dataset> datasets;
        private final String query;
        private final GeneralSettingsDAO.AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings;
        private final AuthCtx authCtx;
        private final LicenseStatusService.LicensingStatus licensingStatus;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;

        public AIRecipeGenerationFutureThread(AuthCtx owner, String projectKey, List<Dataset> datasets, String query, LicenseStatusService.LicensingStatus licensingStatus) {
            super(owner);
            this.projectKey = projectKey;
            this.datasets = datasets;
            this.aiDrivenAnalyticsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings;
            this.query = query;
            this.authCtx = owner;
            this.licensingStatus = licensingStatus;
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_recipe_generation", (String)"AI Recipe Generation");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AIRecipeGenerationFrontendResponse compute() {
            NDC.push((String)("ai-recipegeneration: " + this.query));
            try {
                this.checkUserCanUseAIRecipeGeneration();
                Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap = AIRecipeGenerationService.this.aiGenerationService.getDatasetNameToTWRMap(this.owner, this.projectKey, this.datasets);
                AIRecipeGenerationBackendQueryBase recipeGenerationQuery = this.createRecipeGenerationQuery(datasetNameToTWRMap);
                AIRecipeGenerationFrontendResponse aIRecipeGenerationFrontendResponse = this.requestAIServerBackendAndProcessResponseForRecipeCreation(recipeGenerationQuery, datasetNameToTWRMap);
                return aIRecipeGenerationFrontendResponse;
            }
            catch (IOException e) {
                AIRecipeGenerationFrontendResponse aIRecipeGenerationFrontendResponse = this.handleFailedRequestFromAIServer(e, "Unfortunately, AI was not able to suggest a recipe from your instructions. You may want to update the description and try again");
                return aIRecipeGenerationFrontendResponse;
            }
            catch (CodedRuntimeException e) {
                AIRecipeGenerationFrontendResponse aIRecipeGenerationFrontendResponse = this.handleFailedRequestFromAIServer((Exception)((Object)e), e.getMessage());
                return aIRecipeGenerationFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }

        private void checkUserCanUseAIRecipeGeneration() {
            LicenseStatusService.LicensingStatus ls = AIRecipeGenerationService.this.licenseStatusService.getLicensingStatus();
            if (ls == null || ls.community) {
                throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
            }
            if (!this.aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.FLOW_ASSISTANT)) {
                throw new IllegalStateException("AI-generated explanations are not enabled");
            }
        }

        private AIRecipeGenerationBackendQueryBase createRecipeGenerationQuery(Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap) {
            AIRecipeGenerationBackendQueryBase ret = new AIRecipeGenerationBackendQueryBase();
            ret.telemetryEnabled = this.aiDrivenAnalyticsSettings.telemetryEnabled;
            ret.query = this.query;
            LicenseStatusService.LicensingStatus ls = AIRecipeGenerationService.this.licenseStatusService.getLicensingStatus();
            ret.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
            ret.datasetsInformation = AIRecipeGenerationService.this.aiGenerationService.getDatasetsInformation(this.projectKey, this.datasets, this.query, datasetNameToTWRMap);
            ret.datasetsInformation.stream().filter(dataset -> !dataset.ok).findFirst().ifPresent(dataset -> {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, String.format("The dataset %s has no schema, make sure to build the dataset", dataset.name));
            });
            ret.supportedRecipes = AIRecipeFactory.getRecipesTypes();
            return ret;
        }

        private AIRecipeGetOutputConnectionQuery createRecipeOutputConnectionQuery(AuthCtx authCtx, String outputConnection, SerializedRecipe recipe, String lang) throws IOException {
            AIRecipeGetOutputConnectionQuery outputConnectionQuery = new AIRecipeGetOutputConnectionQuery();
            outputConnectionQuery.telemetryEnabled = this.aiDrivenAnalyticsSettings.telemetryEnabled;
            LicenseStatusService.LicensingStatus ls = AIRecipeGenerationService.this.licenseStatusService.getLicensingStatus();
            outputConnectionQuery.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
            recipe.projectKey = this.projectKey;
            try (Transaction t = AIRecipeGenerationService.this.transactionService.beginRead();){
                outputConnectionQuery.connectionOptions = AIRecipeGenerationService.this.managedDatasetsCreationService.getOptionsForRecipe((SerializedRecipe)recipe, (String)"main", (AuthCtx)authCtx, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (String)lang).connections.stream().map(connection -> {
                    AIConnectionOption connectionOption = new AIConnectionOption();
                    connectionOption.type = connection.connectionType;
                    connectionOption.name = connection.connectionName;
                    connectionOption.description = connection.connectionDescription;
                    return connectionOption;
                }).toList();
            }
            outputConnectionQuery.connectionName = outputConnection;
            return outputConnectionQuery;
        }

        private AIRecipeGenerationFrontendResponse requestAIServerBackendAndProcessResponseForRecipeCreation(AIRecipeGenerationBackendQueryBase recipeGenerationQuery, Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap) throws IOException {
            AIRecipeGenerationFrontendResponse ret;
            String lang;
            TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
            try (Transaction t = AIRecipeGenerationService.this.transactionService.beginRead();){
                lang = AIRecipeGenerationService.this.userSettingsService.getLangForUser(this.authCtx.getIdentifier());
            }
            String defaultFailedRecipeSuggestionErrorMessage = AIRecipeGenerationService.this.translationService.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.DEFAULT_ERROR", "Unfortunately, AI was not able to suggest a recipe from your instructions. You may want to update the description and try again.", new Object[0]);
            String requestId = null;
            Object validationText = "";
            try (InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.authCtx, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);){
                AIRecipeGenerationBackendResponse resp = (AIRecipeGenerationBackendResponse)apiClient.postObject("/text2recipe", AIRecipeGenerationBackendResponse.class, (Object)recipeGenerationQuery);
                logger.info((Object)("AI Response: " + JSON.log((Object)resp)));
                AIRecipeGenerationFrontendResponse finalResp = new AIRecipeGenerationFrontendResponse();
                requestId = resp.request_id;
                if (!resp.ok) {
                    logger.warn((Object)"AI recipe generation was not able to suggest valid actions");
                    Object errorMessage = defaultFailedRecipeSuggestionErrorMessage;
                    if (resp.error != null) {
                        errorMessage = (String)errorMessage + ": " + resp.error;
                    }
                    if (resp.nrecipes > 1) {
                        errorMessage = AIRecipeGenerationService.this.translationService.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.MULTIPLE_RECIPE_ERROR", "After analyzing your request, we suggest creating multiple recipes, which is not currently supported. Please revise your query.", new Object[0]);
                    }
                    finalResp.reasoning = resp.reasoning;
                    finalResp.reformulation = resp.reformulation;
                    finalResp.ok = false;
                    finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, (String)errorMessage));
                    ret = finalResp;
                } else {
                    ret = this.processResponseAndGenerateRecipeConfiguration(resp, finalResp, datasetNameToTWRMap, lang);
                }
            }
            catch (DKUSecurityException e) {
                logger.error((Object)"Unauthorized exception while getting AI explanation", (Throwable)e);
                AIRecipeGenerationFrontendResponse finalResp = new AIRecipeGenerationFrontendResponse();
                finalResp.ok = false;
                finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e)));
                ret = finalResp;
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Configuration error while connecting to AI server", (Throwable)e);
                AIRecipeGenerationFrontendResponse finalResp = new AIRecipeGenerationFrontendResponse();
                finalResp.ok = false;
                finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, e.getMessage()));
                ret = finalResp;
            }
            catch (Exception e) {
                logger.warn((Object)"AI recipe generation failed during recipe creation", (Throwable)e);
                validationText = "AI recipe generation failed during recipe creation:" + e.getMessage() + ". ";
                AIRecipeGenerationFrontendResponse finalResp = new AIRecipeGenerationFrontendResponse();
                finalResp.ok = false;
                finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, defaultFailedRecipeSuggestionErrorMessage));
                ret = finalResp;
            }
            ret.requestId = requestId;
            validationText = (String)validationText + ret.messages.stream().map(m -> m.content).collect(Collectors.joining(", "));
            AIFeaturesUtil.logValidation(ret.requestId, (String)validationText, this.licensingStatus, this.aiDrivenAnalyticsSettings.telemetryEnabled, "text2recipe", ret.ok, this.generalSettings);
            return ret;
        }

        private AIRecipeGenerationFrontendResponse processResponseAndGenerateRecipeConfiguration(AIRecipeGenerationBackendResponse resp, AIRecipeGenerationFrontendResponse finalResp, Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap, String lang) throws Exception {
            RecipeGenerationConfiguration generationConfiguration;
            try {
                generationConfiguration = AIRecipeGenerationService.this.generateRecipeConfiguration(this.authCtx, this.projectKey, resp.recipe, this.datasets, datasetNameToTWRMap, lang);
            }
            catch (IllegalArgumentException e) {
                Object errorMessage = e.getMessage();
                logger.warn(errorMessage);
                if (resp.error != null) {
                    errorMessage = (String)errorMessage + ": " + resp.error;
                }
                finalResp.ok = false;
                finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, (String)errorMessage));
                return finalResp;
            }
            catch (CodedRuntimeException e) {
                logger.warn((Object)"AI recipe generation was not able to generate a valid recipe because: ", (Throwable)e);
                finalResp.ok = false;
                finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, e.getMessage()));
                return finalResp;
            }
            finalResp.ok = true;
            finalResp.messages = generationConfiguration.creationMessages;
            finalResp.reasoning = resp.reasoning;
            finalResp.reformulation = resp.reformulation;
            finalResp.recipeCreationSettings = generationConfiguration.creationSettings;
            return finalResp;
        }

        private AIRecipeGenerationFrontendResponse handleFailedRequestFromAIServer(Exception e, String message) {
            logger.error((Object)"IO exception while getting AI recipe generation", (Throwable)e);
            Object validationText = e.getMessage();
            AIRecipeGenerationFrontendResponse finalResp = new AIRecipeGenerationFrontendResponse();
            finalResp.ok = false;
            finalResp.messages = List.of(new CreationMessage(CreationMessage.Level.ERROR, message));
            validationText = (String)validationText + finalResp.messages.stream().map(m -> m.content).collect(Collectors.joining(", "));
            AIFeaturesUtil.logValidation(finalResp.requestId, (String)validationText, this.licensingStatus, this.aiDrivenAnalyticsSettings.telemetryEnabled, "text2recipe", false, this.generalSettings);
            return finalResp;
        }
    }

    @UIModel
    public static class RecipeCreationSettings {
        public SerializedRecipe recipe;
        public JsonObject recipeCreationData;
        public String recipePayload;
        public JsonObject outputDatasetCreationSettings;
        public List<String> recipeOutputDatasetNames;
        public Map<String, String> renamedOutputDatasets = Map.of();
        public String projectKey;

        public RecipeCreationSettings(SerializedRecipe sr, RecipeCreation recipeCreation, AIMetaCreation aiMetaCreation, String projectKey, JsonObject recipeCreationData, String recipePayload) {
            this.recipe = sr;
            this.recipeCreationData = recipeCreationData;
            this.recipePayload = recipePayload;
            this.outputDatasetCreationSettings = recipeCreation.creationData.getAsJsonObject(AIRecipeGenerationService.OUTPUT_DATASET_SETTINGS);
            this.projectKey = projectKey;
            this.recipeOutputDatasetNames = aiMetaCreation.datasetOutputNames;
            this.renamedOutputDatasets = aiMetaCreation.renamedOutputDatasets;
        }

        public RecipeCreationSettings(SerializedRecipe sr, JsonObject outputDatasetCreationSettings, List<String> recipeOutputDatasetNames, String projectKey, JsonObject recipeCreationData, String recipePayload) {
            this.recipe = sr;
            this.recipeCreationData = recipeCreationData;
            this.recipePayload = recipePayload;
            this.outputDatasetCreationSettings = outputDatasetCreationSettings;
            this.projectKey = projectKey;
            this.recipeOutputDatasetNames = recipeOutputDatasetNames;
        }
    }

    @UIModel
    public static class RecipeCreationResponse {
        public String id;
        @Nullable
        public String error;

        public RecipeCreationResponse(String recipeId, @Nullable String error) {
            this.id = recipeId;
            this.error = error;
        }

        public RecipeCreationResponse(String recipeId) {
            this(recipeId, null);
        }
    }

    public static class AIRecipeGetOutputConnectionQuery {
        String licenseId;
        String connectionName;
        List<AIConnectionOption> connectionOptions;
        boolean telemetryEnabled;
    }

    public static class AIRecipeGetOutputConnectionResponse {
        boolean ok;
        String error;
        String connection_name;
    }

    public static class RecipeGenerationContext {
        public List<Dataset> datasets;
        public Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap;
        public String contextProjectKey;
        public String lang;

        public RecipeGenerationContext(List<Dataset> datasets, Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap, String contextProjectKey, String lang) {
            this.datasets = datasets;
            this.datasetNameToTWRMap = datasetNameToTWRMap;
            this.contextProjectKey = contextProjectKey;
            this.lang = lang;
        }
    }

    public static class AIMetaCreation {
        public String payload;
        public List<String> datasetInputNames;
        public List<String> datasetOutputNames;
        public Map<String, String> renamedOutputDatasets = Map.of();
        public List<CreationMessage> messages;
    }

    public static class RecipeCreation {
        public JsonObject creationData;
        public String payload;
    }

    public static class RecipeGenerationConfiguration {
        public List<CreationMessage> creationMessages;
        public RecipeCreationSettings creationSettings;
    }

    public static class AIConnectionOption {
        String name;
        String description;
        String type;
    }

    public static class CreationMessage {
        public Level level;
        public String content;

        public CreationMessage(Level level, String content) {
            this.level = level;
            this.content = content;
        }

        public static enum Level {
            ERROR,
            WARNING;

        }
    }

    @UIModel
    public static class AIRecipeGenerationFrontendResponse {
        boolean ok;
        RecipeCreationSettings recipeCreationSettings;
        List<CreationMessage> messages;
        String requestId;
        String reformulation;
        String reasoning;
    }

    public static class AIRecipeGenerationBackendResponse {
        boolean ok;
        String error;
        Integer nrecipes;
        JsonObject recipe;
        String reformulation;
        String reasoning;
        String request_id;
    }

    public static class AIRecipeGenerationBackendQueryBase {
        String licenseId;
        String query;
        List<AIGenerationService.AIDatasetInformation> datasetsInformation;
        boolean telemetryEnabled;
        List<String> supportedRecipes;
    }
}

