/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.stereotype.Service;

@Service
public class AiAssistantTransactionService {
    private static final DKULogger logger = DKULogger.getLogger(AiAssistantTransactionService.class);
    private static final String AI_ASSISTANTS_FILES_ROOT = "ai-assistants";
    public static final String AI_ASSISTANTS_FILES_PROJECTS_ROOT = "projects";
    private TransactionProvider provider;

    public static File getAiAssistantsFilesRoot(String projectKey) {
        return DKUApp.getFile((String[])new String[]{AI_ASSISTANTS_FILES_ROOT, projectKey});
    }

    @PostConstruct
    public void init() throws IOException {
        logger.info((Object)"Initializing AI Assistants transaction service");
        File aiAssistantsRoot = DKUApp.getFile((String)AI_ASSISTANTS_FILES_ROOT);
        DKUFileUtils.mkdirs((File)aiAssistantsRoot);
        this.provider = new TransactionProvider(aiAssistantsRoot, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(true, false, false, true));
        logger.info((Object)"AI Assistants transaction service initialized");
    }

    @PreDestroy
    public void destroy() {
        if (this.provider != null) {
            try {
                this.provider.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close AI Assistants transaction provider", (Throwable)e);
            }
        }
    }

    public Transaction beginRead() {
        return this.provider.beginRead();
    }

    public RWTransaction beginWrite(AuthCtx authCtx) {
        return this.provider.beginWrite(authCtx);
    }
}

