/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.capabilities;

import com.dataiku.dip.aigenerations.AIFlowGenerationService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AICapability {
    public static final String capabilityId = "";
    public static final List<String> capabilitySubtypes = new ArrayList<String>();
    protected static final String GENERATE_ERROR_MSG = "Flow Assistant was not able to generate a valid scenario step";

    public abstract CapabilityCreationSettings getCreationSettings(AuthCtx var1, AIFlowGenerationService.CapabilityState var2, String var3, String var4, List<Dataset> var5) throws Exception;

    public abstract CapabilityCreationResponse create(AuthCtx var1, CapabilityCreationSettings var2) throws Exception;

    public Optional<String> run(AuthCtx authCtx, String projectKey, String runnableName) throws Exception {
        return Optional.empty();
    }

    @UIModel
    public static class CapabilityCreationResponse {
        public String id;
        public String capabilityTypeId;
        @Nullable
        public String error;

        public CapabilityCreationResponse(String id, String capabilityTypeId) {
            this(id, capabilityTypeId, null);
        }

        public CapabilityCreationResponse(String id, String capabilityTypeId, @Nullable String error) {
            this.id = id;
            this.capabilityTypeId = capabilityTypeId;
            this.error = error;
        }
    }

    public static class AICapabilityServerException
    extends RuntimeException {
        String type;
        String message;

        public AICapabilityServerException(String type, String message) {
            super(message);
            this.type = type;
            this.message = message;
        }

        public String getType() {
            return this.type;
        }
    }

    @UIModel
    public static class CapabilityCreationSettings {
        public JsonObject creationObject;
        public JsonObject creationData;
        public String payload;
        public JsonObject outputDatasetCreationSettings;
        public List<String> outputDatasetNames;
        public Map<String, String> renamedOutputDatasets = Map.of();
        public String projectKey;
        public String capabilityId;
        @Nullable
        public String capabilitySubtype;
        public String requestId = "";
    }
}

