/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.capabilities;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.aigenerations.AIFlowGenerationService;
import com.dataiku.dip.aigenerations.AIGenerationService;
import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.capabilities.AICapability;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RecipeCapability
extends AICapability {
    public static final String capabilityId = "RECIPE";
    public static final List<String> capabilitySubtypes = List.of("join", "vstack", "sampling", "grouping", "distinct", "split", "window", "topn", "pivot", "sort", "prepare");
    private static final DKULogger logger = DKULogger.getLogger(RecipeCapability.class);

    @Override
    public AICapability.CapabilityCreationSettings getCreationSettings(AuthCtx authCtx, AIFlowGenerationService.CapabilityState state, String projectKey, String lang, List<Dataset> datasets) throws Exception {
        AIRecipeGenerationService.RecipeGenerationConfiguration generationConfiguration;
        AIRecipeGenerationService aiRecipeGenerationService = (AIRecipeGenerationService)SpringUtils.getBean(AIRecipeGenerationService.class);
        AIGenerationService aiGenerationService = (AIGenerationService)SpringUtils.getBean(AIGenerationService.class);
        Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap = aiGenerationService.getDatasetNameToTWRMap(authCtx, projectKey, datasets);
        try {
            generationConfiguration = aiRecipeGenerationService.generateRecipeConfiguration(authCtx, projectKey, state.generationResult.config, datasets, datasetNameToTWRMap, lang);
        }
        catch (IllegalArgumentException e) {
            throw new AICapability.AICapabilityServerException("Recipe configuration argument error", "AI execution was not able to complete the step: " + e.getMessage());
        }
        catch (CodedRuntimeException e) {
            throw new AICapability.AICapabilityServerException("Recipe configuration runtime error", "AI recipe generation was not able to generate a valid recipe: " + e.getMessage());
        }
        AICapability.CapabilityCreationSettings creationSettings = new AICapability.CapabilityCreationSettings();
        creationSettings.creationObject = JSON.toJsonObject((Object)generationConfiguration.creationSettings.recipe, (String[])new String[0]);
        creationSettings.creationData = generationConfiguration.creationSettings.recipeCreationData;
        creationSettings.payload = generationConfiguration.creationSettings.recipePayload;
        creationSettings.outputDatasetNames = generationConfiguration.creationSettings.recipeOutputDatasetNames;
        creationSettings.renamedOutputDatasets = generationConfiguration.creationSettings.renamedOutputDatasets;
        creationSettings.outputDatasetCreationSettings = generationConfiguration.creationSettings.outputDatasetCreationSettings;
        creationSettings.projectKey = generationConfiguration.creationSettings.projectKey;
        creationSettings.capabilityId = state.capabilityId;
        creationSettings.capabilitySubtype = state.capabilitySubtype;
        return creationSettings;
    }

    @Override
    public AICapability.CapabilityCreationResponse create(AuthCtx authCtx, AICapability.CapabilityCreationSettings creationSettings) throws Exception {
        AIRecipeGenerationService aiRecipeGenerationService = (AIRecipeGenerationService)SpringUtils.getBean(AIRecipeGenerationService.class);
        AIRecipeGenerationService.RecipeCreationSettings recipeCreationSettings = new AIRecipeGenerationService.RecipeCreationSettings((SerializedRecipe)JSON.parse((JsonElement)creationSettings.creationObject, SerializedRecipe.class), creationSettings.outputDatasetCreationSettings, creationSettings.outputDatasetNames, creationSettings.projectKey, creationSettings.creationData, creationSettings.payload);
        AIRecipeGenerationService.RecipeCreationResponse recipeResponse = aiRecipeGenerationService.createRecipe(authCtx, recipeCreationSettings);
        return new AICapability.CapabilityCreationResponse(recipeResponse.id, capabilityId, recipeResponse.error);
    }

    @Override
    public Optional<String> run(AuthCtx authCtx, String projectKey, String recipeName) throws Exception {
        GenericRecipesValidationService genericService = (GenericRecipesValidationService)SpringUtils.getBean(GenericRecipesValidationService.class);
        return Optional.of(genericService.runRecipeFromUI_NT((AuthCtx)authCtx, (String)projectKey, (String)recipeName, (GenericRecipesValidationService.RunRecipeFromUIMode)GenericRecipesValidationService.RunRecipeFromUIMode.RUN_RECIPE_ONLY, (JsonObject)new JsonObject(), (boolean)true).jobId);
    }
}

