/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.capabilities;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.aigenerations.AIFlowGenerationService;
import com.dataiku.dip.aigenerations.capabilities.AICapability;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ScenarioScheduleService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ScenarioCapability
extends AICapability {
    public static final String capabilityId = "SCENARIO";
    public static final List<String> capabilitySubtypes = List.of("schedule");

    @Override
    public AICapability.CapabilityCreationSettings getCreationSettings(AuthCtx authCtx, AIFlowGenerationService.CapabilityState state, String projectKey, String lang, List<Dataset> datasets) throws Exception {
        String type = state.capabilitySubtype;
        if (!"schedule".equalsIgnoreCase(type)) {
            throw new AICapability.AICapabilityServerException("Invalid Scenario step", "Flow Assistant was not able to generate a valid scenario step");
        }
        AICapability.CapabilityCreationSettings creationSettings = new AICapability.CapabilityCreationSettings();
        creationSettings.projectKey = projectKey;
        creationSettings.creationData = state.generationResult.config;
        creationSettings.capabilityId = capabilityId;
        creationSettings.capabilitySubtype = type;
        return creationSettings;
    }

    @Override
    public AICapability.CapabilityCreationResponse create(AuthCtx authCtx, AICapability.CapabilityCreationSettings creationSettings) throws Exception {
        Scenario createdScenario;
        String type = creationSettings.capabilitySubtype;
        if (!"schedule".equalsIgnoreCase(type)) {
            throw new AICapability.AICapabilityServerException("Invalid Scenario step", "Flow Assistant was not able to generate a valid scenario step");
        }
        ScenarioScheduleService scenarioScheduleService = (ScenarioScheduleService)SpringUtils.getBean(ScenarioScheduleService.class);
        JsonArray selectedObjects = new JsonArray();
        for (JsonElement item : creationSettings.creationData.getAsJsonArray("selectedObjects")) {
            String id = item.getAsString();
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("id", id);
            jsonObj.addProperty("type", ITaggingService.TaggableType.DATASET.name());
            jsonObj.addProperty("projectKey", creationSettings.projectKey);
            selectedObjects.add((JsonElement)jsonObj);
        }
        creationSettings.creationData.add("selectedObjects", (JsonElement)selectedObjects);
        String recipient = creationSettings.creationData.get("mailRecipient").getAsString();
        if ("CURRENT_USER".equalsIgnoreCase(recipient)) {
            recipient = authCtx.getUserEmail();
        }
        if (!recipient.isBlank()) {
            JsonObject mailSettings = new JsonObject();
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (StringUtils.isBlank((String)gs.notifications.emailChannelId)) {
                mailSettings.addProperty("channelId", "");
            } else {
                mailSettings.addProperty("channelId", gs.notifications.emailChannelId);
            }
            mailSettings.addProperty("recipient", recipient);
            mailSettings.addProperty("send", Boolean.valueOf(true));
            creationSettings.creationData.add("mail", (JsonElement)mailSettings);
        }
        JsonObject stepJob = new JsonObject();
        stepJob.addProperty("type", creationSettings.creationData.get("buildMode").getAsString());
        stepJob.addProperty("projectKey", creationSettings.projectKey);
        stepJob.addProperty("refreshHiveMetastore", Boolean.valueOf(true));
        stepJob.add("outputs", (JsonElement)new JsonArray());
        creationSettings.creationData.add("stepJob", (JsonElement)stepJob);
        ScenarioScheduleService.ScheduleScenarioOptions scheduleOptions = (ScenarioScheduleService.ScheduleScenarioOptions)JSON.parse((JsonElement)creationSettings.creationData, ScenarioScheduleService.ScheduleScenarioOptions.class);
        Scenario scenario = scenarioScheduleService.createScheduledScenario(creationSettings.projectKey, scheduleOptions);
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        ScenariosService scenariosService = (ScenariosService)SpringUtils.getBean(ScenariosService.class);
        try (RWTransaction t = transactionService.beginWriteAsLoggedInUser(authCtx);){
            createdScenario = scenariosService.create(creationSettings.projectKey, scenario);
            t.commit("Scheduled scenario " + creationSettings.projectKey + "." + createdScenario.id);
        }
        return new AICapability.CapabilityCreationResponse(createdScenario.id, capabilityId);
    }
}

