/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.transform.StringTransformation;
import com.dataiku.dip.shaker.server.AICompletionService;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;

public class AIShaker
extends AIRecipe {
    public static final String type = "shaker";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        if (this.params.steps.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, "Failed to fully understand what data processing steps we should apply on the dataset");
        }
        return Collections.emptyList();
    }

    @Override
    public String postValidate(String jsonCreationPayload) {
        String error;
        block5: {
            error = null;
            try {
                JsonObject jsonObject = JsonParser.parseString((String)jsonCreationPayload).getAsJsonObject();
                JsonElement steps = jsonObject.get("steps");
                if (steps == null || !steps.isJsonArray()) break block5;
                for (JsonElement step : steps.getAsJsonArray()) {
                    JsonObject stepObj;
                    JsonElement typeEl;
                    if (!step.isJsonObject() || (typeEl = (stepObj = step.getAsJsonObject()).get("type")) == null || !typeEl.isJsonPrimitive() || !"StringTransformer".equals(typeEl.getAsString())) continue;
                    JsonElement paramsEl = stepObj.get("params");
                    if (paramsEl == null || !paramsEl.isJsonObject()) {
                        return "StringTransformer must have a 'params' object";
                    }
                    JsonObject paramsObj = paramsEl.getAsJsonObject();
                    JsonElement modeEl = paramsObj.get("mode");
                    if (modeEl == null || !modeEl.isJsonPrimitive()) {
                        return "Transform string step must have a valid 'mode' string";
                    }
                    String mode = modeEl.getAsString();
                    if (EnumUtils.isValidEnum(StringTransformation.class, (String)mode)) continue;
                    error = "Invalid StringTransformer mode: " + mode;
                    break;
                }
            }
            catch (Exception e) {
                error = "Recipe json error: " + e.getMessage();
            }
        }
        return error;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) throws Exception {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        SerializedShakerScript serializedShakerScript = new SerializedShakerScript();
        List<ProcessorScriptStep> steps = AICompletionService.getProcessorScriptSteps(recipeGenerationContext.datasetNameToTWRMap.getOrDefault(this.params.input_dataset, null), this.params.steps);
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("AI failed to generate valid steps. List of steps is empty.");
        }
        serializedShakerScript.steps = steps.stream().map(ScriptStep.class::cast).collect(Collectors.toList());
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)serializedShakerScript);
        return metaCreation;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public List<JsonObject> steps;
    }
}

