/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalysisDataService {
    @Autowired
    private DataService shakerDataService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;

    public MemScriptRunner.TableWithReport getCachedUnfiltered_NOTRANSACTION(AnalysisCoreParams coreParams, AuthCtx user, FilteringExecutor executor) throws Exception {
        MemScriptRunner.TableWithReport twr = this.getCachedUnfiltered_NOTRANSACTION(coreParams, user);
        if (executor != null) {
            executor.execute(twr.table);
            twr.filters = executor.getFilterResult();
            twr.facets = executor.getFaceting();
        }
        return twr;
    }

    public MemScriptRunner.TableWithReport getCachedUnfiltered_NOTRANSACTION(AnalysisCoreParams coreParams, AuthCtx user) throws Exception {
        Preconditions.checkNotNull((Object)coreParams);
        Preconditions.checkNotNull((Object)coreParams.script);
        Preconditions.checkNotNull((Object)coreParams.inputDatasetSmartName);
        Preconditions.checkNotNull((Object)this.shakerDataService);
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(coreParams.projectKey, coreParams.inputDatasetSmartName));
        }
        coreParams.script.contextProjectKey = coreParams.projectKey;
        coreParams.script.origin = SerializedShakerScript.ShakerOrigin.ANALYSIS;
        return this.shakerDataService.get_NOTRANSACTION(dataset, coreParams.script.deepCopy(), null, new FilterRequest(), true, user);
    }

    public Schema getInferredSchemaForML_NT(AnalysisCoreParams coreParams, AuthCtx user) throws Exception {
        Dataset dataset;
        Preconditions.checkNotNull((Object)coreParams);
        Preconditions.checkNotNull((Object)coreParams.script);
        Preconditions.checkNotNull((Object)coreParams.inputDatasetSmartName);
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(coreParams.projectKey, coreParams.inputDatasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(loc);
        }
        coreParams.script.contextProjectKey = coreParams.projectKey;
        coreParams.script.origin = SerializedShakerScript.ShakerOrigin.ANALYSIS;
        MemScriptRunner.TableWithReport twr = this.shakerDataService.get_NOTRANSACTION(dataset, coreParams.script.deepCopy(), null, new FilterRequest(), true, user);
        return TableToSchema.inferSchemaForML(twr.table, true, null);
    }

    public Schema getInferredSchemaForML_NT(AnalysisCoreParams coreParams, String datasetSmartName, AuthCtx user) throws Exception {
        Dataset dataset;
        Preconditions.checkNotNull((Object)coreParams);
        Preconditions.checkNotNull((Object)coreParams.script);
        Preconditions.checkNotNull((Object)coreParams.inputDatasetSmartName);
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(coreParams.projectKey, datasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(loc);
        }
        coreParams.script.contextProjectKey = coreParams.projectKey;
        coreParams.script.origin = SerializedShakerScript.ShakerOrigin.ANALYSIS;
        MemScriptRunner.TableWithReport twr = this.shakerDataService.get_NOTRANSACTION(dataset, coreParams.script.deepCopy(), null, new FilterRequest(), true, user);
        return TableToSchema.inferSchemaForML(twr.table, true, null);
    }

    public Schema getInferredSchemaForML_NT(SerializedShakerScript script, String contextProjectKey, Dataset dataset, String forOutputDatasetType, AuthCtx user) throws Exception {
        return this.getInferredSchemaForML_NT(script, contextProjectKey, dataset, forOutputDatasetType, user, false);
    }

    public Schema getInferredSchemaForML_NT(SerializedShakerScript script, String contextProjectKey, Dataset dataset, String forOutputDatasetType, AuthCtx user, boolean inMemory) throws Exception {
        script.contextProjectKey = contextProjectKey;
        script.origin = SerializedShakerScript.ShakerOrigin.ANALYSIS;
        MemScriptRunner.TableWithReport twr = this.shakerDataService.get_NOTRANSACTION(dataset, script.deepCopy(), null, new FilterRequest(), true, user, false, inMemory);
        return TableToSchema.inferSchemaForML(twr.table, true, forOutputDatasetType);
    }
}

