/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.ISplitsStatusService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.TrainingSessionDetailsService;
import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.analysis.ml.MLTaskHandler;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.ClusteringParamsExpander;
import com.dataiku.dip.analysis.ml.clustering.ClusteringRescoringHandler;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.MLLibClusteringMLTaskHandler;
import com.dataiku.dip.analysis.ml.clustering.PythonClusteringMLTaskHandler;
import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuessPolicy;
import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuesser;
import com.dataiku.dip.analysis.ml.shared.AnalysisRetrainWorkSetPreparator;
import com.dataiku.dip.analysis.ml.shared.AnalysisWorkSetPreparator;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTaskStatus;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelSnippetData;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PreTrainStatus;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusteringService {
    @Autowired
    private ISplitsStatusService splitsService;
    @Autowired
    private AnalysisDataService dataService;
    @Autowired
    private AnalysisCRUDService crudService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FutureService futureService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TrainingSessionDetailsService trainingSessionDetailsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.clustering");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeGuessPolicy(AuthCtx user, AnalysisCoreParams acp, MLTaskLoc loc, ClusteringMLTask task, ClusteringGuessPolicy guessPolicy) throws Exception {
        logger.info((Object)"Start changing clustering task guess policy");
        ClusteringMLTask taskBefore = (ClusteringMLTask)JSON.deepCopy((Object)task);
        task.guessPolicy = guessPolicy;
        this.mlBaseService.addGuessing(loc);
        try {
            ClusteringGuesser guesser = this.getGuesser(acp, task, user);
            guesser.reguessAlgorithms();
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        logger.trace(() -> "Before changing policy\n " + JSON.prettyLog((Object)taskBefore));
        logger.trace(() -> "After changing policy\n " + JSON.prettyLog((Object)task));
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Changed clustering task guess policy for " + acp.projectKey + "." + acp.id + " (" + acp.name + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteringMLTask reguess_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, ClusteringMLTask task) throws Exception {
        logger.info((Object)"Start reguess");
        ClusteringMLTask taskBefore = (ClusteringMLTask)JSON.deepCopy((Object)task);
        this.mlBaseService.addGuessing(loc);
        try {
            this.getGuesser(cp, task, user).guessAllSettings(false);
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        logger.trace(() -> "Before reguess\n " + JSON.prettyLog((Object)taskBefore));
        logger.trace(() -> "After reguess\n " + JSON.prettyLog((Object)task));
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Reguessed clustering task settings for " + cp.projectKey + "." + cp.id + " (" + cp.name + ")");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String duplicate(AnalysisCoreParams acp, AuthCtx user, MLTaskLoc loc, ClusteringMLTask task) throws Exception {
        this.mlBaseService.addGuessing(loc);
        try {
            MLTaskLoc newLoc;
            this.getGuesser(acp, task, user).fixupAfterDuplication();
            task.id = SecretKeyGenerator.generate((int)8);
            task.name = this.newTaskName(acp, task.name);
            task.initiator = user.getIdentifier();
            try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
                newLoc = new MLTaskLoc(acp.projectKey, acp.id, task.id);
                this.crudService.prepareMLTaskCreation(newLoc, task, user);
                this.crudService.saveMLTask(newLoc, task, true);
                rw.commit("Duplicate task " + loc.analysisId + "." + loc.mlTaskId + " into " + acp.id + "." + task.id);
            }
            newLoc.writeGuessStatus(loc.getGuessStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        return task.id;
    }

    private String newTaskName(AnalysisCoreParams acp, String wantedName) throws Exception {
        List<AnalysisCRUDService.MLTaskHead> mlTasks;
        try (Transaction t = this.transactionService.beginRead();){
            mlTasks = this.crudService.listMLTasks(acp.projectKey, acp.id, false);
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier(" ", 1);
        for (AnalysisCRUDService.MLTaskHead head : mlTasks) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        return transmogrifier.transmogrify(wantedName);
    }

    public String createAndGuess_NT(AuthCtx user, AnalysisCoreParams cp, MLTask.BackendType mlBackendType, MLSparkParams sparkParams, ClusteringGuessPolicy guessPolicy) throws Exception {
        ClusteringMLTask task = new ClusteringMLTask();
        task.id = SecretKeyGenerator.generate((int)8);
        task.name = this.newTaskName(cp, "Cluster data");
        task.initiator = user.getAssociatedDSSUserOrIdentifier();
        task.backendType = mlBackendType;
        task.guessPolicy = guessPolicy;
        if (mlBackendType.isSparkBased()) {
            task.backendType = mlBackendType;
            task.sparkParams = sparkParams;
        }
        MLTaskLoc loc = new MLTaskLoc(cp.projectKey, cp.id, task.id);
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.prepareMLTaskCreation(loc, task, user);
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Create clustering task in " + cp.projectKey + "." + cp.id + "(" + cp.name + ")");
        }
        MLPaths.createIfNeededMLTaskFolderAndRestrictPermissions(loc);
        FilesystemACLUtils.grantFSReadACLs(user, cp.projectKey, loc.getDataFolder());
        InitialGuessWorkThread thread = new InitialGuessWorkThread((DSSAuthCtx)user, loc, cp, task);
        this.mlBaseService.addGuessing(loc);
        thread.init();
        this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
        return task.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, ClusteringMLTask task) throws Exception {
        logger.info((Object)"Start update guess");
        ClusteringMLTask taskBefore = (ClusteringMLTask)JSON.deepCopy((Object)task);
        this.mlBaseService.addGuessing(loc);
        try {
            this.getGuesser(cp, task, user).updateGuess(loc.getGuessStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        logger.trace(() -> "Before updateGuess\n " + JSON.prettyLog((Object)taskBefore));
        logger.trace(() -> "After updateGuess\n " + JSON.prettyLog((Object)task));
        if (JSON.json((Object)taskBefore).equals(JSON.json((Object)task))) {
            return false;
        }
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Updated clustering task (preparation script changed): " + cp.projectKey + "." + cp.id + "(" + cp.name + ")");
        }
        return true;
    }

    public PreTrainStatus getPreTrainStatus_NT(MLTaskLoc taskLoc, AuthCtx user) throws Exception {
        PreTrainStatus pts = new PreTrainStatus();
        AnalysisCoreParams coreParams = null;
        ClusteringMLTask task = null;
        try (Transaction t = this.transactionService.beginRead();){
            coreParams = this.crudService.getCoreMandatory(taskLoc.analysisProjectKey, taskLoc.analysisId);
            task = this.crudService.getCMLTask(taskLoc);
        }
        try {
            DKUMLUtils.checkClusteringTask(task);
        }
        catch (Exception e) {
            logger.warn((Object)"Check task failed", (Throwable)e);
            pts.messages.add(InfoMessage.fatal((String)e.getMessage()));
            return pts;
        }
        GuessStatus guessStatus = taskLoc.getGuessStatus();
        if (guessStatus != null && GuessStatus.GuessState.CAN_CHANGE_SETTINGS.equals((Object)guessStatus.state) && StringUtils.isNotBlank((String)guessStatus.error.message)) {
            pts.messages.add(InfoMessage.warning((String)guessStatus.error.message));
        }
        for (FeaturePreprocessingParams params : task.preprocessing.per_feature.values()) {
            if (params.role != FeaturePreprocessingParams.Role.INPUT) continue;
            ++pts.nbInputFeatures;
        }
        try {
            WorkSet ws = new ClusteringParamsExpander(task, "__no_session__").expand();
            pts.messages = ws.messages;
            for (WorkSet.PreprocessingSet pps : ws.preprocessingSets) {
                for (WorkSet.ModelingSet ms : pps.modelingSets) {
                    ++pts.nbModelsPreGS;
                    pts.estimatedTotalFits += ms.estimatedTrains;
                }
            }
            if (pts.nbModelsPreGS == 0) {
                pts.messages.add(InfoMessage.warning((String)"You have not selected any algorithm"));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Expansion failed", (Throwable)e);
            pts.messages.add(InfoMessage.fatal((String)"Could not prepare models", (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.DESIGN && task.backendType.isPythonBased()) {
            this.mlBaseService.checkVisualMlRuntime(user, pts, taskLoc.analysisProjectKey, task);
        }
        pts.splitStatus = this.splitsService.getCSplitStatus_NT(coreParams, taskLoc, task, user);
        return pts;
    }

    public String trainStart_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, ClusteringMLTask task, String userSessionName, String userSessionDescription, boolean runQueue) throws Exception {
        return this.trainStartHelper_NT(user, cp, loc, task, null, userSessionName, userSessionDescription, runQueue);
    }

    public void trainStart_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, ClusteringMLTask task, String sessionId, String userSessionName, String userSessionDescription, boolean runQueue) throws Exception {
        this.trainStartHelper_NT(user, cp, loc, task, sessionId, userSessionName, userSessionDescription, runQueue);
    }

    private String trainStartHelper_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, ClusteringMLTask task, @Nullable String sessionId, String userSessionName, String userSessionDescription, boolean runQueue) throws Exception {
        this.mlBaseService.failIfWorking(loc, false);
        DKUMLUtils.checkClusteringTask(task);
        MLPaths.createIfNeededMLTaskFolderAndRestrictPermissions(loc);
        FilesystemACLUtils.grantFSReadACLs(user, cp.projectKey, loc.getDataFolder());
        TrainWorkThread thread = new TrainWorkThread((DSSAuthCtx)user, loc, cp, task, sessionId, userSessionName, userSessionDescription);
        thread.initiator = user.getIdentifier();
        this.mlBaseService.setWorking(loc, thread);
        this.mlBaseService.setQueueState(loc, runQueue);
        thread.init();
        this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
        return thread.sessionId;
    }

    public void retrainStart_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, String sessionId, ClusteringMLTask task, String[] fullModelIdArray) throws Exception {
        this.mlBaseService.failIfWorking(loc, false);
        DKUMLUtils.checkClusteringTask(task);
        HashSet<String> fullModelIdSet = new HashSet<String>();
        if (fullModelIdArray != null) {
            for (String fullModelId : fullModelIdArray) {
                FullModelId fmi = FullModelId.parse(fullModelId);
                File stopSearchFile = fmi.getStopSearchFile();
                if (stopSearchFile.exists() && !stopSearchFile.delete()) {
                    throw new Exception("Could not delete stop_search file");
                }
                ModelTrainInfo mti = fmi.parseModelFile("train_info.json", ModelTrainInfo.class);
                mti.state = ModelTrainInfo.ModelTrainState.PENDING;
                JSON.prettyToFile((Object)mti, (File)new File(fmi.getModelFolder(), "train_info.json"));
                fullModelIdSet.add(fullModelId);
            }
        }
        ReTrainWorkThread thread = new ReTrainWorkThread((DSSAuthCtx)user, loc, cp, task, sessionId, fullModelIdSet);
        thread.initiator = user.getIdentifier();
        this.mlBaseService.setWorking(loc, thread);
        thread.init();
        this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    public FutureResponse<Void> rescoreStart(AuthCtx user, FullModelId modelId) throws Exception {
        for (FutureThreadBase ft : this.futureService.getAllThreads().values()) {
            if (!(ft instanceof ClusteringRescoringHandler.RescoringWorkThread) || !((ClusteringRescoringHandler.RescoringWorkThread)ft).getModelId().equals(modelId.toString())) continue;
            throw new IllegalStateException("Already rescoring this model !");
        }
        ClusteringRescoringHandler.RescoringWorkThread thread = new ClusteringRescoringHandler.RescoringWorkThread((DSSAuthCtx)user, modelId);
        return this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    public void enqueueSession(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, ClusteringMLTask task, boolean pauseQueue, String userSessionName, String userSessionDescription, Boolean forceRefresh) throws Exception {
        this.mlBaseService.failIfWorking(loc, true);
        String sessionId = this.mlBaseService.getNextSessionIdAndCreateSessionFolder(loc);
        DKUMLUtils.dumpParamsOnDisk(cp, loc, task, sessionId);
        try {
            MLBaseService.QueuedSessionMetadata queuedSessionMetadata = new MLBaseService.QueuedSessionMetadata();
            queuedSessionMetadata.userSessionName = userSessionName;
            queuedSessionMetadata.userSessionDescription = userSessionDescription;
            queuedSessionMetadata.forceSplitRefresh = forceRefresh;
            queuedSessionMetadata.sessionOwner = user.getIdentifier();
            JSON.prettyToFile((Object)queuedSessionMetadata, (File)new File(loc.getSessionFolder(sessionId), "queue_info.json"));
        }
        catch (IOException e) {
            logger.error((Object)"Failed to mark session as queued", (Throwable)e);
        }
        if (pauseQueue) {
            this.mlBaseService.setQueueState(loc, false);
        }
    }

    public String trainQueue(AnalysisCoreParams cp, MLTaskLoc loc) throws Exception {
        if (this.mlBaseService.isTraining(loc)) {
            return null;
        }
        String nextSessionId = this.mlBaseService.getNextQueuedSessionId(loc);
        ClusteringMLTask task = null;
        if (nextSessionId != null) {
            try (Transaction t = this.transactionService.beginRead();){
                task = this.crudService.getCMLSessionTask(loc, nextSessionId, false);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get ML task", (Throwable)e);
            }
            if (task != null) {
                MLBaseService.QueuedSessionMetadata queuedSessionMetadata = new MLBaseService.QueuedSessionMetadata();
                try {
                    File sessionFolder = loc.getSessionFolder(nextSessionId);
                    File queueInfoFile = new File(sessionFolder, "queue_info.json");
                    queuedSessionMetadata = (MLBaseService.QueuedSessionMetadata)JSON.parseFile((File)queueInfoFile, MLBaseService.QueuedSessionMetadata.class);
                    DKUFileUtils.delete((File)queueInfoFile);
                }
                catch (IOException e) {
                    logger.info((Object)"Failed to delete queue_info.json", (Throwable)e);
                }
                this.mlBaseService.setQueueState(loc, true);
                DSSAuthCtx user = null;
                try (Transaction t = this.transactionService.beginRead();){
                    user = this.mlBaseService.getQueuedSessionUser(queuedSessionMetadata.sessionOwner, loc);
                }
                if (queuedSessionMetadata.forceSplitRefresh != null && queuedSessionMetadata.forceSplitRefresh.booleanValue()) {
                    t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)user);
                    try {
                        ++task.sampling.instanceIdRefresher;
                        this.crudService.saveMLTask(loc, task, true);
                        t.commit("Saved settings of ML task " + task.id + " in " + loc.analysisProjectKey + "." + loc.analysisId);
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                this.trainStart_NT(user, cp, loc, task, nextSessionId, queuedSessionMetadata.userSessionName, queuedSessionMetadata.userSessionDescription, true);
            }
        }
        if (nextSessionId == null || task == null) {
            this.mlBaseService.setQueueState(loc, false);
        }
        return nextSessionId;
    }

    public List<FullModelId> listTaskModelIds(MLTaskLoc taskLoc) {
        List<FullModelId> ret = this.mlBaseService.listCompletedModelIds(taskLoc);
        HashSet<String> modelsBeingTrained = new HashSet<String>();
        MLBaseService.MLTaskWorkThread thread = this.mlBaseService.getWorkingThread(taskLoc);
        if (thread != null) {
            for (FullModelId fmi : thread.modelsBeingTrained()) {
                modelsBeingTrained.add(fmi.toString());
                ret.add(fmi);
            }
        }
        for (FullModelId fmi : this.mlBaseService.listCompletedModelIds(taskLoc)) {
            if (modelsBeingTrained.contains(fmi.toString())) continue;
            ret.add(fmi);
        }
        return ret;
    }

    public Map<String, ClusteringModelSnippetData> getSnippets_NT(List<FullModelId> fullModelIdList) throws IOException {
        HashMap<String, ClusteringModelSnippetData> ret = new HashMap<String, ClusteringModelSnippetData>();
        for (FullModelId fmi : fullModelIdList) {
            try {
                ret.put(fmi.toString(), ClusteringResultsReader.makeSnippet(fmi));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to get status for model " + String.valueOf(fmi)), (Throwable)e);
            }
        }
        return ret;
    }

    public FullModelId getLatestModelId(List<FullModelId> fullModelIdList) throws IOException {
        Map<String, ClusteringModelSnippetData> snippets = this.getSnippets_NT(fullModelIdList);
        ClusteringModelSnippetData latestVersion = snippets.values().stream().filter(v -> v.trainInfo != null).max(Comparator.comparing(v -> v.trainInfo.endTime)).orElse(null);
        if (latestVersion == null) {
            return null;
        }
        return FullModelId.parse(latestVersion.fullModelId);
    }

    public ClusteringMLTaskStatus getMLTaskStatus_NT(MLTaskLoc taskLoc) throws IOException {
        ClusteringMLTaskStatus ret = new ClusteringMLTaskStatus();
        ret.guessing = this.mlBaseService.isGuessing(taskLoc);
        ret.training = this.mlBaseService.isTraining(taskLoc);
        ret.queueStatus = this.mlBaseService.getQueueStatus(taskLoc);
        if (!ret.guessing) {
            ret.guessStatus = taskLoc.getGuessStatus();
        }
        HashSet<String> modelsBeingTrained = new HashSet<String>();
        MLBaseService.MLTaskWorkThread thread = this.mlBaseService.getWorkingThread(taskLoc);
        if (thread != null) {
            for (FullModelId fmi : thread.modelsBeingTrained()) {
                modelsBeingTrained.add(fmi.toString());
                ret.addModelIdInfo(fmi, true);
            }
        }
        for (FullModelId fmi : this.mlBaseService.listCompletedModelIds(taskLoc)) {
            if (modelsBeingTrained.contains(fmi.toString())) continue;
            ret.addModelIdInfo(fmi, false);
        }
        File lastSessionFolder = taskLoc.getLastSessionFolder();
        if (lastSessionFolder != null) {
            ret.headSessionTask = (ClusteringMLTask)JSON.parseFile((File)new File(lastSessionFolder, "mltask.json"), ClusteringMLTask.class);
        }
        return ret;
    }

    public Callable<NotebookToSave> createJupyterNotebook(final FullModelId fmi, String notebookTitle, final AuthCtx authCtx) throws Exception {
        final ClusteringModelDetails cmd = ClusteringResultsReader.makeDetails(fmi);
        final AnalysisCoreParams acp = this.crudService.getCoreMandatory(fmi.getProjectKey(), fmi.getTaskLoc().analysisId);
        final JsonObject splitStuff = new JsonObject();
        if (cmd.splitDesc.cparams.selection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
            splitStuff.addProperty("respectedSampling", Boolean.valueOf(true));
            splitStuff.addProperty("splitSamplingHeadRows", (Number)cmd.splitDesc.cparams.selection.maxRecords);
        } else {
            splitStuff.addProperty("respectedSampling", Boolean.valueOf(false));
            splitStuff.addProperty("splitSamplingHeadRows", (Number)100000);
        }
        List<JupyterUtils.JupyterNotebookListEntry> existingNotebooks = this.jupyterService.listSimple(DSSAuthCtx.newNone(), fmi.getProjectKey());
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        for (JupyterUtils.JupyterNotebookListEntry nbk : existingNotebooks) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(nbk.name);
        }
        notebookTitle = notebookTitle.replaceAll("[\\\\:/\\s]+", " ");
        final String transmogrifiedTitle = transmogrifier.transmogrify(notebookTitle);
        final RelFile newNotebookFile = this.jupyterService.getNotebookFile(fmi.getProjectKey(), transmogrifiedTitle);
        CodeEnvSelection envSelection = cmd.coreParams.executionParams.envSelection;
        Pair<String, String> nameAndDisplayNameOfKernelSpecs = this.jupyterService.getNameAndDisplayNameOfKernelSpecs(fmi.getProjectKey(), envSelection).orElse((Pair<String, String>)Pair.of((Object)"python3", (Object)"Python 3"));
        final String finalKernelName = (String)nameAndDisplayNameOfKernelSpecs.getLeft();
        final String finalKernelDisplayName = (String)nameAndDisplayNameOfKernelSpecs.getRight();
        return new Callable<NotebookToSave>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotebookToSave call() throws Exception {
                logger.info((Object)"Acquiring a kernel");
                PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                SingleCommandKernelLink link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), dssPortRange);
                AnalysisMLKernel dk = new AnalysisMLKernel(link, null, fmi.getProjectKey(), null, authCtx, fmi.getModelFolder(), null);
                dk.start();
                try {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("model_name", cmd.userMeta.name);
                    obj.addProperty("model_date", (Number)(cmd.trainInfo.startTime / 1000L));
                    obj.addProperty("dataset_smartname", acp.inputDatasetSmartName);
                    obj.add("script", (JsonElement)JSON.toJsonObject((Object)cmd.trainedWithScript, (String[])new String[0]));
                    obj.add("preparation_output_schema", (JsonElement)JSON.toJsonObject((Object)cmd.splitDesc.schema, (String[])new String[0]));
                    obj.add("split_stuff", (JsonElement)splitStuff);
                    obj.add("pre_train", (JsonElement)JSON.toJsonObject((Object)cmd.modeling, (String[])new String[0]));
                    obj.add("post_train", (JsonElement)JSON.toJsonObject((Object)cmd.actualParams.resolved, (String[])new String[0]));
                    obj.add("preprocessing_params", (JsonElement)JSON.toJsonObject((Object)cmd.preprocessing, (String[])new String[0]));
                    obj.addProperty("kernel_name", finalKernelName);
                    obj.addProperty("kernel_display_name", finalKernelDisplayName);
                    String jsonContent = null;
                    try {
                        jsonContent = (String)link.executeAsync((Object)new AnalysisMLKernel.ComputeRequest("create_clustering_notebook", obj.toString()), null, String.class, "Failed to convert to notebook").call();
                    }
                    catch (SocketBlockLinkException e) {
                        throw dk.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)dk)));
                    }
                    NotebookToSave notebookToSave = new NotebookToSave();
                    notebookToSave.newNotebookFile = newNotebookFile;
                    notebookToSave.transmogrifiedTitle = transmogrifiedTitle;
                    notebookToSave.jsonContent = jsonContent;
                    NotebookToSave notebookToSave2 = notebookToSave;
                    return notebookToSave2;
                }
                finally {
                    try {
                        dk.killWithoutMercy();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failure while destroying ml kernel", (Throwable)e);
                    }
                    try {
                        link.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failure while closing link to kernel", (Throwable)e);
                    }
                }
            }
        };
    }

    private MLTaskHandler<? extends ClusteringMLTask> buildMLTaskHandler(AnalysisCoreParams acp, MLTaskLoc taskLoc, ClusteringMLTask task, String sessionId, Set<String> fullModelIds, AuthCtx user) {
        ErrorContext.checkNotNull((Object)((Object)task.backendType));
        switch (task.backendType) {
            case H2O: 
            case MLLIB: {
                return new MLLibClusteringMLTaskHandler(acp, taskLoc, task, sessionId, user);
            }
            case PY_MEMORY: {
                return new PythonClusteringMLTaskHandler(acp, taskLoc, task, sessionId, fullModelIds, user);
            }
        }
        throw ErrorContext.iaef((String)"Unsupported clustering ML backend: %s", (Object)((Object)task.backendType), (Object[])new Object[0]);
    }

    public void checkSourceDatasetPermissions(AuthCtx authCtx, AnalysisCoreParams acp, MLTaskLoc loc) throws IOException, DKUSecurityException {
        ClusteringMLTask task = this.crudService.getCMLTask(loc);
        String ref = task.sampling.datasetSmartName == null ? acp.inputDatasetSmartName : task.sampling.datasetSmartName;
        AnyLoc dsLoc = AnyLoc.resolveSmart(loc.analysisProjectKey, ref);
        this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, dsLoc);
    }

    private ClusteringGuesser getGuesser(AnalysisCoreParams cp, ClusteringMLTask task, AuthCtx user) throws Exception {
        MemScriptRunner.TableWithReport dataTable = this.dataService.getCachedUnfiltered_NOTRANSACTION(cp, user);
        return task.guessPolicy.meta.getGuesser(task, dataTable.table);
    }

    class InitialGuessWorkThread
    extends MLBaseService.MLTaskWorkThread {
        final ClusteringMLTask task;

        InitialGuessWorkThread(DSSAuthCtx user, MLTaskLoc loc, AnalysisCoreParams cp, ClusteringMLTask task) {
            super(user, loc, cp);
            this.task = task;
        }

        @Override
        public synchronized List<FullModelId> modelsBeingTrained() {
            return Lists.newArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("IGT-" + this.task.id));){
                GuessStatus gs = new GuessStatus();
                logger.info((Object)"Start initial guess");
                try {
                    ClusteringService.this.getGuesser(this.cp, this.task, this.owner).guessAllSettings(false);
                    try (RWTransaction rw = ClusteringService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                        ClusteringService.this.crudService.prepareMLTaskCreation(this.loc, this.task, this.owner);
                        ClusteringService.this.crudService.saveMLTask(this.loc, this.task, false);
                        rw.commit("Create clustering task in " + this.cp.projectKey + "." + this.cp.id + "(" + this.cp.name + ")");
                    }
                    gs.state = GuessStatus.GuessState.OK;
                    this.loc.writeGuessStatus(gs);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to guess", (Throwable)e);
                    ClusteringService.this.mlBaseService.setNotWorking(this.loc);
                    gs.state = GuessStatus.GuessState.CAN_CHANGE_SETTINGS;
                    gs.error = new APIError((Throwable)e, true);
                    this.loc.writeGuessStatus(gs);
                }
                finally {
                    ClusteringService.this.mlBaseService.removeGuessing(this.loc);
                }
                logger.info((Object)"Done initial guess");
            }
        }

        @Override
        public void init() throws Exception {
        }

        public Void getResult() {
            return null;
        }

        @Override
        public FuturePayload buildFuturePayload(MLTaskLoc loc, AnalysisCoreParams cp) {
            return MLBaseService.buildBaseFuturePayload(loc, "Guessing clustering training parameters", "guess", "clustering");
        }

        @Override
        public List<Integer> getPids() {
            return null;
        }
    }

    class TrainWorkThread
    extends MLBaseService.MLTaskWorkThread {
        final ClusteringMLTask task;
        final String userSessionName;
        final String userSessionDescription;
        String sessionId;
        String initiator;
        MLTaskHandler<? extends ClusteringMLTask> trainHandler;

        TrainWorkThread(DSSAuthCtx user, MLTaskLoc loc, AnalysisCoreParams cp, ClusteringMLTask task, String sessionId, String userSessionName, String userSessionDescription) {
            super(user, loc, cp);
            this.task = task;
            this.userSessionName = userSessionName;
            this.userSessionDescription = userSessionDescription;
            this.sessionId = sessionId;
        }

        @Override
        public synchronized List<FullModelId> modelsBeingTrained() {
            if (this.trainHandler != null) {
                return this.trainHandler.getTrainedModelIds();
            }
            return Lists.newArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws Exception {
            try {
                ClusteringService.this.mlBaseService.startLogAppender();
                if (this.sessionId == null) {
                    this.sessionId = ClusteringService.this.mlBaseService.getNextSessionIdAndCreateSessionFolder(this.loc);
                }
                MLTaskHandler<? extends ClusteringMLTask> tempTrainHandler = ClusteringService.this.buildMLTaskHandler(this.cp, this.loc, this.task, this.sessionId, Collections.emptySet(), this.owner);
                AnalysisWorkSetPreparator preparator = new AnalysisWorkSetPreparator(MLTask.MLTaskType.CLUSTERING, this.loc, this.sessionId, this.userSessionName, this.userSessionDescription, EvaluationLabelsHelper.getTrainTimeLabels(this.loc, this.task, this.cp));
                tempTrainHandler.init(preparator);
                TrainWorkThread trainWorkThread = this;
                synchronized (trainWorkThread) {
                    this.trainHandler = tempTrainHandler;
                }
            }
            catch (Exception e) {
                ClusteringService.this.mlBaseService.setNotWorking(this.loc);
                ClusteringService.this.mlBaseService.setQueueState(this.loc, false);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            mlTaskContext.set(new MLBaseService.MLTaskWorkThread.MLTaskContext(this.trainHandler.getTrainedModelIds()));
            logger.info((Object)"******************************************");
            logger.info((Object)("** Start train session " + this.sessionId));
            logger.info((Object)"******************************************");
            try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("T-" + this.task.id));){
                try (FutureAborter.AutoCloseableAbortHook aborting = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        assert (TrainWorkThread.this.trainHandler != null);
                        logger.info((Object)"Abort training thread");
                        TrainWorkThread.this.trainHandler.abort();
                    }
                });){
                    ClusteringService.this.pubSub.publish(new MLTaskStateChangedEvent(this.task, this.cp.projectKey, this.cp.id, this.sessionId, this.cp.inputDatasetSmartName, true, this.initiator, null));
                    this.trainHandler.train();
                    logger.info((Object)"Train done");
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedException)) {
                        ClusteringService.this.mlBaseService.setQueueState(this.loc, false);
                    }
                    logger.error((Object)"Failed to train", (Throwable)e);
                }
                finally {
                    ClusteringService.this.mlBaseService.setNotWorking(this.loc);
                    try {
                        FileUtils.touch((File)new File(this.loc.getSessionFolder(this.sessionId), "done.txt"));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to mark session as complete", (Throwable)e);
                    }
                    ClusteringService.this.trainingSessionDetailsService.publishClusteringSession(this.loc, this.sessionId, this.initiator, this.cp, this.task);
                }
            }
        }

        @Override
        public FuturePayload buildFuturePayload(MLTaskLoc loc, AnalysisCoreParams cp) {
            return MLBaseService.buildBaseFuturePayload(loc, "Training clustering model", "train", "clustering");
        }

        public Void getResult() {
            return null;
        }

        @Override
        public List<Integer> getPids() {
            return this.trainHandler != null ? this.trainHandler.getKernelPids() : null;
        }
    }

    class ReTrainWorkThread
    extends TrainWorkThread {
        final Set<String> fullModelIds;

        ReTrainWorkThread(DSSAuthCtx user, MLTaskLoc loc, AnalysisCoreParams cp, ClusteringMLTask task, String sessionId, Set<String> fullModelIds) {
            super(user, loc, cp, task, sessionId, null, null);
            this.sessionId = sessionId;
            this.fullModelIds = fullModelIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws Exception {
            try {
                logger.info((Object)("Start retraining session " + this.sessionId));
                MLTaskHandler<? extends ClusteringMLTask> localTrainHandler = ClusteringService.this.buildMLTaskHandler(this.cp, this.loc, this.task, this.sessionId, this.fullModelIds, this.owner);
                AnalysisRetrainWorkSetPreparator preparator = new AnalysisRetrainWorkSetPreparator(MLTask.MLTaskType.CLUSTERING, this.loc, this.sessionId, EvaluationLabelsHelper.getTrainTimeLabels(this.loc, this.task, this.cp));
                localTrainHandler.init(preparator);
                ReTrainWorkThread reTrainWorkThread = this;
                synchronized (reTrainWorkThread) {
                    this.trainHandler = localTrainHandler;
                }
            }
            catch (Exception e) {
                ClusteringService.this.mlBaseService.setNotWorking(this.loc);
                throw e;
            }
        }
    }

    public static class NotebookToSave {
        public String transmogrifiedTitle;
        public RelFile newNotebookFile;
        public String jsonContent;
    }
}

