/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.helpers.FeaturePreprocessingParamsDescriptor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.ImageFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.VectorFeaturePreprocessingParams;
import com.jayway.jsonpath.DocumentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ModelInputFeatureTableExtractor
implements ModelExtractor<List<List<String>>> {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) {
        ArrayList<List<String>> features = new ArrayList<List<String>>();
        ResolvedPreprocessingParams preprocessingParams = model.getPreprocessing();
        if (preprocessingParams != null && preprocessingParams.per_feature != null) {
            features.add(Arrays.asList("Feature Name", "Status", "Type", "Processing"));
            for (Map.Entry<String, FeaturePreprocessingParams> e : preprocessingParams.per_feature.entrySet()) {
                features.add(this.extractFeatureParams(e.getKey(), e.getValue()));
            }
        } else {
            logger.warn((Object)("No feature found for model " + model.fullModelId));
        }
        return features;
    }

    private List<String> extractFeatureParams(String featureName, FeaturePreprocessingParams featureParams) {
        ArrayList<String> feature = new ArrayList<String>();
        feature.add(featureName);
        feature.add(FeaturePreprocessingParamsDescriptor.label(featureParams.role));
        feature.add(FeaturePreprocessingParamsDescriptor.label(featureParams.type));
        feature.add(this.extractSummary(featureParams));
        return feature;
    }

    private String extractSummary(FeaturePreprocessingParams featureParams) {
        if (FeaturePreprocessingParams.Role.INPUT.equals((Object)featureParams.role) || FeaturePreprocessingParams.Role.PROFILING.equals((Object)featureParams.role)) {
            switch (featureParams.type) {
                case CATEGORY: {
                    return this.extractSummaryForCategoricalFeature((CatFeaturePreprocessingParams)featureParams);
                }
                case NUMERIC: {
                    return FeaturePreprocessingParamsDescriptor.label((NumFeaturePreprocessingParams)featureParams);
                }
                case TEXT: {
                    TextFeaturePreprocessingParams text = (TextFeaturePreprocessingParams)featureParams;
                    return FeaturePreprocessingParamsDescriptor.label(text.text_handling);
                }
                case VECTOR: {
                    VectorFeaturePreprocessingParams vec = (VectorFeaturePreprocessingParams)featureParams;
                    return FeaturePreprocessingParamsDescriptor.label(vec.vector_handling);
                }
                case IMAGE: {
                    ImageFeaturePreprocessingParams image = (ImageFeaturePreprocessingParams)featureParams;
                    return FeaturePreprocessingParamsDescriptor.label(image.image_handling);
                }
            }
            logger.warn((Object)("Unsupported featureParams type : " + String.valueOf((Object)featureParams.type)));
        }
        return "";
    }

    private String extractSummaryForCategoricalFeature(CatFeaturePreprocessingParams catFeature) {
        String missing;
        Object summary = FeaturePreprocessingParamsDescriptor.label(catFeature);
        if (!CatFeaturePreprocessingParams.CategoryHandlingMethod.FLAG_PRESENCE.equals((Object)catFeature.category_handling) && StringUtils.isNotBlank((CharSequence)(missing = FeaturePreprocessingParamsDescriptor.label(catFeature.missing_handling)))) {
            summary = (String)summary + ", " + missing;
        }
        return summary;
    }
}

