/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TableModelExtractorJson
implements ModelExtractor<List<List<String>>> {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");
    private final List<Entry> entries = new ArrayList<Entry>();
    private static String[] nonMandatoryEntries = new String[]{"Min.", "Max.", "Average", "Standard deviation"};

    public TableModelExtractorJson(String[][] nameAndPaths) {
        for (String[] nameAndPath : nameAndPaths) {
            String name = nameAndPath[0];
            JsonPath[] paths = new JsonPath[nameAndPath.length - 1];
            for (int i = 1; i < nameAndPath.length; ++i) {
                JsonPath path;
                paths[i - 1] = path = JsonPath.compile((String)nameAndPath[i], (Predicate[])new Predicate[0]);
            }
            this.entries.add(new Entry(name, paths));
        }
    }

    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        ArrayList<List<String>> table = new ArrayList<List<String>>(this.entries.size());
        for (Entry entry : this.entries) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(entry.name);
            try {
                for (JsonPath jp : entry.path) {
                    Object extracted = documentContext.read(jp);
                    String transformed = this.postTransform(entry.name, extracted);
                    l.add(transformed);
                }
                table.add(l);
            }
            catch (PathNotFoundException e) {
                String errorMessage = "Cannot find value for entry \"" + entry.name + "\" in the model definition.";
                if (Arrays.stream(nonMandatoryEntries).anyMatch(entry.name::equals)) {
                    logger.error((Object)errorMessage);
                    continue;
                }
                throw new IOException(errorMessage);
            }
        }
        return table;
    }

    protected <T> String postTransform(String entryName, T extractedValue) {
        return String.valueOf(extractedValue);
    }

    private static class Entry {
        public final String name;
        public final JsonPath[] path;

        public Entry(String name, JsonPath[] path) {
            this.name = name;
            this.path = path;
        }
    }
}

