/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.GenericMultiTimeseriesExtractor;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelIntrinsicPerf;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimeseriesCoefficientsSingleExtractor
extends GenericMultiTimeseriesExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        this.assertModelIsSupported(model, MODELS_WITH_COEFFICIENTS);
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        if (!timeseriesModelDetails.getCoreParams().timeseriesIdentifiers.isEmpty()) {
            throw new IOException(String.format("Wrong placeholder. Extractor '%s' does not support multi time series. Use {{%s}} instead.", this.getClass().getSimpleName(), Placeholder.RESULT_TIMESERIES_COEFFICIENTS_MULTI_TABLE.placeholderName));
        }
        List<TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients> modelCoefficients = timeseriesModelDetails.iperf.modelCoefficients;
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        if (modelCoefficients.isEmpty()) {
            return output;
        }
        output.add(this.getHeaderRow(modelCoefficients));
        for (int i = 0; i < modelCoefficients.size(); ++i) {
            output.addAll(this.getValuesRows(modelCoefficients.get(i)));
        }
        return output;
    }

    private List<String> getHeaderRow(List<TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients> modelCoefficients) {
        ArrayList<String> row = new ArrayList<String>();
        row.add("Name");
        row.add("Value");
        if (modelCoefficients.stream().anyMatch(Helper::hasStderrs)) {
            row.add("Standard error");
        }
        if (modelCoefficients.stream().anyMatch(Helper::hasPvalues)) {
            row.add("p-value");
        }
        if (modelCoefficients.stream().anyMatch(Helper::hasTvalues)) {
            row.add("t-stat");
        }
        return row;
    }

    private List<List<String>> getValuesRows(TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients modelCoefficient) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> row = new ArrayList<String>();
        row.add(modelCoefficient.displayName);
        Helper.addNullableValueToRow(row, modelCoefficient.values.values().stream().findFirst().orElse(null));
        if (Helper.hasStderrs(modelCoefficient)) {
            Helper.addNullableValueToRow(row, modelCoefficient.stderrs.values().stream().findFirst().get());
        }
        if (Helper.hasPvalues(modelCoefficient)) {
            Helper.addNullableValueToRow(row, modelCoefficient.pvalues.values().stream().findFirst().get());
        }
        if (Helper.hasTvalues(modelCoefficient)) {
            Helper.addNullableValueToRow(row, modelCoefficient.tvalues.values().stream().findFirst().get());
        }
        rows.add(row);
        return rows;
    }

    public static class Helper {
        public static void addNullableValueToRow(List<String> row, Double value) {
            if (value == null) {
                row.add("");
            } else {
                row.add(String.format("%.4f", value));
            }
        }

        public static boolean hasStderrs(TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients modelCoefficient) {
            return modelCoefficient != null && modelCoefficient.stderrs != null && !modelCoefficient.stderrs.isEmpty() && modelCoefficient.stderrs.values().stream().anyMatch(Objects::nonNull);
        }

        public static boolean hasPvalues(TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients modelCoefficient) {
            return modelCoefficient != null && modelCoefficient.pvalues != null && !modelCoefficient.pvalues.isEmpty() && modelCoefficient.pvalues.values().stream().anyMatch(Objects::nonNull);
        }

        public static boolean hasTvalues(TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients modelCoefficient) {
            return modelCoefficient != null && modelCoefficient.tvalues != null && !modelCoefficient.tvalues.isEmpty() && modelCoefficient.tvalues.values().stream().anyMatch(Objects::nonNull);
        }
    }
}

