/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.helpers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.docgen.extractor.AlgorithmNameExtractor;
import com.dataiku.dip.analysis.docgen.model.ModelDocumentFormat;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Preconditions;
import com.jayway.jsonpath.DocumentContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MDGFileUtil {
    public static final String TMP_RENDERED_DOCUMENT = "docgen";
    private static final byte[] DOCX_FILE_SIGNATURE = new byte[]{80, 75, 3, 4};
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    private MDGFileUtil() {
    }

    public static String getDocumentFilename(FullModelId fmi, String analysisName, DocumentContext documentContext, ModelDetailsBase model) {
        String algorithmName = "";
        String mlTaskName = "";
        try {
            algorithmName = new AlgorithmNameExtractor("$.modeling.algorithm").extract(documentContext, model);
            mlTaskName = fmi.getHeadMLTask().name;
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
        return "Dataiku Model Documentation - " + mlTaskName + " on " + analysisName + " - " + algorithmName + "." + ModelDocumentFormat.DOCX.getExtension();
    }

    public static String getDocumentFilename(FullModelId fmi) {
        String mlTaskName = "";
        try {
            mlTaskName = fmi.getHeadMLTask().name;
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
        return "Dataiku Model Documentation - " + mlTaskName + "." + ModelDocumentFormat.DOCX.getExtension();
    }

    public static File getUploadedFile(String uploadId) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uploadId}), (Object)"Upload id not specified");
        return DKUApp.getFile((String[])new String[]{"tmp", TMP_RENDERED_DOCUMENT, uploadId, "template." + ModelDocumentFormat.DOCX.getExtension()});
    }

    public static File writeOnTemporaryFile(Object data, String uploadId) throws IOException {
        File resolvedResultFile = MDGFileUtil.createTemporaryFile(uploadId, "resolved_", "json");
        JSON.prettyToFile((Object)data, (File)resolvedResultFile);
        return resolvedResultFile;
    }

    public static File createTemporaryFile(String uploadId, String prefix, String extension) throws IOException {
        String path = "docgen/" + uploadId;
        File subpath = DKUApp.getFile((String[])new String[]{"tmp", path});
        try {
            DKUFileUtils.mkdirs((File)subpath);
        }
        catch (IOException e) {
            throw new IOException("Failed to create temporary directory", e);
        }
        return File.createTempFile(prefix, "." + extension, subpath);
    }

    public static String getTmpExportDirectory(String exportId) throws IOException {
        return DSSTempUtils.getTempFolderWithSpecificName((String)TMP_RENDERED_DOCUMENT, (String)exportId).getAbsolutePath();
    }

    public static File getRenderedTemplateFile(File templateFolder, String targetedPrefix) {
        File[] files;
        if (templateFolder != null && (files = templateFolder.listFiles()) != null) {
            for (File file : files) {
                if (file.getName().startsWith(targetedPrefix)) {
                    logger.debug((Object)("[Document generation] Output file name: " + file.getName()));
                    return file;
                }
                logger.debug((Object)("[Document generation] Discarding technical file: " + file.getName()));
            }
        }
        logger.error((Object)"[Document generation] No file found.");
        return null;
    }

    public static File getRenderedTemplateFile(File templateFolder) {
        return MDGFileUtil.getRenderedTemplateFile(templateFolder, "Dataiku Model Documentation");
    }

    public static String handleFileUpload(InputStream is) throws IOException {
        String uploadId = SecretKeyGenerator.generate((int)16);
        File outFile = MDGFileUtil.getUploadedFile(uploadId);
        if (!outFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory: " + String.valueOf(outFile.getParentFile()));
        }
        if (!outFile.createNewFile()) {
            throw new IllegalArgumentException("Uploaded file already exists");
        }
        try (FileOutputStream os = new FileOutputStream(outFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        return uploadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSignature(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("This method requires an input stream where mark is supported");
        }
        inputStream.mark(DOCX_FILE_SIGNATURE.length);
        try {
            int read;
            byte[] data = new byte[DOCX_FILE_SIGNATURE.length];
            int index = 0;
            int remaining = data.length;
            do {
                if ((read = inputStream.read(data, index, remaining)) <= 0) continue;
                remaining -= read;
                index += read;
            } while (remaining > 0 && read != -1);
            if (remaining > 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = Arrays.equals(data, DOCX_FILE_SIGNATURE);
            return bl;
        }
        finally {
            inputStream.reset();
        }
    }

    public static void sendDocxDownload(File f, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType(MimeTypeUtils.fromExtension((String)"docx").mimeType);
        resp.setHeader("Content-Disposition", "attachement; filename=\"" + f.getName() + "\"");
        resp.setHeader("Content-Length", "" + f.length());
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            IOUtils.copy((InputStream)bis, (OutputStream)resp.getOutputStream());
        }
    }
}

