/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.transform;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import java.io.IOException;

public enum PlaceholderCompatibility {
    ALL(true, true, true, true, true, true, PlaceholderPartitionSupport.YES),
    ALL_TYPES_NO_PARTITION(true, true, true, true, true, true, PlaceholderPartitionSupport.NO),
    PREDICTION(true, true, true, true, false, true, PlaceholderPartitionSupport.YES),
    CLASSICAL_PREDICTION(true, true, true, true, false, false, PlaceholderPartitionSupport.YES),
    PREDICTION_NO_PARTITION(true, true, true, true, false, true, PlaceholderPartitionSupport.NO),
    PREDICTION_ONLY_PARTITION(true, true, true, false, false, true, PlaceholderPartitionSupport.ONLY),
    CLUSTERING(false, false, false, false, true, false, PlaceholderPartitionSupport.NO),
    REGRESSION(true, false, false, false, false, false, PlaceholderPartitionSupport.YES),
    REGRESSION_NO_PARTITION(true, false, false, false, false, false, PlaceholderPartitionSupport.NO),
    CLASSIFICATION(false, true, true, false, false, false, PlaceholderPartitionSupport.YES),
    CLASSIFICATION_NO_PARTITION(false, true, true, false, false, false, PlaceholderPartitionSupport.NO),
    BINARY_CLASSIFICATION(false, true, false, false, false, false, PlaceholderPartitionSupport.YES),
    BINARY_CLASSIFICATION_NO_PARTITION(false, true, false, false, false, false, PlaceholderPartitionSupport.NO),
    REGRESSION_AND_CLUSTERING(true, false, false, false, true, false, PlaceholderPartitionSupport.YES),
    REGRESSION_AND_CLUSTERING_NO_PARTITION(true, false, false, false, true, false, PlaceholderPartitionSupport.NO),
    REGRESSION_AND_BINARY_NO_PARTITION(true, true, false, false, false, false, PlaceholderPartitionSupport.NO),
    REGRESSION_BINARY_AND_MULTI_NO_PARTITION(true, true, true, false, false, false, PlaceholderPartitionSupport.NO),
    TIMESERIES(false, false, false, false, false, true, PlaceholderPartitionSupport.YES),
    TIMESERIES_NO_PARTITION(false, false, false, false, false, true, PlaceholderPartitionSupport.NO),
    REGRESSION_AND_TIMESERIES(true, false, false, false, false, true, PlaceholderPartitionSupport.YES);

    private final boolean supportRegression;
    private final boolean supportBinaryClassification;
    private final boolean supportMulticlassClassification;
    private final boolean supportsNoneType;
    private final boolean supportClustering;
    private final boolean supportTimeseries;
    private final PlaceholderPartitionSupport supportPartition;

    private PlaceholderCompatibility(boolean supportRegression, boolean supportBinaryClassification, boolean supportMulticlassClassification, boolean supportsNoneType, boolean supportClustering, boolean supportTimeseries, PlaceholderPartitionSupport supportPartition) {
        this.supportRegression = supportRegression;
        this.supportBinaryClassification = supportBinaryClassification;
        this.supportMulticlassClassification = supportMulticlassClassification;
        this.supportsNoneType = supportsNoneType;
        this.supportClustering = supportClustering;
        this.supportTimeseries = supportTimeseries;
        this.supportPartition = supportPartition;
    }

    public void supportMLTaskType(String placeholderName, MLTask mlTask) throws IOException {
        block15: {
            block12: {
                block13: {
                    PredictionMLTask predictionMLTask;
                    block14: {
                        if (!MLTask.MLTaskType.PREDICTION.equals((Object)mlTask.taskType)) break block12;
                        if (!(mlTask instanceof PredictionMLTask)) break block13;
                        predictionMLTask = (PredictionMLTask)mlTask;
                        if (predictionMLTask.predictionType != null) break block14;
                        if (!this.supportsNoneType) {
                            throw PlaceholderCompatibility.notSupportedException(placeholderName, "Other prediction type.");
                        }
                        break block15;
                    }
                    switch (predictionMLTask.predictionType) {
                        case REGRESSION: {
                            if (!this.supportRegression) {
                                throw PlaceholderCompatibility.notSupportedException(placeholderName, "Regression");
                            }
                            break block15;
                        }
                        case BINARY_CLASSIFICATION: {
                            if (!this.supportBinaryClassification) {
                                throw PlaceholderCompatibility.notSupportedException(placeholderName, "Binary classification");
                            }
                            break block15;
                        }
                        case MULTICLASS: {
                            if (!this.supportMulticlassClassification) {
                                throw PlaceholderCompatibility.notSupportedException(placeholderName, "Multi-class classification");
                            }
                            break block15;
                        }
                        case TIMESERIES_FORECAST: {
                            if (!this.supportTimeseries) {
                                throw PlaceholderCompatibility.notSupportedException(placeholderName, "Time series forecasting");
                            }
                            break block15;
                        }
                        default: {
                            throw PlaceholderCompatibility.notSupportedException(placeholderName, predictionMLTask.predictionType.name());
                        }
                    }
                }
                throw PlaceholderCompatibility.notSupportedException(placeholderName, mlTask.getClass().getSimpleName());
            }
            if (!this.supportClustering) {
                throw PlaceholderCompatibility.notSupportedException(placeholderName, "Clustering");
            }
        }
    }

    public boolean supportPartition(MLTask mlTask, FullModelId fmi) {
        if (mlTask instanceof PredictionMLTask && ((PredictionMLTask)mlTask).isPartitioned() && fmi.getPartitionName() == null) {
            return this.supportPartition.equals((Object)PlaceholderPartitionSupport.YES) || this.supportPartition.equals((Object)PlaceholderPartitionSupport.ONLY);
        }
        return !this.supportPartition.equals((Object)PlaceholderPartitionSupport.ONLY);
    }

    private static IOException notSupportedException(String placeholderName, String type) {
        return new IOException(String.format("The placeholder {{%s}} is not supported with ML task of type: %s.", placeholderName, type));
    }

    public static enum PlaceholderPartitionSupport {
        YES,
        NO,
        ONLY;

    }
}

