/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.transform;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.docgen.helpers.DesignDiffCheckUtil;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.docgen.helpers.ModelDetailsBaseUtil;
import com.dataiku.dip.analysis.docgen.helpers.PlaceholderUtil;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.analysis.docgen.model.DesignChangedException;
import com.dataiku.dip.analysis.docgen.model.OriginAnalysisDetails;
import com.dataiku.dip.analysis.docgen.model.PlaceholderNames;
import com.dataiku.dip.analysis.docgen.model.ResolvedPlaceholder;
import com.dataiku.dip.analysis.docgen.model.ResolvedResult;
import com.dataiku.dip.analysis.docgen.transform.ParametrizedPlaceholder;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.docgen.transform.PlaceholderType;
import com.dataiku.dip.analysis.docgen.transform.PuppeteerConfig;
import com.dataiku.dip.analysis.docgen.transform.PuppeteerConfigResolver;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.graphicsexport.charts.DomElementsExportService;
import com.dataiku.dip.graphicsexport.charts.model.DomElementsExport;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlaceholderResolverService {
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DomElementsExportService domElementsExportService;
    @Autowired
    private FutureService futureService;
    private final Map<String, Placeholder> placeholders = new HashMap<String, Placeholder>();
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    @PostConstruct
    public void init() {
        for (Placeholder p : Placeholder.values()) {
            this.placeholders.put(p.placeholderName, p);
        }
    }

    public ResolvedResult resolve(PlaceholderNames placeholdersNames, String rootUrl, FullModelId fmi, AuthCtx authCtx, InfoMessage.InfoMessages messages) throws Exception {
        boolean hasDesignChanged;
        MLTask mlTask = fmi.getHeadMLTask();
        ModelDetailsBase model = ModelDetailsBaseUtil.getModel(mlTask, fmi);
        DocumentContext documentContext = ModelDetailsBaseUtil.getDocumentContext(model);
        ArrayList resolved = new ArrayList();
        boolean designChangedWarningTriggered = false;
        try {
            if (!DesignDiffCheckUtil.hasOriginalAnalysis(fmi)) {
                if (fmi.isExternalMLflowModelVersion()) {
                    hasDesignChanged = false;
                } else {
                    messages.addMessage(DesignDiffCheckUtil.getAnalysisDeletedWarningMessage());
                    hasDesignChanged = true;
                    designChangedWarningTriggered = true;
                }
            } else {
                hasDesignChanged = DesignDiffCheckUtil.hasChangesOccurred(fmi);
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to retrieve original analysis to check for compatibility with document generation", (Throwable)e);
            messages.addMessage(DesignDiffCheckUtil.getAnalysisDeletedWarningMessage());
            hasDesignChanged = true;
            designChangedWarningTriggered = true;
        }
        for (String placeholderName : placeholdersNames.placeholders) {
            try {
                ParametrizedPlaceholder paramPlaceholder = PlaceholderUtil.getParametrizedPlaceholder(placeholderName, this.placeholders);
                PlaceholderUtil.validateParametrizedPlaceholder(paramPlaceholder, model, mlTask, fmi, hasDesignChanged);
                InfoMessage.InfoMessages placeholderMessages = new InfoMessage.InfoMessages();
                resolved.add(this.resolvePlaceholder(paramPlaceholder, fmi, model, mlTask, documentContext, authCtx, placeholderMessages));
                messages.mergeFrom(placeholderMessages);
            }
            catch (IOException e) {
                String errorTitle = placeholderName + " couldn't be resolved";
                String errorDetails = "Cause: " + e.getMessage();
                messages.addMessage(InfoMessage.warning((String)errorTitle, (String)errorDetails));
                logger.warn((Object)errorTitle, (Throwable)e);
                resolved.add(new ResolvedPlaceholder.ResolvedPlaceholderString(placeholderName, PlaceholderType.JSON_TEXT, ""));
            }
            catch (DesignChangedException e) {
                if (!designChangedWarningTriggered) {
                    logger.warn((Object)"Unable to resolve placeholder because design has changed since training", (Throwable)e);
                    messages.addMessage(DesignDiffCheckUtil.getDesignChangedWarningMessage());
                    designChangedWarningTriggered = true;
                }
                resolved.add(new ResolvedPlaceholder.ResolvedPlaceholderString(placeholderName, PlaceholderType.JSON_TEXT, ""));
            }
        }
        ResolvedResult resolvedResult = new ResolvedResult();
        resolvedResult.resolved = resolved;
        resolvedResult.exportId = this.resolvePuppeteerPlaceholders(resolved, rootUrl, fmi, authCtx, messages);
        return resolvedResult;
    }

    public PlaceholderNames removePuppeteerPlaceholders(PlaceholderNames placeholdersNames, InfoMessage.InfoMessages messages) {
        ArrayList<String> filteredNames = new ArrayList<String>();
        for (String placeholderName : placeholdersNames.placeholders) {
            try {
                ParametrizedPlaceholder paramPlaceholder = PlaceholderUtil.getParametrizedPlaceholder(placeholderName, this.placeholders);
                PlaceholderType resolutionMethod = paramPlaceholder.placeholder.resolutionMethod;
                if (PlaceholderType.PUPPETEER.equals((Object)resolutionMethod) || PlaceholderType.JSON_TABLE.equals((Object)resolutionMethod)) {
                    throw new IOException("The placeholder \"" + placeholderName + "\" cannot be used in a conditional placeholder.");
                }
                filteredNames.add(placeholderName);
            }
            catch (IOException e) {
                String errorTitle = placeholderName + " couldn't be resolved";
                String errorDetails = "Cause: " + e.getMessage();
                messages.addMessage(InfoMessage.warning((String)errorTitle, (String)errorDetails));
                logger.warn((Object)errorTitle, (Throwable)e);
            }
        }
        return new PlaceholderNames(filteredNames);
    }

    private ResolvedPlaceholder<?> resolvePlaceholder(ParametrizedPlaceholder paramPlaceholder, FullModelId fmi, ModelDetailsBase model, MLTask mlTask, DocumentContext documentContext, AuthCtx authCtx, InfoMessage.InfoMessages messages) throws IOException {
        Placeholder placeholder = paramPlaceholder.placeholder;
        switch (placeholder.resolutionMethod) {
            case JSON_TEXT: {
                return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, placeholder.resolutionMethod, (String)placeholder.extractValue(documentContext, model));
            }
            case JSON_TABLE: {
                return new ResolvedPlaceholder.ResolvedPlaceholderTable(placeholder.placeholderName, placeholder.resolutionMethod, (List)placeholder.extractValue(documentContext, model));
            }
            case PUPPETEER: {
                return this.resolvePuppeteer(paramPlaceholder, fmi, model, mlTask);
            }
            case URL: {
                return this.resolveURL(placeholder, fmi, mlTask, messages);
            }
            case USER_INFO: {
                return this.resolveUserInfo(placeholder, authCtx);
            }
            case ANALYSIS_INFO: {
                return this.resolveAnalysisInfo(placeholder, fmi, mlTask);
            }
            case ML_TASKS_INFO: {
                return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, mlTask.name);
            }
            case FILE_INFO: {
                return this.resolveFileInfo(placeholder, fmi, documentContext, model, mlTask);
            }
            case MLFLOW_MODEL_VERSION_INFO_FIELD: {
                return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, placeholder.resolutionMethod, (String)placeholder.extractMlFlowModelVersionInfoValue(fmi.getMLflowImportedModelMetadata()));
            }
            case MLFLOW_MODEL_VERSION_INFO_TABLE: {
                return new ResolvedPlaceholder.ResolvedPlaceholderTable(placeholder.placeholderName, placeholder.resolutionMethod, (List)placeholder.extractMlFlowModelVersionInfoValue(fmi.getMLflowImportedModelMetadata()));
            }
        }
        throw new IOException("Type '" + String.valueOf((Object)placeholder.resolutionMethod) + "' is not a supported placeholder type.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResolvedPlaceholder<String> resolveURL(Placeholder placeholder, FullModelId fmi, MLTask mlTask, InfoMessage.InfoMessages messages) throws IOException {
        boolean unsupportedLinkOnSavedModel = false;
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            String rootUrl = UrlUtil.getDSSExternalRootUrl(generalSettings);
            if (rootUrl == null) {
                messages.addMessage(this.noExternalUrlDefinedWarningMessage(placeholder));
                rootUrl = UrlUtil.getDSSLocalhostRootUrl();
            }
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            if (fmi.isExternalMLflowModelVersion()) {
                ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, this.getProjectLinkForSMV(rootUrl, fmi));
                return resolvedPlaceholderString;
            }
            OriginAnalysisDetails originAnalysisDetails = new OriginAnalysisDetails(fmi, mlTask);
            if (Placeholder.RESULT_FULL_LOGS_LINK.equals((Object)placeholder)) {
                String analysisId = originAnalysisDetails.analysisId;
                String mlTaskId = originAnalysisDetails.mlTaskId;
                String sessionId = originAnalysisDetails.sessionId;
                if (fmi.type == FullModelId.Type.SAVED && !this.analysisCRUDService.exists(fmi.getProjectKey(), analysisId)) {
                    unsupportedLinkOnSavedModel = true;
                    throw new IOException("Placeholder \"result.full_logs.link\" is not supported for a saved model without visual analysis");
                }
                ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, new HrefContext(rootUrl).logPage(fmi.getProjectKey(), analysisId, mlTaskId, sessionId, originAnalysisDetails.fmi.getPreprocessingId(), originAnalysisDetails.fmi.getModelId()));
                return resolvedPlaceholderString;
            }
            ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, this.getProjectLink(rootUrl, fmi, originAnalysisDetails));
            return resolvedPlaceholderString;
        }
        catch (IOException e) {
            if (unsupportedLinkOnSavedModel) {
                throw e;
            }
            String errorMsg = "Cannot retrieve the URL of the server containing DSS";
            logger.warn((Object)errorMsg, (Throwable)e);
            throw new IOException(errorMsg, e);
        }
    }

    private InfoMessage noExternalUrlDefinedWarningMessage(Placeholder placeholder) {
        String errorTitle = "DSS external URL not defined";
        String errorDetails = String.format("The placeholder %s has been resolved using DSS internal URL as the external URL has not been defined in the settings. Please ask your administrator to configure it in Administration > Settings > Notifications & Integrations", placeholder.placeholderName);
        return InfoMessage.warning((String)errorTitle, (String)errorDetails);
    }

    private String getProjectLink(String rootUrl, FullModelId fmi, OriginAnalysisDetails originAnalysisDetails) throws IOException {
        if (fmi.type == FullModelId.Type.SAVED) {
            return this.getProjectLinkForSMV(rootUrl, fmi);
        }
        return new HrefContext(rootUrl).analysisReport(fmi.getProjectKey(), originAnalysisDetails.analysisId, fmi.getHeadMLTask().taskType, originAnalysisDetails.mlTaskId, originAnalysisDetails.sessionId, fmi.getPreprocessingId(), fmi.getModelId(), null);
    }

    private String getProjectLinkForSMV(String rootUrl, FullModelId fmi) throws IOException {
        return new HrefContext(rootUrl).savedModelReport(fmi.getProjectKey(), fmi.getSavedModelID(), fmi.getSavedModelVersionID(), fmi.getHeadMLTask().taskType, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResolvedPlaceholder<String> resolveUserInfo(Placeholder placeholder, AuthCtx authCtx) throws IOException {
        try {
            if (Placeholder.CONFIG_AUTHOR_NAME.equals((Object)placeholder)) {
                try (Transaction t = this.transactionService.beginRead();){
                    ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, this.usersService.getPublicUser((String)authCtx.getAssociatedDSSUser()).displayName);
                    return resolvedPlaceholderString;
                }
            }
            try (Transaction t = this.transactionService.beginRead();){
                String email = this.usersService.getPublicUser((String)authCtx.getAssociatedDSSUser()).email;
                if (StringUtils.isNotBlank((String)email)) {
                    ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, this.usersService.getPublicUser((String)authCtx.getAssociatedDSSUser()).email);
                    return resolvedPlaceholderString;
                }
                ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, "no email");
                return resolvedPlaceholderString;
            }
        }
        catch (IOException e) {
            String errorMsg = "Cannot retrieve user information for placeholder \"" + placeholder.placeholderName + "\".";
            logger.warn((Object)errorMsg, (Throwable)e);
            throw new IOException(errorMsg);
        }
    }

    private ResolvedPlaceholder<String> resolveAnalysisInfo(Placeholder placeholder, FullModelId fmi, MLTask mlTask) throws IOException {
        ResolvedPlaceholder.ResolvedPlaceholderString resolvedPlaceholderString;
        block8: {
            Transaction t = this.transactionService.beginRead();
            try {
                String analysisId = new OriginAnalysisDetails((FullModelId)fmi, (MLTask)mlTask).analysisId;
                AnalysisCoreParams params = this.analysisCRUDService.getCoreMandatoryUnsafe(fmi.getProjectKey(), analysisId);
                resolvedPlaceholderString = new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, params.name);
                if (t == null) break block8;
            }
            catch (Throwable analysisId) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable) {
                            analysisId.addSuppressed(throwable);
                        }
                    }
                    throw analysisId;
                }
                catch (IOException e) {
                    String errorMsg = "Cannot retrieve analysis information for placeholder " + placeholder.placeholderName + ".";
                    logger.warn((Object)errorMsg, (Throwable)e);
                    throw new IOException(errorMsg);
                }
            }
            t.close();
        }
        return resolvedPlaceholderString;
    }

    private ResolvedPlaceholder<String> resolveFileInfo(Placeholder placeholder, FullModelId fmi, DocumentContext documentContext, ModelDetailsBase model, MLTask mlTask) throws IOException {
        if (fmi.type == FullModelId.Type.ANALYSIS) {
            String analysisName = "";
            try (Transaction t = this.transactionService.beginRead();){
                String analysisId = new OriginAnalysisDetails((FullModelId)fmi, (MLTask)mlTask).analysisId;
                AnalysisCoreParams params = this.analysisCRUDService.getCoreMandatoryUnsafe(fmi.getProjectKey(), analysisId);
                analysisName = params.name;
            }
            return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, MDGFileUtil.getDocumentFilename(fmi, analysisName, documentContext, model));
        }
        return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, MDGFileUtil.getDocumentFilename(fmi));
    }

    private ResolvedPlaceholder<?> resolvePuppeteer(ParametrizedPlaceholder paramPlaceholder, FullModelId fmi, ModelDetailsBase model, MLTask mlTask) throws IOException {
        Placeholder placeholder = paramPlaceholder.placeholder;
        if ((Placeholder.DESIGN_OTHER_ALGORITHMS_SEARCH_STRATEGY_IMAGE.equals((Object)placeholder) || Placeholder.DESIGN_OTHER_ALGORITHMS_SEARCH_STRATEGY_TABLE.equals((Object)placeholder)) && PlaceholderUtil.countActiveAlgorithm(mlTask) < 2) {
            return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, "The analysis contains only one activated algorithm.");
        }
        PuppeteerConfig puppeteerConfig = placeholder.getPuppeteerConfig(mlTask, model);
        if (PuppeteerConfig.INVALID.equals((Object)puppeteerConfig)) {
            throw new IOException("The placeholder {{" + placeholder.placeholderName + "}} is not supported with this algorithm.");
        }
        if ((placeholder.equals((Object)Placeholder.DESIGN_TRAIN_SET_IMAGE) || placeholder.equals((Object)Placeholder.DESIGN_TEST_SET_IMAGE)) && (model.splitDesc == null || model.splitDesc.params == null || SplitParams.TrainTestPolicy.SPLIT_SINGLE_DATASET.equals((Object)model.splitDesc.params.ttPolicy))) {
            return new ResolvedPlaceholder.ResolvedPlaceholderString(placeholder.placeholderName, PlaceholderType.JSON_TEXT, "");
        }
        DomElementsExport.Target targetElement = new DomElementsExport.Target();
        targetElement.puppeteerConfigName = puppeteerConfig.name();
        targetElement.placeholderName = placeholder.placeholderName;
        targetElement.stepList = PuppeteerConfigResolver.getStepList(puppeteerConfig, model, paramPlaceholder.parameterValue);
        targetElement.fmi = fmi;
        targetElement.doctorPage = puppeteerConfig.doctorPage;
        targetElement.routeSuffix = puppeteerConfig.routeSuffix;
        Object fullName = placeholder.placeholderName;
        if (placeholder.isParametrized && paramPlaceholder.parameterValue != null) {
            fullName = (String)fullName + "/" + paramPlaceholder.parameterValue;
            String generatedString = RandomStringUtils.randomAlphanumeric((int)12);
            targetElement.puppeteerConfigName = targetElement.puppeteerConfigName + "_" + generatedString;
        }
        return new ResolvedPlaceholder.ResolvedPlaceholderPuppeteer((String)fullName, placeholder.resolutionMethod, targetElement);
    }

    private String resolvePuppeteerPlaceholders(List<ResolvedPlaceholder<?>> resolvedPlaceholders, String rootUrl, FullModelId fmi, AuthCtx authCtx, InfoMessage.InfoMessages messages) throws Exception {
        ArrayList<DomElementsExport.Target> puppeteerPlaceholders = new ArrayList<DomElementsExport.Target>();
        for (ResolvedPlaceholder<?> r : resolvedPlaceholders) {
            if (r.type != PlaceholderType.PUPPETEER) continue;
            puppeteerPlaceholders.add((DomElementsExport.Target)r.value);
        }
        if (!puppeteerPlaceholders.isEmpty()) {
            DomElementsExport export = this.domElementsExportService.buildExport(rootUrl, fmi.getProjectKey(), puppeteerPlaceholders, messages);
            FutureResponse futureResponse = this.domElementsExportService.export(authCtx, export);
            futureResponse = this.futureService.waitForFinalResponse(futureResponse);
            return ((ExportResult)futureResponse.result).exportId;
        }
        return null;
    }

    public String getOutputFileName(FullModelId fmi) throws IOException {
        if (fmi.type == FullModelId.Type.ANALYSIS) {
            MLTask mlTask = fmi.getHeadMLTask();
            ModelDetailsBase model = ModelDetailsBaseUtil.getModel(mlTask, fmi);
            DocumentContext documentContext = ModelDetailsBaseUtil.getDocumentContext(model);
            String analysisName = "";
            try (Transaction t = this.transactionService.beginRead();){
                String analysisId = new OriginAnalysisDetails((FullModelId)fmi, (MLTask)mlTask).analysisId;
                AnalysisCoreParams params = this.analysisCRUDService.getCoreMandatoryUnsafe(fmi.getProjectKey(), analysisId);
                analysisName = params.name;
            }
            return MDGFileUtil.getDocumentFilename(fmi, analysisName, documentContext, model);
        }
        return MDGFileUtil.getDocumentFilename(fmi);
    }
}

