/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelInfo;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeployment;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.KerasModelTrainingInfo;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelPerf;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.core.SavedModelOriginInfo;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelPredictionInfos;
import com.dataiku.dip.analysis.model.prediction.ColumnImportance;
import com.dataiku.dip.analysis.model.prediction.DataEvaluationMetrics;
import com.dataiku.dip.analysis.model.prediction.DeepHubPredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.MulticlassModelPerf;
import com.dataiku.dip.analysis.model.prediction.OtherClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelExtract;
import com.dataiku.dip.analysis.model.prediction.PerTimeSeriesMetrics;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelFeaturesDistribution;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPredictionInfos;
import com.dataiku.dip.analysis.model.prediction.RegressionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPredictionInfos;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.mec.engine.CSVSchemaAdapter;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.partitioning.StratifiedModelUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.savedmodels.agents.LoadedCustomAgent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.base.Preconditions;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FullModelId
extends ModelLikeId {
    public static final String POSTTRAIN_SUBFOLDER = "posttrain";
    public static final String ASSERTION_PARAMS_FILENAME = "rassertions.json";
    public static final String OVERRIDES_PARAMS_FILENAME = "roverrides.json";
    public static final String SMO_FILENAME = "sm_origin.json";
    private static final String MODEL_TRAIN_INFO_FILENAME = "train_info.json";
    private static final String PARTS_FILE_BASE_FILENAME = "parts.json";
    private static final String LLM_INFO_FILENAME = "llm_info.json";
    private static final String USER_META_FILENAME = "user_meta.json";
    private static final int TIMESERIES_EVALUATION_FORECASTS_SNIPPET_MAX_ENTRIES = 1000;
    private static final String ACTUAL_PARAMS_FILENAME = "actual_params.json";
    public final Type type;
    private final MLTaskLoc taskLoc;
    protected final String smId;
    protected final String smVersionId;
    private final String sessionId;
    private final String preprocessingId;
    private final String modelId;
    protected final String partitionName;
    protected final String partitionVersion;
    private static final Pattern SAVED_MODEL_VERSIONID_PATTERN = Pattern.compile("^\\w+$");
    public static final Pattern SAVED_MODEL_PATTERN = Pattern.compile("^S-(?<projectKey>\\w+)-(?<savedModelId>\\w+)-(?<versionId>\\w+)(?:-part-(?<partitionName>\\w+)-(?<partitionVersion>v?\\d+))?$");
    public static final Pattern SMART_SAVED_MODEL_PATTERN = Pattern.compile("^S-\\*-(?<savedModelId>\\w+)-(?<versionId>\\w+)(?:-part-(?<partitionName>\\w+)-(?<partitionVersion>v?\\d+))?$");
    public static final Pattern ANALYSIS_PPS_PATTERN = Pattern.compile("(?<ppsId>pp[0-9]+(?:-part-(?<partitionName>\\w+)|-base)?)");
    public static final Pattern ANALYSIS_PATTERN = Pattern.compile("^A-(?<projectKey>\\w+)-(?<analysisId>\\w+)-(?<mlTaskId>\\w+)-(?<sessionId>s[0-9]+)-" + ANALYSIS_PPS_PATTERN.pattern() + "-(?<modelId>m[0-9]+)$");
    public static final Pattern SMART_ANALYSIS_PATTERN = Pattern.compile("^A-\\*-(?<analysisId>\\w+)-(?<mlTaskId>\\w+)-(?<sessionId>s[0-9]+)-" + ANALYSIS_PPS_PATTERN.pattern() + "-(?<modelId>m[0-9]+)$");
    private static final Pattern PREPROCESSING_ID_PATTERN = Pattern.compile("^(?<id>pp[0-9]+)");
    private transient Map<String, String> partitionToVersion;
    private transient PartitionedModelExtract extract;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.fullmodelid");

    @Override
    public String getId() {
        return this.smId;
    }

    protected static FullModelId parseSavedModelId(String fullRunId) {
        Matcher matcher = SAVED_MODEL_PATTERN.matcher(fullRunId);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid saved model id: " + fullRunId);
        }
        if (StringUtils.isNotBlank((String)matcher.group("partitionName")) && StringUtils.isNotBlank((String)matcher.group("partitionVersion"))) {
            String partitionName = PartitioningUtils.decode(matcher.group("partitionName"));
            return new FullModelId(matcher.group("projectKey"), matcher.group("savedModelId"), matcher.group("versionId"), partitionName, matcher.group("partitionVersion"));
        }
        return new FullModelId(matcher.group("projectKey"), matcher.group("savedModelId"), matcher.group("versionId"));
    }

    protected static FullModelId parseSmartSavedModelId(String smartFullId, String contextProjectKey) {
        if (StringUtils.isEmpty((String)contextProjectKey)) {
            throw new Error("Smart id expected, but no contextProjectKey provided. Can not parse " + smartFullId);
        }
        Matcher matcher = SMART_SAVED_MODEL_PATTERN.matcher(smartFullId);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid smart saved model id: " + smartFullId);
        }
        if (StringUtils.isNotBlank((String)matcher.group("partitionName")) && StringUtils.isNotBlank((String)matcher.group("partitionVersion"))) {
            String partitionName = PartitioningUtils.decode(matcher.group("partitionName"));
            return new FullModelId(contextProjectKey, matcher.group("savedModelId"), matcher.group("versionId"), partitionName, matcher.group("partitionVersion"));
        }
        return new FullModelId(contextProjectKey, matcher.group("savedModelId"), matcher.group("versionId"));
    }

    protected static FullModelId parseAnalysisId(String fullRunId) {
        Matcher matcher = ANALYSIS_PATTERN.matcher(fullRunId);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid analysis model id " + fullRunId);
        }
        MLTaskLoc tl = new MLTaskLoc(matcher.group("projectKey"), matcher.group("analysisId"), matcher.group("mlTaskId"));
        return new FullModelId(tl, matcher.group("sessionId"), matcher.group("ppsId"), matcher.group("modelId"));
    }

    protected static FullModelId parseSmartAnalysisId(String smartFullId, String contextProjectKey) {
        if (StringUtils.isEmpty((String)contextProjectKey)) {
            throw new Error("Smart id expected, but no contextProjectKey provided. Can not parse " + smartFullId);
        }
        Matcher matcher = SMART_ANALYSIS_PATTERN.matcher(smartFullId);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid analysis model id " + smartFullId);
        }
        MLTaskLoc tl = new MLTaskLoc(contextProjectKey, matcher.group("analysisId"), matcher.group("mlTaskId"));
        return new FullModelId(tl, matcher.group("sessionId"), matcher.group("ppsId"), matcher.group("modelId"));
    }

    public static FullModelId parse(String fullRunId) {
        if (fullRunId.startsWith("S")) {
            return FullModelId.parseSavedModelId(fullRunId);
        }
        if (fullRunId.startsWith("A")) {
            return FullModelId.parseAnalysisId(fullRunId);
        }
        throw new IllegalArgumentException("Invalid model id " + fullRunId);
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getUnderlyingStore() {
        if (Type.SAVED == this.type) {
            return new TaggableObjectsService.TaggableObjectRef(this.projectKey, ITaggingService.TaggableType.SAVED_MODEL, this.smId);
        }
        return new TaggableObjectsService.TaggableObjectRef(this.taskLoc.analysisProjectKey, ITaggingService.TaggableType.ANALYSIS, this.taskLoc.analysisId);
    }

    public FullModelId getModelPartition(String partitionName) throws IOException {
        if (this.type == Type.ANALYSIS) {
            return this.getAnalysisModelPartition(partitionName);
        }
        return this.getSMModelPartition(partitionName, this.getPartitionVersionId(partitionName));
    }

    private FullModelId getAnalysisModelPartition(String partitionName) {
        assert (this.type == Type.ANALYSIS);
        String newPpsId = String.format("%s%s", this.extractPreprocessingId(), StratifiedModelUtils.generatePartitionSuffix(partitionName));
        return new FullModelId(this.taskLoc, this.sessionId, newPpsId, this.modelId);
    }

    public FullModelId getSMModelPartition(String partitionName, String partitionVersionId) {
        assert (this.type == Type.SAVED);
        return new FullModelId(this.projectKey, this.smId, this.smVersionId, partitionName, partitionVersionId);
    }

    public FullModelId getPartitionedBaseModel() {
        if (this.type == Type.ANALYSIS) {
            String newPpsId = String.format("%s%s", this.extractPreprocessingId(), "-base");
            return new FullModelId(this.taskLoc, this.sessionId, newPpsId, this.modelId);
        }
        return new FullModelId(this.projectKey, this.smId, this.smVersionId);
    }

    private String extractPreprocessingId() {
        Matcher idMatcher = PREPROCESSING_ID_PATTERN.matcher(this.preprocessingId);
        if (!idMatcher.find()) {
            throw new IllegalArgumentException("FullModelId has incorrect preprocessingId: " + this.preprocessingId);
        }
        return idMatcher.group("id");
    }

    public static String extractAnalysisId(String fullModelId) {
        Matcher idMatcher = ANALYSIS_PATTERN.matcher(fullModelId);
        if (!idMatcher.find()) {
            throw new IllegalArgumentException("Cannot extract analysis ID from " + fullModelId);
        }
        return idMatcher.group("analysisId");
    }

    public void checkIdsValidity(String enforceProjectKey) throws DKUSecurityException {
        if (this.taskLoc != null) {
            this.taskLoc.checkIdsValidity(enforceProjectKey);
        }
        if (enforceProjectKey != null && !enforceProjectKey.equals(this.getProjectKey())) {
            throw new DKUSecurityException("Model must be within project " + enforceProjectKey + ", but was in " + this.getProjectKey());
        }
        DKUFileUtils.checkNoPossibleEscape((String)this.projectKey, (String)"smProjectKey");
        DKUFileUtils.checkNoPossibleEscape((String)this.smId, (String)"smId");
        DKUFileUtils.checkNoPossibleEscape((String)this.smVersionId, (String)"smVersionId");
        DKUFileUtils.checkNoPossibleEscape((String)this.sessionId, (String)"sessionId");
        DKUFileUtils.checkNoPossibleEscape((String)this.preprocessingId, (String)"preprocessingId");
        DKUFileUtils.checkNoPossibleEscape((String)this.modelId, (String)"modelId");
    }

    private void checkVersionId(String versionId) {
        if (versionId == null) {
            throw new IllegalArgumentException("No version (null) specified as active for Saved Model " + this.smId);
        }
        Matcher modelIdMatcher = SAVED_MODEL_VERSIONID_PATTERN.matcher(versionId);
        if (!modelIdMatcher.find()) {
            throw new IllegalArgumentException("Invalid model version id " + versionId);
        }
    }

    public FullModelId(MLTaskLoc taskLoc, String sessionId, String preprocessingId, String modelId) {
        super(null, ModelLikeId.ModelLikeType.DOCTOR_MODEL);
        this.type = Type.ANALYSIS;
        this.taskLoc = (MLTaskLoc)Preconditions.checkNotNull((Object)taskLoc);
        this.sessionId = sessionId;
        this.modelId = modelId;
        this.preprocessingId = preprocessingId;
        Matcher matcher = ANALYSIS_PPS_PATTERN.matcher(preprocessingId);
        this.partitionName = matcher.matches() && StringUtils.isNotBlank((String)matcher.group("partitionName")) ? PartitioningUtils.decode(matcher.group("partitionName")) : null;
        this.smId = null;
        this.smVersionId = null;
        this.partitionVersion = null;
    }

    public FullModelId(String projectKey, String smId, String versionId, String partitionName, String partitionVersion) {
        super(projectKey, ModelLikeId.ModelLikeType.DOCTOR_MODEL);
        this.checkVersionId(versionId);
        this.type = Type.SAVED;
        this.smId = smId;
        this.smVersionId = versionId;
        this.partitionName = partitionName;
        this.partitionVersion = partitionVersion;
        this.sessionId = null;
        this.preprocessingId = null;
        this.modelId = null;
        this.taskLoc = null;
    }

    public FullModelId(String projectKey, String smId, String versionId) {
        super(projectKey, ModelLikeId.ModelLikeType.DOCTOR_MODEL);
        this.type = Type.SAVED;
        this.checkVersionId(versionId);
        this.smVersionId = versionId;
        this.smId = smId;
        this.taskLoc = null;
        this.sessionId = null;
        this.preprocessingId = null;
        this.modelId = null;
        this.partitionName = null;
        this.partitionVersion = null;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        if (this.type == Type.ANALYSIS) {
            return String.format("A-%s-%s-%s-%s-%s-%s", this.taskLoc.analysisProjectKey, this.taskLoc.analysisId, this.taskLoc.mlTaskId, this.sessionId, this.preprocessingId, this.modelId);
        }
        if (this.type == Type.SAVED) {
            Object smVersion = this.smVersionId;
            if (StringUtils.isNotBlank((String)this.partitionName)) {
                smVersion = (String)smVersion + StratifiedModelUtils.generatePartitionSuffix(this.partitionName, this.partitionVersion);
            }
            return String.format("S-%s-%s-%s", this.projectKey, this.smId, smVersion);
        }
        throw new Error("Unreachable");
    }

    @Override
    public String getProjectKey() {
        if (this.type == Type.ANALYSIS) {
            return this.taskLoc.analysisProjectKey;
        }
        if (this.type == Type.SAVED) {
            return this.projectKey;
        }
        throw new Error("Unreachable");
    }

    public MLTaskLoc getTaskLoc() {
        assert (this.type == Type.ANALYSIS);
        return this.taskLoc;
    }

    public String getSessionId() {
        assert (this.type == Type.ANALYSIS);
        return this.sessionId;
    }

    public String getSavedModelProjectKey() {
        return this.projectKey;
    }

    public String getSavedModelID() {
        return this.smId;
    }

    public String getSavedModelVersionID() {
        return this.smVersionId;
    }

    public String getPartitionVersion() {
        return this.partitionVersion;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public boolean isModelPartition() {
        return StringUtils.isNotBlank((String)this.partitionName);
    }

    public boolean isPartitionedBaseModel() {
        if (this.type == Type.ANALYSIS) {
            return StringUtils.isBlank((String)this.partitionName) && StringUtils.endsWith((String)this.preprocessingId, (String)"-base");
        }
        return this.getPartFile().exists();
    }

    public PartitionedModelExtract getPartitionedModelExtract() throws IOException {
        assert (this.isPartitionedBaseModel()) : "Expected partitioned base model";
        if (this.extract == null) {
            PartitionedModelExtract tmpExtract = FullModelId.parsePossiblyCompressedJsonFile(this.getPartFile(), PartitionedModelExtract.class);
            for (Map.Entry<String, PartitionedModelExtract.PartitionedModelSummary> entry : tmpExtract.summaries.entrySet()) {
                String partitionName = entry.getKey();
                PartitionedModelExtract.PartitionedModelSummary summary = entry.getValue();
                summary.snippet.fullModelId = (switch (this.type) {
                    case Type.ANALYSIS -> this.getAnalysisModelPartition(partitionName);
                    case Type.SAVED -> this.getSMModelPartition(partitionName, tmpExtract.versions.get(partitionName));
                    default -> throw new IllegalArgumentException("Unreachable");
                }).toString();
            }
            this.extract = tmpExtract;
        }
        return this.extract;
    }

    @Transient
    public Map<String, String> getPartitionToVersion() throws IOException {
        if (this.partitionToVersion == null) {
            assert (this.type == Type.SAVED) : "Expected saved model";
            if (this.isModelPartition()) {
                this.partitionToVersion = this.getPartitionedBaseModel().getPartitionedModelExtract().versions;
            } else if (this.isPartitionedBaseModel()) {
                this.partitionToVersion = this.getPartitionedModelExtract().versions;
            } else {
                throw new IllegalArgumentException("Expected partitioned model, was " + this.toString());
            }
        }
        return this.partitionToVersion;
    }

    @Transient
    private String getPartitionVersionId(String partitionName) throws IOException {
        return this.getPartitionToVersion().get(partitionName);
    }

    @Transient
    public Set<String> listTrainedPartitions() throws IOException {
        if (!this.isPartitionedBaseModel()) {
            return null;
        }
        if (this.type == Type.SAVED) {
            return this.getPartitionToVersion().keySet();
        }
        if (this.type == Type.ANALYSIS) {
            HashSet<String> partitions = new HashSet<String>();
            for (Map.Entry<String, PartitionedModelExtract.PartitionedModelSummary> entry : this.getPartitionedModelExtract().summaries.entrySet()) {
                if (!entry.getValue().state.isUsable()) continue;
                partitions.add(entry.getKey());
            }
            return partitions;
        }
        throw new Error("Unreachable");
    }

    @Transient
    public Map<String, FullModelId> getPartitionsFmis() throws IOException {
        if (!this.isPartitionedBaseModel()) {
            throw new IllegalArgumentException("Can only get partitions fmis for a partitioned base model");
        }
        Set<String> partitionsNames = this.listTrainedPartitions();
        return partitionsNames.stream().collect(Collectors.toMap(Function.identity(), name -> {
            try {
                return this.getModelPartition((String)name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Transient
    public Map<String, String> getPartitionsFmiStrings() throws IOException {
        return this.getPartitionsFmis().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FullModelId)entry.getValue()).toString()));
    }

    @Override
    @Transient
    public File getMainFolder() {
        return this.getModelFolder();
    }

    @Override
    @Transient
    public File getFolderEnsuringSecurity() {
        if (this.type == Type.ANALYSIS) {
            return this.taskLoc.getDataFolder();
        }
        if (this.type == Type.SAVED) {
            return MLPaths.savedModelBaseFolder(this.projectKey, this.smId);
        }
        throw new Error("Unreachable");
    }

    @Transient
    public File getModelFolder() {
        if (this.type == Type.ANALYSIS) {
            return MLPaths.modelFolder(this.taskLoc, this.sessionId, this.preprocessingId, this.modelId);
        }
        if (this.type == Type.SAVED) {
            if (this.isModelPartition()) {
                String encodedPartitionName = PartitioningUtils.encode(this.partitionName);
                return MLPaths.savedModelPartVersionFolder(this.projectKey, this.smId, encodedPartitionName, this.partitionVersion);
            }
            return MLPaths.savedModelVersionFolder(this.projectKey, this.smId, this.smVersionId);
        }
        throw new Error("Unreachable");
    }

    @Transient
    public File getPartitionModelFolder(String partitionName) throws IOException {
        switch (this.type) {
            case ANALYSIS: {
                return MLPaths.modelFolder(this.taskLoc, this.sessionId, this.preprocessingId, this.modelId);
            }
            case SAVED: {
                String encodedPartitionName = PartitioningUtils.encode(partitionName);
                String partitionVersionId = this.getPartitionVersionId(partitionName);
                if (partitionVersionId == null) {
                    throw new IllegalArgumentException("No saved model partition associated with partition " + partitionName);
                }
                return MLPaths.savedModelPartVersionFolder(this.projectKey, this.smId, encodedPartitionName, partitionVersionId);
            }
        }
        throw new Error("Unreachable");
    }

    @Transient
    public Map<String, File> getPartitionModelFolders() throws IOException {
        assert (this.type == Type.SAVED) : "Expected saved model";
        HashMap<String, File> partitionToModelFolder = new HashMap<String, File>();
        for (Map.Entry<String, String> entry : this.getPartitionToVersion().entrySet()) {
            String partition = entry.getKey();
            String partVersion = entry.getValue();
            String encodedPartitionName = PartitioningUtils.encode(partition);
            File partModelFolder = MLPaths.savedModelPartVersionFolder(this.projectKey, this.smId, encodedPartitionName, partVersion);
            partitionToModelFolder.put(partition, partModelFolder);
        }
        return partitionToModelFolder;
    }

    @Transient
    public Map<String, URL> getPartitionModelUrls() throws IOException {
        HashMap<String, URL> partitionToUrl = new HashMap<String, URL>();
        for (Map.Entry<String, File> entry : this.getPartitionModelFolders().entrySet()) {
            partitionToUrl.put(entry.getKey(), entry.getValue().toURI().toURL());
        }
        return partitionToUrl;
    }

    @Transient
    public File getPreprocessingFolder() {
        if (this.type == Type.ANALYSIS) {
            return this.getModelFolder().getParentFile();
        }
        if (this.type == Type.SAVED) {
            return this.getModelFolder();
        }
        throw new Error("Unreachable");
    }

    @Override
    @Transient
    public File getSessionFolder() {
        if (this.type == Type.ANALYSIS) {
            return this.getPreprocessingFolder().getParentFile();
        }
        if (this.type == Type.SAVED) {
            return this.getModelFolder();
        }
        throw new Error("Unreachable");
    }

    private File getNotScoredSampleFile() throws IOException {
        if (!this.isExternalMLflowModelVersion()) {
            SplitDesc splitDesc = this.getSplitDesc();
            String splitFileName = splitDesc.params.kfold ? splitDesc.fullPath : splitDesc.testPath;
            return this.getSplitFile(splitFileName);
        }
        return this.getModelFile("sample.csv.gz");
    }

    @Override
    public boolean hasDataToStreamCSV() throws IOException {
        File notScoredSampleFile = this.getNotScoredSampleFile();
        return notScoredSampleFile != null && notScoredSampleFile.isFile() && notScoredSampleFile.canRead();
    }

    @Override
    public void streamDataCSV(OutputStream out) throws Exception {
        File file = this.getNotScoredSampleFile();
        logger.info((Object)("Streaming sample data from " + String.valueOf(file)));
        try (InputStream sampleData = this.openDataInputStreamCSV();){
            CSVSchemaAdapter.transformCSV(sampleData, this.getNonScoredSchema(), false, this.getDataSchema(), out);
        }
    }

    public InputStream openDataInputStreamCSV() throws Exception {
        return new GZIPInputStream(new FileInputStream(this.getNotScoredSampleFile()));
    }

    @Override
    public Schema getDataSchema() throws IOException {
        File notScoredSampleFile = this.getNotScoredSampleFile();
        if (notScoredSampleFile == null || !notScoredSampleFile.isFile()) {
            return null;
        }
        Schema schema = this.getNonScoredSchema();
        Schema outSchema = (Schema)JSON.deepCopy((Object)schema);
        String targetName = this.getResolvedPredictionPreprocessingParams().getTarget();
        outSchema.removeColumn(targetName);
        return outSchema;
    }

    public boolean isExternalMLflowModelVersion() {
        return this.hasReadableModelFile("mlflow_imported_model.json");
    }

    public boolean isFinetunedLLMSavedModel() {
        return this.hasReadableModelFile(LLM_INFO_FILENAME);
    }

    public boolean isAgentLLMSavedModel() throws IOException {
        SavedModel sm = this.getSavedModel();
        if (sm == null) {
            return false;
        }
        return sm.savedModelType.isAgent();
    }

    public boolean isRetrievalAugmentedLLMSavedModel() throws IOException {
        SavedModel sm = this.getSavedModel();
        if (sm == null) {
            return false;
        }
        return sm.savedModelType.isRetrievalAugmentedLlm();
    }

    private SavedModel getSavedModel() throws IOException {
        SavedModel sm;
        if (this.type != Type.SAVED) {
            return null;
        }
        SavedModelsDAO smDAO = (SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class);
        if (TransactionContext.hasAttachedTransaction()) {
            sm = (SavedModel)smDAO.getOrNullUnsafe(this.getSavedModelProjectKey(), this.getSavedModelID());
        } else {
            try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
                sm = (SavedModel)smDAO.getOrNullUnsafe(this.getSavedModelProjectKey(), this.getSavedModelID());
            }
        }
        return sm;
    }

    public MLFlowModelVersionInfo getMLflowImportedModelMetadata() throws IOException {
        return this.parseModelFile("mlflow_imported_model.json", MLFlowModelVersionInfo.class);
    }

    @Nullable
    public String getOriginalPythonCodeEnvName() throws IOException {
        return this.getMLflowImportedModelMetadata().pythonCodeEnvName;
    }

    public void writeMLflowImportedModelMetadata(MLFlowModelVersionInfo metadata) throws IOException {
        File f = this.getModelFile("mlflow_imported_model.json");
        JSON.prettyToFile((Object)metadata, (File)f);
    }

    public File getPredictionFile() {
        return this.getModelFile("predicted.csv");
    }

    public File getClusteredFile() {
        return this.getModelFile("clustered.csv");
    }

    @Nullable
    public PredictionModelFeaturesDistribution getFeaturesDistribution() throws IOException {
        File file = this.getModelFile("features_distribution.json");
        if (file.isFile()) {
            return (PredictionModelFeaturesDistribution)JSON.parseFile((File)file, PredictionModelFeaturesDistribution.class);
        }
        return null;
    }

    @Override
    @Nullable
    public ColumnImportance getColumnImportance() throws IOException {
        File file = this.getModelFile("column_importance.json");
        if (file.isFile()) {
            return (ColumnImportance)JSON.parseFile((File)file, ColumnImportance.class);
        }
        return null;
    }

    @Override
    public void streamPredictedCSV(OutputStream out) throws Exception {
        Schema predictedSchema = this.getPredictedSchema();
        try (FileInputStream sampleData = new FileInputStream(this.getPredictionFile());){
            CSVSchemaAdapter.transformCSV(sampleData, predictedSchema, true, predictedSchema, out);
        }
    }

    @Override
    public Schema getPredictedSchema() throws IOException {
        File predictionFile = this.getPredictionFile();
        return FullModelId.getSchema(predictionFile);
    }

    public Schema getClusteredSchema() throws IOException {
        File clusteredFile = this.getClusteredFile();
        return FullModelId.getSchema(clusteredFile);
    }

    private static Schema getSchema(File modelFile) throws IOException {
        if (!modelFile.isFile()) {
            return null;
        }
        Schema schema = new Schema();
        try (FileInputStream inputStream = new FileInputStream(modelFile);){
            InputStreamLineReader lineReader = new InputStreamLineReader((InputStream)inputStream, StandardCharsets.UTF_8);
            RFC4180CSVParser csvParser = new RFC4180CSVParser((LineReader)lineReader, '\t');
            ArrayList<String> columns = new ArrayList<String>();
            csvParser.next(columns);
            for (String column : columns) {
                schema.addColumn(column, com.dataiku.dip.datasets.Type.STRING);
            }
        }
        return schema;
    }

    @Override
    @Transient
    public File getPostOperationsFolder() {
        return DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{POSTTRAIN_SUBFOLDER});
    }

    public boolean checkModelFileExists(String file) {
        return DKUFileUtils.exists((File)this.getModelFolder(), (String[])new String[]{file});
    }

    public File getModelFile(String file) {
        return DKUFileUtils.getWithinFollowLink((File)this.getModelFolder(), (String[])new String[]{file});
    }

    public File getPossiblyCompressedModelFile(String file) {
        return DKUFileUtils.getWithAutoDecompress((File)this.getModelFile(file));
    }

    @Transient
    public File getPreprocessingFile(String file) {
        return DKUFileUtils.getWithinFollowLink((File)this.getPreprocessingFolder(), (String[])new String[]{file});
    }

    @Transient
    public String getPreprocessingId() {
        return this.preprocessingId;
    }

    @Transient
    public String getModelId() {
        return this.modelId;
    }

    public boolean hasReadableSessionFile(String file) {
        File sessionFile = this.getSessionFile(file);
        return sessionFile.isFile() && sessionFile.canRead();
    }

    @Transient
    public File getSessionFile(String file) {
        return DKUFileUtils.getWithinFollowLink((File)this.getSessionFolder(), (String[])new String[]{file});
    }

    @Transient
    public boolean hasReadableModelFile(String file) {
        File modelFile = this.getModelFile(file);
        return modelFile.isFile() && modelFile.canRead();
    }

    @Transient
    public <T> T parseModelFile(String file, Class<T> clazz) throws IOException {
        return FullModelId.parseJsonFile(this.getModelFile(file), clazz);
    }

    @Transient
    public <T> T parsePreprocessingFile(String file, Class<T> clazz) throws IOException {
        return FullModelId.parseJsonFile(this.getPreprocessingFile(file), clazz);
    }

    @Transient
    public <T> T parseSessionFile(String file, Class<T> clazz) throws IOException {
        return FullModelId.parseJsonFile(this.getSessionFile(file), clazz);
    }

    @Transient
    public <T> T parseGridsearchScoresFile(Class<T> clazz) throws IOException {
        return FullModelId.parseJsonFile(this.getGridsearchScoresFile(), clazz);
    }

    @Transient
    public KerasModelTrainingInfo parseKerasModelTrainingInfoFile() throws IOException {
        return FullModelId.parseJsonFile(this.getKerasModelTrainingInfoFile(), KerasModelTrainingInfo.class);
    }

    @Transient
    public KerasModelTrainingInfo parseDeepHubModelTrainingInfoFile() throws IOException {
        return FullModelId.parseJsonFile(this.getDeepHubModelTrainingInfoFile(), KerasModelTrainingInfo.class);
    }

    @Transient
    public <T> T parsePossiblyCompressedModelFile(String file, Class<T> clazz) throws IOException {
        return FullModelId.parsePossiblyCompressedJsonFile(this.getModelFile(file), clazz);
    }

    public <T> void saveModelFile(T value, String file) throws IOException {
        JSON.prettyToFile(value, (File)this.getModelFile(file));
    }

    @Transient
    public File getStopSearchFile() {
        return this.getModelFile("stop_search");
    }

    @Transient
    public boolean hasSearchStopped() {
        return this.getStopSearchFile().exists();
    }

    @Transient
    public File getModelInfoFile() {
        return this.getModelFile(MODEL_TRAIN_INFO_FILENAME);
    }

    public Optional<ModelTrainInfo> getTrainModelInfo() {
        if (this.hasReadableModelFile(MODEL_TRAIN_INFO_FILENAME)) {
            try {
                return Optional.of(FullModelId.parseJsonFile(this.getModelInfoFile(), ModelTrainInfo.class));
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Could not read train info file of model: %s", this), (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public void saveModelTrainInfo(ModelTrainInfo mti) throws IOException {
        this.saveModelFile(mti, MODEL_TRAIN_INFO_FILENAME);
    }

    public Optional<ActualModelParameters> getActualModelParameters() {
        if (this.hasReadableModelFile(ACTUAL_PARAMS_FILENAME)) {
            try {
                return Optional.of(FullModelId.parseJsonFile(this.getModelFile(ACTUAL_PARAMS_FILENAME), ActualModelParameters.class));
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Could not read actual model parameters file of model: %s", this), (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public String getAlgorithmName() {
        Optional<ActualModelParameters> actualModelParametersOpt = this.getActualModelParameters();
        if (actualModelParametersOpt.isPresent()) {
            return actualModelParametersOpt.get().resolved.getAlgorithmName();
        }
        Optional<ModelUserMeta> userMetaOpt = this.getUserMetaOpt();
        if (userMetaOpt.isPresent()) {
            for (SimpleKeyValue label : userMetaOpt.get().labels) {
                if (!label.key.equals("model:algorithm")) continue;
                return label.value;
            }
        }
        return null;
    }

    public String getAlgorithmSlug() {
        String name = this.getAlgorithmName();
        if (name == null) {
            return null;
        }
        return name.replace(" | ", "__").replaceAll("[^0-9a-zA-Z_-]", "-");
    }

    @Transient
    public File getGridsearchScoresFile() {
        return this.getModelFile("grid_search_scores.json");
    }

    @Transient
    @Nullable
    public SplitDesc.SplitRef getSplitRef() throws IOException {
        File splitRefPath;
        File file = splitRefPath = this.isModelPartition() ? this.getPreprocessingFile("split_ref.json") : this.getSessionFile("split_ref.json");
        if (splitRefPath.exists()) {
            return FullModelId.parseJsonFile(splitRefPath, SplitDesc.SplitRef.class);
        }
        return null;
    }

    @Transient
    public File getKerasModelTrainingInfoFile() {
        return this.getModelFile("keras_model_training_info.json");
    }

    @Transient
    public File getDeepHubModelTrainingInfoFile() {
        return this.getModelFile("deephub_model_info_handler.json");
    }

    @Transient
    public File getLLMStepwiseTrainingMetricsFile() {
        return this.getModelFile("llm_stepwise_training_metrics.json");
    }

    @Transient
    public File getLLMDeploymentFile() {
        return this.getModelFile("deployment.json");
    }

    public void writeLLMSavedModelDeployment(LLMSavedModelVersionDeployment deployment) throws IOException {
        File f = this.getLLMDeploymentFile();
        JSON.prettyToFile((Object)deployment, (File)f);
    }

    @Override
    public boolean hasResolvedCoreParams() {
        if (this.isExternalMLflowModelVersion()) {
            return true;
        }
        File f = this.getSessionFile("core_params.json");
        return f.isFile() && f.canRead();
    }

    @Override
    public ResolvedCoreParams getResolvedCoreParams() throws IOException {
        if (this.isExternalMLflowModelVersion()) {
            return this.getMLflowImportedModelMetadata().getMinimalClassicalPredictionCoreParams();
        }
        return this.parseSessionFile("core_params.json", ResolvedCoreParams.class);
    }

    @Override
    public File getCollectorDataFile() throws IOException {
        return this.getPreprocessingFile("collector_data.json");
    }

    @Override
    @Transient
    public File getSubpopulationFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getPostOperationsFolder(), (String[])new String[]{"subpop.json"});
    }

    @Override
    public File getPredictionStatisticsFile() {
        return this.getModelFile("prediction_statistics.json");
    }

    @Override
    public boolean hasPredictionStatisticsFile() {
        File predictionStatisticsFile = this.getPredictionStatisticsFile();
        return predictionStatisticsFile.isFile() && predictionStatisticsFile.canRead();
    }

    @Transient
    public File getPartFile() {
        return this.getPossiblyCompressedModelFile(PARTS_FILE_BASE_FILENAME);
    }

    public void savePartFile(PartitionedModelExtract pme) throws IOException {
        File partFile = this.getPartFile().exists() ? this.getPartFile() : this.getModelFile("parts.json.gz");
        JSON.prettyToFileAutoCompress((Object)pme, (File)partFile);
    }

    @Transient
    public File getAssertionsFile() {
        return this.getModelFile(ASSERTION_PARAMS_FILENAME);
    }

    @Transient
    public MLAssertionsParams getAssertionsParams() throws IOException {
        return FullModelId.parseJsonFile(this.getAssertionsFile(), MLAssertionsParams.class);
    }

    @Transient
    public File getOverridesFile() {
        return this.getModelFile(OVERRIDES_PARAMS_FILENAME);
    }

    @Transient
    public MLOverridesParams getOverridesParams() throws IOException {
        return FullModelId.parseJsonFile(this.getOverridesFile(), MLOverridesParams.class);
    }

    @Transient
    public boolean hasOverrides() throws IOException {
        if (!this.getOverridesFile().isFile()) {
            return false;
        }
        return this.getOverridesParams().hasOverrides();
    }

    @Override
    public File getSplitFolder() {
        if (this.getType() == Type.ANALYSIS) {
            return this.getTaskLoc().getSplitsFolder();
        }
        if (this.isExternalMLflowModelVersion()) {
            return this.getModelFolder();
        }
        return this.getModelFile("split");
    }

    @Nullable
    public File getSplitDescFile() throws IOException {
        File splits = this.getSplitFolder();
        if (this.getType() == Type.ANALYSIS) {
            SplitDesc.SplitRef splitRef = this.getSplitRef();
            if (splitRef == null) {
                return null;
            }
            return DKUFileUtils.getWithinFollowLink((File)splits, (String[])new String[]{splitRef.splitInstanceId + ".json"});
        }
        return DKUFileUtils.getWithinFollowLink((File)splits, (String[])new String[]{"split.json"});
    }

    @Override
    public SplitDesc getSplitDesc() throws IOException {
        if (this.isExternalMLflowModelVersion()) {
            return new SplitDesc();
        }
        return (SplitDesc)JSON.parseFile((File)this.getSplitDescFile(), SplitDesc.class);
    }

    public File getSplitFile(String splitFileName) {
        if (splitFileName == null) {
            return null;
        }
        return DKUFileUtils.getWithinFollowLink((File)this.getSplitFolder(), (String[])new String[]{splitFileName});
    }

    @Override
    public int hashCode() {
        if (this.type == Type.ANALYSIS) {
            return Objects.hash(this.getTaskLoc(), this.sessionId, this.preprocessingId, this.modelId, this.partitionName);
        }
        if (this.type == Type.SAVED) {
            return Objects.hash(this.projectKey, this.smVersionId, this.smId, this.partitionName, this.partitionVersion);
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FullModelId other = (FullModelId)object;
        if (this.type != other.type) {
            return false;
        }
        if (this.type == Type.ANALYSIS) {
            return this.getTaskLoc().equals(other.getTaskLoc()) && this.sessionId.equals(other.getSessionId()) && this.preprocessingId.equals(other.getPreprocessingId()) && this.modelId.equals(other.getModelId()) && StringUtils.equals((String)this.partitionName, (String)other.partitionName);
        }
        if (this.type == Type.SAVED) {
            return this.projectKey.equals(other.getSavedModelProjectKey()) && this.smVersionId.equals(other.getSavedModelVersionID()) && this.smId.equals(other.getSavedModelID()) && StringUtils.equals((String)this.partitionName, (String)other.partitionName) && StringUtils.equals((String)this.partitionVersion, (String)other.partitionVersion);
        }
        throw new Error("unreachable");
    }

    public ModelUserMeta getUserMeta() throws IOException {
        return this.parseModelFile(USER_META_FILENAME, ModelUserMeta.class);
    }

    public Optional<ModelUserMeta> getUserMetaOpt() {
        if (this.hasReadableModelFile(USER_META_FILENAME)) {
            try {
                return Optional.of(this.getUserMeta());
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Could not read user meta file of model: %s", this), (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public void saveUserMeta(ModelUserMeta mum) throws IOException {
        this.saveModelFile(mum, USER_META_FILENAME);
    }

    public MLTask getHeadMLTask() throws IOException {
        if (this.type == Type.ANALYSIS) {
            AnalysisCRUDService service = (AnalysisCRUDService)SpringUtils.getBean(AnalysisCRUDService.class);
            MLTask trainedWith = this.parseSessionFile("mltask.json", MLTask.class);
            if (TransactionContext.hasAttachedTransaction()) {
                return this.getCorrespondingMlTask(service, trainedWith);
            }
            try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
                MLTask mLTask = this.getCorrespondingMlTask(service, trainedWith);
                return mLTask;
            }
        }
        if (this.type == Type.SAVED) {
            SavedModel sm;
            SavedModelsDAO smDAO = (SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class);
            if (TransactionContext.hasAttachedTransaction()) {
                sm = (SavedModel)smDAO.getMandatory(this.getSavedModelProjectKey(), this.getSavedModelID());
            } else {
                try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
                    sm = (SavedModel)smDAO.getMandatory(this.getSavedModelProjectKey(), this.getSavedModelID());
                    sm.miniTask.name = sm.name;
                }
            }
            return sm.miniTask;
        }
        throw new Error("unreachable");
    }

    private MLTask getCorrespondingMlTask(AnalysisCRUDService service, MLTask trainedWith) throws IOException {
        if (trainedWith.taskType == MLTask.MLTaskType.PREDICTION) {
            return service.getPMLTask(this.getTaskLoc());
        }
        if (trainedWith.taskType == MLTask.MLTaskType.CLUSTERING) {
            return service.getCMLTask(this.getTaskLoc());
        }
        throw new Error("unreachable");
    }

    public MLTask getTrainedWithMLTask() throws IOException {
        if (this.type == Type.ANALYSIS) {
            return this.parseSessionFile("mltask.json", MLTask.class);
        }
        throw new NotImplementedException("Unhandled model type: " + String.valueOf((Object)this.type));
    }

    public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(CodeEnvModel.EnvUsage usageType) throws IOException {
        if (this.isExternalMLflowModelVersion()) {
            return this.collectMLflowCodeEnvUsage(usageType);
        }
        return this.collectDSSManagedCodeEnvUsage(usageType);
    }

    public List<CodeEnvModel.CodeEnvUsage> collectMLflowCodeEnvUsage(CodeEnvModel.EnvUsage usageType) throws IOException {
        ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
        usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.getMLflowImportedModelMetadata().pythonCodeEnvName, usageType, this.getProjectKey(), this.toString()));
        return usages;
    }

    @Nullable
    public ContainerExecSelection getContainerSelection() throws IOException {
        if (this.isExternalMLflowModelVersion()) {
            return null;
        }
        if (this.isAgentLLMSavedModel()) {
            SavedModel sm = this.getSavedModel();
            if (sm == null) {
                return null;
            }
            SavedModel.SavedModelInlineVersion smiv = sm.getActiveSaveModelInlineVersion();
            if (smiv == null) {
                return null;
            }
            SavedModel.AgentSettings settings = smiv.getAgentSettings(sm.savedModelType);
            if (settings == null) {
                return null;
            }
            return settings.containerExecSelection;
        }
        if (this.type == Type.ANALYSIS) {
            ModelTrainInfo info = this.parseModelFile(MODEL_TRAIN_INFO_FILENAME, ModelTrainInfo.class);
            if (!ModelTrainInfo.ModelTrainState.DONE.equals((Object)info.state)) {
                return null;
            }
        }
        if (!this.getSessionFolder().exists()) {
            logger.info((Object)("Files for model '" + this.toString() + "' do not exist, cannot collect contain-exec usages"));
            return null;
        }
        return this.getResolvedCoreParams().getContainerSelection();
    }

    private boolean isModelTrainDone() {
        return this.getTrainModelInfo().filter(info -> info.state == ModelTrainInfo.ModelTrainState.DONE).isPresent();
    }

    public boolean isModelUsable() {
        switch (this.getType()) {
            case ANALYSIS: {
                return this.isModelTrainDone();
            }
            case SAVED: {
                if (this.isFinetunedLLMSavedModel()) {
                    return true;
                }
                if (this.isExternalMLflowModelVersion()) {
                    return true;
                }
                if (this.isModelPartition()) {
                    return this.isModelTrainDone();
                }
                return this.hasReadableModelFile(SMO_FILENAME);
            }
        }
        throw new IllegalArgumentException("Unreachable");
    }

    public List<CodeEnvModel.CodeEnvUsage> collectDSSManagedCodeEnvUsage(CodeEnvModel.EnvUsage usageType) throws IOException {
        ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
        if (this.type == Type.ANALYSIS) {
            ModelTrainInfo info = this.parseModelFile(MODEL_TRAIN_INFO_FILENAME, ModelTrainInfo.class);
            if (!ModelTrainInfo.ModelTrainState.DONE.equals((Object)info.state)) {
                return usages;
            }
        }
        if (this.isAgentLLMSavedModel()) {
            String codeEnvName = null;
            SavedModel sm = this.getSavedModel();
            block0 : switch (sm.savedModelType) {
                case PYTHON_AGENT: {
                    String activeVersion = sm.getActiveVersion();
                    if (sm.inlineVersions.isEmpty() || StringUtils.isBlank((String)activeVersion)) {
                        return usages;
                    }
                    for (SavedModel.SavedModelInlineVersion version : sm.inlineVersions) {
                        if (!Objects.equals(version.versionId, activeVersion)) continue;
                        codeEnvName = new CodeEnvSelector().selectForPythonRecipe(sm.projectKey, version.pythonAgentSettings.codeEnvSelection);
                        break block0;
                    }
                    break;
                }
                case PLUGIN_AGENT: {
                    if (sm.inlineVersions.isEmpty()) {
                        return usages;
                    }
                    CustomAgentMeta meta = AgentTypesRegistry.getMeta(sm.inlineVersions.get((int)0).pluginAgentType);
                    LoadedCustomAgent desc = (LoadedCustomAgent)meta.getLoadedDesc();
                    codeEnvName = new CodeEnvSelector().getCodeEnvNameForPlugin(desc.ownerPluginId);
                    break;
                }
                case TOOLS_USING_AGENT: {
                    SavedModel.SavedModelInlineVersion activeSmiv = sm.getActiveSaveModelInlineVersion();
                    codeEnvName = activeSmiv != null && activeSmiv.toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH ? new CodeEnvSelector().selectForAdvancedLLMAgent(sm.projectKey, activeSmiv.toolsUsingAgentSettings.codeEnvSelection) : new CodeEnvSelector().selectForLLMAgent();
                    if (!StringUtils.equals((String)codeEnvName, (String)"__BUILTIN_ENV__")) break;
                    codeEnvName = "";
                }
            }
            if (StringUtils.isNotBlank(codeEnvName)) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, codeEnvName, usageType, this.getProjectKey(), this.toString()));
            }
            return usages;
        }
        if (!this.getSessionFolder().exists()) {
            logger.info((Object)("Files for model '" + this.toString() + "' do not exist, cannot collect code-env usages"));
            return usages;
        }
        usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.getResolvedCoreParams().executionParams.envName, usageType, this.getProjectKey(), this.toString()));
        return usages;
    }

    public static String analysisPrefix(String projectKey, String analysisId) {
        return "A-" + projectKey + "-" + analysisId + "-";
    }

    @Override
    public Map<String, FeaturePreprocessingParams> getFeatures() throws IOException {
        return this.getResolvedPredictionPreprocessingParams().per_feature;
    }

    @Override
    public boolean hasResolvedPreprocessingParams() {
        File f = this.getPreprocessingFile("rpreprocessing_params.json");
        return f.isFile() && f.canRead();
    }

    @Override
    public ResolvedPreprocessingParams getResolvedPreprocessingParams() throws IOException {
        if (this.isExternalMLflowModelVersion()) {
            return this.getMLflowImportedModelMetadata().getMinimalClassicalPredictionPreprocessingParams();
        }
        return (ResolvedPreprocessingParams)JSON.parseFile((File)this.getPreprocessingFile("rpreprocessing_params.json"), ResolvedPreprocessingParams.class);
    }

    public void savePreprocessingParams(ResolvedPreprocessingParams resolvedPreprocessingParams) throws IOException {
        JSON.prettyToFile((Object)resolvedPreprocessingParams, (File)this.getPreprocessingFile("rpreprocessing_params.json"));
    }

    @Override
    public MLTask.BackendType getBackendType() throws IOException {
        return this.getResolvedCoreParams().backendType;
    }

    @Override
    public PredictionMLTask.PredictionType getPredictionType() throws IOException {
        return ((ResolvedPredictionCoreParams)this.getResolvedCoreParams()).prediction_type;
    }

    @Override
    public FullModelId getUnderlyingModel() throws IOException {
        return this;
    }

    @Override
    public FuturePayload buildPostComputationFuturePayload() {
        FuturePayload fp = new FuturePayload();
        fp.action = "postraining-computation";
        fp.targets.add(DSSFuturePayloadUtils.forFMI(this).withPart("post-training-computation"));
        fp.displayName = "Post training computation";
        return fp;
    }

    @Override
    public ComputeResourceUsageContext getComputeResourceUsageContext(DSSAuthCtx owner) {
        switch (this.type) {
            case ANALYSIS: {
                return ComputeResourceUsageContext.forAnalysisMLTrain((AuthCtx)owner, (String)this.taskLoc.analysisProjectKey, (String)this.taskLoc.analysisId, (String)this.taskLoc.mlTaskId, (String)this.getSessionId());
            }
            case SAVED: {
                return ComputeResourceUsageContext.forSavedMLOperation((AuthCtx)owner, (String)this.getSavedModelProjectKey(), (String)this.getSavedModelID(), (String)this.getSavedModelVersionID());
            }
        }
        throw new NotImplementedException("Unknown model type");
    }

    public Schema getNonScoredSchema() throws IOException {
        if (!this.isExternalMLflowModelVersion()) {
            SplitDesc splitDesc = ResultsReaderBase.readSplitDesc(this);
            return splitDesc.schema;
        }
        File file = this.getModelFile("sample_schema.json");
        if (file.isFile()) {
            return (Schema)JSON.parseFile((File)file, Schema.class);
        }
        return null;
    }

    public Optional<ClusteringModelPerf> getClusteringPerf() throws IOException {
        assert (this.getHeadMLTask().taskType == MLTask.MLTaskType.CLUSTERING);
        File resultsFile = FullModelId.getResultsFile(this.getModelFolder());
        if (!resultsFile.exists()) {
            return Optional.empty();
        }
        return Optional.of(FullModelId.parseJsonFile(resultsFile, ClusteringModelPerf.class));
    }

    public Optional<PredictionModelPerf> getClassicalPredictionPerf() throws IOException {
        PredictionMLTask.PredictionType predictionType = this.getPredictionType();
        assert (predictionType == PredictionMLTask.PredictionType.REGRESSION || predictionType == PredictionMLTask.PredictionType.MULTICLASS || predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION);
        File perfFile = FullModelId.getPerfFile(this.getModelFolder());
        if (!perfFile.exists()) {
            return Optional.empty();
        }
        return Optional.of(FullModelId.getClassicalPredictionPerf(this.getModelFolder(), this.getPredictionType()));
    }

    public Optional<? extends DeepHubPredictionModelPerf> getDeepHubPredictionPerf() throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION || this.getPredictionType() == PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_CLASSIFICATION);
        return FullModelId.getDeepHubPredictionPerf(this.getModelFolder());
    }

    public ClassificationModelPredictionInfos getDeepHubPredictionStatistics() throws IOException {
        PredictionMLTask.PredictionType predictionType = this.getPredictionType();
        if (predictionType != PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION && predictionType != PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_CLASSIFICATION) {
            throw new IllegalArgumentException("Unexpected prediction type: " + String.valueOf((Object)predictionType));
        }
        return (ClassificationModelPredictionInfos)FullModelId.getPredictionStatistics(this.getModelFolder(), this.getPredictionType());
    }

    public static Optional<? extends DeepHubPredictionModelPerf> getDeepHubPredictionPerf(File modelFolder) throws IOException {
        File perfFile = FullModelId.getPerfFile(modelFolder);
        if (!perfFile.exists()) {
            return Optional.empty();
        }
        return Optional.of(FullModelId.parseJsonFile(perfFile, DeepHubPredictionModelPerf.class));
    }

    public CausalPredictionModelPerf getCausalPredictionPerf() throws IOException {
        assert (EnumSet.of(PredictionMLTask.PredictionType.CAUSAL_REGRESSION, PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION).contains((Object)this.getPredictionType()));
        return FullModelId.getCausalPredictionPerf(this.getModelFolder());
    }

    public static CausalPredictionModelPerf getCausalPredictionPerf(File modelFolder) throws IOException {
        return FullModelId.parseJsonFile(FullModelId.getPerfFile(modelFolder), CausalPredictionModelPerf.class);
    }

    public TimeseriesForecastingModelPerf getTimeseriesForecastingPerf() throws IOException {
        return this.getTimeseriesForecastingPerf(false);
    }

    public TimeseriesForecastingModelPerf getTimeseriesForecastingPerf(boolean withPerTimeseriesMetrics) throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        TimeseriesForecastingModelPerf modelPerf = FullModelId.getTimeseriesForecastingPerf(this.getModelFolder());
        if (!withPerTimeseriesMetrics) {
            modelPerf.perTimeseriesMetrics = new HashMap<String, TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics>();
        }
        return modelPerf;
    }

    public Map<String, PerTimeSeriesMetrics> getPartitionedTimeseriesForecastingPerfs() throws IOException {
        assert (this.getPartitionedBaseModel().isPartitionedBaseModel());
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        HashMap<String, PerTimeSeriesMetrics> ret = new HashMap<String, PerTimeSeriesMetrics>();
        for (FullModelId partitionedFmi : this.getPartitionsFmis().values()) {
            PerTimeSeriesMetrics perTimeSeriesMetrics = new PerTimeSeriesMetrics(partitionedFmi.getTimeseriesForecastingPerf(true));
            ret.put(partitionedFmi.partitionName, perTimeSeriesMetrics);
        }
        return ret;
    }

    public TimeseriesForecastingModelPerf getIndividualFoldTimeseriesForecastingPerf(int perfId) throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        return FullModelId.parsePossiblyCompressedJsonFile(FullModelId.getFoldPerfFile(this.getModelFolder(), perfId), TimeseriesForecastingModelPerf.class);
    }

    public static TimeseriesForecastingModelPerf getTimeseriesForecastingPerf(File modelFolder) throws IOException {
        return FullModelId.parsePossiblyCompressedJsonFile(FullModelId.getPerfFile(modelFolder), TimeseriesForecastingModelPerf.class);
    }

    public TimeseriesForecastingModelIntrinsicPerf getTimeseriesForecastingIPerf() throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        return (TimeseriesForecastingModelIntrinsicPerf)FullModelId.getPredictionIntrinsicPerf(this.getModelFolder(), PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
    }

    public static TimeseriesForecastingModelIntrinsicPerf getTimeseriesForecastingIPerf(File modelFolder) throws IOException {
        return (TimeseriesForecastingModelIntrinsicPerf)FullModelId.getPredictionIntrinsicPerf(modelFolder, PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
    }

    public TimeseriesEvaluationForecasts getTimeseriesEvaluationForecasts() throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        return this.parsePossiblyCompressedModelFile("forecasts.json", TimeseriesEvaluationForecasts.class);
    }

    public Map<String, TimeseriesEvaluationForecasts> getPartitionedTimeseriesEvaluationForecasts() throws IOException {
        assert (this.getPartitionedBaseModel().isPartitionedBaseModel());
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        HashMap<String, TimeseriesEvaluationForecasts> ret = new HashMap<String, TimeseriesEvaluationForecasts>();
        for (FullModelId partitionedFmi : this.getPartitionsFmis().values()) {
            TimeseriesEvaluationForecasts perTimeSeriesEvaluationForecasts = partitionedFmi.getTimeseriesEvaluationForecasts();
            ret.put(partitionedFmi.partitionName, perTimeSeriesEvaluationForecasts);
        }
        return ret;
    }

    public TimeseriesEvaluationForecasts getTimeseriesEvaluationForecastsForSnippet() throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        File oneForecastFile = this.getModelFile("one_forecast.json");
        TimeseriesEvaluationForecasts evaluationForecasts = oneForecastFile.exists() ? FullModelId.parseJsonFile(oneForecastFile, TimeseriesEvaluationForecasts.class) : TimeseriesEvaluationForecasts.keepFirstTimeseries(this.getTimeseriesEvaluationForecasts());
        FullModelId.computeHorizonStep(evaluationForecasts);
        FullModelId.clipTimeseriesEvaluationForecastsForSnippet(evaluationForecasts);
        return evaluationForecasts;
    }

    public LLMSavedModelInfo getLlmSavedModelInfo() throws IOException {
        assert (this.isFinetunedLLMSavedModel());
        return this.parseModelFile(LLM_INFO_FILENAME, LLMSavedModelInfo.class);
    }

    public void saveLLMInfo(LLMSavedModelInfo llmSmi) throws IOException {
        this.saveModelFile(llmSmi, LLM_INFO_FILENAME);
    }

    @Override
    public DataEvaluationMetrics getDataEvaluationMetrics() {
        return null;
    }

    private static PredictionModelPerf parseClassicalPredictionPerfFile(File perfFile, PredictionMLTask.PredictionType predictionType) throws IOException {
        if (null == predictionType) {
            return FullModelId.parseJsonFile(perfFile, OtherClassificationModelPerf.class);
        }
        switch (predictionType) {
            case BINARY_CLASSIFICATION: {
                return FullModelId.parseJsonFile(perfFile, BinaryClassificationModelPerf.class);
            }
            case MULTICLASS: {
                return FullModelId.parseJsonFile(perfFile, MulticlassModelPerf.class);
            }
            case REGRESSION: {
                RegressionModelPerf perf = FullModelId.parseJsonFile(perfFile, RegressionModelPerf.class);
                if (perf.metrics != null && perf.metrics.mape != null && (perf.metrics.mape.isInfinite() || perf.metrics.mape.isNaN())) {
                    perf.metrics.mape = null;
                }
                return perf;
            }
        }
        throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)predictionType));
    }

    public static PredictionModelPerf getClassicalPredictionPerfWithoutOverrides(File baseFolder, PredictionMLTask.PredictionType predictionType) throws IOException {
        File perfFile = FullModelId.getPerfWithoutOverridesFile(baseFolder);
        return FullModelId.parseClassicalPredictionPerfFile(perfFile, predictionType);
    }

    public static PredictionModelPerf getClassicalPredictionPerf(File baseFolder, PredictionMLTask.PredictionType predictionType) throws IOException {
        File perfFile = FullModelId.getPerfFile(baseFolder);
        return FullModelId.parseClassicalPredictionPerfFile(perfFile, predictionType);
    }

    public static PredictionModelPredictionInfos getPredictionStatistics(File baseFolder, PredictionMLTask.PredictionType predictionType) throws IOException {
        return FullModelId.getPredictionStatistics(baseFolder, predictionType, "prediction_statistics.json");
    }

    public static PredictionModelPredictionInfos getReferencePredictionStatistics(File baseFolder, PredictionMLTask.PredictionType predictionType) throws IOException {
        return FullModelId.getPredictionStatistics(baseFolder, predictionType, "drift_reference_prediction_statistics.json");
    }

    private static PredictionModelPredictionInfos getPredictionStatistics(File baseFolder, PredictionMLTask.PredictionType predictionType, String filename) throws IOException {
        if (predictionType == null) {
            throw new IllegalArgumentException("No prediction statistics for null prediction type.");
        }
        File predictionFile = DKUFileUtils.getWithinFollowLink((File)baseFolder, (String[])new String[]{filename});
        switch (predictionType) {
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: 
            case DEEP_HUB_IMAGE_OBJECT_DETECTION: 
            case DEEP_HUB_IMAGE_CLASSIFICATION: {
                return FullModelId.parseJsonFile(predictionFile, ClassificationModelPredictionInfos.class);
            }
            case REGRESSION: {
                return FullModelId.parseJsonFile(predictionFile, RegressionModelPredictionInfos.class);
            }
        }
        throw new IllegalArgumentException("No prediction statistics for: " + String.valueOf((Object)predictionType));
    }

    private static File getPerfFile(File baseFolder) {
        return DKUFileUtils.getWithinFollowLink((File)baseFolder, (String[])new String[]{"perf.json"});
    }

    private static File getFoldPerfFile(File baseFolder, int foldId) {
        String fold = "fold_" + foldId;
        return DKUFileUtils.getWithinFollowLink((File)baseFolder, (String[])new String[]{fold, "perf.json"});
    }

    public static File getPerfWithoutOverridesFile(File baseFolder) {
        return DKUFileUtils.getWithinFollowLink((File)baseFolder, (String[])new String[]{"perf_without_overrides.json"});
    }

    private static File getResultsFile(File baseFolder) {
        return DKUFileUtils.getWithinFollowLink((File)baseFolder, (String[])new String[]{"results.json"});
    }

    public static PredictionModelIntrinsicPerf getPredictionIntrinsicPerf(File baseFolder, PredictionMLTask.PredictionType predictionType) throws IOException {
        File perfFile = DKUFileUtils.getWithinFollowLink((File)baseFolder, (String[])new String[]{"iperf.json"});
        switch (predictionType) {
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: {
                return FullModelId.parseJsonFile(perfFile, ClassificationModelIntrinsicPerf.class);
            }
            case REGRESSION: {
                return FullModelId.parseJsonFile(perfFile, RegressionModelIntrinsicPerf.class);
            }
            case DEEP_HUB_IMAGE_OBJECT_DETECTION: 
            case DEEP_HUB_IMAGE_CLASSIFICATION: {
                return null;
            }
            case TIMESERIES_FORECAST: {
                return FullModelId.parseJsonFile(perfFile, TimeseriesForecastingModelIntrinsicPerf.class);
            }
        }
        throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)predictionType));
    }

    public SavedModelOriginInfo getSmOrigin() throws IOException {
        assert (Type.SAVED.equals((Object)this.type));
        SavedModelOriginInfo smOriginInfo = FullModelId.parseJsonFile(this.getSmOriginFile(), SavedModelOriginInfo.class);
        if (smOriginInfo.fullModelId == null) {
            return smOriginInfo;
        }
        FullModelId updatedFmi = FullModelId.buildFmiWithEnforcedProjectKey(smOriginInfo.fullModelId, this.getProjectKey());
        smOriginInfo.fullModelId = updatedFmi.toString();
        return smOriginInfo;
    }

    public static FullModelId buildFmiWithEnforcedProjectKey(String fmiStr, String projectKey) {
        FullModelId tmpFmi = FullModelId.parse(fmiStr);
        switch (tmpFmi.getType()) {
            case SAVED: {
                return new FullModelId(projectKey, tmpFmi.getSavedModelID(), tmpFmi.getSavedModelVersionID(), tmpFmi.partitionName, tmpFmi.partitionVersion);
            }
            case ANALYSIS: {
                MLTaskLoc mlTaskLoc = new MLTaskLoc(projectKey, tmpFmi.getTaskLoc().analysisId, tmpFmi.getTaskLoc().mlTaskId);
                return new FullModelId(mlTaskLoc, tmpFmi.getSessionId(), tmpFmi.getPreprocessingId(), tmpFmi.getModelId());
            }
        }
        throw new IllegalArgumentException("Unsupported FullModelId type: " + String.valueOf((Object)tmpFmi.getType()));
    }

    public void saveSmOriginFromAnalysis(File targetFolder) throws IOException {
        assert (this.type == Type.ANALYSIS);
        SavedModelOriginInfo smo = new SavedModelOriginInfo();
        smo.origin = SavedModelOriginInfo.Origin.EXPORTED_FROM_ANALYSIS;
        smo.fullModelId = this.toString();
        JSON.prettyToFile((Object)smo, (File)FullModelId.getSmOriginFile(targetFolder));
    }

    public static File getSmOriginFile(File targetFolder) {
        return DKUFileUtils.getWithinFollowLink((File)targetFolder, (String[])new String[]{SMO_FILENAME});
    }

    public File getSmOriginFile() {
        return FullModelId.getSmOriginFile(this.getModelFolder());
    }

    public String getAnalysisModelId() {
        assert (Type.ANALYSIS == this.type);
        return String.format("%s-%s-%s-%s-%s", this.taskLoc.analysisId, this.taskLoc.mlTaskId, this.sessionId, this.preprocessingId, this.modelId);
    }

    public AnyLoc getAnalysisModelLoc() {
        return new AnyLoc(this.taskLoc.analysisProjectKey, this.getAnalysisModelId());
    }

    @Override
    public Set<String> getUsedConnections() throws IOException {
        HashSet<String> s = new HashSet<String>();
        if (this.type == Type.ANALYSIS) {
            s.addAll(this.getTrainedWithMLTask().getUsedConnections());
        }
        if (this.isFinetunedLLMSavedModel()) {
            s.add(this.getLlmSavedModelInfo().connection);
        } else if (this.isAgentLLMSavedModel() || this.isRetrievalAugmentedLLMSavedModel()) {
            s.addAll(this.getSavedModel().getLlmConnections());
        } else {
            s.addAll(this.getResolvedPreprocessingParams().getUsedConnections());
        }
        if (this.type == Type.SAVED && this.isPartitionedBaseModel()) {
            for (FullModelId partitionedFmi : this.getSMPartitionsFmis()) {
                s.addAll(partitionedFmi.getUsedConnections());
            }
        }
        return s;
    }

    @Override
    public boolean remapAndSaveConnections(Map<String, String> replacements) throws IOException {
        MLTask mlTask;
        boolean replaced = false;
        if (this.type == Type.ANALYSIS && (mlTask = this.getTrainedWithMLTask()).replaceConnections(replacements)) {
            JSON.prettyToFile((Object)mlTask, (File)this.getSessionFile("mltask.json"));
            replaced = true;
        }
        if (this.isFinetunedLLMSavedModel()) {
            LLMSavedModelInfo llmSavedModelInfo = this.getLlmSavedModelInfo();
            if (llmSavedModelInfo.remapConnections(replacements)) {
                this.saveLLMInfo(llmSavedModelInfo);
                replaced = true;
            }
        } else {
            if (this.isAgentLLMSavedModel() || this.isRetrievalAugmentedLLMSavedModel()) {
                return false;
            }
            ResolvedPreprocessingParams preprocessingParams = this.getResolvedPreprocessingParams();
            if (preprocessingParams.remapConnections(replacements)) {
                this.savePreprocessingParams(preprocessingParams);
                replaced = true;
            }
            if (this.type == Type.SAVED && this.isPartitionedBaseModel()) {
                for (FullModelId partitionedFmi : this.getSMPartitionsFmis()) {
                    if (!partitionedFmi.remapAndSaveConnections(replacements)) continue;
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    public Set<FullModelId> getSMPartitionsFmis() throws IOException {
        return this.getSMPartitionsFmis(this.getPartitionToVersion());
    }

    public Set<FullModelId> getSMPartitionsFmis(Map<String, String> partitionsVersions) {
        return partitionsVersions.entrySet().stream().map(entry -> this.getSMModelPartition((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    public String toSmartModelLikeId(String contextProjectKey) {
        if (this.type == Type.ANALYSIS) {
            if (StringUtils.equals((String)contextProjectKey, (String)this.taskLoc.analysisProjectKey)) {
                return String.format("A-*-%s-%s-%s-%s-%s", this.taskLoc.analysisId, this.taskLoc.mlTaskId, this.sessionId, this.preprocessingId, this.modelId);
            }
            return this.toString();
        }
        if (this.type == Type.SAVED) {
            if (StringUtils.equals((String)contextProjectKey, (String)this.projectKey)) {
                Object smVersion = this.smVersionId;
                if (StringUtils.isNotBlank((String)this.partitionName)) {
                    smVersion = (String)smVersion + StratifiedModelUtils.generatePartitionSuffix(this.partitionName, this.partitionVersion);
                }
                return String.format("S-*-%s-%s", this.smId, smVersion);
            }
            return this.toString();
        }
        throw new Error("Unreachable");
    }

    protected static void computeHorizonStep(TimeseriesEvaluationForecasts evaluationForecasts) {
        for (Map.Entry<String, TimeseriesEvaluationForecasts.EvaluationForecasts> stringEvaluationForecastsEntry : evaluationForecasts.perTimeseries.entrySet()) {
            TimeseriesEvaluationForecasts.EvaluationForecasts forecast = stringEvaluationForecastsEntry.getValue();
            List<Integer> foldIds = forecast.foldId;
            ArrayList<Integer> horizonStep = new ArrayList<Integer>();
            int currentStepId = 0;
            for (int index = 0; index < foldIds.size(); ++index) {
                currentStepId = index == 0 || !foldIds.get(index).equals(foldIds.get(index - 1)) ? 1 : ++currentStepId;
                horizonStep.add(currentStepId);
            }
            forecast.horizonStep = horizonStep;
        }
    }

    protected static void clipTimeseriesEvaluationForecastsForSnippet(TimeseriesEvaluationForecasts forecasts) {
        for (Map.Entry<String, TimeseriesEvaluationForecasts.EvaluationForecasts> stringEvaluationForecastsEntry : forecasts.perTimeseries.entrySet()) {
            TimeseriesEvaluationForecasts.EvaluationForecasts forecast = stringEvaluationForecastsEntry.getValue();
            FullModelId.clipList(forecast.groundTruthTime, 1000, false);
            FullModelId.clipList(forecast.forecastTime, 1000, false);
            FullModelId.clipList(forecast.groundTruth, 1000, false);
            FullModelId.clipList(forecast.forecast, 1000, false);
            FullModelId.clipList(forecast.foldId, 1000, false);
            FullModelId.clipList(forecast.horizonStep, 1000, false);
            for (TimeseriesEvaluationForecasts.Quantile quantile : forecast.quantiles) {
                FullModelId.clipList(quantile.forecast, 1000, false);
                FullModelId.clipList(quantile.futureForecast, 1000, true);
            }
            FullModelId.clipList(forecast.futureForecast, 1000, true);
            FullModelId.clipList(forecast.futureTime, 1000, true);
        }
    }

    private static void clipList(List<?> list, int maxSize, boolean keepStart) {
        if (list != null && list.size() > maxSize) {
            if (keepStart) {
                list.subList(maxSize, list.size()).clear();
            } else {
                list.subList(0, list.size() - maxSize).clear();
            }
        }
    }

    public static enum Type {
        ANALYSIS,
        SAVED;

    }
}

