/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.hf;

import com.dataiku.dip.analysis.ml.hf.HuggingFaceClient;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class HuggingFaceClientFactory {
    public HuggingFaceClient getClient(@Nullable String hfApiKey) {
        return new HuggingFaceClient(hfApiKey);
    }

    public HuggingFaceClient getClient(AuthCtx authCtx, String connection) throws DKUSecurityException, IOException {
        DSSConnection conn;
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
            conn = ConnectionsDAO.get().getMandatoryConnection(authCtx, connection);
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new UnauthorizedException("You may not use this connection", "denied");
            }
        }
        ICredentialsService.BasicCredential creds = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ICredentialsService.BasicCredential.class);
        return new HuggingFaceClient(creds.password);
    }
}

