/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.ml.prediction.PredictionMLTaskHandlingStrategy;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.DeepHubParamsExpander;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Collections;
import java.util.Map;

public class DeephubMLTaskHandlingStrategy
implements PredictionMLTaskHandlingStrategy {
    @Override
    public String getDSSMetricName(PredictionMLTask task) {
        assert (!task.isPartitioned());
        return "dku.ml.predictionTrain.deepHubTrain";
    }

    @Override
    public void checkSplit(PredictionMLTask task, SplitDesc splitDesc) {
        if (splitDesc.trainRows == 0L) {
            throw ErrorContext.iae((String)"Train set is empty. Please check your train & validation settings");
        }
        if (splitDesc.testRows == 0L) {
            throw ErrorContext.iae((String)"Test set is empty. Please check your train & validation settings");
        }
    }

    @Override
    public String getPythonFunction(PredictionMLTask task) {
        return "train_prediction_deephub";
    }

    @Override
    public WorkSet expandPredictionParams(PredictionMLTask task, String sessionId) throws Exception {
        return new DeepHubParamsExpander((PredictionMLTask.DeepHubPredictionMLTask)task, sessionId).expand();
    }

    @Override
    public int getThreadCountToRun(PredictionMLTask task) {
        return 1;
    }

    @Override
    public Map<String, String> getForcedEnvVars() {
        return Collections.emptyMap();
    }
}

