/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PredictionPostComputationHandler;
import com.dataiku.dip.analysis.ml.prediction.PythonPostComputationHandler;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PythonPostTrainComputationHandler
extends PythonPostComputationHandler {
    private ResolvedPredictionCoreParams coreParams;

    public PythonPostTrainComputationHandler(AuthCtx authCtx, String jobId, ModelLikeId mle, PredictionPostComputationHandler.PostComputationCommand computationCommand, JsonObject computationParameters) {
        super(authCtx, jobId, mle, computationCommand, computationParameters);
    }

    @Override
    protected String envName() {
        return this.coreParams.executionParams.envName;
    }

    @Override
    protected ContainerExecRuntimeConfig getContainerConfig() throws IOException, DKUSecurityException {
        return new ContainerExecConfigSelector().selectForML_autoTXN(this.authCtx, this.mle.getProjectKey(), this.coreParams.executionParams.containerSelection, this.coreParams.backendType);
    }

    @Override
    protected File getExecutionDirForContainerExec() throws IOException {
        switch (this.mle.getModelLikeType()) {
            case DOCTOR_MODEL: {
                return ((FullModelId)this.mle).getPreprocessingFolder();
            }
            case MODEL_EVALUATION: {
                return this.mle.getMainFolder();
            }
        }
        throw new IllegalArgumentException("Unknown model type: " + String.valueOf((Object)this.mle.getModelLikeType()));
    }

    @Override
    protected void init() throws IOException {
        this.coreParams = (ResolvedPredictionCoreParams)this.mle.getUnderlyingModel().getResolvedCoreParams();
    }

    @Override
    protected Map<String, Object> prepareParams() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("job_id", this.jobId);
        params.put("split_desc", this.mle.getSplitDesc());
        params.put("core_params", this.coreParams);
        params.put("model_folder", this.mle.getUnderlyingModel().getModelFolder().getAbsolutePath());
        params.put("split_folder", this.mle.getSplitFolder().getAbsolutePath());
        params.put("fmi", this.mle.getUnderlyingModel().toString());
        params.put("modellike_folder", this.mle.getMainFolder().getAbsolutePath());
        params.put("preprocessing_folder", this.mle.getUnderlyingModel().getPreprocessingFolder().getAbsolutePath());
        params.put("computation_parameters", this.computationParameters);
        params.put("postcompute_folder", this.mle.getPostOperationsFolder().getAbsolutePath());
        if (ModelLikeId.ModelLikeType.MODEL_EVALUATION == this.mle.getModelLikeType()) {
            params.put("train_split_desc", this.mle.getUnderlyingModel().getSplitDesc());
            params.put("train_split_folder", this.mle.getUnderlyingModel().getSplitFolder().getAbsolutePath());
        }
        return params;
    }

    @Override
    protected File getContextDirForContainerExec() throws IOException {
        switch (this.mle.getModelLikeType()) {
            case DOCTOR_MODEL: {
                FullModelId fmi = this.mle.getUnderlyingModel();
                return MLPaths.getContextDir(fmi);
            }
            case MODEL_EVALUATION: {
                return this.mle.getUnderlyingModel().getMainFolder();
            }
        }
        throw new NotImplementedException("Unknown model like type");
    }

    @Override
    protected FullModelId.Type getFMIType() throws IOException {
        return this.mle.getUnderlyingModel().getType();
    }
}

