/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.ScoringRecipeUtils;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractScoringRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.DeepHubScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PyPredictionScoringRecipeSubrunner;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DeepHubScoringRecipeRunner
extends AbstractScoringRecipeRunner {
    private DeepHubScoringRecipePayloadParams desc;
    @Autowired
    private DatasetAccessService datasetAccessService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.prediction.scoring");

    public DeepHubScoringRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (DeepHubScoringRecipePayloadParams)JSON.parse((String)payload, DeepHubScoringRecipePayloadParams.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (this.desc.backendType != MLTask.BackendType.DEEP_HUB) {
            throw new NotImplementedException("Unsupported backend type: " + String.valueOf((Object)this.desc.backendType));
        }
        List<FlowDataset> inputFDS = this.activity.getSubgraph().getSourceDatasets();
        if (inputFDS.size() == 0) {
            throw ErrorContext.iae((String)"Missing input dataset in scoring recipe");
        }
        Dataset inputDataset = this.getInputDataset("main");
        AnyLoc managedFolder = this.recipe.getModel().getSingleInput("data").getLoc(this.recipe.getProjectKey());
        String hadMetadataColName = ScoringRecipeUtils.ModelMetadataUtils.schemaIncludesModelMetadata(inputDataset.getSchema());
        if (this.desc.outputModelMetadata && hadMetadataColName != null) {
            throw new Exception("\"" + hadMetadataColName + "\" is a reserved column name for model metadata output");
        }
        Dataset outputDataset = this.getOutputDataset("main");
        FlowSavedModel fsm = MLFlowUtils.getSMInput(this.activity);
        SavedModel sm = fsm.getSavedModel();
        MLFlowUtils.checkActiveVersion(sm);
        File activeModelFolder = MLPaths.savedModelVersionFolder(sm, sm.activeVersion);
        this.copyModelDetailsForFutureJobDiagnostic(activeModelFolder);
        SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)new File(activeModelFolder, "script.json"), SerializedShakerScript.class);
        script.contextProjectKey = sm.projectKey;
        Schema inferredPreparationOSchema = null;
        ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).stashTheSingleTransaction();
        try {
            inferredPreparationOSchema = MLFlowUtils.getInferredPreparationOutputSchema_NT(sm.projectKey, inputDataset, script, outputDataset.getType(), this.authCtx);
        }
        finally {
            ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).unstashTheSingleTransaction();
        }
        String inputDatasetSmartName = inputDataset.getSmartName(this.recipe.getProjectKey());
        String managedFolderSmartId = managedFolder.getSmartName(this.recipe.getProjectKey());
        String outputDatasetSmartName = outputDataset.getSmartName(this.recipe.getProjectKey());
        Schema inferredPreparationOSchemaF = inferredPreparationOSchema;
        JobContext.getCurrentActivitySummary().engineType = "DSS";
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("deephub-scoring-recipe", "pyrun");){
            JSON.prettyToFile((Object)this.desc, (File)new File((File)outputTmpDir, "desc.json"));
            JSON.prettyToFile((Object)script, (File)new File((File)outputTmpDir, "script.json"));
            JSON.prettyToFile((Object)inferredPreparationOSchemaF, (File)new File((File)outputTmpDir, "preparation_output_schema.json"));
            PyPredictionScoringRecipeSubrunner.Scoring runner = this.createRunner(activeModelFolder, sm, inputDatasetSmartName, managedFolderSmartId, outputDatasetSmartName, outputTmpDir);
            this.startRunner(runner);
        }
    }

    private PyPredictionScoringRecipeSubrunner.Scoring createRunner(File activeModelFolder, SavedModel sm, String inputDatasetSmartName, String managedFolderSmartId, String outputDatasetSmartName, AutoDelete outputTmpDir) throws IOException {
        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, sm.activeVersion);
        JsonObject containerPayload = new JsonObject();
        containerPayload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
        containerPayload.addProperty("managedFolderSmartId", managedFolderSmartId);
        containerPayload.addProperty("outputDatasetSmartName", outputDatasetSmartName);
        containerPayload.addProperty("inputModel", fmi.toString());
        String codeEnvName = new FullModelId((String)sm.projectKey, (String)sm.id, (String)sm.activeVersion).getResolvedCoreParams().executionParams.envName;
        return new PyPredictionScoringRecipeSubrunner.Scoring(this.activity, fmi, activeModelFolder, this.authCtx, codeEnvName, this.desc, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_DEEPHUB, outputTmpDir, containerPayload, "dataiku.doctor.deephub.launch_scoring_recipe", activeModelFolder.getAbsolutePath(), inputDatasetSmartName, managedFolderSmartId, outputDatasetSmartName, new File((File)outputTmpDir, "desc.json").getAbsolutePath(), new File((File)outputTmpDir, "script.json").getAbsolutePath(), new File((File)outputTmpDir, "preparation_output_schema.json").getAbsolutePath(), fmi.toString());
    }

    private Dataset getInputDataset(String role) throws IOException {
        return this.datasetAccessService.getMandatory(this.recipe.getModel().getSingleInput(role).getLoc(this.recipe.getProjectKey()));
    }

    private Dataset getOutputDataset(String role) throws IOException {
        return this.datasetAccessService.getMandatory(this.recipe.getModel().getSingleOutput(role).getLoc(this.recipe.getProjectKey()));
    }
}

