/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.shared;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.clustering.ClusteringNamer;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringPreprocessingParams;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeOrderingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class WorkSetPreparator {
    public static final String PREPROCESSING_BASE_PREFIX = "pp";
    public String userSessionName;
    public String userSessionDescription;
    public List<SimpleKeyValue> labels;
    private String preprocessingIdSuffix;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.ml");

    abstract File baseFolder();

    abstract MLTask.MLTaskType taskType();

    abstract File preprocessingFolder(WorkSet.PreprocessingSet var1);

    abstract File splitFolder();

    abstract FullModelId fullId(WorkSet.PreprocessingSet var1, WorkSet.ModelingSet var2);

    public void prepare(WorkSet ws) throws IOException {
        for (WorkSet.PreprocessingSet ps2 : ws.preprocessingSets) {
            ps2.preprocessingId = this.getPreprocessingId(null);
            File ppRunFolder = this.preprocessingFolder(ps2);
            ps2.run_folder = ppRunFolder.getAbsolutePath();
            ps2.split_folder = this.splitFolder().getAbsolutePath();
            DKUFileUtils.mkdirs((File)ppRunFolder);
            logger.info((Object)("Preprocessing " + ps2.preprocessingId + " in " + ps2.run_folder));
            JSON.prettyToFile((Object)ps2.preprocessing_params, (File)new File(ppRunFolder, "rpreprocessing_params.json"));
            for (WorkSet.ModelingSet ms : ps2.modelingSets) {
                PreTrainModelingParams rpmp;
                ms.modelId = DKUtils.nextFileInSequence((File)ppRunFolder, (String)"m").getName();
                ms.fullId = this.fullId(ps2, ms);
                File modelingRunFolder = ms.fullId.getModelFolder();
                DKUFileUtils.mkdirs((File)modelingRunFolder);
                ms.run_folder = modelingRunFolder.getAbsolutePath();
                logger.info((Object)("Model " + ms.modelId + " in " + ms.run_folder));
                JSON.prettyToFile((Object)ms.modelingParams, (File)ms.fullId.getModelFile("rmodeling_params.json"));
                ModelTrainInfo mti = new ModelTrainInfo();
                mti.modelId = ms.modelId;
                mti.state = ModelTrainInfo.ModelTrainState.PENDING;
                switch (this.taskType()) {
                    case CLUSTERING: {
                        break;
                    }
                    case PREDICTION: {
                        TimeOrderingParams time;
                        rpmp = ms.modelingParams;
                        mti.preSearchDescription = rpmp.generatePreTrainDescription();
                        if (!(ms.modelingParams instanceof PreTrainPredictionModelingParams)) break;
                        for (String key : ps2.preprocessing_params.per_feature.keySet()) {
                            FeaturePreprocessingParams feature = ps2.preprocessing_params.per_feature.get(key);
                            if (feature.role != FeaturePreprocessingParams.Role.WEIGHT) continue;
                            mti.sampleWeightsEnabled = true;
                            mti.sampleWeightsVariable = key;
                        }
                        if (ms.fullId.getResolvedCoreParams() instanceof ResolvedClassicalPredictionCoreParams && (time = ((ResolvedClassicalPredictionCoreParams)ms.fullId.getResolvedCoreParams()).time).isTimeOrderingEnabled()) {
                            mti.timeOrderingEnabled = true;
                            mti.timeVariable = time.timeVariable;
                        }
                        JSON.prettyToFile((Object)ps2.assertionsParams, (File)ms.fullId.getAssertionsFile());
                        JSON.prettyToFile((Object)ps2.overridesParams, (File)ms.fullId.getOverridesFile());
                    }
                }
                JSON.prettyToFile((Object)mti, (File)new File(modelingRunFolder, "train_info.json"));
                if (ms.userMeta == null) {
                    ms.userMeta = new ModelUserMeta();
                    switch (this.taskType()) {
                        case CLUSTERING: {
                            ClusteringNamer.fill(ms.userMeta, (ResolvedClusteringPreprocessingParams)ps2.preprocessing_params, (PreTrainClusteringModelingParams)ms.modelingParams);
                            break;
                        }
                        case PREDICTION: {
                            rpmp = ms.modelingParams;
                            logger.debug((Object)("rpmp : " + String.valueOf(rpmp)));
                            ms.userMeta.name = rpmp.generateName();
                            ms.userMeta.description = "";
                        }
                    }
                    if (!StringUtils.isEmpty((String)this.userSessionName)) {
                        ms.userMeta.name = ms.userMeta.name + " (" + this.userSessionName + ")";
                        ms.userMeta.sessionName = this.userSessionName;
                    } else {
                        ms.userMeta.name = ms.userMeta.name + " (" + ws.sessionId + ")";
                    }
                    if (!StringUtils.isEmpty((String)this.userSessionDescription)) {
                        ms.userMeta.description = this.userSessionDescription;
                    }
                }
                ms.userMeta.labels = EvaluationLabelsHelper.setAlgorithmModelNameAndSessionNameToLabels(this.labels, ms);
                JSON.prettyToFile((Object)ms.userMeta, (File)new File(modelingRunFolder, "user_meta.json"));
            }
        }
    }

    public WorkSetPreparator withPreprocessingIdSuffix(String suffix) {
        this.preprocessingIdSuffix = suffix;
        return this;
    }

    public String getPreprocessingId(Integer id) {
        String suffix = StringUtils.defaultIfBlank((String)this.preprocessingIdSuffix, (String)"");
        if (id == null) {
            return DKUtils.nextFileInSequence((File)this.baseFolder(), (String)PREPROCESSING_BASE_PREFIX, (String)suffix).getName();
        }
        return PREPROCESSING_BASE_PREFIX + id + suffix;
    }

    public static String extractPrefixAndId(String preprocessingId) {
        return preprocessingId.split("-")[0];
    }
}

