/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.analysis.model.prediction.DataEvaluationMetrics;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;

public class TimeseriesForecastingModelDetails
extends TabularPredictionModelDetails {
    public ResolvedTimeseriesForecastingCoreParams coreParams;
    public ResolvedTimeseriesForecastingPreprocessingParams preprocessing;
    public TimeseriesForecastingModelPerf perf;
    public TimeseriesForecastingModelIntrinsicPerf iperf;
    public DataEvaluationMetrics dataEvaluationMetrics;

    public TimeseriesForecastingModelDetails() {
        this.javaScoreCompatibility = CompatibilityWithReason.nok("Timeseries forecasting is not compatible with Java scoring");
        this.javaExportCompatibility = CompatibilityWithReason.nok("Causal prediction is not compatible with Java exporting");
        this.sqlCompatibility = CompatibilityWithReason.nok("Timeseries forecasting is not compatible with SQL scoring");
        this.pmmlCompatibility = CompatibilityWithReason.nok("Timeseries forecasting is not compatible with PMML scoring");
        this.pythonCompatibility = CompatibilityWithReason.nok("Timeseries forecasting is not compatible with Python scoring");
        this.pythonApiNodeScoreCompatibility = CompatibilityWithReason.ok();
        this.apiNodeScoreCompatibility = this.resolveApiNodeScoreCompatibility();
    }

    @Override
    public ResolvedTimeseriesForecastingCoreParams getCoreParams() {
        return this.coreParams;
    }

    @Override
    public ResolvedTimeseriesForecastingPreprocessingParams getPreprocessing() {
        return this.preprocessing;
    }

    @Override
    public TimeseriesForecastingModelPerf getPerf() {
        return this.perf;
    }

    public boolean supportsExternalFeatures() {
        PreTrainPredictionModelingParams.Algorithm algorithm = this.modeling.algorithm;
        switch (algorithm) {
            case TRIVIAL_IDENTITY_TIMESERIES: 
            case SEASONAL_NAIVE: 
            case SEASONAL_LOESS: 
            case CROSTON: 
            case GLUONTS_SIMPLE_FEEDFORWARD: 
            case GLUONTS_TORCH_SIMPLE_FEEDFORWARD: 
            case ETS: {
                return false;
            }
        }
        return true;
    }
}

