/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.overrides;

import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.scoring.models.filter.SimpleFilterDesc;
import com.dataiku.scoring.models.overrides.MLOverridesParamsBase;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

public class MLOverridesParams
extends MLOverridesParamsBase<FilterDesc>
implements Serializable {
    private CompatibilityWithReason getFullUserFriendlyIncompatibility(String incompatibleElement) {
        return CompatibilityWithReason.nok("Models with overrides that contain " + incompatibleElement + " are not Java exportable");
    }

    public CompatibilityWithReason getJavaExportCompatibility() {
        HashSet<String> unsupportedOperators = new HashSet<String>();
        for (MLOverridesParamsBase.MLOverride override : this.overrides) {
            if (((FilterDesc)override.filter).uiData == null) continue;
            if (Objects.equals(((FilterDesc)override.filter).uiData.mode, "CUSTOM")) {
                return this.getFullUserFriendlyIncompatibility("formulas");
            }
            for (FilterDesc.FilterUiCondition condition : ((FilterDesc)override.filter).uiData.conditions) {
                if (SimpleFilterDesc.FilterUiOperator.isSupported((String)condition.operator)) continue;
                unsupportedOperators.add(condition.operator);
            }
        }
        if (unsupportedOperators.isEmpty()) {
            return CompatibilityWithReason.ok();
        }
        return this.getFullUserFriendlyIncompatibility("conditions with operators " + unsupportedOperators.stream().map(e -> "'" + e + "'").collect(Collectors.joining(", ")));
    }
}

