/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppCodeEnvUtils {
    public static CodeEnvModel.AbstractBusinessAppEnvDesc getCodeEnvDesc(File folder) throws IOException {
        File codeEnvDir = new File(folder, "code-env");
        if (codeEnvDir.exists() && codeEnvDir.isDirectory()) {
            File descFile;
            File pythonEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.PYTHON.getFolderName());
            File rEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.R.getFolderName());
            if (pythonEnvDir.exists() && pythonEnvDir.isDirectory()) {
                File descFile2 = new File(pythonEnvDir, "desc.json");
                if (descFile2.exists() && descFile2.isFile()) {
                    try {
                        return (CodeEnvModel.AbstractBusinessAppEnvDesc)JSON.parseFile((File)descFile2, CodeEnvModel.PythonBusinessAppEnvDesc.class);
                    }
                    catch (JsonParseException e) {
                        throw new IOException("Unable to parse code-env/python/desc.json file", e);
                    }
                }
            } else if (rEnvDir.exists() && rEnvDir.isDirectory() && (descFile = new File(rEnvDir, "desc.json")).exists() && descFile.isFile()) {
                try {
                    return (CodeEnvModel.AbstractBusinessAppEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.RBusinessAppEnvDesc.class);
                }
                catch (JsonParseException e) {
                    throw new IOException("Unable to parse code-env/r/desc.json file", e);
                }
            }
        }
        return null;
    }

    public static CodeEnvModel.EnvLang getCodeEnvLang(File folder) {
        File codeEnvDir = new File(folder, "code-env");
        if (codeEnvDir.exists() && codeEnvDir.isDirectory()) {
            File descFile;
            File pythonEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.PYTHON.getFolderName());
            File rEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.R.getFolderName());
            if (pythonEnvDir.exists() && pythonEnvDir.isDirectory()) {
                File descFile2 = new File(pythonEnvDir, "desc.json");
                if (descFile2.exists() && descFile2.isFile()) {
                    return CodeEnvModel.EnvLang.PYTHON;
                }
            } else if (rEnvDir.exists() && rEnvDir.isDirectory() && (descFile = new File(rEnvDir, "desc.json")).exists() && descFile.isFile()) {
                return CodeEnvModel.EnvLang.R;
            }
        }
        return null;
    }

    public static boolean codeEnvExistsForBusinessApp(CodeEnvModel.EnvLang envLang, String envName) throws Exception {
        return switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> {
                CodeEnvModel.AutomationEnvRootDef envRootDef = BusinessAppCodeEnvUtils.automationNodeCodeEnvsService().getEnvRootDef(envLang, envName);
                if (envRootDef != null && BusinessAppCodeEnvUtils.isBusinessAppCodeEnv(envRootDef.deploymentMode)) {
                    yield true;
                }
                yield false;
            }
            case ApplicationConfigurator.DSSNodeType.DESIGN -> {
                CodeEnvModel.AbstractEnvDesc envDesc = BusinessAppCodeEnvUtils.designNodeCodeEnvsService().getEnvDesc(envLang, envName);
                if (envDesc != null && BusinessAppCodeEnvUtils.isBusinessAppCodeEnv(envDesc.deploymentMode)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
        };
    }

    public static CodeEnvModel.CodeEnvListItem getCodeEnv(String businessAppId, CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        CodeEnvModel.CodeEnvListItem codeEnv = null;
        if (!StringUtils.isBlank((String)envName)) {
            List<CodeEnvModel.CodeEnvListItem> items = switch (ApplicationConfigurator.getNodeType()) {
                default -> throw new IncompatibleClassChangeError();
                case ApplicationConfigurator.DSSNodeType.AUTOMATION -> BusinessAppCodeEnvUtils.automationNodeCodeEnvsService().listCodeEnvsWithKernelSpecNames_NT();
                case ApplicationConfigurator.DSSNodeType.DESIGN -> BusinessAppCodeEnvUtils.designNodeCodeEnvsService().listCodeEnvsWithKernelSpecNames_NT();
                case ApplicationConfigurator.DSSNodeType.API -> throw BusinessAppCodeEnvUtils.businessAppsDoNotSupportAPINodes();
            };
            codeEnv = items.stream().filter(item -> Strings.equals((String)envName, (String)item.envName) && envLang == item.envLang && BusinessAppCodeEnvUtils.isBusinessAppCodeEnv(item.deploymentMode)).findFirst().orElse(null);
        }
        if (codeEnv != null) {
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    BusinessAppCodeEnvUtils.automationNodeCodeEnvsService().checkBusinessAppEnvUptodateWithDefinition(businessAppId, codeEnv);
                    break;
                }
                case DESIGN: {
                    BusinessAppCodeEnvUtils.designNodeCodeEnvsService().checkBusinessAppEnvUptodateWithDefinition(businessAppId, codeEnv);
                    break;
                }
                case API: {
                    throw BusinessAppCodeEnvUtils.businessAppsDoNotSupportAPINodes();
                }
            }
        }
        return codeEnv;
    }

    public static boolean isBusinessAppCodeEnv(CodeEnvModel.CodeEnvDeploymentMode deploymentMode) {
        return deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED || deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED;
    }

    private static DesignNodeCodeEnvsService designNodeCodeEnvsService() {
        return (DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class);
    }

    private static AutomationNodeCodeEnvsService automationNodeCodeEnvsService() {
        return (AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class);
    }

    private static IllegalStateException businessAppsDoNotSupportAPINodes() {
        return new IllegalStateException("Business Application code-envs are not supported on API nodes");
    }
}

