/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.businessapps.BusinessAppCodeEnvUtils;
import com.dataiku.dip.businessapps.BusinessAppCodes;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.BusinessAppDescriptor;
import com.dataiku.dip.businessapps.model.BusinessAppSettings;
import com.dataiku.dip.businessapps.model.BusinessAppState;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppsDAO {
    private static final File baseDir = ApplicationConfigurator.getFile((String)"business-apps");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.businessapps.dao");

    @PostConstruct
    public void init() {
        BusinessAppsDAO.deleteDanglingBackups();
    }

    public List<String> listIds() {
        File[] subDirs = baseDir.listFiles();
        if (subDirs != null) {
            return Arrays.stream(subDirs).filter(File::isDirectory).filter(subDir -> !subDir.getName().startsWith("BACKUP.")).filter(subDir -> new File((File)subDir, "business-app.json").exists()).map(File::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<BusinessApp> list(ReadOption ... options) throws IOException, CodedException {
        return this.listIds().stream().map(businessAppId -> {
            try {
                return this.getOrNull((String)businessAppId, options);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unable to read Business Application '%s' while enumerating applications. Ignoring it.", businessAppId), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    public BusinessApp getOrNull(String businessAppId, ReadOption ... options) throws IOException, CodedException {
        FileInputStream is;
        if (StringUtils.isBlank((String)businessAppId)) {
            return null;
        }
        boolean readDescriptor = options.length == 0;
        boolean readSettings = options.length == 0;
        boolean readState = options.length == 0;
        boolean readCodeEnv = options.length == 0;
        block21: for (ReadOption opt : options) {
            switch (opt) {
                case READ_DESCRIPTOR: {
                    readDescriptor = true;
                    continue block21;
                }
                case READ_SETTINGS: {
                    readSettings = true;
                    continue block21;
                }
                case READ_STATE: {
                    readState = true;
                    continue block21;
                }
                case READ_CODEENV: {
                    readCodeEnv = true;
                }
            }
        }
        File descriptorFile = BusinessAppsDAO.getInstalledBusinessAppDescriptorFile(businessAppId);
        if (!descriptorFile.isFile()) {
            return null;
        }
        BusinessApp app = new BusinessApp();
        if (readDescriptor) {
            try (FileInputStream is2 = new FileInputStream(descriptorFile);){
                app.desc = (BusinessAppDescriptor)JSON.parse((InputStream)is2, BusinessAppDescriptor.class);
            }
            if (StringUtils.isBlank((String)app.desc.id)) {
                throw new CodedException((InfoMessage.MessageCode)BusinessAppCodes.ERR_BUSINESS_APP_INVALID_DEFINITION, String.format("Business Application: '%s' has no 'id' field in its descriptor (business-app.json)", businessAppId));
            }
        }
        if (readSettings) {
            app.settings = new BusinessAppSettings();
            File settingsFile = BusinessAppsDAO.getInstalledBusinessAppSettingsFile(businessAppId);
            if (settingsFile.isFile()) {
                is = new FileInputStream(settingsFile);
                try {
                    app.settings = (BusinessAppSettings)JSON.parse((InputStream)is, BusinessAppSettings.class);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        }
        if (readState) {
            app.state = new BusinessAppState();
            File stateFile = BusinessAppsDAO.getInstalledBusinessAppStateFile(businessAppId);
            if (stateFile.isFile()) {
                is = new FileInputStream(stateFile);
                try {
                    app.state = (BusinessAppState)JSON.parse((InputStream)is, BusinessAppState.class);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        }
        if (readCodeEnv) {
            File businessAppDir = BusinessAppsDAO.getInstalledBusinessAppFolder(app.desc.id);
            app.codeEnvLang = BusinessAppCodeEnvUtils.getCodeEnvLang(businessAppDir);
            app.codeEnvSpec = BusinessAppCodeEnvUtils.getCodeEnvDesc(businessAppDir);
            CodeEnvModel.CodeEnvListItem codeEnv = BusinessAppCodeEnvUtils.getCodeEnv(app.desc.id, app.codeEnvLang, app.desc.codeEnvName);
            app.codeEnvExist = codeEnv != null;
            app.codeEnvUpToDate = codeEnv != null && codeEnv.isUptodate;
        }
        return app;
    }

    public BusinessApp getMandatory(String businessAppId, ReadOption ... options) throws IOException, CodedException {
        BusinessApp app = this.getOrNull(businessAppId, options);
        if (app == null) {
            throw new NotFoundException("Business Application does not exist: " + businessAppId);
        }
        return app;
    }

    public File getArchive(String businessAppId) {
        return new File(BusinessAppsDAO.getInstalledBusinessAppFolder(businessAppId), "app.zip");
    }

    public void saveSettings(String businessAppId, BusinessAppSettings settings) throws IOException {
        if (!BusinessAppsDAO.getInstalledBusinessAppFolder(businessAppId).isDirectory()) {
            throw new NotFoundException("Business Application does not exist: " + businessAppId);
        }
        File settingsFile = BusinessAppsDAO.getInstalledBusinessAppSettingsFile(businessAppId);
        JSON.prettyToFile((Object)settings, (File)settingsFile);
    }

    private static void deleteDanglingBackups() {
        File[] subDirs = baseDir.listFiles();
        if (subDirs != null) {
            Arrays.stream(subDirs).filter(subDir -> subDir.getName().startsWith("BACKUP.")).forEach(subDir -> {
                logger.warn((Object)("Found dangling Business Application backup directory. Deleting it: " + String.valueOf(subDir)));
                try {
                    DKUFileUtils.deleteDirectory((File)subDir);
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to delete directory " + String.valueOf(subDir)), (Throwable)e);
                }
            });
        }
    }

    public static File getInstalledBusinessAppFolder(String businessAppId) {
        return DKUFileUtils.getWithin((File)baseDir, (String[])new String[]{businessAppId});
    }

    private static File getInstalledBusinessAppDescriptorFile(String businessAppId) {
        return DKUFileUtils.getWithin((File)baseDir, (String[])new String[]{businessAppId, "business-app.json"});
    }

    private static File getInstalledBusinessAppSettingsFile(String businessAppId) {
        return DKUFileUtils.getWithin((File)baseDir, (String[])new String[]{businessAppId, "settings.json"});
    }

    private static File getInstalledBusinessAppStateFile(String businessAppId) {
        return DKUFileUtils.getWithin((File)baseDir, (String[])new String[]{businessAppId, "state.json"});
    }

    public static enum ReadOption {
        READ_DESCRIPTOR,
        READ_SETTINGS,
        READ_STATE,
        READ_CODEENV;

    }
}

