/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.businessapps.BusinessAppCodes;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.UpgradeBusinessAppInstancePythonKernel;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceParams;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceResult;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.trust.FingerprintService;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppsUpgradeInstanceService {
    public static final String DKU_UPGRADE_PREFIX = "__DKU_BUSINESS_APP_UPGRADE_INSTANCE__";
    @Autowired
    private BusinessAppsDAO businessAppsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private WebAppsService webAppService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private FlowExecutionService2 flowExecutionService2;
    @Autowired
    private TrustedCodeService trustedCodeService;
    @Autowired
    private FingerprintService fingerprintService;
    @Autowired
    private UsersDAO usersDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.businessapps.instances.upgrade");

    public FutureResponse<CreateOrUpgradeInstanceResult> upgradeInstance(DSSAuthCtx authCtx, String businessAppId, String projectKey) throws Exception {
        UpgradeBusinessAppInstanceFutureThread ft = new UpgradeBusinessAppInstanceFutureThread(authCtx, businessAppId, projectKey);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<CreateOrUpgradeInstanceResult>>(){});
    }

    private static FuturePayload buildFuturePayload(String appId, String projectKey) {
        FuturePayload fp = new FuturePayload();
        fp.action = "upgrade_instance";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(appId, appId, appId, "INSTANCE", "BUSINESS_APP"));
        fp.withExtra("instanceProjectKey", (Object)projectKey);
        fp.displayName = "Upgrading Business Application instance";
        return fp;
    }

    private class UpgradeBusinessAppInstanceFutureThread
    extends FutureThread<CreateOrUpgradeInstanceResult> {
        private final CreateOrUpgradeInstanceResult result;
        private final String projectKey;
        private final String businessAppId;
        private final FuturePayload futurePayload;

        public UpgradeBusinessAppInstanceFutureThread(DSSAuthCtx authCtx, String businessAppId, String projectKey) {
            super(authCtx);
            this.result = new CreateOrUpgradeInstanceResult();
            this.projectKey = projectKey;
            this.businessAppId = businessAppId;
            this.futurePayload = BusinessAppsUpgradeInstanceService.buildFuturePayload(businessAppId, projectKey);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public CreateOrUpgradeInstanceResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            try {
                this.upgrade();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to upgrade the Business Application instance", (Throwable)e);
                this.result.withError(BusinessAppCodes.ERR_BUSINESS_APP_UPGRADE_INSTANCE, e.getMessage());
            }
        }

        private void upgrade() throws Exception {
            block37: {
                BusinessApp businessApp = BusinessAppsUpgradeInstanceService.this.businessAppsDAO.getMandatory(this.businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS, BusinessAppsDAO.ReadOption.READ_CODEENV);
                if (!businessApp.codeEnvExist) {
                    throw new IllegalStateException("The code environment for Business Application '" + this.businessAppId + "' does not exist.");
                }
                if (businessApp.desc == null || StringUtils.isBlank((String)businessApp.desc.version)) {
                    throw new IllegalStateException("Business Application '" + this.businessAppId + "' descriptor missing or its version is empty.");
                }
                SerializedProject sp = this.getAndValidateSerializedProject(businessApp.desc.version);
                logger.infoV("Upgrading instance '%s' of Business Application '%s' from %s to %s", new Object[]{this.projectKey, this.businessAppId, sp.businessAppVersion, businessApp.desc.version});
                File archive = BusinessAppsUpgradeInstanceService.this.businessAppsDAO.getArchive(businessApp.desc.id);
                try (AutoDelete newInstanceDir = this.createTmpDir(this.projectKey + ".new");){
                    logger.info((Object)"Creating new instance");
                    try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Preparing migration");){
                        this.createNewInstanceData(newInstanceDir, businessApp, archive, new CreateOrUpgradeInstanceParams(this.businessAppId, this.projectKey, "Upgrade in progress", "This instance is being upgraded"));
                    }
                    ignored = FutureProgress.pushAutoCloseableState((String)"Stopping existing instance");
                    try {
                        logger.info((Object)"Stopping webapp");
                        this.stopWebAppBackend(this.projectKey, sp.businessAppWebAppId);
                        logger.info((Object)"Disabling scenario triggers and aborting scenario runs and jobs");
                        this.disableScenarioTriggers(this.projectKey);
                        BusinessAppsUpgradeInstanceService.this.scenariosService.abortRunningScenarios(this.projectKey, "Upgrading Business Application instance");
                        this.abortRunningJobs(this.projectKey);
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                    sp = this.getSerializedProject();
                    File newParamsFile = new File((File)newInstanceDir, "params.json");
                    sp.businessAppVersion = businessApp.desc.version;
                    sp.businessAppWebAppId = businessApp.desc.webAppId;
                    JSON.prettyToFile((Object)sp, (File)newParamsFile);
                    try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Running migration script");){
                        logger.info((Object)"Flush pending commits on project if any");
                        BusinessAppsUpgradeInstanceService.this.transactionService.flushPendingCommits(this.projectKey);
                        File oldInstanceDir = DKUApp.getFile((String[])new String[]{"config", "projects", this.projectKey});
                        logger.info((Object)"Running python upgrade script");
                        UpgradeBusinessAppInstanceScriptResult scriptResult = this.executeUpgradePythonScript(oldInstanceDir, (File)newInstanceDir, businessApp.desc.codeEnvName);
                        if (scriptResult.messages != null) {
                            scriptResult.messages.forEach(msg -> this.result.messages.add(new InfoMessage(msg.severity, msg.title, msg.details)));
                            this.result.summarize();
                        }
                        logger.infoV("Python upgrade script returned %s", new Object[]{JSON.log((Object)scriptResult)});
                        if (scriptResult.success && !this.result.error) {
                            File projectBackupDir = this.getProjectBackupDirectory(this.projectKey);
                            Files.move(oldInstanceDir.toPath(), projectBackupDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
                            Files.move(newInstanceDir.toPath(), oldInstanceDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
                            try {
                                DKUFileUtils.deleteDirectory((File)projectBackupDir);
                            }
                            catch (IOException e) {
                                logger.error((Object)("Failed to delete project directory: " + String.valueOf(projectBackupDir)), (Throwable)e);
                            }
                            logger.info((Object)"Invalidating caches");
                            BusinessAppsUpgradeInstanceService.this.transactionService.invalidateCache(RelFile.fromPath((String)"/"));
                            BusinessAppsUpgradeInstanceService.this.flowGraphService.invalidateCache(this.projectKey);
                            if (!StringUtils.isNotBlank((String)businessApp.desc.webAppId)) break block37;
                            logger.info((Object)"Trusting webapp backend");
                            try {
                                this.trustWebAppBackend(businessApp);
                            }
                            catch (Exception e) {
                                this.result.withWarning(BusinessAppCodes.WARN_BUSINESS_APP_UNABLE_TO_TRUST, "Unable to trust the backend for everybody.");
                                logger.warn((Object)"Unable to trust webapp backend", (Throwable)e);
                            }
                            logger.info((Object)"Starting webapp backend");
                            try {
                                this.startWebAppBackend(businessApp);
                            }
                            catch (Exception e) {
                                this.result.withWarning(BusinessAppCodes.WARN_BUSINESS_APP_UNABLE_TO_START_WEBAPP, "Unable to automatically start the backend. You might need to manually start it to use the application.");
                                logger.warn((Object)"Unable to start webapp backend", (Throwable)e);
                            }
                            break block37;
                        }
                        if (!this.result.error) {
                            this.result.withError(BusinessAppCodes.ERR_BUSINESS_APP_UPGRADE_INSTANCE, "Upgrade script returned an error without a message. Please check the logs.");
                        }
                    }
                }
            }
        }

        private void abortRunningJobs(String projectKey) throws Exception {
            List<FlowExecutionService2.JobSummary> jobs;
            try (Transaction ignored = BusinessAppsUpgradeInstanceService.this.transactionService.retrieveOrBeginRead();){
                jobs = BusinessAppsUpgradeInstanceService.this.flowExecutionService2.listRunningJobs(projectKey);
            }
            for (FlowExecutionService2.JobSummary job : jobs) {
                BusinessAppsUpgradeInstanceService.this.flowExecutionService2.abort_NT(this.owner, projectKey, job.def.id);
            }
        }

        private void disableScenarioTriggers(String projectKey) throws IOException {
            try (RWTransaction rwTransaction = BusinessAppsUpgradeInstanceService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                boolean modified = false;
                List<Scenario> list = BusinessAppsUpgradeInstanceService.this.scenariosService.list(projectKey);
                for (Scenario scenario : list) {
                    List<Trigger> triggers = scenario.triggers;
                    for (Trigger trigger : triggers) {
                        if (!trigger.active) continue;
                        trigger.active = false;
                        modified = true;
                    }
                }
                if (modified) {
                    rwTransaction.commit("Disabled scenario trigger before upgrade");
                }
            }
        }

        private File getProjectBackupDirectory(String projectKey) throws IOException {
            File tmpDir = DKUApp.getFile((String[])new String[]{"tmp", "business-app-upgrade"});
            DKUFileUtils.mkdirs((File)tmpDir);
            File backupDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"backup." + projectKey});
            int counter = 1;
            while (backupDir.exists()) {
                backupDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"backup." + projectKey + "." + ++counter});
            }
            return backupDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createNewInstanceData(AutoDelete refInstanceDir, BusinessApp businessApp, File archive, CreateOrUpgradeInstanceParams params) throws Exception {
            String generatedProjectKey = null;
            try {
                generatedProjectKey = this.createReferenceInstance(businessApp, archive, params);
                DKUFileUtils.copyDirectory((File)DKUApp.getFile((String[])new String[]{"config", "projects", generatedProjectKey}), (File)refInstanceDir);
            }
            finally {
                if (generatedProjectKey != null) {
                    try (RWTransaction rwt = BusinessAppsUpgradeInstanceService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                        BusinessAppsUpgradeInstanceService.this.projectsService.deleteProject(this.owner, generatedProjectKey);
                        rwt.commit("Deleted Business Application reference instance generated to upgrade application");
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to delete the reference Business Application instance", (Throwable)e);
                    }
                }
            }
        }

        private AutoDelete createTmpDir(String prefix) throws IOException {
            File subpath = DKUApp.getFile((String[])new String[]{"tmp", "business-app-upgrade"});
            DKUFileUtils.mkdirs((File)subpath);
            return new AutoDelete(Files.createTempDirectory(subpath.toPath(), prefix, new FileAttribute[0]).toFile());
        }

        private SerializedProject getAndValidateSerializedProject(String upgradeVersion) throws IOException {
            SerializedProject sp = this.getSerializedProject();
            if (sp.projectType != SerializedProject.ProjectType.BUSINESS_APP) {
                throw new IllegalStateException("Project '" + this.projectKey + "' is not a Business Application instance");
            }
            if (!this.businessAppId.equals(sp.businessAppId)) {
                throw new IllegalStateException("Project '" + this.projectKey + "' is not a Business Application instance of '" + this.businessAppId + "'");
            }
            if (upgradeVersion.equals(sp.businessAppVersion)) {
                throw new IllegalStateException("Business Application instance '" + sp.projectKey + "' is already in version " + upgradeVersion);
            }
            return sp;
        }

        private SerializedProject getSerializedProject() throws IOException {
            try (Transaction ignored = BusinessAppsUpgradeInstanceService.this.transactionService.beginRead();){
                SerializedProject serializedProject = BusinessAppsUpgradeInstanceService.this.projectsService.getMandatory(this.projectKey);
                return serializedProject;
            }
        }

        private UpgradeBusinessAppInstanceScriptResult executeUpgradePythonScript(File oldInstanceDirectory, File newInstanceDirectory, String envName) throws Exception {
            SingleCommandKernelLink link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), ApplicationConfigurator.getPortRangeParams());
            APITicketService.Ticket ticket = BusinessAppsUpgradeInstanceService.this.apiTicketService.createTicket((AuthCtx)this.owner, "Business Application instance upgrade", (Object)this);
            Map<String, String> pythonLibs = this.getPythonLibs(newInstanceDirectory);
            if (logger.isDebugEnabled()) {
                logger.debugV("Using python libs: %s", new Object[]{JSON.prettyLog(pythonLibs)});
            }
            UpgradeBusinessAppInstancePythonKernel kernel = new UpgradeBusinessAppInstancePythonKernel(link, pythonLibs, ticket, this.projectKey, envName);
            UpgradeBusinessAppInstancePythonCommand command = UpgradeBusinessAppInstancePythonCommand.upgrade(oldInstanceDirectory.getAbsolutePath(), newInstanceDirectory.getAbsolutePath());
            String errorMessage = "Failed to upgrade Business Application instance.";
            try {
                kernel.start();
                try {
                    UpgradeBusinessAppInstanceScriptResult upgradeBusinessAppInstanceScriptResult = (UpgradeBusinessAppInstanceScriptResult)link.executeAsync((Object)command, null, UpgradeBusinessAppInstanceScriptResult.class, errorMessage).call();
                    return upgradeBusinessAppInstanceScriptResult;
                }
                catch (SocketBlockLinkException e) {
                    try {
                        logger.error((Object)e.getMessage());
                        throw kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)kernel)));
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        logger.error((Object)errorMessage, (Throwable)e2);
                        throw e2;
                    }
                    catch (Exception e3) {
                        logger.warn((Object)errorMessage, (Throwable)e3);
                        throw e3;
                    }
                }
            }
            finally {
                this.closeQuietly(() -> ((UpgradeBusinessAppInstancePythonKernel)kernel).killWithoutMercy(), "Failure while destroying Business Application upgrade instance kernel");
                this.closeQuietly(() -> ((SingleCommandKernelLink)link).close(), "Failure while closing link to kernel");
            }
        }

        private void closeQuietly(ThrowingRunnable runnable, String errorMessage) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                logger.error((Object)errorMessage, (Throwable)e);
            }
        }

        private Map<String, String> getPythonLibs(File referenceInstanceDirectory) throws IOException {
            File externalLibrariesFile;
            HashSet pythonPath = Sets.newHashSet((Object[])new String[]{"python"});
            File projectLib = DKUFileUtils.getWithin((File)referenceInstanceDirectory, (String[])new String[]{"lib"});
            if (projectLib.isDirectory() && (externalLibrariesFile = DKUFileUtils.getWithin((File)projectLib, (String[])new String[]{"external-libraries.json"})).isFile()) {
                DSSGitModel.ExternalLibraries externalLibraries = (DSSGitModel.ExternalLibraries)JSON.parseFile((File)externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
                if (externalLibraries.pythonPath != null) {
                    pythonPath.addAll(externalLibraries.pythonPath);
                }
            }
            return pythonPath.stream().collect(Collectors.toMap(s -> s, s -> DKUFileUtils.getWithin((File)projectLib, (String[])new String[]{s}).getAbsolutePath(), (ov, nv) -> ov, LinkedHashMap::new));
        }

        private boolean isWebAppBackendStarted(String projectKey, String webAppId) throws Exception {
            WebApp webApp = this.getWebApp(projectKey, webAppId);
            WebAppBackendInstance.BackendState backendState = BusinessAppsUpgradeInstanceService.this.webAppService.getBackendState(webApp, false);
            return backendState != null && backendState.futureInfo != null && backendState.futureInfo.alive;
        }

        private void trustWebAppBackend(BusinessApp app) throws IOException, DKUSecurityException, SQLException {
            String fingerprint;
            if (StringUtils.isBlank((String)app.desc.webAppId)) {
                return;
            }
            try (Transaction ignored = BusinessAppsUpgradeInstanceService.this.transactionService.beginRead();){
                WebApp webApp = BusinessAppsUpgradeInstanceService.this.webAppService.getMandatoryUnsafe(this.projectKey, app.desc.webAppId);
                UsersDAO.User user = BusinessAppsUpgradeInstanceService.this.usersDAO.getMandatoryUnsafe(webApp.params.runAs);
                fingerprint = BusinessAppsUpgradeInstanceService.this.fingerprintService.computeWebAppFingerprint(webApp, DSSAuthCtx.forUserLogin(user));
            }
            BusinessAppsUpgradeInstanceService.this.trustedCodeService.trustBusinessApplicationWebApp_NT(this.owner, this.projectKey, app.desc.webAppId, fingerprint);
        }

        private void startWebAppBackend(BusinessApp app) throws Exception {
            WebApp webApp = this.getWebApp(this.projectKey, app.desc.webAppId);
            if (webApp != null && webApp.params.isBackendEnabled() && webApp.params.isAutoStartBackend()) {
                try {
                    FutureResponse response = BusinessAppsUpgradeInstanceService.this.futureService.waitForFinalResponse(BusinessAppsUpgradeInstanceService.this.webAppService.restartBackend_NT(this.owner, webApp));
                    if (!response.hasResult) {
                        throw new IOException("Failed to start backend of Business Application instance");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.errorV((Throwable)e, "Interrupted while waiting for web app backend for instance '%s' of Business Application '%s' to start", new Object[]{this.projectKey, webApp.id});
                    throw e;
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to start web app backend for instance '%s' of Business Application '%s'", new Object[]{this.projectKey, webApp.id});
                    throw e;
                }
            }
        }

        private void stopWebAppBackend(String projectKey, String webAppId) throws Exception {
            if (StringUtils.isBlank((String)webAppId) || !this.isWebAppBackendStarted(projectKey, webAppId)) {
                return;
            }
            WebApp webApp = this.getWebApp(projectKey, webAppId);
            if (webApp != null && webApp.params.isBackendEnabled()) {
                try {
                    BusinessAppsUpgradeInstanceService.this.webAppService.stopBackend(webApp);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.errorV((Throwable)e, "Interrupted while waiting for web app backend for instance '%s' of Business Application '%s' to stop", new Object[]{projectKey, webAppId});
                    throw e;
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to stop web app backend for instance '%s' of Business Application '%s'", new Object[]{projectKey, webAppId});
                    throw e;
                }
            }
        }

        private WebApp getWebApp(String projectKey, String webAppId) throws IOException {
            WebApp webApp;
            try (Transaction ignored = BusinessAppsUpgradeInstanceService.this.transactionService.beginRead();){
                webApp = BusinessAppsUpgradeInstanceService.this.webAppService.getOrNull(projectKey, webAppId);
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to retrieve the web app for instance '%s' of Business Application '%s'", new Object[]{projectKey, webAppId});
                throw e;
            }
            return webApp;
        }

        private String computeProjectKey() throws IOException {
            StringTransmogrifier st2 = new StringTransmogrifier();
            try (Transaction ignored = BusinessAppsUpgradeInstanceService.this.transactionService.beginRead();){
                for (String s : BusinessAppsUpgradeInstanceService.this.projectsService.listProjectKeys()) {
                    st2.addAlreadyTransmogrified(s);
                }
            }
            return st2.transmogrify(BusinessAppsUpgradeInstanceService.DKU_UPGRADE_PREFIX + this.projectKey);
        }

        private String createReferenceInstance(final BusinessApp businessApp, File archive, final CreateOrUpgradeInstanceParams params) throws Exception {
            String targetProjectKey = this.computeProjectKey();
            ProjectImporter.ProjectImportSettings importSettings = new ProjectImporter.ProjectImportSettings();
            importSettings.targetProjectKey = targetProjectKey;
            importSettings.importType = "BUSINESS_APP_UPGRADE";
            importSettings.targetProjectFolderId = null;
            importSettings.remapping = businessApp.settings.remapping;
            ProjectImporter pi = new ProjectImporter(this.owner, archive, importSettings, true){

                @Override
                protected void preSaveHook(SerializedProject sp) throws IOException {
                    super.preSaveHook(sp);
                    sp.name = params.projectName;
                    sp.shortDesc = params.shortDesc;
                    sp.projectType = SerializedProject.ProjectType.BUSINESS_APP;
                    sp.businessAppId = businessApp.desc.id;
                    sp.businessAppVersion = businessApp.desc.version;
                    sp.businessAppWebAppId = businessApp.desc.webAppId;
                }
            };
            ProjectImporter.ProjectImportResult result = pi.importProject(this.owner);
            if (!result.success) {
                throw new RuntimeException("Business Application project import failed:\n " + JSON.log((Object)((Object)result)));
            }
            return targetProjectKey;
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    private static class UpgradeBusinessAppInstancePythonCommand {
        public String task;
        public String oldInstanceDirectory;
        public String newInstanceDirectory;

        private UpgradeBusinessAppInstancePythonCommand() {
        }

        public static UpgradeBusinessAppInstancePythonCommand upgrade(String oldInstanceDirectory, String newInstanceDirectory) {
            UpgradeBusinessAppInstancePythonCommand command = new UpgradeBusinessAppInstancePythonCommand();
            command.task = "upgrade";
            command.oldInstanceDirectory = oldInstanceDirectory;
            command.newInstanceDirectory = newInstanceDirectory;
            return command;
        }
    }

    private static class UpgradeBusinessAppInstanceScriptResult {
        public boolean success;
        public List<UpgradeBusinessAppInstanceMessage> messages;

        private UpgradeBusinessAppInstanceScriptResult() {
        }
    }

    private static class UpgradeBusinessAppInstanceMessage {
        public InfoMessage.Severity severity;
        public String title;
        public String details;

        private UpgradeBusinessAppInstanceMessage() {
        }
    }
}

