/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.charts.ai;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.aigenerations.AIGenerationService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIChartService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(AIChartService.class);

    public FutureResponse<AIChartGenerationResponse> startGeneration(AIChartGenerationFutureThread futureThread) throws Exception {
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIChartGenerationResponse>>(){});
    }

    public static class AIChartGenerationFutureThread
    extends SimpleFutureThread<AIChartGenerationResponse> {
        private final GeneralSettingsDAO.GeneralSettings generalSettings;
        private final LicenseStatusService.LicensingStatus licensingStatus;
        private final String previousRequestId;
        private final List<ColumnSummary.UsableColumn> usableColumns;
        private final ChartDef existingDef;
        private final String query;

        public AIChartGenerationFutureThread(AuthCtx owner, LicenseStatusService.LicensingStatus licensingStatus, String previousRequestId, List<ColumnSummary.UsableColumn> usableColumns, ChartDef existingDef, String query, GeneralSettingsDAO.GeneralSettings generalSettings) {
            super(owner);
            this.licensingStatus = licensingStatus;
            this.previousRequestId = previousRequestId;
            this.usableColumns = usableColumns;
            this.existingDef = existingDef;
            this.query = query;
            this.generalSettings = generalSettings;
        }

        @Override
        protected AIChartGenerationResponse compute() throws Exception {
            NDC.push((String)("ai-chartgeneration: " + this.query));
            try {
                AIChartGenerationQuery generationQuery = this.createGenerationQuery();
                AIChartGenerationResponse aIChartGenerationResponse = this.requestAIServerBackendAndProcessResponseForSqlQuery(generationQuery);
                return aIChartGenerationResponse;
            }
            catch (Exception e) {
                AIChartGenerationResponse aIChartGenerationResponse = this.handleFailedRequestFromAIServer(e, "Unfortunately, AI was not able to suggest a chart from your instructions. You may want to update them and try again");
                return aIChartGenerationResponse;
            }
            finally {
                NDC.pop();
            }
        }

        private AIChartGenerationResponse requestAIServerBackendAndProcessResponseForSqlQuery(AIChartGenerationQuery generationQuery) {
            AIChartGenerationResponse aIChartGenerationResponse;
            block13: {
                InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.getOwner(), this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
                try {
                    AIChartGenerationBackendResponse resp = (AIChartGenerationBackendResponse)apiClient.postObject("/text2chart/generate", AIChartGenerationBackendResponse.class, (Object)generationQuery);
                    AIChartGenerationResponse finalResp = new AIChartGenerationResponse();
                    finalResp.ok = true;
                    finalResp.reasoning = resp.reasoning;
                    finalResp.requestId = resp.requestId;
                    finalResp.aborted = resp.aborted;
                    if (StringUtils.isNotBlank((String)resp.chartDef)) {
                        try {
                            finalResp.chartDef = (ChartDef)JSON.parse((String)resp.chartDef, ChartDef.class);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Cannot parse chartDef from ai service response", (Throwable)e);
                            AIFeaturesUtil.sendRating(false, "Cannot deserialize chartDef", resp.requestId, "text2dsschart", this.licensingStatus);
                        }
                    }
                    finalResp.messages = Collections.singletonList(resp.message);
                    aIChartGenerationResponse = finalResp;
                    if (apiClient == null) break block13;
                }
                catch (Throwable resp) {
                    try {
                        if (apiClient != null) {
                            try {
                                apiClient.close();
                            }
                            catch (Throwable throwable) {
                                resp.addSuppressed(throwable);
                            }
                        }
                        throw resp;
                    }
                    catch (IOException e) {
                        return this.handleFailedRequestFromAIServer(e, "Error while generating the chart");
                    }
                    catch (DKUSecurityException e) {
                        logger.error((Object)"Security exception while generating chart", (Throwable)e);
                        AIChartGenerationResponse finalResp = new AIChartGenerationResponse();
                        finalResp.ok = false;
                        return finalResp;
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)"Configuration error while connecting to AI server", (Throwable)e);
                        AIChartGenerationResponse finalResp = new AIChartGenerationResponse();
                        finalResp.ok = false;
                        return finalResp;
                    }
                }
                apiClient.close();
            }
            return aIChartGenerationResponse;
        }

        private AIChartGenerationResponse handleFailedRequestFromAIServer(Exception e, String message) {
            logger.error((Object)"Exception while generating AI chart", (Throwable)e);
            AIChartGenerationResponse finalResp = new AIChartGenerationResponse();
            finalResp.ok = false;
            finalResp.messages = List.of(message);
            return finalResp;
        }

        private AIChartGenerationQuery createGenerationQuery() {
            AIChartGenerationQuery backendQueryBase = new AIChartGenerationQuery();
            backendQueryBase.licenseId = this.licensingStatus != null && this.licensingStatus.licenseContent != null ? this.licensingStatus.licenseContent.licenseId : null;
            backendQueryBase.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
            backendQueryBase.query = this.query;
            backendQueryBase.usableColumns = this.usableColumns.stream().map(col -> new AIGenerationService.AIDatasetSchemaColumnInformation(col.column, col.type, "")).toList();
            backendQueryBase.previousRequestId = this.previousRequestId;
            backendQueryBase.existingDef = this.existingDef;
            return backendQueryBase;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_chart_generation", (String)"AI Chart Generation");
        }
    }

    public static class AIChartGenerationQuery {
        public String previousRequestId;
        String licenseId;
        String query;
        List<AIGenerationService.AIDatasetSchemaColumnInformation> usableColumns;
        ChartDef existingDef;
        boolean telemetryEnabled;
    }

    public static class AIChartGenerationBackendResponse {
        String requestId;
        String query;
        String reasoning;
        String message;
        String chartDef;
        boolean aborted;
    }

    @UIModel
    public static class AIChartGenerationResponse {
        public boolean ok;
        public boolean aborted;
        public ChartDef chartDef;
        public String reasoning;
        public String requestId;
        public List<String> messages;
    }
}

