/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class ConfigurableYarnLogsCLI {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage : applicationId listOfKeyValuePairs");
        }
        String yarnAppId = args[0];
        List extraConf = (List)JSON.parse((String)args[1], (TypeToken)new TypeToken<List<ClusterProperty>>(){});
        try {
            Class<?> clazz = ConfigurableYarnLogsCLI.class.getClassLoader().loadClass("org.apache.hadoop.yarn.client.cli.LogsCLI");
            System.err.println("Got class " + clazz.getCanonicalName() + " in " + clazz.getProtectionDomain().getCodeSource().getLocation().toString());
            Object logDumper = clazz.newInstance();
            YarnConfiguration conf = new YarnConfiguration();
            for (ClusterProperty property : extraConf) {
                conf.set(property.key, property.value);
            }
            ((Configured)logDumper).setConf((Configuration)conf);
            Method runMethod = clazz.getDeclaredMethod("run", String[].class);
            String[] fakeArgs = new String[]{"-applicationId", yarnAppId};
            System.err.println("Use fake args " + Joiner.on((String)", ").join(Arrays.asList(fakeArgs)));
            int exitCode = (Integer)runMethod.invoke(logDumper, new Object[]{fakeArgs});
            System.exit(exitCode);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.err.println("Failed to run yarn logs CLI");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

