/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ClusterSelector {
    public static final String BUILTIN_CLUSTER_ID = "__builtin__";
    private static MainLoggingConfigurator.ProcessType context;
    private static GeneralSettingsDAO.GeneralSettings settingsForTests;
    private static ClusterSettings forcedSettingsGlobal;
    private static InheritableThreadLocal<ClusterSettings> forcedSettingsOnThread;
    private ProjectsDAO projectsDAO;
    private ApiNodeInfrasDAO infrasDAO;
    private GeneralSettingsDAO generalSettingsDAO;
    private ClustersDAO clustersDAO;
    private VariablesService variablesService;
    private ScenarioRunContext scenarioRunContext;
    private PasswordEncryptionService cryptoService;
    private final boolean rawAccess;
    private static final Set<String> jekCachedGrants;
    private static final Map<String, Lock> jekGrantLocks;
    private static final DKULogger logger;

    public ClusterSelector() {
        this(false);
        if (!ApplicationConfigurator.isInSparkDriver() && settingsForTests == null) {
            this.clustersDAO = (ClustersDAO)SpringUtils.getBean(ClustersDAO.class);
            this.projectsDAO = (ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class);
            this.infrasDAO = (ApiNodeInfrasDAO)SpringUtils.getBean(ApiNodeInfrasDAO.class);
            this.generalSettingsDAO = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
            this.scenarioRunContext = (ScenarioRunContext)SpringUtils.getBean(ScenarioRunContext.class);
            this.variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
            this.cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        }
    }

    public ClusterSelector(boolean rawAccess) {
        this.rawAccess = rawAccess;
    }

    public static MainLoggingConfigurator.ProcessType getContext() {
        return context == null ? MainLoggingConfigurator.ProcessType.UNKNOWN : context;
    }

    public static void setContext(MainLoggingConfigurator.ProcessType processType) {
        context = processType;
    }

    public static void forceSettingsOnCurrentThread(ClusterSettings clusterSettings) {
        forcedSettingsOnThread.set(clusterSettings);
    }

    public static void forceSettings(ClusterSettings clusterSettings) {
        forcedSettingsGlobal = clusterSettings;
    }

    @VisibleForTesting
    public static void setupForTests(GeneralSettingsDAO.GeneralSettings generalSettings) {
        settingsForTests = generalSettings;
    }

    public ClusterSettings selectGlobal() throws IOException {
        if (this.rawAccess) {
            GeneralSettingsDAO.GeneralSettings generalSettings = (GeneralSettingsDAO.GeneralSettings)JSON.parseFile((File)ApplicationConfigurator.getFile((String)"config/general-settings.json"), GeneralSettingsDAO.GeneralSettings.class);
            return new ClusterSettings(null, generalSettings);
        }
        ClusterSettings forcedSettings = ClusterSelector.getForcedSettings();
        if (forcedSettings != null) {
            return forcedSettings;
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            ClusterSettings clusterSettings = this.getGlobalClusterSettings_T();
            return clusterSettings;
        }
    }

    @Nonnull
    public ClusterSettings selectForProject(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        ClusterSettings forcedSettings = ClusterSelector.getForcedSettings();
        logger.trace(() -> "select for project key=" + projectKey + " auth=" + String.valueOf(authCtx) + " forced=" + String.valueOf(forcedSettings));
        if (forcedSettings != null) {
            return forcedSettings;
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            ClusterSettings clusterSettings = this.getClusterSettings_T(authCtx, this.getClusterForProject_T(projectKey, Cluster.ClusterArchitecture.HADOOP), this.getClusterForProject_T(projectKey, Cluster.ClusterArchitecture.KUBERNETES), null);
            return clusterSettings;
        }
    }

    public ClusterSettings selectForAPIDeployer(AuthCtx authCtx, String infraId) throws IOException, DKUSecurityException {
        ClusterSettings forcedSettings = ClusterSelector.getForcedSettings();
        logger.trace(() -> "select for api deployer infra=" + infraId + " auth=" + String.valueOf(authCtx) + " forced=" + String.valueOf(forcedSettings));
        if (forcedSettings != null) {
            return forcedSettings;
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            ClusterSettings clusterSettings = this.getClusterSettings_T(authCtx, this.getBuiltinOrDefaultClusterId_T(Cluster.ClusterArchitecture.HADOOP), this.getClusterForAPIDeployer_T(infraId, Cluster.ClusterArchitecture.KUBERNETES), null);
            return clusterSettings;
        }
    }

    public ClusterSettings selectForAPIDeployer(AuthCtx authCtx, K8SAPIDeploymentInfra infra) throws IOException, DKUSecurityException {
        ClusterSettings forcedSettings = ClusterSelector.getForcedSettings();
        logger.trace(() -> "select for api deployer infra=" + infra.id + " auth=" + String.valueOf(authCtx) + " forced=" + String.valueOf(forcedSettings));
        if (forcedSettings != null) {
            return forcedSettings;
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            ClusterSettings clusterSettings = this.getClusterSettings_T(authCtx, this.getBuiltinOrDefaultClusterId_T(Cluster.ClusterArchitecture.HADOOP), this.getClusterFromGlobalContext(infra.cluster, Cluster.ClusterArchitecture.KUBERNETES), null);
            return clusterSettings;
        }
    }

    public ClusterSettings selectForCluster(AuthCtx authCtx, String hadoopClusterId, String k8sClusterId) throws IOException, DKUSecurityException {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            ClusterSettings clusterSettings = this.getClusterSettings_T(authCtx, hadoopClusterId, k8sClusterId, null);
            return clusterSettings;
        }
    }

    public ClusterSettings selectForCluster(AuthCtx authCtx, String hadoopClusterId, String k8sClusterId, ContainerExecRuntimeConfig containerConfig) throws IOException, DKUSecurityException {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            ClusterSettings clusterSettings = this.getClusterSettings_T(authCtx, hadoopClusterId, k8sClusterId, containerConfig);
            return clusterSettings;
        }
    }

    public String getBuiltinOrDefaultClusterId(Cluster.ClusterArchitecture architecture) throws IOException {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            String string = this.getBuiltinOrDefaultClusterId_T(architecture);
            return string;
        }
    }

    public String getClusterForProject(String projectKey, Cluster.ClusterArchitecture architecture) throws IOException {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            String string = this.getClusterForProject_T(projectKey, architecture);
            return string;
        }
    }

    private String getClusterForProject_T(String projectKey, Cluster.ClusterArchitecture architecture) throws IOException {
        String scenarioClusterId;
        logger.trace(() -> "Get cluster id projectKey=" + projectKey + " architecture=" + String.valueOf((Object)architecture));
        if (ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CDE) {
            return BUILTIN_CLUSTER_ID;
        }
        if (architecture == Cluster.ClusterArchitecture.HADOOP ? StringUtils.isNotBlank((String)(scenarioClusterId = this.scenarioRunContext.getActiveCluster())) : architecture == Cluster.ClusterArchitecture.KUBERNETES && StringUtils.isNotBlank((String)(scenarioClusterId = this.scenarioRunContext.getActiveK8sCluster()))) {
            return scenarioClusterId;
        }
        if (StringUtils.isBlank((String)projectKey) || StringUtils.equals((String)"__DKU_ANY_PROJECT__", (String)projectKey)) {
            return this.getBuiltinOrDefaultClusterId_T(architecture);
        }
        SerializedProject.ProjectSettings projectSettings = this.projectsDAO.getMandatoryUnsafe((String)projectKey).settings;
        return this.getCluster(switch (architecture) {
            case Cluster.ClusterArchitecture.HADOOP -> projectSettings.cluster;
            case Cluster.ClusterArchitecture.KUBERNETES -> projectSettings.k8sCluster;
            default -> throw new Error("unreachable");
        }, architecture, this.variablesService.getForProject(projectKey));
    }

    private String getClusterForAPIDeployer_T(String infraId, Cluster.ClusterArchitecture architecture) throws IOException {
        logger.trace(() -> "Get cluster id infraId=" + infraId + " architecture=" + String.valueOf((Object)architecture));
        if (StringUtils.isBlank((String)infraId) || StringUtils.equals((String)"__DKU_ANY_INFRA__", (String)infraId)) {
            return this.getBuiltinOrDefaultClusterId_T(architecture);
        }
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.infrasDAO.getMandatoryUnsafe(infraId);
        return this.getClusterFromGlobalContext(switch (architecture) {
            case Cluster.ClusterArchitecture.HADOOP -> new ClusterSelection();
            case Cluster.ClusterArchitecture.KUBERNETES -> {
                if (infra instanceof K8SAPIDeploymentInfra) {
                    yield ((K8SAPIDeploymentInfra)infra).cluster;
                }
                yield new ClusterSelection();
            }
            default -> throw new Error("unreachable");
        }, architecture);
    }

    private String getClusterFromGlobalContext(ClusterSelection clusterSelection, Cluster.ClusterArchitecture architecture) throws IOException {
        return this.getCluster(clusterSelection, architecture, this.variablesService.getForGlobal());
    }

    private String getCluster(ClusterSelection clusterSelection, Cluster.ClusterArchitecture architecture, VariablesContext variablesContext) throws IOException {
        switch (clusterSelection.clusterMode) {
            case INHERIT: {
                return this.getBuiltinOrDefaultClusterId_T(architecture);
            }
            case EXPLICIT_CLUSTER: {
                String clusterId = StringUtils.defaultIfEmpty((String)clusterSelection.clusterId, (String)"");
                logger.trace(() -> "Cluster id for project is " + clusterId);
                String expandedClusterId = variablesContext.expandEmptyIfUnresolved(clusterId);
                logger.trace(() -> "Cluster id after variable expansion is " + expandedClusterId);
                if (StringUtils.isBlank((String)expandedClusterId)) {
                    if (StringUtils.isNotBlank((String)clusterSelection.defaultClusterId)) {
                        logger.trace(() -> "Using default cluster id for project : " + clusterSelection.defaultClusterId);
                        return clusterSelection.defaultClusterId;
                    }
                    return this.getBuiltinOrDefaultClusterId_T(architecture);
                }
                return expandedClusterId;
            }
        }
        throw new Error("unreachable");
    }

    private String getBuiltinOrDefaultClusterId_T(Cluster.ClusterArchitecture architecture) throws IOException {
        logger.trace(() -> "Get global cluster id architecture=" + String.valueOf((Object)architecture));
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
        switch (architecture) {
            case HADOOP: {
                return StringUtils.defaultIfBlank((String)generalSettings.defaultClusterId, (String)BUILTIN_CLUSTER_ID);
            }
            case KUBERNETES: {
                return StringUtils.defaultIfBlank((String)generalSettings.defaultK8sClusterId, (String)BUILTIN_CLUSTER_ID);
            }
        }
        throw new Error("unreachable");
    }

    @Nonnull
    private ClusterSettings getGlobalClusterSettings_T() throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
        ClusterSettings clusterSettings = new ClusterSettings(null, generalSettings).deepCopy();
        clusterSettings.decryptFields(this.cryptoService);
        return clusterSettings;
    }

    @Nonnull
    private ClusterSettings getClusterSettings_T(AuthCtx authCtx, String hadoopClusterId, String k8sClusterId, ContainerExecRuntimeConfig containerConfig) throws IOException, DKUSecurityException {
        if (!BUILTIN_CLUSTER_ID.equals(hadoopClusterId) || !BUILTIN_CLUSTER_ID.equals(k8sClusterId)) {
            logger.traceV("Build cluster settings: hadoop=%s k8s=%s", new Object[]{hadoopClusterId, k8sClusterId});
        }
        if (!BUILTIN_CLUSTER_ID.equals(hadoopClusterId)) {
            try {
                ClusterSelector.checkClusterPrivilege(authCtx, hadoopClusterId, Privileges.ClusterLevelPrivilegeType.USE);
            }
            catch (UnauthorizedException e) {
                hadoopClusterId = BUILTIN_CLUSTER_ID;
                logger.debug((Object)(e.getMessage() + " - falling back to builtin."));
            }
        }
        if (!BUILTIN_CLUSTER_ID.equals(k8sClusterId)) {
            try {
                ClusterSelector.checkClusterPrivilege(authCtx, k8sClusterId, Privileges.ClusterLevelPrivilegeType.USE);
            }
            catch (APIError.APIErrorException | UnauthorizedException e) {
                if (e.getMessage().startsWith("Action forbidden on cluster ")) {
                    k8sClusterId = BUILTIN_CLUSTER_ID;
                    logger.debug((Object)(e.getMessage() + " - falling back to builtin."));
                }
                throw e;
            }
        }
        ClusterSettings globalClusterSettings = this.getGlobalClusterSettings_T();
        if (containerConfig != null) {
            ContainerSettings containerSettings = globalClusterSettings.getContainerSettings();
            int found = -1;
            for (int i = 0; i < containerSettings.executionConfigs.size(); ++i) {
                if (!StringUtils.equals((String)containerConfig.name, (String)containerSettings.executionConfigs.get((int)i).name)) continue;
                found = i;
            }
            if (found >= 0) {
                containerSettings.executionConfigs.set(found, containerConfig);
            } else {
                containerSettings.executionConfigs.add(containerConfig);
            }
        }
        if (authCtx.getAuthSource() == AuthCtx.AuthSource.NONE || BUILTIN_CLUSTER_ID.equals(hadoopClusterId) && BUILTIN_CLUSTER_ID.equals(k8sClusterId)) {
            logger.trace((Object)"Builtin cluster used, no override");
            return globalClusterSettings;
        }
        if (!BUILTIN_CLUSTER_ID.equals(k8sClusterId)) {
            globalClusterSettings.k8sClusterDefined();
        }
        ClusterSettings overriden = globalClusterSettings;
        if (!BUILTIN_CLUSTER_ID.equals(hadoopClusterId)) {
            Cluster hadoopCluster = this.clustersDAO.getMandatory(hadoopClusterId);
            overriden = this.applyOverrides(overriden, hadoopCluster);
        }
        if (!BUILTIN_CLUSTER_ID.equals(k8sClusterId)) {
            Cluster k8sCluster = this.clustersDAO.getMandatory(k8sClusterId);
            overriden = this.applyOverrides(overriden, k8sCluster);
        }
        if (k8sClusterId != null && !"__NOOP__".equals(k8sClusterId) && !BUILTIN_CLUSTER_ID.equals(k8sClusterId)) {
            overriden.overridenFromK8SClusterId = k8sClusterId;
            for (ContainerExecRuntimeConfig runtimeConfig : overriden.getContainerSettings().executionConfigs) {
                runtimeConfig.overridenFromK8SClusterId = k8sClusterId;
            }
        }
        overriden.decryptFields(this.cryptoService);
        return overriden;
    }

    private ClusterSettings applyOverrides(ClusterSettings rawClusterSettings, Cluster cluster) {
        HadoopSettings hadoopSettings = cluster.overrideHadoopSettings.apply(rawClusterSettings.getHadoopSettings(), cluster.hadoopSettings);
        HiveSettings hiveSettings = cluster.overrideHiveSettings.apply(rawClusterSettings.getHiveSettings(), cluster.hiveSettings);
        ImpalaSettings impalaSettings = cluster.overrideImpalaSettings.apply(rawClusterSettings.getImpalaSettings(), cluster.impalaSettings);
        SparkSettings sparkSettings = cluster.overrideSparkSettings.apply(rawClusterSettings.getSparkSettings(), cluster.sparkSettings);
        sparkSettings = cluster.overrideContainerSettings.apply(sparkSettings, cluster.containerSettings);
        ContainerSettings containerSettings = cluster.overrideContainerSettings.apply(rawClusterSettings.getContainerSettings(), cluster.containerSettings);
        return new ClusterSettings(cluster.id, hadoopSettings, hiveSettings, impalaSettings, sparkSettings, containerSettings, rawClusterSettings.isNoImplicitK8sClusterAndNoDefaultClusterId());
    }

    private static ClusterSettings getForcedSettings() {
        ClusterSettings threadSettings = (ClusterSettings)forcedSettingsOnThread.get();
        if (threadSettings != null) {
            return threadSettings;
        }
        if (settingsForTests != null) {
            return new ClusterSettings(BUILTIN_CLUSTER_ID, settingsForTests);
        }
        return forcedSettingsGlobal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkClusterPrivilege(AuthCtx authCtx, String clusterId, Privileges.ClusterLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        switch (ClusterSelector.getContext()) {
            case APIMAIN: 
            case BACKEND: {
                IPermissionsService permissionsService = (IPermissionsService)SpringUtils.getBean(IPermissionsService.class);
                permissionsService.checkClusterPrivileges(authCtx, clusterId, privilege);
                return;
            }
            case CDE: {
                try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
                    apiClient.postFormToJSON("/tintercom/permissions/check-cluster-privilege", Void.class, new Object[]{"clusterId", clusterId, "privilege", privilege.toString()});
                    return;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not check cluster permissions", (Throwable)e);
                }
            }
            case DKU: 
            case JEK: {
                String grant = ClusterSelector.getJEKGrant(clusterId, privilege);
                Lock grantLock = ClusterSelector.getGrantLock(grant);
                try {
                    if (!grantLock.tryLock(DKUApp.getProperty((String)"dku.cluster.jek.grants.cache.timeoutInSeconds", (int)300), TimeUnit.SECONDS)) throw new DKUSecurityException("Could not check cluster permissions within timeout");
                    try {
                        if (jekCachedGrants.contains(grant)) {
                            logger.info((Object)("Using cached grant: " + grant));
                            return;
                        }
                        logger.info((Object)("Checking cluster " + clusterId + " privilege: " + String.valueOf((Object)privilege)));
                        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                             TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-cluster-privilege", Void.class, new Object[]{"clusterId", clusterId, "privilege", privilege.toString()});
                        }
                        catch (DKUSecurityException | IOException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                        }
                        jekCachedGrants.add(grant);
                        return;
                    }
                    finally {
                        grantLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    throw new DKUSecurityException("Interrupted while checking cluster permissions", (Throwable)e);
                }
            }
            case FEK: 
            case CAK: {
                int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                try (LocalPrivilegedIntercomAPIClient apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);){
                    apiClient.postFormToJSON("/dip/api/intercom/permissions/check-cluster-privilege", Void.class, new Object[]{"authCtx", JSON.json((Object)authCtx), "clusterId", clusterId, "privilege", privilege.toString()});
                    return;
                }
            }
            case UNKNOWN: {
                throw new Error("DSS Process type not set, cannot check cluster access");
            }
        }
    }

    private static synchronized Lock getGrantLock(String grant) {
        Lock grantLock;
        if (!jekGrantLocks.containsKey(grant)) {
            grantLock = new ReentrantLock();
            jekGrantLocks.put(grant, grantLock);
        } else {
            grantLock = jekGrantLocks.get(grant);
        }
        return grantLock;
    }

    private static String getJEKGrant(String clusterId, Privileges.ClusterLevelPrivilegeType privilege) {
        return "cluster::" + privilege.toString() + "::" + clusterId;
    }

    static {
        forcedSettingsOnThread = new InheritableThreadLocal();
        jekCachedGrants = Sets.newConcurrentHashSet();
        jekGrantLocks = new HashMap<String, Lock>();
        logger = DKULogger.getLogger((String)"dku.cluster.selector");
    }
}

