/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.code.AutomationNodeCodeEnvsAccessService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.CodeEnvVersionChecker;
import com.dataiku.dip.code.CondaEnvUtils;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.code.PythonCodeEnvUtils;
import com.dataiku.dip.code.RCodeEnvUtils;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.containers.exec.ContainerExecDockerFilePreparer;
import com.dataiku.dip.containers.exec.ContainerExecImagesBuilder;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.cde.CDEImageBuilderService;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ReflectedEventEvent;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomationNodeCodeEnvsService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private AutomationNodeCodeEnvsAccessService accessService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private CDEImageBuilderService cdeImageBuilderService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code-envs");

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvs() throws IOException {
        return this.accessService.listCodeEnvs();
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvsWithKernelSpecNames_NT() throws IOException {
        List<CodeEnvModel.CodeEnvListItem> ret = this.accessService.listCodeEnvs();
        this.addKernelSpecNames(ret);
        return ret;
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvs(String projectKey, String bundleId) throws IOException {
        return this.accessService.listCodeEnvs(projectKey, bundleId);
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvsWithKernelSpecNames_NT(String projectKey, String bundleId) throws IOException {
        List<CodeEnvModel.CodeEnvListItem> ret = this.accessService.listCodeEnvs(projectKey, bundleId);
        this.addKernelSpecNames(ret);
        return ret;
    }

    private void addKernelSpecNames(List<CodeEnvModel.CodeEnvListItem> ret) {
        try {
            HashMap kernelSpecByEnvName = Maps.newHashMap();
            HashMap bundleKernelSpecByEnvName = Maps.newHashMap();
            for (JupyterService.KernelSpec kernelSpec : this.jupyterService.listKernelSpecs()) {
                if (!StringUtils.isNotBlank((String)kernelSpec.envName)) continue;
                if (StringUtils.isNotBlank((String)kernelSpec.bundleId)) {
                    if (!bundleKernelSpecByEnvName.containsKey(kernelSpec.envName)) {
                        bundleKernelSpecByEnvName.put(kernelSpec.envName, new HashMap());
                    }
                    ((Map)bundleKernelSpecByEnvName.get(kernelSpec.envName)).put(kernelSpec.projectKey + "." + kernelSpec.bundleId, kernelSpec);
                    continue;
                }
                kernelSpecByEnvName.put(kernelSpec.envName, kernelSpec);
            }
            for (CodeEnvModel.CodeEnvListItem env : ret) {
                if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                    if (!bundleKernelSpecByEnvName.containsKey(env.envName)) continue;
                    env.kernelSpecNames = Lists.newArrayList(((Map)bundleKernelSpecByEnvName.get(env.envName)).keySet());
                    continue;
                }
                if (!kernelSpecByEnvName.containsKey(env.envName)) continue;
                env.kernelSpecName = ((JupyterService.KernelSpec)kernelSpecByEnvName.get((Object)env.envName)).name;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get kernelSpecs", (Throwable)e);
            for (CodeEnvModel.CodeEnvListItem env : ret) {
                env.unknownKernelSpecStatus = true;
            }
        }
    }

    public void checkPluginEnvUptodateWithDefinition(String pluginId, CodeEnvModel.CodeEnvListItem env) throws IOException {
        env.isUptodate = true;
        File pluginEnvFolder = new File(new File(this.pluginsRegistryService.getActualPluginFolder(pluginId), "code-env"), env.envLang.getFolderName());
        if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && pluginEnvFolder.exists()) {
            File installedEnvFolder = AutomationNodeCodeEnvsService.getEnvRootDir(env.envLang, env.envName);
            File descFolder = DKUFileUtils.getWithin((File)installedEnvFolder, (String[])new String[]{"desc"});
            String pluginCondaSpec = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)pluginEnvFolder, (String[])new String[]{"spec", "environment.spec"}));
            String installedCondaSpec = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", "environment.spec"}));
            String pluginPackageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)pluginEnvFolder, (String[])new String[]{"spec", env.envLang.getPackageFileName()}));
            String installedPackageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", env.envLang.getPackageFileName()}));
            env.isUptodate &= StringUtils.equals((String)pluginCondaSpec, (String)installedCondaSpec);
            env.isUptodate &= StringUtils.equals((String)pluginPackageList, (String)installedPackageList);
            String pluginResourcesInitScript = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)pluginEnvFolder, (String[])new String[]{"spec", "resources_init.py"}));
            String installedResourcesInitScript = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", "resources_init.py"}));
            env.isUptodate &= StringUtils.equals((String)pluginResourcesInitScript, (String)installedResourcesInitScript);
        }
    }

    public void checkBusinessAppEnvUptodateWithDefinition(String businessAppId, CodeEnvModel.CodeEnvListItem env) throws IOException {
        env.isUptodate = true;
        File businessAppEnvFolder = DKUFileUtils.getWithin((File)BusinessAppsDAO.getInstalledBusinessAppFolder(businessAppId), (String[])new String[]{"code-env", env.envLang.getFolderName()});
        if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED && businessAppEnvFolder.exists()) {
            File installedEnvFolder = AutomationNodeCodeEnvsService.getEnvRootDir(env.envLang, env.envName);
            File descFolder = DKUFileUtils.getWithin((File)installedEnvFolder, (String[])new String[]{"desc"});
            String businessAppCondaSpec = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)businessAppEnvFolder, (String[])new String[]{"spec", "environment.spec"}));
            String installedCondaSpec = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", "environment.spec"}));
            String businessAppPackageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)businessAppEnvFolder, (String[])new String[]{"spec", env.envLang.getPackageFileName()}));
            String installedPackageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", env.envLang.getPackageFileName()}));
            env.isUptodate &= StringUtils.equals((String)businessAppCondaSpec, (String)installedCondaSpec);
            env.isUptodate &= StringUtils.equals((String)businessAppPackageList, (String)installedPackageList);
            String businessAppResourcesInitScript = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)businessAppEnvFolder, (String[])new String[]{"spec", "resources_init.py"}));
            String installedResourcesInitScript = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", "resources_init.py"}));
            env.isUptodate &= StringUtils.equals((String)businessAppResourcesInitScript, (String)installedResourcesInitScript);
        }
    }

    private Iterable<String> listValidVersions(CodeEnvModel.EnvLang envLang, String envName) {
        final File versionsDir = this.getEnvVersionsDir(envLang, envName);
        ArrayList<String> ret = new ArrayList<String>();
        for (File versionDir : versionsDir.listFiles()) {
            String versionId = versionDir.getName();
            if (!new File(versionDir, "desc/desc.json").isFile()) {
                logger.warnV("Version folder %s not valid (no desc.json)", new Object[]{versionDir});
                continue;
            }
            ret.add(versionId);
        }
        Collections.sort(ret, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                long lb;
                File fa = new File(versionsDir, a);
                File fb = new File(versionsDir, b);
                long la = fa.lastModified();
                return la < (lb = fb.lastModified()) ? -1 : (la > lb ? 1 : 0);
            }
        });
        return ret;
    }

    public CodeEnvModel.AutomationEnvRootDef getEnvRootDefOrNull(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        return this.accessService.getEnvRootDefOrNull(envLang, envName);
    }

    public CodeEnvModel.EnvVersionRef findMatchingEnvVersion(CodeEnvModel.EnvLang envLang, String envName, File exportedEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws IOException {
        CodeEnvModel.AutomationEnvRootDef rootDef = this.getEnvRootDefOrNull(envLang, envName);
        if (rootDef == null) {
            return null;
        }
        assert (rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED);
        File versionsDir = this.getEnvVersionsDir(envLang, envName);
        if (!versionsDir.isDirectory()) {
            return null;
        }
        for (File versionDir : versionsDir.listFiles()) {
            String versionId = versionDir.getName();
            File versionFolder = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionId);
            boolean matches = new CodeEnvVersionChecker().checkIfCodeEnvVersionIsUpToDate(envLang, versionFolder, exportedEnvDir, specMode);
            if (!matches) continue;
            CodeEnvModel.EnvVersionRef ret = new CodeEnvModel.EnvVersionRef();
            ret.envName = envName;
            ret.envVersion = versionId;
            logger.info((Object)("Version " + versionId + " of " + envName + " matches reqs"));
            return ret;
        }
        logger.infoV("Found no proper version for env %s %s", new Object[]{envLang, envName});
        return null;
    }

    public boolean checkIfNonVersionedCodeEnvMatches(CodeEnvModel.EnvLang envLang, String envName, File exportedEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws IOException {
        CodeEnvModel.AutomationEnvRootDef rootDef = this.getEnvRootDefOrNull(envLang, envName);
        assert (rootDef != null);
        assert (rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE || rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL);
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                return new CodeEnvVersionChecker().checkIfPythonEnvVersionIsUpToDate(envDir, exportedEnvDir, specMode);
            }
            case R: {
                return new CodeEnvVersionChecker().checkIfREnvVersionIsUpToDate(envDir, exportedEnvDir, specMode);
            }
        }
        throw new Error("unreachable");
    }

    private File createNonVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.AutomationNewEnvSpec spec, DKUtils.SmartLogTailBuilder logTailBuilder, File log, InfoMessage.InfoMessages ret) throws Exception {
        File envFolder = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                this.createPythonEnvInFolder(authCtx, envFolder, spec, logTailBuilder, log, ret);
                break;
            }
            case R: {
                this.createREnvInFolder(authCtx, envFolder, spec, logTailBuilder, log, ret);
            }
        }
        return envFolder;
    }

    public CodeEnvModel.AbstractEnvDesc importToNonVersionedEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File exportedEnvDir, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, CodeEnvModel.EnvImportSpecificationMode specMode, boolean updateResources, DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        File envRootDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        CodeEnvModel.AbstractEnvDesc envDesc = null;
        switch (envLang) {
            case PYTHON: {
                envDesc = CodeEnvImportUtils.importPythonEnvInFolder(authCtx, envRootDir, exportedEnvDir, this.getEnvLogsDir(CodeEnvModel.EnvLang.PYTHON, envName), deploymentMode, specMode, logTailBuilder, null);
                File descFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                File resourcesFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"resources"});
                File envFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"env"});
                if (!updateResources || !envDesc.installCorePackages) break;
                CodeEnvImportUtils.markManagedNotReady(envRootDir);
                File log = ApplicationConfigurator.getFile((File)this.getEnvLogsDir(envLang, envName), (String[])new String[]{"updatePythonEnvResources.log"});
                DKUFileUtils.mkdirsParent((File)log);
                boolean successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, envName, descFolder, envFolder, resourcesFolder, logTailBuilder, log, null);
                if (successfulRun) {
                    CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, envLang, envRootDir, logTailBuilder, log);
                }
                CodeEnvImportUtils.markManagedReady(envRootDir);
                break;
            }
            case R: {
                envDesc = CodeEnvImportUtils.importREnvInFolder(authCtx, envRootDir, exportedEnvDir, this.getEnvLogsDir(CodeEnvModel.EnvLang.R, envName), deploymentMode, specMode, logTailBuilder, null);
            }
        }
        return envDesc;
    }

    public CodeEnvModel.EnvVersionRef importNewCodeEnvVersion(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File exportedEnvDir, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, CodeEnvModel.EnvImportSpecificationMode specMode, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings, boolean updateResources, DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        long newVersionId = this.getNextAvailableImportVersion(envLang, envName);
        File versionFolder = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, "v." + newVersionId);
        logger.infoV("Importing new version of env %s %s depl=%s ism=%s odds=%s", new Object[]{envLang, envName, deploymentMode, specMode, JSON.log((Object)overrideDescDirSettings)});
        switch (envLang) {
            case PYTHON: {
                CodeEnvImportUtils.importPythonEnvInFolder(authCtx, versionFolder, exportedEnvDir, this.getEnvLogsDir(CodeEnvModel.EnvLang.PYTHON, envName), deploymentMode, specMode, logTailBuilder, overrideDescDirSettings);
                File versionRootDir = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionFolder.getName());
                File versionDescFolder = DKUFileUtils.getWithin((File)versionRootDir, (String[])new String[]{"desc"});
                File versionResourcesFolder = DKUFileUtils.getWithin((File)versionRootDir, (String[])new String[]{"resources"});
                File versionEnvFolder = DKUFileUtils.getWithin((File)versionRootDir, (String[])new String[]{"env"});
                CodeEnvModel.AbstractEnvDesc desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"desc.json"}), envLang.getDescClazz());
                if (!updateResources || !((CodeEnvModel.PythonEnvDesc)desc).installCorePackages) break;
                CodeEnvImportUtils.markManagedNotReady(versionRootDir);
                File log = ApplicationConfigurator.getFile((File)this.getEnvLogsDir(CodeEnvModel.EnvLang.PYTHON, envName), (String[])new String[]{"importPythonEnv.log"});
                DKUFileUtils.mkdirsParent((File)log);
                boolean successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, envName, versionDescFolder, versionEnvFolder, versionResourcesFolder, logTailBuilder, log, null);
                if (successfulRun) {
                    CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, envLang, versionRootDir, logTailBuilder, log);
                }
                CodeEnvImportUtils.markManagedReady(versionRootDir);
                break;
            }
            case R: {
                CodeEnvImportUtils.importREnvInFolder(authCtx, versionFolder, exportedEnvDir, this.getEnvLogsDir(CodeEnvModel.EnvLang.R, envName), deploymentMode, specMode, logTailBuilder, overrideDescDirSettings);
            }
        }
        CodeEnvModel.EnvVersionRef ret = new CodeEnvModel.EnvVersionRef();
        ret.envName = envName;
        ret.envVersion = versionFolder.getName();
        logger.info((Object)("Imported version " + versionFolder.getName() + " of " + envName));
        return ret;
    }

    private void createPythonEnvInFolder(AuthCtx authCtx, File versionFolder, CodeEnvModel.AutomationNewEnvSpec spec, DKUtils.SmartLogTailBuilder logTailBuilder, File log, InfoMessage.InfoMessages ret) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(versionFolder);
        File versionDescFolder = new File(versionFolder, "desc");
        File versionEnvFolder = new File(versionFolder, "env");
        DKUFileUtils.mkdirs((File)versionDescFolder);
        DKUFileUtils.mkdirs((File)new File(versionDescFolder, "spec"));
        DKUFileUtils.mkdirs((File)new File(versionDescFolder, "actual"));
        CodeEnvModel.PythonEnvDesc initialDesc = (CodeEnvModel.PythonEnvDesc)JSON.parse((String)JSON.json((Object)spec), CodeEnvModel.PythonEnvDesc.class);
        initialDesc.versionTag = initialDesc.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
        initialDesc.corePackagesSet = CodeEnvModel.getDefaultCorePackagesSet(initialDesc.pythonInterpreter);
        JSON.prettyToFile((Object)initialDesc, (File)new File(versionDescFolder, "desc.json"));
        try (FileOutputStream fos = new FileOutputStream(new File(versionDescFolder, "spec/" + CodeEnvModel.EnvLang.PYTHON.getPackageFileName()), false);){
            IOUtils.write((String)"", (OutputStream)fos);
        }
        if (initialDesc.conda) {
            fos = new FileOutputStream(new File(versionDescFolder, "spec/environment.spec"), false);
            try {
                IOUtils.write((String)"", (OutputStream)fos);
            }
            finally {
                fos.close();
            }
        }
        fos = new FileOutputStream(DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec", "resources_init.py"}), false);
        try {
            IOUtils.write((String)"", (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        PythonCodeEnvUtils.createEmptyPyEnvFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, null);
        try {
            PythonCodeEnvUtils.installPyEnvPackagesFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, null);
        }
        catch (Exception e) {
            logger.error((Object)"Initial code env packages installation failed", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, "Initial code env packages installation failed");
        }
        CodeEnvImportUtils.markManagedReady(versionFolder);
        CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.PYTHON, versionFolder, logTailBuilder, log);
    }

    private void recreatePythonEnvInFolder(AuthCtx authCtx, String envName, File versionFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, CodeEnvModel.AutomationEnvRootDef rootDef, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        boolean successfulRun;
        CodeEnvImportUtils.markManagedNotReady(versionFolder);
        File versionDescFolder = DKUFileUtils.getWithin((File)versionFolder, (String[])new String[]{"desc"});
        File versionEnvFolder = DKUFileUtils.getWithin((File)versionFolder, (String[])new String[]{"env"});
        File versionResourcesFolder = DKUFileUtils.getWithin((File)versionFolder, (String[])new String[]{"resources"});
        logTailBuilder.appendLine("Clearing code environment ...");
        CodeEnvUtilsBase.addLogHeader(authCtx, log, "clear environment", "");
        logger.info((Object)("Clear env " + envName + " to rebuild from scratch"));
        try {
            DKUFileUtils.forceDelete((File)versionEnvFolder);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to clear env", (Throwable)e);
        }
        DKUFileUtils.mkdirsParent((File)versionEnvFolder);
        logger.info((Object)("Clear env " + envName + " resources to rebuild from scratch"));
        if (versionResourcesFolder.exists()) {
            try {
                DKUFileUtils.forceDelete((File)versionResourcesFolder);
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to clear env resources", (Throwable)e);
            }
        }
        logTailBuilder.appendLine("Creating new pyenv environment according to spec ...");
        PythonCodeEnvUtils.createEmptyPyEnvFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, rootDef.envSettings.overrideImportedEnvSettings ? rootDef.envSettings : null);
        PythonCodeEnvUtils.installPyEnvPackagesFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, rootDef.envSettings.overrideImportedEnvSettings ? rootDef.envSettings : null);
        CodeEnvModel.PythonEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(versionFolder, CodeEnvModel.PythonEnvDesc.class);
        if (desc.installCorePackages && updateSettings.updateResources && (successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, envName, versionDescFolder, versionEnvFolder, versionResourcesFolder, logTailBuilder, log, null))) {
            CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.PYTHON, versionFolder, logTailBuilder, log);
        }
        CodeEnvImportUtils.markManagedReady(versionFolder);
    }

    private void createREnvInFolder(AuthCtx authCtx, File versionFolder, CodeEnvModel.AutomationNewEnvSpec spec, DKUtils.SmartLogTailBuilder logTailBuilder, File log, InfoMessage.InfoMessages ret) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(versionFolder);
        File versionDescFolder = new File(versionFolder, "desc");
        File versionEnvFolder = new File(versionFolder, "env");
        DKUFileUtils.mkdirs((File)versionDescFolder);
        DKUFileUtils.mkdirs((File)new File(versionDescFolder, "spec"));
        DKUFileUtils.mkdirs((File)new File(versionDescFolder, "actual"));
        CodeEnvModel.REnvDesc initialDesc = (CodeEnvModel.REnvDesc)JSON.parse((String)JSON.json((Object)spec), CodeEnvModel.REnvDesc.class);
        initialDesc.versionTag = initialDesc.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
        JSON.prettyToFile((Object)initialDesc, (File)new File(versionDescFolder, "desc.json"));
        try (FileOutputStream fos = new FileOutputStream(new File(versionDescFolder, "spec/" + CodeEnvModel.EnvLang.R.getPackageFileName()), false);){
            IOUtils.write((String)"", (OutputStream)fos);
        }
        if (initialDesc.conda) {
            fos = new FileOutputStream(new File(versionDescFolder, "spec/environment.spec"), false);
            try {
                IOUtils.write((String)"", (OutputStream)fos);
            }
            finally {
                fos.close();
            }
        }
        RCodeEnvUtils.createEmptyREnvFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, null);
        try {
            RCodeEnvUtils.installREnvPackagesFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, null);
        }
        catch (Exception e) {
            logger.error((Object)"Initial code env packages installation failed", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, "Initial code env packages installation failed");
        }
        CodeEnvImportUtils.markManagedReady(versionFolder);
        CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.R, versionFolder, logTailBuilder, log);
    }

    private void recreateREnvInFolder(AuthCtx authCtx, String envName, File versionFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, CodeEnvModel.AutomationEnvRootDef rootDef) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(versionFolder);
        File versionDescFolder = new File(versionFolder, "desc");
        File versionEnvFolder = new File(versionFolder, "env");
        logTailBuilder.appendLine("Clearing code environment ...");
        CodeEnvUtilsBase.addLogHeader(authCtx, log, "clear environment", "");
        logger.info((Object)("Clear env " + envName + " to rebuild from scratch"));
        try {
            DKUFileUtils.forceDelete((File)versionEnvFolder);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to clear env", (Throwable)e);
        }
        DKUFileUtils.mkdirsParent((File)versionEnvFolder);
        RCodeEnvUtils.createEmptyREnvFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, rootDef.envSettings.overrideImportedEnvSettings ? rootDef.envSettings : null);
        RCodeEnvUtils.installREnvPackagesFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, rootDef.envSettings.overrideImportedEnvSettings ? rootDef.envSettings : null);
        CodeEnvImportUtils.markManagedReady(versionFolder);
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startImportEnv(AuthCtx authCtx, String owner, CodeEnvModel.CodeEnvDeploymentMode mode, String envName, CodeEnvModel.EnvLang envLang, File envToImportFolder, File envFolderCleanup, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        return this.startImportEnv(authCtx, owner, mode, envName, envLang, envToImportFolder, envFolderCleanup, updateSettings, null, false, null, false);
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startImportEnv(final AuthCtx authCtx, String owner, final CodeEnvModel.CodeEnvDeploymentMode mode, final String envName, final CodeEnvModel.EnvLang envLang, final File envToImportFolder, final File envFolderCleanup, final CodeEnvModel.CodeEnvUpdateSettings updateSettings, final String pluginId, final boolean associateToPlugin, String businessAppId, boolean associateToBusinessApp) throws Exception {
        final CodeEnvModel.AutomationNewEnvSpec spec = new CodeEnvModel.AutomationNewEnvSpec();
        spec.envLang = envLang;
        spec.deploymentMode = mode;
        spec.envName = envName;
        spec.owner = owner;
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        SimpleFutureThread<CodeEnvModel.EnvCreationResult> ft = new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(spec.envLang, spec.envName), (String[])new String[]{"createEnv.log"});
                DKUFileUtils.mkdirsParent((File)log);
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    AutomationNodeCodeEnvsService.this.createEnv(authCtx, spec, null, logTailBuilder, log, ret.messages);
                    File targetEnvRootDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
                    File targetDescFolder = DKUFileUtils.getWithin((File)targetEnvRootDir, (String[])new String[]{"desc"});
                    CodeEnvModel.AbstractEnvDesc desc = AutomationNodeCodeEnvsService.this.importToNonVersionedEnv(authCtx, spec.envLang, spec.envName, envToImportFolder, mode, CodeEnvModel.EnvImportSpecificationMode.SPECIFIED, mode != CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED && updateSettings.updateResources, logTailBuilder);
                    if (StringUtils.isNotBlank((String)pluginId) && associateToPlugin) {
                        String oldEnvName = null;
                        try (RWTransaction t = AutomationNodeCodeEnvsService.this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                            PluginSettings settings = AutomationNodeCodeEnvsService.this.pluginsRegistryService.getSettings(pluginId);
                            oldEnvName = settings.codeEnvName;
                            settings.codeEnvName = envName;
                            AutomationNodeCodeEnvsService.this.pluginsRegistryService.setSettings(pluginId, settings);
                            t.commit("Changed code env on plugin " + pluginId);
                        }
                        if (!StringUtils.equals((String)oldEnvName, (String)envName)) {
                            AutomationNodeCodeEnvsService.this.cdeImageBuilderService.buildIfNeededOnPluginCodeEnvChange(pluginId, logTailBuilder, ret.messages);
                        }
                    }
                    AutomationNodeCodeEnvsService.this.buildEnvDockerImages(targetDescFolder, desc, spec.envLang, logTailBuilder, log, spec.envName, null, ret.messages);
                    ret.messages.withInfo((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_IMPORT_OK, "Imported " + envToImportFolder.getName() + " as code env " + spec.envName);
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                if (envFolderCleanup != null) {
                    DKUFileUtils.forceDelete((File)envFolderCleanup);
                }
                return ret;
            }

            public FuturePayload getPayload() {
                FuturePayload fp = new FuturePayload();
                fp.action = "import_env";
                fp.displayName = "Import env";
                return fp;
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        };
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvVersionCreationResult> startImportEnvVersion(final AuthCtx authCtx, String owner, final String envName, final CodeEnvModel.EnvLang envLang, final File envFolder, final File envFolderCleanup, final CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        final CodeEnvModel.AutomationNewEnvSpec spec = new CodeEnvModel.AutomationNewEnvSpec();
        spec.envLang = envLang;
        spec.deploymentMode = CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED;
        spec.envName = envName;
        spec.owner = owner;
        final CodeEnvModel.AutomationEnvRootDef rootDef = this.getEnvRootDef(envLang, envName);
        logger.infoV("startImportEnvVersion rootDef=%s", new Object[]{JSON.log((Object)rootDef)});
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        SimpleFutureThread<CodeEnvModel.EnvVersionCreationResult> ft = new SimpleFutureThread<CodeEnvModel.EnvVersionCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvVersionCreationResult compute() throws Exception {
                File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(spec.envLang, spec.envName), (String[])new String[]{"createEnv.log"});
                DKUFileUtils.mkdirsParent((File)log);
                CodeEnvModel.EnvVersionCreationResult ret = new CodeEnvModel.EnvVersionCreationResult(spec.envName);
                try {
                    CodeEnvModel.EnvVersionRef versionRef = AutomationNodeCodeEnvsService.this.importNewCodeEnvVersion(authCtx, envLang, envName, envFolder, spec.deploymentMode, CodeEnvModel.EnvImportSpecificationMode.SPECIFIED, rootDef.envSettings.overrideImportedEnvSettings ? rootDef.envSettings : null, updateSettings.updateResources, logTailBuilder);
                    logger.infoV("Imported version: %s", new Object[]{versionRef.envVersion});
                    AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(authCtx, envLang, envName, versionRef.envVersion, logTailBuilder, log, true);
                    File envVersionDir = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionRef.envVersion);
                    if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                        CodeEnvImportUtils.markManagedNotReady(envVersionDir);
                        AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(envLang, envName, versionRef.envVersion, logTailBuilder, log, false);
                        CodeEnvImportUtils.markManagedReady(envVersionDir);
                    }
                    switch (envLang) {
                        case PYTHON: {
                            ret.version = AutomationNodeCodeEnvsService.this.getPythonVersionDetails(versionRef.envVersion, envVersionDir);
                            break;
                        }
                        case R: {
                            ret.version = AutomationNodeCodeEnvsService.this.getRVersionDetails(versionRef.envVersion, envVersionDir);
                        }
                    }
                    File descFolder = DKUFileUtils.getWithin((File)envVersionDir, (String[])new String[]{"desc"});
                    CodeEnvModel.AbstractEnvDesc desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"desc.json"}), envLang.getDescClazz());
                    AutomationNodeCodeEnvsService.this.buildEnvDockerImages(descFolder, desc, envLang, logTailBuilder, log, envName, versionRef.envVersion, ret.messages);
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                if (envFolderCleanup != null) {
                    DKUFileUtils.forceDelete((File)envFolderCleanup);
                }
                return ret;
            }

            public FuturePayload getPayload() {
                FuturePayload fp = new FuturePayload();
                fp.action = "import_env";
                fp.displayName = "Import env";
                return fp;
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        };
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvVersionCreationResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startImportEnvDefStandalone(AuthCtx authCtx, String owner, File zipFile, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        AutoDelete unzipDir = CodeEnvImportUtils.getTempImportFolder("import-" + zipFile.getName());
        ZipUnzipDir.extractFolder(zipFile, (File)unzipDir);
        CodeEnvModel.EnvLang envLang = null;
        File descDir = null;
        for (CodeEnvModel.EnvLang el : CodeEnvModel.EnvLang.values()) {
            if (!new File((File)unzipDir, el.getFolderName()).exists() || !new File(descDir = new File((File)unzipDir, el.getFolderName()), "desc.json").exists()) continue;
            envLang = el;
        }
        if (envLang == null) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INVALID_CODE_ENV_ARCHIVE, "No known code env type in the zip");
        }
        String envName = FilenameUtils.getBaseName((String)zipFile.getName());
        envName = envName.replaceAll("[^A-z0-9\\-_\\.]", "_");
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (CodeEnvModel.CodeEnvListItem existing : this.listCodeEnvs()) {
            st2.addAlreadyTransmogrified(existing.envName);
        }
        String creationEnvName = st2.transmogrify(envName);
        logger.info((Object)("Importing a " + String.valueOf((Object)envLang) + " code env as " + creationEnvName));
        File descFile = new File(descDir, "desc.json");
        CodeEnvModel.AbstractEnvDesc spec = switch (envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.PythonEnvDesc.class);
            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.REnvDesc.class);
            default -> throw new Error("unreachable");
        };
        CodeEnvModel.CodeEnvDeploymentMode deploymentMode = spec.deploymentMode;
        return this.startImportEnv(authCtx, owner, switch (deploymentMode) {
            case CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED -> CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE;
            case CodeEnvModel.CodeEnvDeploymentMode.DESIGN_NON_MANAGED -> CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH;
            case CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED -> deploymentMode;
            case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED, CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH, CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Code envs from automation nodes cannot be exported");
            case CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Code envs for plugins need to be created from the plugin's settings");
            case CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Code envs for Business Applications need to be created from the Business Application's settings");
            case CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "DSS internally managed code envs cannot be exported.");
            default -> throw new Error("unreachable");
        }, creationEnvName, envLang, descDir, (File)unzipDir, updateSettings);
    }

    public FutureResponse<CodeEnvModel.EnvVersionCreationResult> startImportEnvVersion(AuthCtx authCtx, String owner, File zipFile, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        AutoDelete unzipDir = CodeEnvImportUtils.getTempImportFolder("import-" + zipFile.getName());
        ZipUnzipDir.extractFolder(zipFile, (File)unzipDir);
        CodeEnvModel.EnvLang importedEnvLang = null;
        File descDir = null;
        for (CodeEnvModel.EnvLang el : CodeEnvModel.EnvLang.values()) {
            if (!new File((File)unzipDir, el.getFolderName()).exists() || !new File(descDir = new File((File)unzipDir, el.getFolderName()), "desc.json").exists()) continue;
            importedEnvLang = el;
        }
        if (importedEnvLang == null) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INVALID_CODE_ENV_ARCHIVE, "No known code env type in the zip");
        }
        if (importedEnvLang != envLang) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INVALID_CODE_ENV_ARCHIVE, "Wrong type of language for imported env : expected " + String.valueOf((Object)envLang) + ", found " + String.valueOf(importedEnvLang));
        }
        logger.info((Object)("Importing a " + String.valueOf((Object)envLang) + " code env into " + envName));
        File descFile = new File(descDir, "desc.json");
        CodeEnvModel.AbstractEnvDesc spec = switch (envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.PythonEnvDesc.class);
            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.REnvDesc.class);
            default -> throw new Error("unreachable");
        };
        CodeEnvModel.CodeEnvDeploymentMode deploymentMode = spec.deploymentMode;
        switch (deploymentMode) {
            case DSS_INTERNAL: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "DSS internal code envs cannot be versions of a managed code env");
            }
            case DESIGN_MANAGED: {
                logger.info((Object)"Exported env is of right type");
                break;
            }
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Non-managed code envs cannot be versions of a managed code env");
            }
            case EXTERNAL_CONDA_NAMED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "External Conda code envs cannot be versions of a managed code env");
            }
            case AUTOMATION_VERSIONED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case AUTOMATION_SINGLE: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Code envs from automation nodes cannot be exported");
            }
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Code envs for plugins need to be created from the plugin's settings");
            }
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Code envs for Business Applications need to be created from the Business Applications's settings");
            }
            default: {
                throw new Error("unreachable");
            }
        }
        return this.startImportEnvVersion(authCtx, owner, envName, envLang, descDir, (File)unzipDir, updateSettings);
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startCreateEnv(final AuthCtx authCtx, final CodeEnvModel.AutomationNewEnvSpec spec) throws Exception {
        this.accessService.checkEnvDoesntExists(spec.envLang, spec.envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        SimpleFutureThread<CodeEnvModel.EnvCreationResult> ft = new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret;
                block5: {
                    logger.info((Object)("Create env with spec " + JSON.prettyLog((Object)spec)));
                    File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(spec.envLang, spec.envName), (String[])new String[]{"createEnv.log"});
                    DKUFileUtils.mkdirsParent((File)log);
                    ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                    try {
                        AutomationNodeCodeEnvsService.this.createEnv(authCtx, spec, spec.externalCondaEnvName, logTailBuilder, log, ret.messages);
                        if (spec.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE) break block5;
                        File envFolder = AutomationNodeCodeEnvsService.this.createNonVersionedEnv(authCtx, spec.envLang, spec.envName, spec, logTailBuilder, log, ret.messages);
                        if (spec.installJupyterSupport) {
                            try {
                                AutomationNodeManagedEnvUtils.installJupyterSupportForNonVersionedEnv(authCtx, spec.envLang, spec.envName, logTailBuilder, log, true);
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Cannot install jupyter integration for " + spec.envName), (Throwable)e);
                                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                            }
                        }
                        File descFolder = new File(envFolder, "desc");
                        CodeEnvModel.AbstractEnvDesc desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)new File(descFolder, "desc.json"), spec.envLang.getDescClazz());
                        AutomationNodeCodeEnvsService.this.buildEnvDockerImages(descFolder, desc, spec.envLang, logTailBuilder, log, spec.envName, null, ret.messages);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Env creation failed", (Throwable)e);
                        ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                }
                return ret;
            }

            public FuturePayload getPayload() {
                FuturePayload fp = new FuturePayload();
                fp.action = "create_python_env";
                fp.displayName = "Create Python env";
                return fp;
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        };
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    public void createEnv(AuthCtx authCtx, CodeEnvModel.AutomationNewEnvSpec spec, String externalCondaEnvName, DKUtils.SmartLogTailBuilder tailBuilder, File log, InfoMessage.InfoMessages ret) throws Exception {
        if (!((DSSAuthCtx)authCtx).getPermissions().mayCreateCodeEnvs()) {
            throw new DKUSecurityException("You may not create new code envs").withCode((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_NO_CREATION_PERMISSION);
        }
        switch (spec.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case AUTOMATION_SINGLE: 
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case DSS_INTERNAL: {
                File targetEnvDir = AutomationNodeCodeEnvsService.getEnvRootDir(spec.envLang, spec.envName);
                DKUFileUtils.mkdirs((File)targetEnvDir);
                CodeEnvModel.AutomationEnvRootDef rootDef = new CodeEnvModel.AutomationEnvRootDef();
                rootDef.owner = spec.owner;
                rootDef.usableByAll = true;
                rootDef.deploymentMode = spec.deploymentMode;
                JSON.prettyToFile((Object)rootDef, (File)new File(targetEnvDir, "env.json"));
                DKUFileUtils.mkdirs((File)new File(targetEnvDir, "env"));
                this.makeInitialDescFile(spec, externalCondaEnvName, targetEnvDir);
                break;
            }
            case EXTERNAL_CONDA_NAMED: {
                File targetEnvDir = AutomationNodeCodeEnvsService.getEnvRootDir(spec.envLang, spec.envName);
                DKUFileUtils.mkdirs((File)targetEnvDir);
                this.createExternalCondaEnv(spec, externalCondaEnvName, ret, targetEnvDir);
                this.makeInitialDescFile(spec, externalCondaEnvName, targetEnvDir);
                if (!spec.installJupyterSupport) break;
                try {
                    AutomationNodeManagedEnvUtils.installJupyterSupportForNonVersionedEnv(authCtx, spec.envLang, spec.envName, tailBuilder, log, true);
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot install jupyter integration for " + spec.envName), (Throwable)e);
                    ret.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                break;
            }
            case AUTOMATION_VERSIONED: {
                File targetEnvDir = AutomationNodeCodeEnvsService.getEnvRootDir(spec.envLang, spec.envName);
                DKUFileUtils.mkdirs((File)targetEnvDir);
                CodeEnvModel.AutomationEnvRootDef rootDef = new CodeEnvModel.AutomationEnvRootDef();
                rootDef.deploymentMode = spec.deploymentMode;
                rootDef.owner = spec.owner;
                rootDef.usableByAll = true;
                JSON.prettyToFile((Object)rootDef, (File)new File(targetEnvDir, "env.json"));
                DKUFileUtils.mkdirs((File)new File(targetEnvDir, "versions"));
                DKUFileUtils.mkdirs((File)new File(targetEnvDir, "links"));
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new Error("should not be here");
            }
        }
    }

    private void createExternalCondaEnv(CodeEnvModel.AutomationNewEnvSpec spec, String externalCondaEnvName, InfoMessage.InfoMessages ret, File targetEnvDir) throws IOException {
        CodeEnvModel.AutomationEnvRootDef rootDef = new CodeEnvModel.AutomationEnvRootDef();
        rootDef.owner = spec.owner;
        rootDef.usableByAll = true;
        rootDef.deploymentMode = spec.deploymentMode;
        JSON.prettyToFile((Object)rootDef, (File)new File(targetEnvDir, "env.json"));
        try {
            CondaEnvUtils.linkToCondaEnv(externalCondaEnvName, new File(targetEnvDir, "env"));
        }
        catch (IOException e) {
            logger.warn((Object)"Created code env pointing to external conda, but conda env doesn't exist", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONDA_ENV_NOT_FOUND, "Created code env pointing to external conda, but conda env doesn't exist");
        }
    }

    private void makeInitialDescFile(CodeEnvModel.AutomationNewEnvSpec spec, String externalCondaEnvName, File targetEnvDir) throws Error, IOException {
        CodeEnvModel.AbstractEnvDesc desc = switch (spec.envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> new CodeEnvModel.PythonEnvDesc();
            case CodeEnvModel.EnvLang.R -> new CodeEnvModel.REnvDesc();
            default -> throw new Error("unreachable");
        };
        desc.deploymentMode = spec.deploymentMode;
        desc.conda = spec.conda;
        desc.externalCondaEnvName = externalCondaEnvName;
        File descDir = new File(targetEnvDir, "desc");
        DKUFileUtils.mkdirs((File)descDir);
        JSON.prettyToFile((Object)desc, (File)new File(descDir, "desc.json"));
    }

    private CodeEnvModel.AutomationUIPythonEnvVersion getPythonVersionDetails(String versionId, File versionRootDir) throws Exception {
        CodeEnvModel.AutomationUIPythonEnvVersion ret = new CodeEnvModel.AutomationUIPythonEnvVersion();
        ret.versionId = versionId;
        ret.path = new File(versionRootDir, "env").getAbsolutePath();
        File descDesc = this.f(versionRootDir, "desc", "desc.json");
        if (!descDesc.isFile()) {
            return ret;
        }
        ret.desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descDesc, CodeEnvModel.PythonEnvDesc.class);
        if (((CodeEnvModel.PythonEnvDesc)ret.desc).corePackagesSet == null) {
            ((CodeEnvModel.PythonEnvDesc)ret.desc).corePackagesSet = CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.LEGACY_PANDAS023;
        }
        ret.ready = this.f(versionRootDir, "ready.txt").isFile();
        this.setContainerConfigurationForEnv(ret, (CodeEnvModel.PythonEnvDesc)ret.desc);
        ret.predefinedContainerHooks = ((CodeEnvModel.PythonEnvDesc)ret.desc).predefinedContainerHooks;
        File specFile = this.f(versionRootDir, "desc", "spec", "environment.spec");
        File reqFile = this.f(versionRootDir, "desc", "spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName());
        File resourcesInitScriptFile = this.f(versionRootDir, "desc", "spec", "resources_init.py");
        File infoFile = this.f(versionRootDir, "desc", "actual", "info.json");
        File aspecFile = this.f(versionRootDir, "desc", "actual", "environment.spec");
        File areqFile = this.f(versionRootDir, "desc", "actual", CodeEnvModel.EnvLang.PYTHON.getPackageFileName());
        if (specFile.isFile()) {
            ret.specCondaEnvironment = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
        }
        if (reqFile.isFile()) {
            ret.specPackageList = FileUtils.readFileToString((File)reqFile, (Charset)StandardCharsets.UTF_8);
        }
        if (resourcesInitScriptFile.isFile()) {
            ret.resourcesInitScript = FileUtils.readFileToString((File)resourcesInitScriptFile, (Charset)StandardCharsets.UTF_8);
        }
        if (infoFile.isFile()) {
            ret.info = (CodeEnvModel.PythonEnvInfo)JSON.parseFile((File)infoFile, CodeEnvModel.PythonEnvInfo.class);
        }
        if (aspecFile.isFile()) {
            ret.actualCondaEnvironment = FileUtils.readFileToString((File)aspecFile, (Charset)StandardCharsets.UTF_8);
        }
        if (areqFile.isFile()) {
            ret.actualPackageList = FileUtils.readFileToString((File)areqFile, (Charset)StandardCharsets.UTF_8);
        }
        if (((CodeEnvModel.PythonEnvDesc)ret.desc).installCorePackages) {
            if (((CodeEnvModel.PythonEnvDesc)ret.desc).conda) {
                ret.mandatoryCondaEnvironment = CodeEnvPackageSystems.CONDA_PYTHON.getMandatoryPackageList(ret.desc);
            }
            ret.mandatoryPackageList = CodeEnvPackageSystems.PIP.getMandatoryPackageList(ret.desc);
        }
        return ret;
    }

    private CodeEnvModel.AutomationUIREnvVersion getRVersionDetails(String versionId, File versionRootDir) throws Exception {
        CodeEnvModel.AutomationUIREnvVersion ret = new CodeEnvModel.AutomationUIREnvVersion();
        ret.versionId = versionId;
        ret.path = new File(versionRootDir, "env").getAbsolutePath();
        File descDesc = this.f(versionRootDir, "desc", "desc.json");
        if (!descDesc.isFile()) {
            return ret;
        }
        ret.desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descDesc, CodeEnvModel.REnvDesc.class);
        ret.ready = this.f(versionRootDir, "ready.txt").isFile();
        this.setContainerConfigurationForEnv(ret, (CodeEnvModel.REnvDesc)ret.desc);
        File specFile = this.f(versionRootDir, "desc", "spec", "environment.spec");
        File reqFile = this.f(versionRootDir, "desc", "spec", CodeEnvModel.EnvLang.R.getPackageFileName());
        File aspecFile = this.f(versionRootDir, "desc", "actual", "environment.spec");
        File areqFile = this.f(versionRootDir, "desc", "actual", CodeEnvModel.EnvLang.R.getPackageFileName());
        if (specFile.isFile()) {
            ret.specCondaEnvironment = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
        }
        if (reqFile.isFile()) {
            ret.specPackageList = FileUtils.readFileToString((File)reqFile, (Charset)StandardCharsets.UTF_8);
        }
        if (aspecFile.isFile()) {
            ret.actualCondaEnvironment = FileUtils.readFileToString((File)aspecFile, (Charset)StandardCharsets.UTF_8);
        }
        if (areqFile.isFile()) {
            ret.actualPackageList = FileUtils.readFileToString((File)areqFile, (Charset)StandardCharsets.UTF_8);
        }
        if (((CodeEnvModel.REnvDesc)ret.desc).installCorePackages) {
            if (((CodeEnvModel.REnvDesc)ret.desc).conda) {
                ret.mandatoryCondaEnvironment = CodeEnvPackageSystems.CONDA_R.getMandatoryPackageList(ret.desc);
            }
            ret.mandatoryPackageList = CodeEnvPackageSystems.R.getMandatoryPackageList(ret.desc);
        }
        return ret;
    }

    public void saveEnvForUI(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.AutomationUIEnv<?> upe, boolean mayUpdatePermissions) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        if (mayUpdatePermissions) {
            rootDef.owner = upe.owner;
            rootDef.usableByAll = upe.usableByAll;
            rootDef.permissions = upe.permissions;
        }
        rootDef.envSettings = upe.envSettings;
        this.setContainerConfigurationForEnv(rootDef, upe);
        JSON.prettyToFile((Object)rootDef, (File)new File(envDir, "env.json"));
        switch (rootDef.deploymentMode) {
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case DSS_INTERNAL: {
                File versionRootDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
                Iterator uiVersion = upe.noVersion;
                this.saveEnvVersionForUI(envLang, upe, versionRootDir, (CodeEnvModel.AbstractAutomationUIEnvVersion<?>)((Object)uiVersion));
                break;
            }
            case AUTOMATION_SINGLE: {
                File versionRootDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
                Iterator uiVersion = upe.currentVersion;
                this.saveEnvVersionForUI(envLang, upe, versionRootDir, (CodeEnvModel.AbstractAutomationUIEnvVersion<?>)((Object)uiVersion));
                break;
            }
            case AUTOMATION_VERSIONED: {
                List versions = upe.versions;
                for (CodeEnvModel.AbstractAutomationUIEnvVersion versionToSave : versions) {
                    File versionRootDir = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionToSave.versionId);
                    this.saveEnvVersionForUI(envLang, upe, versionRootDir, versionToSave);
                }
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        if (rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
            File targetEnvDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
            try {
                CondaEnvUtils.linkToCondaEnv(upe.externalCondaEnvName, new File(targetEnvDir, "env"));
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot find conda environment", (Throwable)e);
            }
        }
    }

    public void saveEnvVersionForUI(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.AbstractAutomationUIEnvVersion<?> ue) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        switch (rootDef.deploymentMode) {
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case AUTOMATION_SINGLE: 
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case DSS_INTERNAL: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot update specific version in a single-version env");
            }
            case AUTOMATION_VERSIONED: {
                File versionRootDir = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, ue.versionId);
                this.saveEnvVersionForUI(envLang, null, versionRootDir, ue);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    private void saveEnvVersionForUI(CodeEnvModel.EnvLang envLang, CodeEnvModel.AutomationUIEnv<?> upe, File versionRootDir, CodeEnvModel.AbstractAutomationUIEnvVersion<?> uiVersion) throws Exception {
        GeneralSettingsDAO.SecuritySettings securitySettings = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().security;
        File descDesc = this.f(versionRootDir, "desc", "desc.json");
        File specFile = this.f(versionRootDir, "desc", "spec", "environment.spec");
        File reqFile = this.f(versionRootDir, "desc", "spec", envLang.getPackageFileName());
        File resourcesInitScriptFile = this.f(versionRootDir, "desc", "spec", "resources_init.py");
        switch (envLang) {
            case PYTHON: {
                FileOutputStream fos;
                CodeEnvModel.AutomationUIPythonEnvVersion pVersion = (CodeEnvModel.AutomationUIPythonEnvVersion)uiVersion;
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)descDesc, CodeEnvModel.PythonEnvDesc.class);
                desc.useReferenceSpec = ((CodeEnvModel.PythonEnvDesc)pVersion.desc).useReferenceSpec;
                desc.yarnPythonBin = ((CodeEnvModel.PythonEnvDesc)pVersion.desc).yarnPythonBin;
                desc.corePackagesSet = ((CodeEnvModel.PythonEnvDesc)pVersion.desc).corePackagesSet;
                desc.dockerImageResources = ((CodeEnvModel.PythonEnvDesc)pVersion.desc).dockerImageResources;
                desc.envSettings = ((CodeEnvModel.PythonEnvDesc)pVersion.desc).envSettings;
                desc.updateResourcesApiNode = securitySettings.enableCodeEnvResources ? ((CodeEnvModel.PythonEnvDesc)pVersion.desc).updateResourcesApiNode : false;
                desc.externalCondaEnvName = upe == null ? null : upe.externalCondaEnvName;
                desc.predefinedContainerHooks = ((CodeEnvModel.PythonEnvDesc)pVersion.desc).predefinedContainerHooks;
                this.setContainerConfigurationForEnv(desc, (CodeEnvModel.PythonEnvDesc)pVersion.desc);
                desc.containerConfs = pVersion.containerConfs;
                desc.allContainerConfs = pVersion.allContainerConfs;
                desc.allSparkKubernetesConfs = pVersion.allSparkKubernetesConfs;
                desc.sparkKubernetesConfs = pVersion.sparkKubernetesConfs;
                JSON.prettyToFile((Object)desc, (File)descDesc);
                if (pVersion.specCondaEnvironment != null) {
                    fos = new FileOutputStream(specFile, false);
                    try {
                        IOUtils.write((String)pVersion.specCondaEnvironment, (OutputStream)fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                if (pVersion.specPackageList != null) {
                    fos = new FileOutputStream(reqFile, false);
                    try {
                        IOUtils.write((String)pVersion.specPackageList, (OutputStream)fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                fos = new FileOutputStream(resourcesInitScriptFile, false);
                try {
                    IOUtils.write((String)pVersion.resourcesInitScript, (OutputStream)fos);
                    break;
                }
                finally {
                    fos.close();
                }
            }
            case R: {
                FileOutputStream fos;
                CodeEnvModel.AutomationUIREnvVersion rVersion = (CodeEnvModel.AutomationUIREnvVersion)uiVersion;
                CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)descDesc, CodeEnvModel.REnvDesc.class);
                desc.yarnRBin = ((CodeEnvModel.REnvDesc)rVersion.desc).yarnRBin;
                desc.externalCondaEnvName = upe == null ? null : upe.externalCondaEnvName;
                desc.envSettings = ((CodeEnvModel.REnvDesc)rVersion.desc).envSettings;
                this.setContainerConfigurationForEnv(desc, (CodeEnvModel.REnvDesc)rVersion.desc);
                desc.containerConfs = rVersion.containerConfs;
                desc.allContainerConfs = rVersion.allContainerConfs;
                desc.allSparkKubernetesConfs = rVersion.allSparkKubernetesConfs;
                desc.sparkKubernetesConfs = rVersion.sparkKubernetesConfs;
                JSON.prettyToFile((Object)desc, (File)descDesc);
                if (rVersion.specCondaEnvironment != null) {
                    fos = new FileOutputStream(specFile, false);
                    try {
                        IOUtils.write((String)rVersion.specCondaEnvironment, (OutputStream)fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                if (rVersion.specPackageList == null) break;
                fos = new FileOutputStream(reqFile, false);
                try {
                    IOUtils.write((String)rVersion.specPackageList, (OutputStream)fos);
                    break;
                }
                finally {
                    fos.close();
                }
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    private <TEnvDesc extends CodeEnvModel.ContainerConfBearingDesc, TEnvSource extends CodeEnvModel.ContainerConfBearingDesc> void setContainerConfigurationForEnv(TEnvDesc targetEnvDesc, TEnvSource sourceEnvDesc) {
        targetEnvDesc.allContainerConfs = sourceEnvDesc.allContainerConfs;
        targetEnvDesc.containerConfs = sourceEnvDesc.containerConfs;
        targetEnvDesc.allSparkKubernetesConfs = sourceEnvDesc.allSparkKubernetesConfs;
        targetEnvDesc.sparkKubernetesConfs = sourceEnvDesc.sparkKubernetesConfs;
        targetEnvDesc.dockerfileAtStart = sourceEnvDesc.dockerfileAtStart;
        targetEnvDesc.dockerfileBeforePackages = sourceEnvDesc.dockerfileBeforePackages;
        targetEnvDesc.dockerfileAfterCondaPackages = sourceEnvDesc.dockerfileAfterCondaPackages;
        targetEnvDesc.dockerfileAfterPackages = sourceEnvDesc.dockerfileAfterPackages;
        targetEnvDesc.dockerfileAtEnd = sourceEnvDesc.dockerfileAtEnd;
        targetEnvDesc.containerCacheBustingLocation = sourceEnvDesc.containerCacheBustingLocation;
    }

    public CodeEnvModel.AutomationUIEnv<?> getEnvForUI(CodeEnvModel.EnvLang envLang, String envName, boolean withKernelSpec) throws Exception {
        switch (envLang) {
            case PYTHON: {
                return this.getPythonEnvForUI(envName, withKernelSpec);
            }
            case R: {
                return this.getREnvForUI(envName, withKernelSpec);
            }
        }
        throw new Error("unreachable");
    }

    public CodeEnvModel.AbstractAutomationUIEnvVersion<?> getEnvVersionForUI(CodeEnvModel.EnvLang envLang, String envName, String versionId) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        switch (rootDef.deploymentMode) {
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case AUTOMATION_SINGLE: 
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case DSS_INTERNAL: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot get single version of a non versioned code env");
            }
            case AUTOMATION_VERSIONED: {
                switch (envLang) {
                    case PYTHON: {
                        return this.getPythonVersionDetails(versionId, AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionId));
                    }
                    case R: {
                        return this.getRVersionDetails(versionId, AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionId));
                    }
                }
                throw new Error("unreachable");
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Cannot have design-type code envs on automation node");
            }
        }
        throw new Error("unreachable");
    }

    private void addKernelSpecNameIfExists(String envName, CodeEnvModel.AutomationUIEnv<?> env) throws IOException {
        try {
            List<JupyterService.KernelSpec> kernelSpecs = this.jupyterService.listKernelSpecs();
            if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                this.addVersionedKernelSpecNameIfExists(envName, env, kernelSpecs);
            } else if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE) {
                this.addNonVersionedKernelSpecNameIfExists(envName, env, kernelSpecs);
            } else if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED || env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED || env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED || env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED || env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH) {
                this.addNoVersionKernelSpecNameIfExists(envName, env, kernelSpecs);
            } else {
                this.addExternalKernelSpecNameIfExists(envName, env, kernelSpecs);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get kernelSpecs", (Throwable)e);
            env.unknownKernelSpecStatus = true;
            env.kernelSpecsListingError = new SerializedError((Throwable)e, true);
        }
    }

    private void addExternalKernelSpecNameIfExists(String envName, CodeEnvModel.AutomationUIEnv<?> env, List<JupyterService.KernelSpec> kernelSpecs) throws Error {
        for (JupyterService.KernelSpec kernelSpec : kernelSpecs) {
            if (!StringUtils.isNotBlank((String)kernelSpec.envName) || !kernelSpec.envName.equals(envName)) continue;
            ((CodeEnvModel.AbstractAutomationUIEnvVersion)env.noVersion).kernelSpecName = kernelSpec.name;
        }
    }

    private void addNonVersionedKernelSpecNameIfExists(String envName, CodeEnvModel.AutomationUIEnv<?> env, List<JupyterService.KernelSpec> kernelSpecs) throws Error {
        for (JupyterService.KernelSpec kernelSpec : kernelSpecs) {
            if (!StringUtils.isNotBlank((String)kernelSpec.envName) || !kernelSpec.envName.equals(envName)) continue;
            ((CodeEnvModel.AbstractAutomationUIEnvVersion)env.currentVersion).kernelSpecName = kernelSpec.name;
        }
    }

    private void addNoVersionKernelSpecNameIfExists(String envName, CodeEnvModel.AutomationUIEnv<?> env, List<JupyterService.KernelSpec> kernelSpecs) throws Error {
        for (JupyterService.KernelSpec kernelSpec : kernelSpecs) {
            if (!StringUtils.isNotBlank((String)kernelSpec.envName) || !kernelSpec.envName.equals(envName)) continue;
            ((CodeEnvModel.AbstractAutomationUIEnvVersion)env.noVersion).kernelSpecName = kernelSpec.name;
        }
    }

    private void addVersionedKernelSpecNameIfExists(String envName, CodeEnvModel.AutomationUIEnv<?> env, List<JupyterService.KernelSpec> kernelSpecs) throws Error {
        for (CodeEnvModel.AbstractAutomationUIEnvVersion version : env.versions) {
            this.addKernelSpecNamesIfExists(envName, version, kernelSpecs);
        }
    }

    private void addKernelSpecNamesIfExists(String envName, CodeEnvModel.AbstractAutomationUIEnvVersion<?> env, List<JupyterService.KernelSpec> kernelSpecs) {
        for (String link : env.links) {
            Pair<String, String> projectKeyBundle = AutomationNodeManagedEnvUtils.readProjectKeyBundleFromLink(link);
            String projectKey = (String)projectKeyBundle.first;
            String bundleId = (String)projectKeyBundle.second;
            logger.info((Object)("Looking for jupyter kernels to " + projectKey + "." + bundleId));
            for (JupyterService.KernelSpec kernelSpec : kernelSpecs) {
                if (!envName.equals(kernelSpec.envName) || !projectKey.equals(kernelSpec.projectKey) || !bundleId.equals(kernelSpec.bundleId)) continue;
                env.kernelSpecNames.put(link, kernelSpec.name);
            }
        }
    }

    public CodeEnvModel.AutomationUIPythonEnv getPythonEnvForUI(String envName, boolean withKernelSpec) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.PYTHON, envName);
        CodeEnvModel.AutomationUIPythonEnv upe = new CodeEnvModel.AutomationUIPythonEnv();
        upe.envName = envName;
        upe.envLang = CodeEnvModel.EnvLang.PYTHON;
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        upe.deploymentMode = rootDef.deploymentMode;
        upe.owner = rootDef.owner;
        upe.usableByAll = rootDef.usableByAll;
        upe.permissions = rootDef.permissions;
        upe.envSettings = rootDef.envSettings;
        upe.allContainerConfs = rootDef.allContainerConfs;
        upe.containerConfs = rootDef.containerConfs;
        upe.allSparkKubernetesConfs = rootDef.allSparkKubernetesConfs;
        upe.sparkKubernetesConfs = rootDef.sparkKubernetesConfs;
        switch (upe.deploymentMode) {
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case DSS_INTERNAL: {
                upe.noVersion = this.getPythonVersionDetails(null, envDir);
                break;
            }
            case AUTOMATION_SINGLE: {
                upe.currentVersion = this.getPythonVersionDetails(null, envDir);
                break;
            }
            case AUTOMATION_VERSIONED: {
                for (String versionId : this.listValidVersions(CodeEnvModel.EnvLang.PYTHON, envName)) {
                    CodeEnvModel.AutomationUIPythonEnvVersion versionDetails = this.getPythonVersionDetails(versionId, AutomationNodeCodeEnvsService.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionId));
                    versionDetails.links.addAll(AutomationNodeManagedEnvUtils.listBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, versionId));
                    upe.versions.add(versionDetails);
                }
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new Error("unreachable");
            }
        }
        if (upe.noVersion != null && ((CodeEnvModel.AutomationUIPythonEnvVersion)upe.noVersion).desc != null) {
            upe.externalCondaEnvName = ((CodeEnvModel.PythonEnvDesc)((CodeEnvModel.AutomationUIPythonEnvVersion)upe.noVersion).desc).externalCondaEnvName;
        }
        if (withKernelSpec) {
            this.addKernelSpecNameIfExists(envName, upe);
        }
        return upe;
    }

    public CodeEnvModel.AutomationEnvRootDef getEnvRootDef(CodeEnvModel.EnvLang envLang, String envName) throws Exception {
        return this.accessService.getEnvRootDef(envLang, envName);
    }

    public CodeEnvModel.AutomationUIREnv getREnvForUI(String envName, boolean withKernelSpec) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.R, envName);
        CodeEnvModel.AutomationUIREnv upe = new CodeEnvModel.AutomationUIREnv();
        upe.envName = envName;
        upe.envLang = CodeEnvModel.EnvLang.R;
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        upe.deploymentMode = rootDef.deploymentMode;
        upe.owner = rootDef.owner;
        upe.usableByAll = rootDef.usableByAll;
        upe.permissions = rootDef.permissions;
        upe.envSettings = rootDef.envSettings;
        upe.allContainerConfs = rootDef.allContainerConfs;
        upe.containerConfs = rootDef.containerConfs;
        upe.allSparkKubernetesConfs = rootDef.allSparkKubernetesConfs;
        upe.sparkKubernetesConfs = rootDef.sparkKubernetesConfs;
        switch (upe.deploymentMode) {
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_MANAGED: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case DSS_INTERNAL: {
                upe.noVersion = this.getRVersionDetails(null, envDir);
                break;
            }
            case AUTOMATION_SINGLE: {
                upe.currentVersion = this.getRVersionDetails(null, envDir);
                break;
            }
            case AUTOMATION_VERSIONED: {
                for (String versionId : this.listValidVersions(CodeEnvModel.EnvLang.R, envName)) {
                    CodeEnvModel.AutomationUIREnvVersion versionDetails = this.getRVersionDetails(versionId, AutomationNodeCodeEnvsService.getEnvVersionDir(CodeEnvModel.EnvLang.R, envName, versionId));
                    versionDetails.links.addAll(AutomationNodeManagedEnvUtils.listBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, versionId));
                    upe.versions.add(versionDetails);
                }
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new Error("unreachable");
            }
        }
        if (upe.noVersion != null && ((CodeEnvModel.AutomationUIREnvVersion)upe.noVersion).desc != null) {
            upe.externalCondaEnvName = ((CodeEnvModel.REnvDesc)((CodeEnvModel.AutomationUIREnvVersion)upe.noVersion).desc).externalCondaEnvName;
        }
        if (withKernelSpec) {
            this.addKernelSpecNameIfExists(envName, upe);
        }
        return upe;
    }

    public CodeEnvModel.PythonEnvActualData computePyEnvActualData(AuthCtx authCtx, String envName, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        return PythonCodeEnvUtils.computePyEnvActualData(authCtx, new File(AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.PYTHON, envName), "env"), logTailBuilder, log);
    }

    public CodeEnvModel.REnvActualData computeREnvActualData(AuthCtx authCtx, String envName, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        return RCodeEnvUtils.computeREnvActualData(authCtx, new File(AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.R, envName), "env"), logTailBuilder, log);
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startUpdateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang language, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        return this.startUpdateEnvAccordingToSpec(authCtx, language, envName, updateSettings, null, false);
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startUpdateEnvAccordingToSpec(final AuthCtx authCtx, final CodeEnvModel.EnvLang language, final String envName, final CodeEnvModel.CodeEnvUpdateSettings updateSettings, final String pluginId, final boolean rebuildCodeStudioTemplate) throws Exception {
        this.accessService.checkEnvExists(language, envName);
        final DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                try {
                    CodeEnvModel.PythonEnvDesc desc;
                    File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(language, envName), (String[])new String[]{"updateEnvFolderAccordingToSpec.log"});
                    DKUFileUtils.mkdirsParent((File)log);
                    CodeEnvModel.AutomationEnvRootDef rootDef = AutomationNodeCodeEnvsService.this.getEnvRootDef(language, envName);
                    if (language == CodeEnvModel.EnvLang.PYTHON && rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL && (desc = AutomationNodeManagedEnvUtils.getEnvDesc(AutomationNodeCodeEnvsService.getEnvRootDir(language, envName), CodeEnvModel.PythonEnvDesc.class)).useReferenceSpec()) {
                        DSSInternalCodeEnvsService.DSSInternalCodeEnv dssInternalCodeEnv = DSSInternalCodeEnvsService.DSSInternalCodeEnv.fromName(envName);
                        if (!dssInternalCodeEnv.isCompatibleWithInterpreter(desc.pythonInterpreter)) {
                            List<StandardPythonInterpreter> availablePythonInterpreters = AutomationNodeCodeEnvsService.this.availablePythonInterpretersService.getAvailablePythonInterpreters();
                            Optional<StandardPythonInterpreter> newInterpreter = DSSInternalCodeEnvsService.getPreferredInstalledInterpreterOrNull(dssInternalCodeEnv.codeEnvType, dssInternalCodeEnv.version, availablePythonInterpreters);
                            if (newInterpreter.isEmpty()) {
                                List<StandardPythonInterpreter> supportedInterpreters = DSSInternalCodeEnvsService.getSupportedInterpreters(dssInternalCodeEnv.codeEnvType);
                                String message = String.format("No supported interpreter is available on the machine to update the '%s' internal code env. Supported interpreters are: '%s'", envName, supportedInterpreters.stream().map(Enum::toString).collect(Collectors.joining(", ")));
                                tailBuilder.appendLine(message);
                                throw new UnsupportedOperationException(message);
                            }
                            String message = String.format("Current interpreter '%s' for internal code env '%s' is not supported. Updating its Python interpreter to '%s' instead.", new Object[]{desc.pythonInterpreter, envName, newInterpreter.get()});
                            tailBuilder.appendLine(message);
                            logger.info((Object)message);
                            desc.pythonInterpreter = newInterpreter.get();
                            AutomationNodeCodeEnvsService.this.updateDesc(CodeEnvModel.EnvLang.PYTHON, envName, desc);
                            logger.info((Object)"Interpreter updated successfully. Forcing rebuild.");
                            tailBuilder.appendLine("Interpreter updated successfully. Forcing rebuild.");
                            updateSettings.forceRebuildEnv = true;
                        }
                        AutomationNodeCodeEnvsService.this.updateSpecFromInternalResources(authCtx, dssInternalCodeEnv, tailBuilder, log);
                        updateSettings.upgradeAllPackages = true;
                        updateSettings.updateResources = true;
                    }
                    if (updateSettings.forceRebuildEnv) {
                        AutomationNodeCodeEnvsService.this.recreateEnvAccordingToSpec(authCtx, language, envName, updateSettings, tailBuilder, log);
                    }
                    Pair<File, String> envDetails = AutomationNodeCodeEnvsService.this.updateEnvAccordingToSpec(authCtx, language, envName, updateSettings, tailBuilder);
                    File envRootDir = (File)envDetails.first;
                    File descFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                    File resourcesFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"resources"});
                    File envFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"env"});
                    CodeEnvModel.AbstractEnvDesc desc2 = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, language.getDescClazz());
                    if (language == CodeEnvModel.EnvLang.PYTHON) {
                        boolean successfulRun;
                        CodeEnvImportUtils.markManagedNotReady(envRootDir);
                        if (((CodeEnvModel.PythonEnvDesc)desc2).installCorePackages && updateSettings.updateResources && (successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, envName, descFolder, envFolder, resourcesFolder, tailBuilder, log, ret.messages))) {
                            CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, language, envRootDir, tailBuilder, log);
                        }
                        CodeEnvImportUtils.markManagedReady(envRootDir);
                    }
                    AutomationNodeCodeEnvsService.this.buildEnvDockerImages(descFolder, desc2, language, tailBuilder, log, envName, (String)envDetails.second, ret.messages);
                    if (StringUtils.isNotBlank((String)pluginId)) {
                        AutomationNodeCodeEnvsService.this.cdeImageBuilderService.buildIfNeededOnPluginCodeEnvChange(pluginId, tailBuilder, ret.messages);
                    }
                    try {
                        if (StringUtils.isNotBlank((String)updateSettings.versionToUpdate)) {
                            AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(authCtx, language, envName, updateSettings.versionToUpdate, tailBuilder, log, true);
                            AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(language, envName, updateSettings.versionToUpdate, tailBuilder, log, false);
                        } else {
                            AutomationNodeManagedEnvUtils.installJupyterSupportForNonVersionedEnv(authCtx, language, envName, tailBuilder, log, true);
                            AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForNonVersionedEnv(language, envName, tailBuilder, log, false);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Jupyter install failed", (Throwable)e);
                        ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    ret.messages.withSuccess((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_UPDATE_SUCCESS, "Code env '" + String.valueOf((Object)language) + "/" + envName + "' built with success");
                }
                catch (Exception e) {
                    logger.error((Object)"Env update failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                if (rebuildCodeStudioTemplate) {
                    CodeEnvModel.AutomationUIEnv<?> containerConfBearingDesc = AutomationNodeCodeEnvsService.this.getAutomationUIEnv(authCtx, language, envName);
                    AutomationNodeCodeEnvsService.this.codeStudioTemplatesService.rebuildLinkedCodeStudioTemplate(authCtx, ret, containerConfBearingDesc, language, envName);
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"update_python_env", (String)("Update Python environment " + envName));
            }

            public SmartLogTail getLog() {
                return tailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    public CodeEnvModel.AutomationUIEnv<?> getAutomationUIEnv(AuthCtx authCtx, CodeEnvModel.EnvLang el, String envName) throws Exception {
        CodeEnvModel.AutomationUIEnv<?> automationEnv = this.getEnvForUI(el, envName, true);
        try (Transaction t = this.transactionService.beginRead();){
            automationEnv.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
            automationEnv.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        return automationEnv;
    }

    private void updateDesc(CodeEnvModel.EnvLang language, String envName, CodeEnvModel.PythonEnvDesc envDesc) throws IOException {
        AutomationNodeManagedEnvUtils.writeEnvDesc(AutomationNodeCodeEnvsService.getEnvRootDir(language, envName), envDesc);
    }

    public FutureResponse<CodeEnvModel.EnvImageRebuildResult> startRebuildImage(AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName, final String envVersion) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvImageRebuildResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvImageRebuildResult compute() throws Exception {
                CodeEnvModel.EnvImageRebuildResult ret = new CodeEnvModel.EnvImageRebuildResult();
                try {
                    ret.logFileName = "rebuildImage" + (String)(StringUtils.isNotBlank((String)envVersion) ? "." + envVersion : "") + ".log";
                    File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(envLang, envName), (String[])new String[]{ret.logFileName});
                    DKUFileUtils.mkdirsParent((File)log);
                    if (log.exists()) {
                        log.delete();
                    }
                    File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
                    CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
                    File versionFolder = switch (rootDef.deploymentMode) {
                        case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot build image for a non-managed Python environment");
                        case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED -> envDir;
                        case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED -> AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, envVersion);
                        case CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot build image for an external Python environment");
                        case CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.DESIGN_NON_MANAGED -> throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal Python environment deployment kind");
                        default -> throw new DSSInternalErrorException("Unsupported deployment mode " + String.valueOf((Object)rootDef.deploymentMode));
                    };
                    CodeEnvModel.AbstractEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(versionFolder, envLang.getDescClazz());
                    File versionDescFolder = new File(versionFolder, "desc");
                    ret.imagesBuilt = AutomationNodeCodeEnvsService.this.buildEnvDockerImages(versionDescFolder, desc, envLang, tailBuilder, log, envName, envVersion, ret.messages);
                    if (!log.exists()) {
                        ret.logFileName = null;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Env image rebuild failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"rebuild_env_image", (String)("Rebuild image for " + String.valueOf((Object)envLang) + " environment: " + envName));
            }

            public SmartLogTail getLog() {
                return tailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvImageRebuildResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startUpdatePluginEnv(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName, final File pluginEnvFolder, final CodeEnvModel.CodeEnvUpdateSettings updateSettings, final String pluginId) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.AbstractEnvDesc desc;
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(envName);
                File envRootDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
                File descDir = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                File resourcesDir = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"resources"});
                File envDir = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"env"});
                if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                    desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)descDir, (String[])new String[]{"desc.json"}), CodeEnvModel.PythonEnvDesc.class);
                } else if (envLang == CodeEnvModel.EnvLang.R) {
                    desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)descDir, (String[])new String[]{"desc.json"}), CodeEnvModel.REnvDesc.class);
                } else {
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, "Invalid environment language : " + String.valueOf((Object)envLang));
                    return ret;
                }
                try {
                    AutomationNodeCodeEnvsService.this.updateSpecFromPlugin(authCtx, envLang, envName, pluginEnvFolder);
                    AutomationNodeCodeEnvsService.this.updateEnvFolderAccordingToSpec(authCtx, envLang, envName, envRootDir, updateSettings, tailBuilder);
                    if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                        boolean successfulRun;
                        CodeEnvImportUtils.markManagedNotReady(envRootDir);
                        File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(envLang, envName), (String[])new String[]{"updatePythonEnvResources.log"});
                        DKUFileUtils.mkdirsParent((File)log);
                        if (((CodeEnvModel.PythonEnvDesc)desc).installCorePackages && updateSettings.updateResources && (successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, envName, descDir, envDir, resourcesDir, tailBuilder, log, ret.messages))) {
                            CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, envLang, envRootDir, tailBuilder, log);
                        }
                        CodeEnvImportUtils.markManagedReady(envRootDir);
                    }
                    if (StringUtils.isNotBlank((String)pluginId)) {
                        AutomationNodeCodeEnvsService.this.cdeImageBuilderService.buildIfNeededOnPluginCodeEnvChange(pluginId, tailBuilder, ret.messages);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Env update failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"update_plugin_env", (String)("Update dev plugin environment " + envName));
            }

            public SmartLogTail getLog() {
                return tailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    public void importSpecToDirectory(CodeEnvModel.EnvLang envLang, File destinationDescDirectory, File sourceDirectory, boolean syncPresetFields) throws IOException {
        File sourceCondaSpecFile = DKUFileUtils.getWithin((File)sourceDirectory, (String[])new String[]{"spec", "environment.spec"});
        File installedCondaSpecFile = DKUFileUtils.getWithin((File)destinationDescDirectory, (String[])new String[]{"spec", "environment.spec"});
        if (sourceCondaSpecFile.exists()) {
            FileUtils.copyFile((File)sourceCondaSpecFile, (File)installedCondaSpecFile);
        } else if (installedCondaSpecFile.exists() && !installedCondaSpecFile.delete()) {
            logger.warn((Object)("Unable to delete " + String.valueOf(installedCondaSpecFile)));
        }
        File sourceResourcesInitScriptFile = DKUFileUtils.getWithin((File)sourceDirectory, (String[])new String[]{"spec", "resources_init.py"});
        File installedResourcesInitScriptFile = DKUFileUtils.getWithin((File)destinationDescDirectory, (String[])new String[]{"spec", "resources_init.py"});
        if (sourceResourcesInitScriptFile.exists()) {
            FileUtils.copyFile((File)sourceResourcesInitScriptFile, (File)installedResourcesInitScriptFile);
        } else if (installedResourcesInitScriptFile.exists() && !installedResourcesInitScriptFile.delete()) {
            logger.warn((Object)("Unable to delete " + String.valueOf(installedResourcesInitScriptFile)));
        }
        File sourcePackageListFile = DKUFileUtils.getWithin((File)sourceDirectory, (String[])new String[]{"spec", envLang.getPackageFileName()});
        File installedPackageListFile = DKUFileUtils.getWithin((File)destinationDescDirectory, (String[])new String[]{"spec", envLang.getPackageFileName()});
        FileUtils.copyFile((File)sourcePackageListFile, (File)installedPackageListFile);
        if (envLang == CodeEnvModel.EnvLang.PYTHON && syncPresetFields) {
            File sourceDescFile = DKUFileUtils.getWithin((File)sourceDirectory, (String[])new String[]{"desc.json"});
            File installedDescFile = DKUFileUtils.getWithin((File)destinationDescDirectory, (String[])new String[]{"desc.json"});
            if (sourceDescFile.exists()) {
                CodeEnvModel.PythonEnvDesc sourceDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)sourceDescFile, CodeEnvModel.PythonEnvDesc.class);
                if (installedDescFile.exists()) {
                    CodeEnvModel.PythonEnvDesc destinationDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)installedDescFile, CodeEnvModel.PythonEnvDesc.class);
                    destinationDesc.corePackagesSet = sourceDesc.corePackagesSet;
                    destinationDesc.installCorePackages = sourceDesc.installCorePackages;
                    destinationDesc.predefinedContainerHooks = sourceDesc.predefinedContainerHooks;
                    JSON.prettyToFile((Object)destinationDesc, (File)installedDescFile);
                } else {
                    logger.warnV("Code env desc file not found in %s: will import whole desc file from %s", new Object[]{destinationDescDirectory.getAbsolutePath(), sourceDirectory.getAbsolutePath()});
                    JSON.prettyToFile((Object)sourceDesc, (File)installedDescFile);
                }
            } else {
                throw new IllegalArgumentException("Unable to import predefined container hooks, no desc file found in " + sourceDirectory.getAbsolutePath());
            }
        }
    }

    public void updateSpecFromPlugin(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File pluginEnvFolder) throws IOException {
        File descFolder = DKUFileUtils.getWithin((File)AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName), (String[])new String[]{"desc"});
        this.importSpecToDirectory(envLang, descFolder, pluginEnvFolder, false);
    }

    public void updateSpecFromBusinessApp(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File businessAppEnvFolder) throws IOException {
        File descFolder = DKUFileUtils.getWithin((File)AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName), (String[])new String[]{"desc"});
        this.importSpecToDirectory(envLang, descFolder, businessAppEnvFolder, false);
    }

    public void updateSpecFromInternalResources(AuthCtx authCtx, DSSInternalCodeEnvsService.DSSInternalCodeEnv dssInternalCodeEnv, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws IOException {
        tailBuilder.appendLine("Updating code environment spec from DSS internal resources ...");
        CodeEnvUtilsBase.addLogHeader(authCtx, log, "update internal code env spec", "");
        String envName = dssInternalCodeEnv.getCodeEnvName();
        File envFolder = dssInternalCodeEnv.getResourceSpecFolder();
        File descFolder = DKUFileUtils.getWithin((File)AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.PYTHON, envName), (String[])new String[]{"desc"});
        this.importSpecToDirectory(CodeEnvModel.EnvLang.PYTHON, descFolder, envFolder, true);
    }

    private Pair<File, String> updateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings, DKUtils.SmartLogTailBuilder tailBuilder) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        tailBuilder.appendLine("Updating code environment according to spec ...");
        switch (rootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot update a non-managed Python environment");
            }
            case AUTOMATION_SINGLE: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case DSS_INTERNAL: {
                this.updateEnvFolderAccordingToSpec(authCtx, envLang, envName, envDir, updateSettings, tailBuilder);
                return new Pair((Object)envDir, null);
            }
            case AUTOMATION_VERSIONED: {
                File versionToUpdateFolder = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, updateSettings.versionToUpdate);
                this.updateEnvFolderAccordingToSpec(authCtx, envLang, envName, versionToUpdateFolder, updateSettings, tailBuilder);
                return new Pair((Object)versionToUpdateFolder, (Object)updateSettings.versionToUpdate);
            }
            case EXTERNAL_CONDA_NAMED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot update an external Python environment");
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal Python environment deployment kind");
            }
        }
        throw new DSSInternalErrorException("Unsupported deployment mode " + String.valueOf((Object)rootDef.deploymentMode));
    }

    public void recreateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws Exception {
        File envDir = AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envDir, "env.json");
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
        switch (rootDef.deploymentMode) {
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: {
                tailBuilder.appendLine("Skipping force rebuild for non-managed code environment");
                logger.info((Object)("Skipping force rebuild for non-managed code environment" + envName));
                break;
            }
            case AUTOMATION_SINGLE: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case DSS_INTERNAL: {
                switch (envLang) {
                    case PYTHON: {
                        this.recreatePythonEnvInFolder(authCtx, envName, envDir, tailBuilder, log, rootDef, updateSettings);
                        break;
                    }
                    case R: {
                        this.recreateREnvInFolder(authCtx, envName, envDir, tailBuilder, log, rootDef);
                    }
                }
                break;
            }
            case AUTOMATION_VERSIONED: {
                File versionToUpdateFolder = AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, updateSettings.versionToUpdate);
                switch (envLang) {
                    case PYTHON: {
                        this.recreatePythonEnvInFolder(authCtx, envName, versionToUpdateFolder, tailBuilder, log, rootDef, updateSettings);
                        break;
                    }
                    case R: {
                        this.recreateREnvInFolder(authCtx, envName, versionToUpdateFolder, tailBuilder, log, rootDef);
                    }
                }
                break;
            }
        }
    }

    private void updateEnvFolderAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File envFolder, CodeEnvModel.CodeEnvUpdateSettings updateSettings, DKUtils.SmartLogTailBuilder tailBuilder) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(envFolder);
        File descDir = new File(envFolder, "desc");
        File actualEnvDir = new File(envFolder, "env");
        CodeEnvModel.AutomationEnvRootDef rootDef = this.getEnvRootDef(envLang, envName);
        logger.infoV("updateEnvFolderAccordingToSpec lang=%s name=%s rootDef=%s", new Object[]{envLang, envName, JSON.log((Object)rootDef)});
        File log = ApplicationConfigurator.getFile((File)this.getEnvLogsDir(envLang, envName), (String[])new String[]{"updateEnvFolderAccordingToSpec.log"});
        DKUFileUtils.mkdirsParent((File)log);
        switch (envLang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                GeneralSettingsDAO.AbstractCodeEnvExtraSettings settingsToUse = CodeEnvPackageSystems.getCodeEnvSettings(envDesc);
                if (rootDef.envSettings.overrideImportedEnvSettings) {
                    settingsToUse = rootDef.envSettings;
                }
                if (envDesc.conda) {
                    String specData = "";
                    File specFile = new File(descDir, "spec/environment.spec");
                    if (specFile.exists()) {
                        specData = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
                    } else {
                        logger.info((Object)"conda spec file does not exist");
                    }
                    CodeEnvPackageSystems.CONDA_PYTHON.install(authCtx, actualEnvDir, envDesc, true, specData, true, envDesc.conda, tailBuilder, log, settingsToUse);
                }
                File requirementsFile = new File(descDir, "spec/" + envLang.getPackageFileName());
                CodeEnvPackageSystems.PIP.install(authCtx, actualEnvDir, envDesc, true, FileUtils.readFileToString((File)requirementsFile, (Charset)StandardCharsets.UTF_8), updateSettings.upgradeAllPackages, envDesc.conda, tailBuilder, log, settingsToUse);
                break;
            }
            case R: {
                CodeEnvModel.REnvDesc envDesc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.REnvDesc.class);
                GeneralSettingsDAO.AbstractCodeEnvExtraSettings settingsToUse = CodeEnvPackageSystems.getCodeEnvSettings(envDesc);
                if (rootDef.envSettings.overrideImportedEnvSettings) {
                    settingsToUse = rootDef.envSettings;
                }
                if (envDesc.conda) {
                    String specData = "";
                    File specFile = new File(descDir, "spec/environment.spec");
                    if (specFile.exists()) {
                        specData = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
                    } else {
                        logger.info((Object)"conda spec file does not exist");
                    }
                    CodeEnvPackageSystems.CONDA_R.install(authCtx, actualEnvDir, envDesc, true, specData, true, envDesc.conda, tailBuilder, log, settingsToUse);
                }
                File requirementsFile = new File(descDir, "spec/" + envLang.getPackageFileName());
                CodeEnvPackageSystems.R.install(authCtx, actualEnvDir, envDesc, true, FileUtils.readFileToString((File)requirementsFile, (Charset)StandardCharsets.UTF_8), updateSettings.upgradeAllPackages, envDesc.conda, tailBuilder, log, settingsToUse);
                break;
            }
        }
        CodeEnvImportUtils.markManagedReady(envFolder);
        CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, envLang, envFolder, tailBuilder, log);
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startInstallJupyterSupport(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName, final String versionId) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                try {
                    File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(envLang, envName), (String[])new String[]{"installJupyterSupport.log"});
                    DKUFileUtils.mkdirsParent((File)log);
                    if (StringUtils.isNotBlank((String)versionId)) {
                        AutomationNodeManagedEnvUtils.installJupyterSupportForVersionedEnv(authCtx, envLang, envName, versionId, logTailBuilder, log, false);
                        AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForVersionedEnv(envLang, envName, versionId, logTailBuilder, log, true);
                    } else {
                        AutomationNodeManagedEnvUtils.installJupyterSupportForNonVersionedEnv(authCtx, envLang, envName, logTailBuilder, log, false);
                        AutomationNodeManagedEnvUtils.addResourcesEnvVariablesToJupyterKernelForNonVersionedEnv(envLang, envName, logTailBuilder, log, true);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter install failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"install_jupyter_support", (String)("Install Jupyter support in env " + envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startRemoveJupyterSupport(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName, final String versionId) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                try {
                    File log = ApplicationConfigurator.getFile((File)AutomationNodeCodeEnvsService.this.getEnvLogsDir(envLang, envName), (String[])new String[]{"removeJupyterSupport.log"});
                    DKUFileUtils.mkdirsParent((File)log);
                    if (StringUtils.isNotBlank((String)versionId)) {
                        AutomationNodeManagedEnvUtils.removeJupyterSupportForVersionedEnv(authCtx, envLang, envName, versionId, logTailBuilder, log);
                    } else {
                        AutomationNodeManagedEnvUtils.removeJupyterSupportForNonVersionedEnv(authCtx, envLang, envName, logTailBuilder, log);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter removal failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_REMOVAL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"remove_jupyter_support", (String)("Remove Jupyter support in env " + envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvDeletionResult> startEnvDelete(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvDeletionResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvDeletionResult compute() throws Exception {
                return AutomationNodeCodeEnvsService.this.doDeleteCodeEnv(envLang, envName, authCtx, logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"delete_env", (String)("Delete env: " + envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvDeletionResult>>(){});
    }

    public CodeEnvModel.EnvDeletionResult doDeleteCodeEnv(CodeEnvModel.EnvLang envLang, String envName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder) {
        CodeEnvModel.EnvDeletionResult ret = new CodeEnvModel.EnvDeletionResult();
        try {
            File envDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName});
            CodeEnvModel.AutomationEnvRootDef rootDef = this.getEnvRootDefOrNull(envLang, envName);
            File log = ApplicationConfigurator.getFile((File)this.getEnvLogsDir(envLang, envName), (String[])new String[]{"delete.log"});
            DKUFileUtils.mkdirsParent((File)log);
            boolean expectJupyter = true;
            CodeEnvModel.AbstractEnvDesc envDesc = null;
            try {
                switch (rootDef.deploymentMode) {
                    case EXTERNAL_CONDA_NAMED: 
                    case AUTOMATION_NON_MANAGED_PATH: 
                    case AUTOMATION_SINGLE: 
                    case PLUGIN_MANAGED: 
                    case PLUGIN_NON_MANAGED: 
                    case BUSINESS_APP_MANAGED: 
                    case BUSINESS_APP_NON_MANAGED: 
                    case DSS_INTERNAL: {
                        File descDesc = this.f(envDir, "desc", "desc.json");
                        if (descDesc.isFile()) {
                            if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                                CodeEnvModel.PythonEnvDesc pyEnvDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)descDesc, CodeEnvModel.PythonEnvDesc.class);
                                expectJupyter = pyEnvDesc.installJupyterSupport;
                                envDesc = pyEnvDesc;
                            } else if (envLang == CodeEnvModel.EnvLang.R) {
                                CodeEnvModel.REnvDesc rEnvDesc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)descDesc, CodeEnvModel.REnvDesc.class);
                                expectJupyter = rEnvDesc.installJupyterSupport;
                                envDesc = rEnvDesc;
                            }
                        }
                        AutomationNodeManagedEnvUtils.removeJupyterSupportForNonVersionedEnv(authCtx, envLang, envName, logTailBuilder, log);
                        break;
                    }
                    case AUTOMATION_VERSIONED: {
                        break;
                    }
                    case DESIGN_MANAGED: 
                    case DESIGN_NON_MANAGED: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Wrong environment type " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                    default: {
                        throw new Error("unreachable");
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to remove Jupyter kernel", (Throwable)e);
                if (!expectJupyter) {
                    logger.info((Object)"Ignoring Jupyter uninstallation error, was not supposed to be installed");
                }
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_REMOVAL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            if (envDesc != null) {
                try {
                    CodeEnvUtilsBase.removeCodeEnvImages(envDesc, envLang, envName);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to remove code env container images", (Throwable)e);
                    ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONTAINER_IMAGE_DELETION_FAILED, "Failed to remove code env container images");
                }
            }
            try {
                DKUFileUtils.forceDelete((File)envDir);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to remove env dir", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, "Failed to remove env dir");
            }
            try {
                File logDir = this.getEnvLogsDir(envLang, envName);
                DKUFileUtils.forceDelete((File)logDir);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to remove log dir", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, "Failed to remove log dir");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Env deletion failed", (Throwable)e);
            ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    public List<LogsService.LogDesc> listLogs(CodeEnvModel.EnvLang envLang, String envName) {
        ArrayList logs = Lists.newArrayList();
        File logsFolder = this.getEnvLogsDir(envLang, envName);
        if (logsFolder.exists() && logsFolder.isDirectory()) {
            for (File logFile : logsFolder.listFiles()) {
                logs.add(new LogsService.LogDesc(logFile, logsFolder));
            }
        }
        return logs;
    }

    public File getLogFile(CodeEnvModel.EnvLang envLang, String envName, String logName) throws IOException {
        File logFile = ApplicationConfigurator.getFile((File)this.getEnvLogsDir(envLang, envName), (String[])new String[]{logName});
        if (logFile.exists() && logFile.isFile()) {
            return logFile;
        }
        return null;
    }

    public SmartLogTail getLog(CodeEnvModel.EnvLang envLang, String envName, String logName) throws IOException {
        File logFile = this.getLogFile(envLang, envName, logName);
        if (logFile != null) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        throw new IOException("Log file doesn't exist");
    }

    public void streamLog(CodeEnvModel.EnvLang envLang, String envName, String logName, OutputStream os) throws IOException {
        block11: {
            File logFile = this.getLogFile(envLang, envName, logName);
            if (logFile != null) {
                logger.info((Object)"Start compressed stream");
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file doesn't exist");
        }
    }

    public void exportEnvDefToFS(String projectKey, CodeEnvModel.EnvLang envLang, String envName, ReadWriteFS targetDirectoryFS) throws IOException {
        File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName});
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
        File versionFolder = null;
        switch (rootDef.deploymentMode) {
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot export a non-managed environment");
            }
            case AUTOMATION_VERSIONED: {
                String bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(envLang, envName, projectKey, bundleId);
                if (versionRef == null) {
                    throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                }
                versionFolder = new File(AutomationNodeManagedEnvUtils.getEnvVersionDir(envLang, envName, versionRef.envVersion), "desc");
                break;
            }
            case AUTOMATION_SINGLE: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case DSS_INTERNAL: {
                versionFolder = new File(envRootDir, "desc");
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal environment type");
            }
        }
        logger.info((Object)("Exporting env from " + String.valueOf(versionFolder)));
        if (DKUFileUtils.getWithin((File)versionFolder, (String[])new String[]{"spec"}).isDirectory()) {
            targetDirectoryFS.makeDirectory("spec");
        }
        if (DKUFileUtils.getWithin((File)versionFolder, (String[])new String[]{"actual"}).isDirectory()) {
            targetDirectoryFS.makeDirectory("actual");
        }
        ArrayList toCopy = Lists.newArrayList();
        toCopy.add(new RelFile(new String[]{"desc.json"}));
        toCopy.add(new RelFile(new String[]{"spec", "environment.spec"}));
        toCopy.add(new RelFile(new String[]{"spec", envLang.getPackageFileName()}));
        toCopy.add(new RelFile(new String[]{"actual", "environment.spec"}));
        toCopy.add(new RelFile(new String[]{"actual", envLang.getPackageFileName()}));
        toCopy.add(new RelFile(new String[]{"spec", "resources_init.py"}));
        NativeFS versionFolderFS = NativeFS.from((File)versionFolder).build();
        for (RelFile relFile : toCopy) {
            logger.info((Object)("Copying " + versionFolderFS.getRoot().getPath() + String.valueOf(relFile) + " to " + String.valueOf(relFile)));
            if (versionFolderFS.isFile(relFile)) {
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)versionFolderFS, relFile).to(targetDirectoryFS, relFile).run();
                continue;
            }
            logger.info((Object)"  -> nothing to copy");
        }
    }

    public static String getResourcesPath(CodeEnvModel.EnvLang envLang, String envName, String versionId) {
        if (StringUtils.isNotBlank((String)versionId)) {
            return DKUFileUtils.getWithin((File)AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionId), (String[])new String[]{"resources"}).getAbsolutePath();
        }
        return DKUFileUtils.getWithin((File)AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName), (String[])new String[]{"resources"}).getAbsolutePath();
    }

    public PythonCodeEnvUtils.AddResourcesZipResult uploadResourcesZip(CodeEnvModel.EnvLang envLang, String envName, String versionId, String relativePath, InputStream resourcesInputStream, String resourcesFileName, boolean overwrite) throws IOException {
        File resourcesFolder = new File(AutomationNodeCodeEnvsService.getResourcesPath(envLang, envName, versionId));
        return PythonCodeEnvUtils.addResourcesZip(resourcesFolder, relativePath, resourcesInputStream, resourcesFileName, overwrite);
    }

    public FSBrowsePath browseResourcesDir(CodeEnvModel.EnvLang envLang, String envName, String versionId, String relativePath, boolean withDirectoriesSize) throws DKUSecurityException, IOException {
        return FSBrowsePath.browse((String)AutomationNodeCodeEnvsService.getResourcesPath(envLang, envName, versionId), (String)relativePath, (boolean)withDirectoriesSize);
    }

    public void clearResourcesDir(CodeEnvModel.EnvLang envLang, String envName, String versionId) throws IOException {
        File resourcesDir = new File(AutomationNodeCodeEnvsService.getResourcesPath(envLang, envName, versionId));
        if (resourcesDir.exists()) {
            DKUFileUtils.forceDelete((File)resourcesDir);
        }
    }

    public String deleteResource(CodeEnvModel.EnvLang envLang, String envName, String path, String versionId) throws IOException {
        File fileToDelete = PythonCodeEnvUtils.resolveSafely(new File(AutomationNodeCodeEnvsService.getResourcesPath(envLang, envName, versionId)), path);
        if (fileToDelete.exists()) {
            DKUFileUtils.forceDelete((File)fileToDelete);
        }
        return path;
    }

    public FSBrowsePath renameResource(CodeEnvModel.EnvLang envLang, String envName, String path, String newName, String versionId) throws IOException, DKUSecurityException {
        String destPath = CodeEnvUtilsBase.validateAndGetRenamedResourcePath(path, newName);
        return this.moveResource(envLang, envName, path, destPath, versionId);
    }

    public FSBrowsePath moveResource(CodeEnvModel.EnvLang envLang, String envName, String sourcePath, String destPath, String versionId) throws IOException, DKUSecurityException {
        String resourcesPath = AutomationNodeCodeEnvsService.getResourcesPath(envLang, envName, versionId);
        File resourcesFolder = new File(resourcesPath);
        File sourceFile = CodeEnvUtilsBase.resolveSafely(resourcesFolder, sourcePath);
        File destFile = CodeEnvUtilsBase.resolveSafely(resourcesFolder, destPath);
        try {
            Files.move(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new IOException("File name " + destPath + " already exists", e);
        }
        catch (IOException e) {
            throw new IOException("Error renaming file " + sourcePath, e);
        }
        return FSBrowsePath.browse((String)resourcesPath, (String)Paths.get(sourcePath, new String[0]).getParent().toString(), (boolean)true);
    }

    public CodeEnvModel.CodeEnvResourcesEnvVariables getResourcesEnvVars(CodeEnvModel.EnvLang envLang, String envName, String versionId) throws IOException {
        File envDir;
        File resourcesEnvFile;
        CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = new CodeEnvModel.CodeEnvResourcesEnvVariables();
        if (envLang == CodeEnvModel.EnvLang.PYTHON && (resourcesEnvFile = ApplicationConfigurator.getFile((File)(envDir = StringUtils.isNotBlank((String)versionId) ? AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionId) : AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName)), (String[])new String[]{"desc", "actual", "resources_env.json"})).exists()) {
            resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
        }
        return resourcesEnvVariables;
    }

    public CodeEnvModel.CodeEnvResourcesModelsMeta getResourcesModelsMeta(CodeEnvModel.EnvLang envLang, String envName, String versionId) throws IOException {
        File envDir;
        File resourcesModelsMetaFile;
        CodeEnvModel.CodeEnvResourcesModelsMeta resourcesModelsMeta = new CodeEnvModel.CodeEnvResourcesModelsMeta();
        if (envLang == CodeEnvModel.EnvLang.PYTHON && StringUtils.isNotBlank((String)envName) && (resourcesModelsMetaFile = ApplicationConfigurator.getFile((File)(envDir = StringUtils.isNotBlank((String)versionId) ? AutomationNodeCodeEnvsService.getEnvVersionDir(envLang, envName, versionId) : AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName)), (String[])new String[]{"desc", "actual", "models_meta.json"})).exists()) {
            resourcesModelsMeta = (CodeEnvModel.CodeEnvResourcesModelsMeta)JSON.parseFile((File)resourcesModelsMetaFile, CodeEnvModel.CodeEnvResourcesModelsMeta.class);
            IReflectedEventsService.ReflectedEvent event = new IReflectedEventsService.ReflectedEvent("codeenv-list-resources-models", JSON.toJsonObject(resourcesModelsMeta.getResourcesModelsMetaSizes(), (String[])new String[0]));
            this.pubSubService.publish((DSSEvent)new ReflectedEventEvent(event));
        }
        return resourcesModelsMeta;
    }

    public static File getEnvRootDir(CodeEnvModel.EnvLang envLang, String envName) {
        return AutomationNodeCodeEnvsAccessService.getEnvRootDir(envLang, envName);
    }

    private File getEnvVersionsDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "versions"});
    }

    @ParametersAreNonnullByDefault
    public CodeEnvModel.AbstractEnvDesc getEnvDesc(String envName, CodeEnvModel.EnvLang envLang, Optional<String> envVersionIdOptional) throws IOException {
        return AutomationNodeManagedEnvUtils.getEnvDesc(envLang, envName, envVersionIdOptional);
    }

    private static File getEnvVersionDir(CodeEnvModel.EnvLang envLang, String envName, @Nonnull String version) {
        if (StringUtils.isBlank((String)version)) {
            throw new IllegalArgumentException("Version not specified");
        }
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "versions", version});
    }

    public File getEnvLogsDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", "logs", envLang.getFolderName(), envName});
    }

    private long getNextAvailableImportVersion(CodeEnvModel.EnvLang envLang, String envName) {
        File versionsFolder = new File(AutomationNodeCodeEnvsService.getEnvRootDir(envLang, envName), "versions");
        long highest = DKUFileUtils.highestFileNumber((File)versionsFolder, (String)"v.");
        if (highest == -1L) {
            return 1L;
        }
        return highest + 1L;
    }

    public List<String> buildEnvDockerImages(File versionDescFolder, CodeEnvModel.AbstractEnvDesc desc, CodeEnvModel.EnvLang lang, DKUtils.SmartLogTailBuilder logTailBuilder, File log, String envName, String envVersion, InfoMessage.InfoMessages messages) throws IOException {
        ArrayList built = Lists.newArrayList();
        List<ContainerExecImagesBuilder> imageBuilders = ContainerExecImagesBuilder.getBuilders(desc, CodeEnvPackageSystems.getCodeEnvSettings(desc), this.getEnvSpecData(versionDescFolder, desc, lang), envName, envVersion, messages);
        if (!imageBuilders.isEmpty()) {
            logger.infoV("Building Docker images for code environment %s", new Object[]{envName});
        }
        for (ContainerExecImagesBuilder imageBuilder : imageBuilders) {
            try {
                AutoDelete buildDir = DSSTempUtils.getTempFolder((String)"docker-image", (String)("codeenv-" + envName));
                try {
                    switch (lang) {
                        case PYTHON: {
                            this.copyPythonResources((CodeEnvModel.PythonEnvDesc)desc, lang, envName, envVersion, imageBuilder, (File)buildDir);
                            imageBuilder.prepareForPythonEnv((File)buildDir);
                            break;
                        }
                        case R: {
                            imageBuilder.prepareForREnv((File)buildDir);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported lang " + String.valueOf((Object)lang));
                        }
                    }
                    File dockerfileDump = DKUFileUtils.getWithin((File)log.getParentFile(), (String[])new String[]{"Dockerfile.dump"});
                    String image = imageBuilder.build((File)buildDir, logTailBuilder, log, dockerfileDump);
                    logger.info((Object)("Built Docker image " + image));
                    built.add(image);
                }
                finally {
                    if (buildDir == null) continue;
                    buildDir.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Building of Docker image for code env failed", (Throwable)e);
                messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CONTAINER_IMAGE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return built;
    }

    public void copyPythonResources(CodeEnvModel.PythonEnvDesc desc, CodeEnvModel.EnvLang lang, String envName, String envVersion, ContainerExecDockerFilePreparer imageBuilder, File buildDir) throws IOException {
        File envDir;
        File resourcesEnvJsonFile;
        File resourcesDirectory;
        CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions dockerImageResourcesOption = desc.dockerImageResources;
        if (dockerImageResourcesOption == CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions.COPY && (resourcesDirectory = new File(AutomationNodeCodeEnvsService.getResourcesPath(lang, envName, envVersion))).exists()) {
            logger.info((Object)"Copying resources directory to build directory");
            DKUFileUtils.copyDirectory((File)resourcesDirectory, (File)DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{imageBuilder.getResourcesDir()}));
        }
        if ((resourcesEnvJsonFile = DKUFileUtils.getWithin((File)(envDir = StringUtils.isNotBlank((String)envVersion) ? AutomationNodeCodeEnvsService.getEnvVersionDir(lang, envName, envVersion) : AutomationNodeCodeEnvsService.getEnvRootDir(lang, envName)), (String[])new String[]{"desc", "actual", "resources_env.json"})).exists()) {
            logger.info((Object)"Copying resources environment variables to build directory");
            FileUtils.copyFile((File)resourcesEnvJsonFile, (File)DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{imageBuilder.getResourcesEnvJsonFile()}));
        }
    }

    public CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> getEnvSpecData(File versionDescFolder, CodeEnvModel.AbstractEnvDesc desc, CodeEnvModel.EnvLang lang) throws IOException {
        File resourcesInitScriptFile;
        File packageFile;
        CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData = new CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc>();
        specData.desc = desc;
        File condaSpecFile = this.f(versionDescFolder, "spec", "environment.spec");
        if (condaSpecFile.isFile()) {
            specData.condaEnvSpec = DKUFileUtils.readFileToStringUTF8((File)condaSpecFile);
        }
        if ((packageFile = this.f(versionDescFolder, "spec", lang.getPackageFileName())).isFile()) {
            specData.packageList = DKUFileUtils.readFileToStringUTF8((File)packageFile);
        }
        if ((resourcesInitScriptFile = this.f(versionDescFolder, "spec", "resources_init.py")).isFile()) {
            specData.resourcesInitScript = DKUFileUtils.readFileToStringUTF8((File)resourcesInitScriptFile);
        }
        return specData;
    }

    private File f(File f, String ... chunks) {
        return new File(f, StringUtils.join((Object[])chunks, (String)"/"));
    }

    public List<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> getEnvListWithMLflowCompat_NT(AuthCtx authCtx, String projectKey) throws Exception {
        ArrayList<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> envsWithMLflowCompat = new ArrayList<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat>();
        for (PythonCodeEnvPackagesUtils.PythonEnvPackages env : this.getPythonEnvs_NT(authCtx, projectKey)) {
            envsWithMLflowCompat.add(new PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat(env));
        }
        return envsWithMLflowCompat;
    }

    public List<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> getEnvListWithTestCompat_NT(AuthCtx authCtx, String projectKey) throws Exception {
        ArrayList<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> envsWithTestCompat = new ArrayList<PythonCodeEnvPackagesUtils.CodeEnvTestCompat>();
        for (PythonCodeEnvPackagesUtils.PythonEnvPackages env : this.getPythonEnvs_NT(authCtx, projectKey)) {
            envsWithTestCompat.add(new PythonCodeEnvPackagesUtils.CodeEnvTestCompat(env));
        }
        return envsWithTestCompat;
    }

    private List<PythonCodeEnvPackagesUtils.PythonEnvPackages> getPythonEnvs_NT(AuthCtx authCtx, String projectKey) throws Exception {
        List<CodeEnvModel.CodeEnvListItem> envList = this.listCodeEnvs();
        HashSet pluginOrAppModes = Sets.newHashSet((Object[])new CodeEnvModel.CodeEnvDeploymentMode[]{CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED});
        ArrayList<String> authorizedEnvNameList = new ArrayList<String>();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem env : envList) {
                if (pluginOrAppModes.contains((Object)env.deploymentMode) || !env.envLang.equals((Object)CodeEnvModel.EnvLang.PYTHON) || !this.permissionsService.hasAnyCodeEnvAccess(authCtx, env.envLang, env.envName)) continue;
                authorizedEnvNameList.add(env.envName);
            }
        }
        ArrayList<PythonCodeEnvPackagesUtils.PythonEnvPackages> ret = new ArrayList<PythonCodeEnvPackagesUtils.PythonEnvPackages>();
        for (String envName : authorizedEnvNameList) {
            PythonCodeEnvPackagesUtils.PythonEnvPackages pythonEnvPackages = this.getPythonEnvPackages(projectKey, envName);
            if (null == pythonEnvPackages) continue;
            ret.add(pythonEnvPackages);
        }
        return ret;
    }

    public PythonCodeEnvPackagesUtils.PythonEnvPackages getPythonEnvPackages(String projectKey, String envName) throws Exception {
        CodeEnvModel.AutomationUIPythonEnv env = this.getPythonEnvForUI(envName, false);
        CodeEnvModel.AutomationUIPythonEnvVersion version = this.getPythonEnvVersion(projectKey, env);
        if (version != null) {
            return PythonCodeEnvPackagesUtils.getEnvPackages(env, version);
        }
        return null;
    }

    public CodeEnvModel.AutomationUIPythonEnvVersion getPythonEnvVersion(String projectKey, CodeEnvModel.AutomationUIPythonEnv env) throws Exception {
        return switch (env.deploymentMode) {
            case CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED, CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL -> (CodeEnvModel.AutomationUIPythonEnvVersion)env.noVersion;
            case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE -> (CodeEnvModel.AutomationUIPythonEnvVersion)env.currentVersion;
            case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED -> this.findCurrentCodeEnvVersion(projectKey, env);
            default -> throw new Error("unreachable");
        };
    }

    private CodeEnvModel.AutomationUIPythonEnvVersion findCurrentCodeEnvVersion(String projectKey, CodeEnvModel.AutomationUIPythonEnv env) throws IOException {
        CommonBundleUtils.BundleDetails bundle = this.automationBundlesService.getBundleDetails(projectKey, CommonBundleUtils.getActiveBundleId(projectKey));
        CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, env.envName, projectKey, bundle.bundleId);
        if (versionRef == null) {
            logger.info((Object)("Skipping versioned code environment " + env.envName + " since project " + projectKey + " does not reference it."));
            return null;
        }
        CodeEnvModel.AutomationUIPythonEnvVersion version = env.versions.stream().filter(v -> StringUtils.equals((String)versionRef.envVersion, (String)v.versionId)).findFirst().orElse(null);
        if (version == null) {
            logger.info((Object)("Skipping versioned code environment " + env.envName + " since project " + projectKey + " references its version " + versionRef.envVersion + ", which does not exist."));
        }
        return version;
    }
}

