/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class RCodeEnvUtils
extends CodeEnvUtilsBase {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code-envs.r");

    private RCodeEnvUtils() {
    }

    public static void createEmptyREnv(AuthCtx authCtx, CodeEnvModel.REnvDesc envDesc, File targetEnvDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
        logger.info((Object)("Creating empty R env: " + JSON.log((Object)envDesc) + " in " + String.valueOf(targetEnvDir)));
        if (envDesc.conda) {
            CodeEnvPackageSystems.CONDA_R.createEmpty(authCtx, envDesc, targetEnvDir, logTailBuilder, log, envSettings);
        } else {
            CodeEnvPackageSystems.R.createEmpty(authCtx, envDesc, targetEnvDir, logTailBuilder, log, envSettings);
        }
    }

    public static CodeEnvModel.REnvActualData computeREnvActualData(AuthCtx authCtx, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        CodeEnvModel.REnvActualData ret = new CodeEnvModel.REnvActualData();
        if (new File(envRootFolder, "conda-meta").isDirectory()) {
            ret.conda = true;
            ret.condaEnvSpec = CodeEnvPackageSystems.CONDA_R.getPackageList(authCtx, envRootFolder, logTailBuilder, log);
        }
        ret.nocondaEnvSpec = CodeEnvPackageSystems.R.getPackageList(authCtx, envRootFolder, logTailBuilder, log);
        return ret;
    }

    public static void createEmptyREnvFromDescDir(AuthCtx authCtx, File descDir, File targetEnvDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings) throws Exception {
        CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.REnvDesc.class);
        GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings = CodeEnvPackageSystems.getCodeEnvSettings(desc);
        if (overrideDescDirSettings != null) {
            envSettings = overrideDescDirSettings;
        }
        RCodeEnvUtils.createEmptyREnv(authCtx, desc, targetEnvDir, logTailBuilder, log, envSettings);
    }

    public static CodeEnvModel.REnvDesc installREnvPackagesFromDescDir(AuthCtx authCtx, File descDir, File targetEnvDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings) throws Exception {
        CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.REnvDesc.class);
        GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings = CodeEnvPackageSystems.getCodeEnvSettings(desc);
        if (overrideDescDirSettings != null) {
            envSettings = overrideDescDirSettings;
        }
        if (desc.conda) {
            File specFile = new File(descDir, "spec/environment.spec");
            String specData = "";
            if (specFile.exists()) {
                specData = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
            } else {
                logger.info((Object)"conda spec file does not exist");
            }
            CodeEnvPackageSystems.CONDA_R.install(authCtx, targetEnvDir, desc, true, specData, true, desc.conda, logTailBuilder, log, envSettings);
        }
        File pkgsFile = new File(descDir, "spec/rPackages.txt");
        CodeEnvPackageSystems.R.install(authCtx, targetEnvDir, desc, true, FileUtils.readFileToString((File)pkgsFile, (Charset)StandardCharsets.UTF_8), true, desc.conda, logTailBuilder, log, envSettings);
        return desc;
    }
}

