/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AWSCredentialsProviders {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.aws.provider");

    public static class UnshadedSerializableAWSCredentialHadoopProvider
    implements AwsCredentialsProvider {
        private ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = new ConnectionWithAWSAuthCredentials.SerializableAWSCredential();
        private CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo;
        private String connectionName;
        private String projectKey;

        public UnshadedSerializableAWSCredentialHadoopProvider(URI uri, Configuration conf) {
            this.cred.accessKey = conf.get("fs.s3a.access.key", null);
            this.cred.secretKey = conf.get("fs.s3a.secret.key", null);
            this.cred.sessionToken = conf.get("fs.s3a.session.token", null);
            this.cred.expirationTime = Long.parseLong(conf.get("fs.s3a.session.expirationTime", "0"));
            if (this.cred.accessKey == null || this.cred.secretKey == null) {
                throw new IllegalArgumentException("Credentials not found");
            }
            String fetchInfoJson = conf.get("fs.s3a.dku.fetchInfo", null);
            if (fetchInfoJson == null) {
                throw new IllegalArgumentException("Fetch info not found");
            }
            this.fetchInfo = (CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo)JSON.parse((String)fetchInfoJson, CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.class);
            this.connectionName = conf.get("fs.s3a.dku.connectionName", null);
            if (this.connectionName == null) {
                throw new IllegalArgumentException("Connection name not found");
            }
            this.projectKey = conf.get("fs.s3a.dku.projectKey", "__DKU_ANY_PROJECT__");
        }

        public UnshadedSerializableAWSCredentialHadoopProvider(Map<String, String> conf) {
            String fetchInfoJson;
            this.cred.accessKey = conf.getOrDefault("access.key", null);
            this.cred.secretKey = conf.getOrDefault("secret.key", null);
            this.cred.sessionToken = conf.getOrDefault("session.token", null);
            this.cred.expirationTime = Long.parseLong(conf.getOrDefault("session.expirationTime", "0"));
            if (StringUtils.isBlank((String)this.cred.sessionToken)) {
                if (StringUtils.isBlank((String)this.cred.accessKey)) {
                    this.cred.expirationTime = 1L;
                }
            } else if (StringUtils.isBlank((String)this.cred.accessKey) || StringUtils.isBlank((String)this.cred.secretKey)) {
                throw new IllegalArgumentException("Credentials incomplete");
            }
            if ((fetchInfoJson = (String)conf.getOrDefault("dku.fetchInfo", null)) == null) {
                throw new IllegalArgumentException("Fetch info not found");
            }
            this.fetchInfo = (CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo)JSON.parse((String)fetchInfoJson, CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.class);
            this.connectionName = conf.getOrDefault("dku.connectionName", null);
            if (this.connectionName == null) {
                throw new IllegalArgumentException("Connection name not found");
            }
            this.projectKey = conf.getOrDefault("dku.projectKey", "__DKU_ANY_PROJECT__");
        }

        public static UnshadedSerializableAWSCredentialHadoopProvider create(Map<String, String> properties) {
            return new UnshadedSerializableAWSCredentialHadoopProvider(properties);
        }

        @Override
        public AwsCredentials resolveCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toUnshadedAWSCredentials();
        }

        public void refresh() {
            try {
                this.cred = CredentialsRemoteFetchConfigurationProvider.getFromRemote(this.fetchInfo, "/connections/get-fully-resolved-credentials", ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class, "name", this.connectionName, "projectKey", this.projectKey, "useTokenCache", false);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to refresh STS token", e);
            }
        }
    }

    public static class SerializableAWSCredentialHadoopProvider
    implements com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider,
    AWSCredentialsProvider {
        private ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = new ConnectionWithAWSAuthCredentials.SerializableAWSCredential();
        private CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo;
        private String connectionName;
        private String projectKey;

        public SerializableAWSCredentialHadoopProvider(URI uri, Configuration conf) {
            this.cred.accessKey = conf.get("fs.s3a.access.key", null);
            this.cred.secretKey = conf.get("fs.s3a.secret.key", null);
            this.cred.sessionToken = conf.get("fs.s3a.session.token", null);
            this.cred.expirationTime = Long.parseLong(conf.get("fs.s3a.session.expirationTime", "0"));
            if (this.cred.accessKey == null || this.cred.secretKey == null) {
                throw new IllegalArgumentException("Credentials not found");
            }
            String fetchInfoJson = conf.get("fs.s3a.dku.fetchInfo", null);
            if (fetchInfoJson == null) {
                throw new IllegalArgumentException("Fetch info not found");
            }
            this.fetchInfo = (CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo)JSON.parse((String)fetchInfoJson, CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.class);
            this.connectionName = conf.get("fs.s3a.dku.connectionName", null);
            if (this.connectionName == null) {
                throw new IllegalArgumentException("Connection name not found");
            }
            this.projectKey = conf.get("fs.s3a.dku.projectKey", "__DKU_ANY_PROJECT__");
        }

        public SerializableAWSCredentialHadoopProvider(Map<String, String> conf) {
            String fetchInfoJson;
            this.cred.accessKey = conf.getOrDefault("access.key", null);
            this.cred.secretKey = conf.getOrDefault("secret.key", null);
            this.cred.sessionToken = conf.getOrDefault("session.token", null);
            this.cred.expirationTime = Long.parseLong(conf.getOrDefault("session.expirationTime", "0"));
            if (StringUtils.isBlank((String)this.cred.sessionToken)) {
                if (StringUtils.isBlank((String)this.cred.accessKey)) {
                    this.cred.expirationTime = 1L;
                }
            } else if (StringUtils.isBlank((String)this.cred.accessKey) || StringUtils.isBlank((String)this.cred.secretKey)) {
                throw new IllegalArgumentException("Credentials incomplete");
            }
            if ((fetchInfoJson = (String)conf.getOrDefault("dku.fetchInfo", null)) == null) {
                throw new IllegalArgumentException("Fetch info not found");
            }
            this.fetchInfo = (CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo)JSON.parse((String)fetchInfoJson, CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.class);
            this.connectionName = conf.getOrDefault("dku.connectionName", null);
            if (this.connectionName == null) {
                throw new IllegalArgumentException("Connection name not found");
            }
            this.projectKey = conf.getOrDefault("dku.projectKey", "__DKU_ANY_PROJECT__");
        }

        public static SerializableAWSCredentialHadoopProvider create(Map<String, String> properties) {
            return new SerializableAWSCredentialHadoopProvider(properties);
        }

        public com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials resolveCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toAWSCredentials();
        }

        @Override
        public AWSCredentials getCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toAWSCredentialsUnshadedSDK1();
        }

        @Override
        public void refresh() {
            try {
                this.cred = CredentialsRemoteFetchConfigurationProvider.getFromRemote(this.fetchInfo, "/connections/get-fully-resolved-credentials", ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class, "name", this.connectionName, "projectKey", this.projectKey, "useTokenCache", false);
            }
            catch (IOException e) {
                throw SdkException.create((String)"Unable to refresh STS token", (Throwable)e);
            }
        }
    }

    public static class SerializableAWSCredentialProvider
    implements com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider {
        private final AuthCtx authCtx;
        private final ConnectionWithAWSAuthCredentials conn;
        private ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred;

        public SerializableAWSCredentialProvider(AuthCtx authCtx, ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred, ConnectionWithAWSAuthCredentials conn) {
            this.authCtx = authCtx;
            this.cred = cred;
            this.conn = conn;
        }

        public com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials resolveCredentials() {
            if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
                logger.info((Object)"Credentials will expire soon, refreshing");
                this.refresh();
            }
            return this.cred.toAWSCredentials();
        }

        public void refresh() {
            try {
                this.cred = ((DSSConnection)((Object)this.conn)).getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            }
            catch (DKUSecurityException | IOException e) {
                throw SdkException.create((String)"Unable to refresh STS token", (Throwable)e);
            }
        }
    }
}

